/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.scs2.sharedMemory;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import us.ihmc.log.LogTools;
import us.ihmc.scs2.sharedMemory.LinkedBuffer;

public class LinkedBufferArray
extends LinkedBuffer {
    private int size = 0;
    private LinkedBuffer[] linkedBuffers = new LinkedBuffer[8];
    private final Set<LinkedBuffer> linkedBuffersWithPendingPushRequest = new HashSet<LinkedBuffer>();
    private final LinkedBuffer.PushRequestListener listener = target -> this.linkedBuffersWithPendingPushRequest.add(target);
    private final List<LinkedBufferChangeListener> changeListeners = new ArrayList<LinkedBufferChangeListener>();
    private boolean isDisposed = false;
    private static final int MAX_ARRAY_SIZE = 0x7FFFFFF7;

    public void cleanupInactiveLinkedBuffers() {
        if (this.isDisposed) {
            return;
        }
        for (int i = this.size - 1; i >= 0; --i) {
            if (this.linkedBuffers[i].isActive()) continue;
            this.remove(i);
        }
    }

    public boolean add(LinkedBuffer e) {
        if (this.isDisposed) {
            return false;
        }
        ++this.size;
        this.ensureCapacity(this.size);
        this.linkedBuffers[this.size - 1] = e;
        e.addPushRequestListener(this.listener);
        Change change = new Change(true, false, e);
        this.changeListeners.forEach(listener -> listener.onChange(change));
        return true;
    }

    public boolean remove(LinkedBuffer e) {
        if (this.isDisposed) {
            return false;
        }
        int index = this.indexOf(e);
        if (index == -1) {
            return false;
        }
        this.remove(index);
        return true;
    }

    public LinkedBuffer remove(int index) {
        if (this.isDisposed) {
            return null;
        }
        LinkedBuffer removedLinkedBuffer = this.linkedBuffers[index];
        this.linkedBuffers[index].removePushRequestListener(this.listener);
        this.linkedBuffers[index] = this.linkedBuffers[this.size - 1];
        --this.size;
        this.linkedBuffers[this.size] = null;
        Change change = new Change(false, true, removedLinkedBuffer);
        this.changeListeners.forEach(listener -> listener.onChange(change));
        return removedLinkedBuffer;
    }

    public int indexOf(LinkedBuffer e) {
        if (this.isDisposed) {
            return -1;
        }
        if (e != null) {
            for (int i = 0; i < this.size; ++i) {
                if (!e.equals(this.linkedBuffers[i])) continue;
                return i;
            }
        }
        return -1;
    }

    public int size() {
        return this.size;
    }

    public void addChangeListener(LinkedBufferChangeListener listener) {
        if (this.isDisposed) {
            return;
        }
        this.changeListeners.add(listener);
    }

    public boolean removeChangeListener(LinkedBufferChangeListener listener) {
        return this.changeListeners.remove(listener);
    }

    @Override
    public boolean pull() {
        if (this.isDisposed) {
            return false;
        }
        boolean hasPulledSomething = false;
        try {
            for (int i = 0; i < this.size; ++i) {
                hasPulledSomething |= this.linkedBuffers[i].pull();
            }
        }
        catch (NullPointerException e) {
            LogTools.info((String)("linkedBuffers: size = " + this.size + ", " + Arrays.toString(this.linkedBuffers)));
            e.printStackTrace();
        }
        return hasPulledSomething;
    }

    @Override
    public void push() {
        if (this.isDisposed) {
            return;
        }
        for (int i = 0; i < this.size; ++i) {
            this.linkedBuffers[i].push();
        }
    }

    @Override
    public boolean processPush(boolean writeBuffer) {
        if (this.isDisposed) {
            return false;
        }
        if (this.linkedBuffersWithPendingPushRequest.isEmpty()) {
            return false;
        }
        this.linkedBuffersWithPendingPushRequest.forEach(buffer -> buffer.processPush(writeBuffer));
        this.linkedBuffersWithPendingPushRequest.clear();
        return true;
    }

    @Override
    public void flushPush() {
        if (this.isDisposed) {
            return;
        }
        for (int i = 0; i < this.size; ++i) {
            this.linkedBuffers[i].flushPush();
        }
    }

    @Override
    public void prepareForPull() {
        if (this.isDisposed) {
            return;
        }
        for (int i = this.size - 1; i >= 0; --i) {
            LinkedBuffer linkedBuffer = this.linkedBuffers[i];
            if (linkedBuffer == null) {
                LogTools.error((String)"Unexpected null pointer");
            }
            if (!linkedBuffer.isActive()) {
                this.remove(i);
                continue;
            }
            linkedBuffer.prepareForPull();
        }
    }

    @Override
    public boolean hasRequestPending() {
        for (int i = 0; i < this.size; ++i) {
            if (!this.linkedBuffers[i].hasRequestPending()) continue;
            return true;
        }
        return false;
    }

    protected void ensureCapacity(int minCapacity) {
        if (minCapacity <= this.linkedBuffers.length) {
            return;
        }
        int previousArraySize = this.linkedBuffers.length;
        int newArraySize = previousArraySize + (previousArraySize >> 1);
        if (newArraySize - minCapacity < 0) {
            newArraySize = minCapacity;
        }
        if (newArraySize - 0x7FFFFFF7 > 0) {
            newArraySize = LinkedBufferArray.checkWithMaxCapacity(minCapacity);
        }
        this.linkedBuffers = Arrays.copyOf(this.linkedBuffers, newArraySize);
    }

    private static int checkWithMaxCapacity(int minCapacity) {
        if (minCapacity < 0) {
            throw new OutOfMemoryError();
        }
        return minCapacity > 0x7FFFFFF7 ? Integer.MAX_VALUE : 0x7FFFFFF7;
    }

    @Override
    public void dispose() {
        if (this.isDisposed) {
            return;
        }
        this.isDisposed = true;
        for (int i = 0; i < this.linkedBuffers.length; ++i) {
            if (this.linkedBuffers[i] == null) continue;
            this.linkedBuffers[i].dispose();
            this.linkedBuffers[i] = null;
        }
        this.linkedBuffers = null;
        this.linkedBuffersWithPendingPushRequest.clear();
        this.changeListeners.clear();
    }

    public static class Change {
        private final boolean wasLinkedBufferAdded;
        private final boolean wasLinkedBufferRemoved;
        private final LinkedBuffer target;

        private Change(boolean wasLinkedBufferAdded, boolean wasLinkedBufferRemoved, LinkedBuffer target) {
            this.wasLinkedBufferAdded = wasLinkedBufferAdded;
            this.wasLinkedBufferRemoved = wasLinkedBufferRemoved;
            this.target = target;
        }

        public boolean wasLinkedBufferAdded() {
            return this.wasLinkedBufferAdded;
        }

        public boolean wasLinkedBufferRemoved() {
            return this.wasLinkedBufferRemoved;
        }

        public LinkedBuffer getTarget() {
            return this.target;
        }
    }

    public static interface LinkedBufferChangeListener {
        public void onChange(Change var1);
    }
}

