/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.scs2.sharedMemory;

import java.util.Random;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import us.ihmc.commons.RandomNumbers;
import us.ihmc.scs2.sharedMemory.BufferSample;
import us.ihmc.scs2.sharedMemory.LinkedYoInteger;
import us.ihmc.scs2.sharedMemory.YoBufferProperties;
import us.ihmc.scs2.sharedMemory.YoIntegerBuffer;
import us.ihmc.scs2.sharedMemory.YoVariableBuffer;
import us.ihmc.scs2.sharedMemory.interfaces.YoBufferPropertiesReadOnly;
import us.ihmc.scs2.sharedMemory.tools.SharedMemoryRandomTools;
import us.ihmc.scs2.sharedMemory.tools.SharedMemoryTools;
import us.ihmc.yoVariables.registry.YoRegistry;
import us.ihmc.yoVariables.variable.YoInteger;
import us.ihmc.yoVariables.variable.YoVariable;

public class YoIntegerBufferTest {
    private static final int ITERATIONS = 1000;

    @Test
    public void testConstructors() {
        int j;
        YoBufferProperties yoBufferProperties;
        YoIntegerBuffer yoIntegerBuffer;
        YoInteger yoInteger;
        int i;
        Random random = new Random(467L);
        for (i = 0; i < 1000; ++i) {
            yoInteger = SharedMemoryRandomTools.nextYoInteger((Random)random, (YoRegistry)new YoRegistry("Dummy"));
            Assertions.assertTrue((yoInteger == (yoIntegerBuffer = new YoIntegerBuffer(yoInteger, (YoBufferPropertiesReadOnly)(yoBufferProperties = SharedMemoryRandomTools.nextYoBufferProperties((Random)random)))).getYoVariable() ? 1 : 0) != 0);
            Assertions.assertTrue((yoBufferProperties == yoIntegerBuffer.getProperties() ? 1 : 0) != 0);
            Assertions.assertEquals((int)yoBufferProperties.getSize(), (int)yoIntegerBuffer.getBuffer().length);
            for (j = 0; j < yoBufferProperties.getSize(); ++j) {
                Assertions.assertEquals((int)0, (int)yoIntegerBuffer.getBuffer()[j]);
            }
        }
        for (i = 0; i < 1000; ++i) {
            yoInteger = SharedMemoryRandomTools.nextYoInteger((Random)random, (YoRegistry)new YoRegistry("Dummy"));
            Assertions.assertTrue((yoInteger == (yoIntegerBuffer = (YoIntegerBuffer)YoVariableBuffer.newYoVariableBuffer((YoVariable)yoInteger, (YoBufferPropertiesReadOnly)(yoBufferProperties = SharedMemoryRandomTools.nextYoBufferProperties((Random)random)))).getYoVariable() ? 1 : 0) != 0);
            Assertions.assertTrue((yoBufferProperties == yoIntegerBuffer.getProperties() ? 1 : 0) != 0);
            Assertions.assertEquals((int)yoBufferProperties.getSize(), (int)yoIntegerBuffer.getBuffer().length);
            for (j = 0; j < yoBufferProperties.getSize(); ++j) {
                Assertions.assertEquals((int)0, (int)yoIntegerBuffer.getBuffer()[j]);
            }
        }
    }

    @Test
    public void testResizeBuffer() {
        Random random = new Random(8967254L);
        for (int i = 0; i < 1000; ++i) {
            YoIntegerBuffer yoIntegerBuffer = SharedMemoryRandomTools.nextYoIntegerBuffer((Random)random, (YoRegistry)new YoRegistry("Dummy"));
            YoBufferProperties originalBufferProperties = new YoBufferProperties(yoIntegerBuffer.getProperties());
            int from = random.nextInt(yoIntegerBuffer.getProperties().getSize());
            int newLength = random.nextInt(yoIntegerBuffer.getProperties().getSize());
            int[] expectedBuffer = SharedMemoryTools.ringArrayCopy((int[])yoIntegerBuffer.getBuffer(), (int)from, (int)newLength);
            yoIntegerBuffer.resizeBuffer(from, newLength);
            Assertions.assertArrayEquals((int[])expectedBuffer, (int[])yoIntegerBuffer.getBuffer());
            Assertions.assertEquals((Object)originalBufferProperties, (Object)yoIntegerBuffer.getProperties());
            int[] buffer = yoIntegerBuffer.getBuffer();
            yoIntegerBuffer.resizeBuffer(0, buffer.length);
            Assertions.assertTrue((buffer == yoIntegerBuffer.getBuffer() ? 1 : 0) != 0);
        }
    }

    @Test
    public void testWriteBuffer() {
        Random random = new Random(867324L);
        for (int i = 0; i < 1000; ++i) {
            YoIntegerBuffer yoIntegerBuffer = SharedMemoryRandomTools.nextYoIntegerBuffer((Random)random, (YoRegistry)new YoRegistry("Dummy"));
            YoInteger yoInteger = (YoInteger)yoIntegerBuffer.getYoVariable();
            int currentIndex = yoIntegerBuffer.getProperties().getCurrentIndex();
            for (int j = 0; j < 10; ++j) {
                int newValue = RandomNumbers.nextInt((Random)random, (int)-100000, (int)100000);
                yoInteger.set(newValue);
                yoIntegerBuffer.writeBuffer();
                Assertions.assertEquals((int)newValue, (int)yoInteger.getValue());
                Assertions.assertEquals((int)newValue, (int)yoIntegerBuffer.getBuffer()[currentIndex]);
            }
        }
    }

    @Test
    public void testReadBuffer() {
        Random random = new Random(867324L);
        for (int i = 0; i < 1000; ++i) {
            YoIntegerBuffer yoIntegerBuffer = SharedMemoryRandomTools.nextYoIntegerBuffer((Random)random, (YoRegistry)new YoRegistry("Dummy"));
            YoInteger yoInteger = (YoInteger)yoIntegerBuffer.getYoVariable();
            int currentIndex = yoIntegerBuffer.getProperties().getCurrentIndex();
            for (int j = 0; j < 10; ++j) {
                int newValue;
                yoIntegerBuffer.getBuffer()[currentIndex] = newValue = RandomNumbers.nextInt((Random)random, (int)-100000, (int)100000);
                yoIntegerBuffer.readBuffer();
                Assertions.assertEquals((int)newValue, (int)yoInteger.getValue());
                Assertions.assertEquals((int)newValue, (int)yoIntegerBuffer.getBuffer()[currentIndex]);
            }
        }
    }

    @Test
    public void testCopy() {
        Random random = new Random(43566L);
        for (int i = 0; i < 1000; ++i) {
            YoIntegerBuffer yoIntegerBuffer = SharedMemoryRandomTools.nextYoIntegerBuffer((Random)random, (YoRegistry)new YoRegistry("Dummy"));
            int from = random.nextInt(yoIntegerBuffer.getProperties().getSize());
            int length = random.nextInt(yoIntegerBuffer.getProperties().getSize() - 1) + 1;
            int[] expectedCopy = SharedMemoryTools.ringArrayCopy((int[])yoIntegerBuffer.getBuffer(), (int)from, (int)length);
            BufferSample actualCopy = yoIntegerBuffer.copy(from, length, yoIntegerBuffer.getProperties().copy());
            Assertions.assertEquals((int)from, (int)actualCopy.getFrom());
            Assertions.assertEquals((int)length, (int)actualCopy.getSampleLength());
            Assertions.assertEquals((Object)yoIntegerBuffer.getProperties(), (Object)actualCopy.getBufferProperties());
            int to = from + length - 1;
            if (to >= yoIntegerBuffer.getProperties().getSize()) {
                to -= yoIntegerBuffer.getProperties().getSize();
            }
            Assertions.assertEquals((int)to, (int)actualCopy.getTo());
            Assertions.assertArrayEquals((int[])expectedCopy, (int[])((int[])actualCopy.getSample()));
        }
    }

    @Test
    public void testNewLinkedYoVariable() {
        Random random = new Random(87324L);
        for (int i = 0; i < 1000; ++i) {
            YoInteger linkedInteger = new YoInteger("linked", new YoRegistry("Dummy"));
            YoIntegerBuffer yoIntegerBuffer = SharedMemoryRandomTools.nextYoIntegerBuffer((Random)random, (YoRegistry)new YoRegistry("Dummy"));
            LinkedYoInteger linkedYoVariable = yoIntegerBuffer.newLinkedYoVariable(linkedInteger);
            Assertions.assertTrue((linkedInteger == linkedYoVariable.getLinkedYoVariable() ? 1 : 0) != 0);
            Assertions.assertTrue((yoIntegerBuffer == linkedYoVariable.getBuffer() ? 1 : 0) != 0);
        }
    }
}

