/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.scs2.sharedMemory;

import java.util.Random;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import us.ihmc.scs2.sharedMemory.BufferSample;
import us.ihmc.scs2.sharedMemory.LinkedYoEnum;
import us.ihmc.scs2.sharedMemory.YoBufferProperties;
import us.ihmc.scs2.sharedMemory.YoEnumBuffer;
import us.ihmc.scs2.sharedMemory.YoVariableBuffer;
import us.ihmc.scs2.sharedMemory.interfaces.YoBufferPropertiesReadOnly;
import us.ihmc.scs2.sharedMemory.tools.SharedMemoryRandomTools;
import us.ihmc.scs2.sharedMemory.tools.SharedMemoryTools;
import us.ihmc.yoVariables.registry.YoRegistry;
import us.ihmc.yoVariables.variable.YoEnum;
import us.ihmc.yoVariables.variable.YoVariable;

public class YoEnumBufferTest {
    private static final int ITERATIONS = 1000;

    @Test
    public void testConstructors() {
        int j;
        YoBufferProperties yoBufferProperties;
        YoEnumBuffer yoEnumBuffer;
        YoEnum yoEnum;
        int i;
        Random random = new Random(467L);
        for (i = 0; i < 1000; ++i) {
            yoEnum = SharedMemoryRandomTools.nextYoEnum((Random)random, (YoRegistry)new YoRegistry("Dummy"));
            Assertions.assertTrue((yoEnum == (yoEnumBuffer = new YoEnumBuffer(yoEnum, (YoBufferPropertiesReadOnly)(yoBufferProperties = SharedMemoryRandomTools.nextYoBufferProperties((Random)random)))).getYoVariable() ? 1 : 0) != 0);
            Assertions.assertTrue((yoBufferProperties == yoEnumBuffer.getProperties() ? 1 : 0) != 0);
            Assertions.assertEquals((int)yoBufferProperties.getSize(), (int)yoEnumBuffer.getBuffer().length);
            for (j = 0; j < yoBufferProperties.getSize(); ++j) {
                Assertions.assertEquals((byte)0, (byte)yoEnumBuffer.getBuffer()[j]);
            }
        }
        for (i = 0; i < 1000; ++i) {
            yoEnum = SharedMemoryRandomTools.nextYoEnum((Random)random, (YoRegistry)new YoRegistry("Dummy"));
            Assertions.assertTrue((yoEnum == (yoEnumBuffer = (YoEnumBuffer)YoVariableBuffer.newYoVariableBuffer((YoVariable)yoEnum, (YoBufferPropertiesReadOnly)(yoBufferProperties = SharedMemoryRandomTools.nextYoBufferProperties((Random)random)))).getYoVariable() ? 1 : 0) != 0);
            Assertions.assertTrue((yoBufferProperties == yoEnumBuffer.getProperties() ? 1 : 0) != 0);
            Assertions.assertEquals((int)yoBufferProperties.getSize(), (int)yoEnumBuffer.getBuffer().length);
            for (j = 0; j < yoBufferProperties.getSize(); ++j) {
                Assertions.assertEquals((byte)0, (byte)yoEnumBuffer.getBuffer()[j]);
            }
        }
    }

    @Test
    public void testResizeBuffer() {
        Random random = new Random(8967254L);
        for (int i = 0; i < 1000; ++i) {
            YoEnumBuffer yoEnumBuffer = SharedMemoryRandomTools.nextYoEnumBuffer((Random)random, (YoRegistry)new YoRegistry("Dummy"));
            YoBufferProperties originalBufferProperties = new YoBufferProperties(yoEnumBuffer.getProperties());
            int from = random.nextInt(yoEnumBuffer.getProperties().getSize());
            int newLength = random.nextInt(yoEnumBuffer.getProperties().getSize());
            byte[] expectedBuffer = SharedMemoryTools.ringArrayCopy((byte[])yoEnumBuffer.getBuffer(), (int)from, (int)newLength);
            yoEnumBuffer.resizeBuffer(from, newLength);
            Assertions.assertArrayEquals((byte[])expectedBuffer, (byte[])yoEnumBuffer.getBuffer());
            Assertions.assertEquals((Object)originalBufferProperties, (Object)yoEnumBuffer.getProperties());
            byte[] buffer = yoEnumBuffer.getBuffer();
            yoEnumBuffer.resizeBuffer(0, buffer.length);
            Assertions.assertTrue((buffer == yoEnumBuffer.getBuffer() ? 1 : 0) != 0);
        }
    }

    @Test
    public void testWriteBuffer() {
        Random random = new Random(867324L);
        for (int i = 0; i < 1000; ++i) {
            YoEnumBuffer yoEnumBuffer = SharedMemoryRandomTools.nextYoEnumBuffer((Random)random, (YoRegistry)new YoRegistry("Dummy"));
            YoEnum yoEnum = (YoEnum)yoEnumBuffer.getYoVariable();
            int currentIndex = yoEnumBuffer.getProperties().getCurrentIndex();
            for (int j = 0; j < 10; ++j) {
                int newValue = yoEnum.isNullAllowed() ? random.nextInt(yoEnum.getEnumSize() + 1) - 1 : random.nextInt(yoEnum.getEnumSize());
                yoEnum.set(newValue);
                yoEnumBuffer.writeBuffer();
                Assertions.assertEquals((int)newValue, (int)yoEnum.getOrdinal());
                Assertions.assertEquals((byte)((byte)newValue), (byte)yoEnumBuffer.getBuffer()[currentIndex]);
            }
        }
    }

    @Test
    public void testReadBuffer() {
        Random random = new Random(867324L);
        for (int i = 0; i < 1000; ++i) {
            YoEnumBuffer yoEnumBuffer = SharedMemoryRandomTools.nextYoEnumBuffer((Random)random, (YoRegistry)new YoRegistry("Dummy"));
            YoEnum yoEnum = (YoEnum)yoEnumBuffer.getYoVariable();
            int currentIndex = yoEnumBuffer.getProperties().getCurrentIndex();
            for (int j = 0; j < 10; ++j) {
                int newValue = yoEnum.isNullAllowed() ? random.nextInt(yoEnum.getEnumSize() + 1) - 1 : random.nextInt(yoEnum.getEnumSize());
                yoEnumBuffer.getBuffer()[currentIndex] = (byte)newValue;
                yoEnumBuffer.readBuffer();
                Assertions.assertEquals((int)newValue, (int)yoEnum.getOrdinal());
                Assertions.assertEquals((byte)((byte)newValue), (byte)yoEnumBuffer.getBuffer()[currentIndex]);
            }
        }
    }

    @Test
    public void testCopy() {
        Random random = new Random(43566L);
        for (int i = 0; i < 1000; ++i) {
            YoEnumBuffer yoEnumBuffer = SharedMemoryRandomTools.nextYoEnumBuffer((Random)random, (YoRegistry)new YoRegistry("Dummy"));
            int from = random.nextInt(yoEnumBuffer.getProperties().getSize());
            int length = random.nextInt(yoEnumBuffer.getProperties().getSize() - 1) + 1;
            byte[] expectedCopy = SharedMemoryTools.ringArrayCopy((byte[])yoEnumBuffer.getBuffer(), (int)from, (int)length);
            BufferSample actualCopy = yoEnumBuffer.copy(from, length, yoEnumBuffer.getProperties().copy());
            Assertions.assertEquals((int)from, (int)actualCopy.getFrom());
            Assertions.assertEquals((int)length, (int)actualCopy.getSampleLength());
            Assertions.assertEquals((Object)yoEnumBuffer.getProperties(), (Object)actualCopy.getBufferProperties());
            int to = from + length - 1;
            if (to >= yoEnumBuffer.getProperties().getSize()) {
                to -= yoEnumBuffer.getProperties().getSize();
            }
            Assertions.assertEquals((int)to, (int)actualCopy.getTo());
            Assertions.assertArrayEquals((byte[])expectedCopy, (byte[])((byte[])actualCopy.getSample()));
        }
    }

    @Test
    public void testNewLinkedYoVariable() {
        Random random = new Random(87324L);
        for (int i = 0; i < 1000; ++i) {
            LinkedYoEnum linkedYoVariable;
            YoEnumBuffer yoEnumBuffer = SharedMemoryRandomTools.nextYoEnumBuffer((Random)random, (YoRegistry)new YoRegistry("Dummy"));
            YoEnum linkedEnum = new YoEnum("linked", new YoRegistry("Dummy"), ((YoEnum)yoEnumBuffer.getYoVariable()).getEnumType(), ((YoEnum)yoEnumBuffer.getYoVariable()).isNullAllowed());
            Assertions.assertTrue((linkedEnum == (linkedYoVariable = yoEnumBuffer.newLinkedYoVariable(linkedEnum)).getLinkedYoVariable() ? 1 : 0) != 0);
            Assertions.assertTrue((yoEnumBuffer == linkedYoVariable.getBuffer() ? 1 : 0) != 0);
        }
    }
}

