/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.scs2.session;

import java.util.concurrent.TimeUnit;
import us.ihmc.yoVariables.exceptions.IllegalOperationException;
import us.ihmc.yoVariables.registry.YoRegistry;
import us.ihmc.yoVariables.variable.YoDouble;

public class YoTimer {
    private final YoDouble timer;
    private final double scaleFromNanoseconds;
    private long start = -1L;
    private long lastUpdateTime = -1L;

    public YoTimer(String namePrefix, TimeUnit timerUnit, YoRegistry registry) {
        this.timer = new YoDouble(namePrefix + "[" + YoTimer.timeUnitSuffix(timerUnit) + "]", registry);
        this.scaleFromNanoseconds = YoTimer.scaleFromNanoseconds(timerUnit);
    }

    private static String timeUnitSuffix(TimeUnit timeUnit) {
        switch (timeUnit) {
            case DAYS: {
                return "day";
            }
            case HOURS: {
                return "hour";
            }
            case MINUTES: {
                return "min";
            }
            case SECONDS: {
                return "sec";
            }
            case MILLISECONDS: {
                return "ms";
            }
            case MICROSECONDS: {
                return "us";
            }
            case NANOSECONDS: {
                return "ns";
            }
        }
        throw new IllegalArgumentException("Unexpected value: " + (Object)((Object)timeUnit));
    }

    private static double scaleFromNanoseconds(TimeUnit timeUnit) {
        switch (timeUnit) {
            case DAYS: {
                return 1.1574074074074074E-14;
            }
            case HOURS: {
                return 2.777777777777778E-13;
            }
            case MINUTES: {
                return 1.6666666666666667E-11;
            }
            case SECONDS: {
                return 1.0E-9;
            }
            case MILLISECONDS: {
                return 1.0E-6;
            }
            case MICROSECONDS: {
                return 0.001;
            }
            case NANOSECONDS: {
                return 1.0;
            }
        }
        throw new IllegalArgumentException("Unexpected value: " + (Object)((Object)timeUnit));
    }

    public void start() {
        this.start = System.nanoTime();
    }

    public void start(long now, TimeUnit timeUnit) {
        this.start(timeUnit.toNanos(now));
    }

    public void start(long nowNanosec) {
        this.start = nowNanosec;
    }

    public void stop() {
        this.stop(System.nanoTime());
    }

    public void stop(long now, TimeUnit timeUnit) {
        this.stop(timeUnit.toNanos(now));
    }

    public void stop(long nowNanosec) {
        if (this.start == -1L) {
            throw new IllegalOperationException("Call start before each call of stop.");
        }
        this.timer.set((double)(nowNanosec - this.start) * this.scaleFromNanoseconds);
        this.start = -1L;
    }

    public void reset() {
        this.start = -1L;
        this.lastUpdateTime = -1L;
    }

    public void update() {
        this.update(System.nanoTime());
    }

    public void update(long now, TimeUnit timeUnit) {
        this.update(timeUnit.toNanos(now));
    }

    public void update(long nowNanosec) {
        if (this.lastUpdateTime > -1L) {
            this.timer.set((double)(nowNanosec - this.lastUpdateTime) * this.scaleFromNanoseconds);
        }
        this.lastUpdateTime = nowNanosec;
    }

    public YoDouble getTimer() {
        return this.timer;
    }
}

