/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.scs2.session;

import java.lang.management.ClassLoadingMXBean;
import java.lang.management.CompilationMXBean;
import java.lang.management.GarbageCollectorMXBean;
import java.lang.management.ManagementFactory;
import java.lang.management.OperatingSystemMXBean;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import us.ihmc.scs2.session.YoTimer;
import us.ihmc.yoVariables.registry.YoRegistry;
import us.ihmc.yoVariables.tools.YoTools;
import us.ihmc.yoVariables.variable.YoDouble;
import us.ihmc.yoVariables.variable.YoInteger;
import us.ihmc.yoVariables.variable.YoLong;

public class JVMStatisticsGenerator {
    private final YoRegistry registry = new YoRegistry("JVMStatistics");
    private final YoTimer timer = new YoTimer("jvmStatsTimer", TimeUnit.MILLISECONDS, this.registry);
    private final YoLong freeMemory = new YoLong("freeMemoryInBytes", this.registry);
    private final YoLong maxMemory = new YoLong("maxMemoryInBytes", this.registry);
    private final YoLong usedMemory = new YoLong("usedMemoryInBytes", this.registry);
    private final YoLong totalMemory = new YoLong("totalMemoryInBytes", this.registry);
    private final YoLong totalGCInvocations = new YoLong("totalGCInvocations", this.registry);
    private final YoLong totalGCTotalCollectionTimeMs = new YoLong("gcTotalCollectionTimeMs", this.registry);
    private final YoInteger loadedClassCount = new YoInteger("loadedClassCount", this.registry);
    private final YoLong totalLoadedClassCount = new YoLong("totalLoadedClassCount", this.registry);
    private final YoLong unloadedClassCount = new YoLong("unloadedClassCount", this.registry);
    private final YoLong totalCompilationTime = new YoLong("totalCompilationTimeMs", this.registry);
    private final YoInteger availableProcessors = new YoInteger("availableProcessors", this.registry);
    private final YoDouble systemLoadAverage = new YoDouble("systemLoadAverage", this.registry);
    private final ArrayList<GCBeanHolder> gcBeanHolders = new ArrayList();
    private final ClassLoadingMXBean classLoadingMXBean = ManagementFactory.getClassLoadingMXBean();
    private final CompilationMXBean compilationMXBean = ManagementFactory.getCompilationMXBean();
    private final OperatingSystemMXBean operatingSystemMXBean = ManagementFactory.getOperatingSystemMXBean();

    public JVMStatisticsGenerator(YoRegistry parentRegistry) {
        this.createGCBeanHolders();
        this.availableProcessors.set(this.operatingSystemMXBean.getAvailableProcessors());
        this.maxMemory.set(Runtime.getRuntime().maxMemory());
        parentRegistry.addChild(this.registry);
    }

    public void update() {
        this.timer.start();
        this.updateGCStatistics();
        this.updateClassLoadingStatistics();
        this.updateMemoryUsageStatistics();
        if (this.compilationMXBean != null) {
            this.totalCompilationTime.set(this.compilationMXBean.getTotalCompilationTime());
        }
        this.systemLoadAverage.set(this.operatingSystemMXBean.getSystemLoadAverage());
        this.timer.stop();
    }

    private void updateMemoryUsageStatistics() {
        this.freeMemory.set(Runtime.getRuntime().freeMemory());
        this.totalMemory.set(Runtime.getRuntime().totalMemory());
        this.usedMemory.set(this.totalMemory.getLongValue() - this.freeMemory.getLongValue());
    }

    private void updateClassLoadingStatistics() {
        this.loadedClassCount.set(this.classLoadingMXBean.getLoadedClassCount());
        this.totalLoadedClassCount.set(this.classLoadingMXBean.getTotalLoadedClassCount());
        this.unloadedClassCount.set(this.classLoadingMXBean.getUnloadedClassCount());
    }

    private void updateGCStatistics() {
        long totalInvocations = 0L;
        long totalTime = 0L;
        for (int i = 0; i < this.gcBeanHolders.size(); ++i) {
            GCBeanHolder holder = this.gcBeanHolders.get(i);
            holder.update();
            totalInvocations += holder.gcInvocations.getLongValue();
            totalTime += holder.gcTotalCollectionTimeMs.getLongValue();
        }
        this.totalGCInvocations.set(totalInvocations);
        this.totalGCTotalCollectionTimeMs.set(totalTime);
    }

    private void createGCBeanHolders() {
        List<GarbageCollectorMXBean> gcbeans = ManagementFactory.getGarbageCollectorMXBeans();
        for (int i = 0; i < gcbeans.size(); ++i) {
            GarbageCollectorMXBean gcbean = gcbeans.get(i);
            String name = YoTools.ILLEGAL_CHARACTERS_PATTERN.matcher(gcbean.getName()).replaceAll("");
            this.gcBeanHolders.add(new GCBeanHolder(name, gcbean));
        }
    }

    private class GCBeanHolder {
        final GarbageCollectorMXBean gcBean;
        final YoLong gcInvocations;
        final YoLong gcTotalCollectionTimeMs;

        GCBeanHolder(String name, GarbageCollectorMXBean gcBean) {
            this.gcBean = gcBean;
            this.gcInvocations = new YoLong(name + "GCInvocations", JVMStatisticsGenerator.this.registry);
            this.gcTotalCollectionTimeMs = new YoLong(name + "GCTotalTimeMs", JVMStatisticsGenerator.this.registry);
        }

        void update() {
            this.gcInvocations.set(this.gcBean.getCollectionCount());
            this.gcTotalCollectionTimeMs.set(this.gcBean.getCollectionTime());
        }
    }
}

