/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.scs2.session;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URISyntaxException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.HashSet;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import javax.xml.bind.JAXBException;
import org.apache.commons.io.FileUtils;
import us.ihmc.commons.nio.FileTools;
import us.ihmc.log.LogTools;
import us.ihmc.scs2.definition.DefinitionIOTools;
import us.ihmc.scs2.definition.SessionInformationDefinition;
import us.ihmc.scs2.definition.robot.RobotDefinition;
import us.ihmc.scs2.definition.terrain.TerrainObjectDefinition;
import us.ihmc.scs2.definition.yoGraphic.YoGraphicListDefinition;
import us.ihmc.scs2.session.Session;
import us.ihmc.scs2.session.SessionDataExportRequest;
import us.ihmc.scs2.sharedMemory.YoSharedBuffer;
import us.ihmc.scs2.sharedMemory.tools.SharedMemoryIOTools;
import us.ihmc.scs2.sharedMemory.tools.SharedMemoryTools;
import us.ihmc.yoVariables.registry.YoRegistry;

public class SessionIOTools {
    public static final Path SCS2_HOME = Paths.get(System.getProperty("user.home"), ".ihmc", "scs2");
    public static final Path SCS2_TEMP_FOLDER_PATH = SCS2_HOME.resolve(".temp");
    public static final String infoFileExtension = ".scs2.info";
    public static final String robotDefinitionFileExtension = ".scs2.robot";
    public static final String terrainObjectDefinitionFileExtension = ".scs2.terrain";
    public static final String yoGraphicConfigurationFileExtension = ".scs2.yoGraphic";
    public static final String yoRegistryDefinitionFileExtension = ".scs2.registry";

    public static void exportSessionData(Session session, SessionDataExportRequest request) throws JAXBException, IOException, URISyntaxException {
        if (request.getOnExportStartCallback() != null) {
            try {
                request.getOnExportStartCallback().run();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        try {
            SessionIOTools.exportSessionDataImpl(session, request);
        }
        finally {
            if (request.getOnExportEndCallback() != null) {
                try {
                    request.getOnExportEndCallback().run();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
    }

    private static void exportSessionDataImpl(Session session, SessionDataExportRequest request) throws JAXBException, IOException, URISyntaxException {
        File file = request.getFile();
        if (file.exists()) {
            if (file.isFile()) {
                if (!request.getOverwrite()) {
                    LogTools.error((String)"File exists and overwrite is set to false: {}", (Object)file);
                    return;
                }
                if (!file.delete()) {
                    LogTools.error((String)"Could not delete file: {}", (Object)file);
                    return;
                }
                if (!file.mkdir()) {
                    LogTools.error((String)"Could not create directory: {}", (Object)file);
                    return;
                }
            } else if (file.isDirectory() && file.list().length > 0) {
                String[] allExtensions = new String[]{infoFileExtension, robotDefinitionFileExtension, terrainObjectDefinitionFileExtension, yoGraphicConfigurationFileExtension, yoRegistryDefinitionFileExtension};
                allExtensions = (String[])SharedMemoryTools.concatenate((Object[][])new String[][]{allExtensions, (String[])Arrays.stream(SharedMemoryIOTools.DataFormat.values()).map(SharedMemoryIOTools.DataFormat::getFileExtension).toArray(String[]::new)});
                block5: for (File childFile : file.listFiles()) {
                    if (childFile.isDirectory() && childFile.getName().equals("resources")) {
                        if (!request.getOverwrite()) {
                            LogTools.error((String)"Cannot delete file ({}) because overwrite is set to false.", (Object)childFile);
                            return;
                        }
                        if (SessionIOTools.emptyDirectory(childFile)) continue;
                        LogTools.error((String)"Could not empty directory: {}", (Object)childFile);
                        return;
                    }
                    for (String extension : allExtensions) {
                        if (!childFile.getName().endsWith(extension)) continue;
                        if (!request.getOverwrite()) {
                            LogTools.error((String)"Cannot delete file ({}) because overwrite is set to false.", (Object)childFile);
                            return;
                        }
                        if (childFile.delete()) continue block5;
                        LogTools.error((String)"Could not delete file: {}", (Object)childFile);
                        return;
                    }
                }
            }
        }
        SessionInformationDefinition sessionInfo = new SessionInformationDefinition();
        sessionInfo.setSessionName(session.getSessionName());
        sessionInfo.setSessionDTSeconds(session.getSessionDTSeconds() * (double)session.getBufferRecordTickPeriod());
        File resourcesDirectory = new File(file, "resources");
        resourcesDirectory.mkdir();
        if (request.getExportRobotDefinitions()) {
            for (RobotDefinition robotDefinition : session.getRobotDefinitions()) {
                String name = robotDefinition.getName();
                File robotFile = new File(file, name + robotDefinitionFileExtension);
                LogTools.info((String)"Exporting RobotDefinition for: {} File: {}", (Object)name, (Object)robotFile);
                DefinitionIOTools.saveRobotDefinition((OutputStream)new FileOutputStream(robotFile), (RobotDefinition)robotDefinition);
                sessionInfo.getRobotFileNames().add(robotFile.getName());
                ClassLoader resourceClassLoader = robotDefinition.getResourceClassLoader();
                if (resourceClassLoader == null) {
                    resourceClassLoader = SessionIOTools.class.getClassLoader();
                }
                File robotResourceDirectory = new File(resourcesDirectory, name);
                DefinitionIOTools.saveResources((RobotDefinition)robotDefinition, (File)robotResourceDirectory, (ClassLoader)resourceClassLoader);
            }
        }
        if (request.getExportTerrainObjectDefinitions()) {
            HashSet<String> terrainNames = new HashSet<String>();
            for (TerrainObjectDefinition terrainObjectDefinition : session.getTerrainObjectDefinitions()) {
                String name = terrainObjectDefinition.getName();
                if (name == null || name.isEmpty()) {
                    name = "terrain";
                }
                if (terrainNames.contains(name)) {
                    int index = 1;
                    String uniqueName = name + "_" + index;
                    while (terrainNames.contains(uniqueName)) {
                        uniqueName = name + "_" + ++index;
                    }
                    name = uniqueName;
                }
                terrainNames.add(name);
                File terrainFile = new File(file, name + terrainObjectDefinitionFileExtension);
                LogTools.info((String)"Exporting TerrainObjectDefinition for: {}. File: {}", (Object)name, (Object)terrainFile);
                DefinitionIOTools.saveTerrainObjectDefinition((OutputStream)new FileOutputStream(terrainFile), (TerrainObjectDefinition)terrainObjectDefinition);
                sessionInfo.getTerrainFileNames().add(terrainFile.getName());
                ClassLoader resourceClassLoader = terrainObjectDefinition.getResourceClassLoader();
                if (resourceClassLoader == null) {
                    resourceClassLoader = SessionIOTools.class.getClassLoader();
                }
                File terrainResourceDirectory = new File(resourcesDirectory, name);
                DefinitionIOTools.saveResources((TerrainObjectDefinition)terrainObjectDefinition, (File)terrainResourceDirectory, (ClassLoader)resourceClassLoader);
            }
        }
        if (request.getExportSessionYoGraphicDefinitions()) {
            File graphicFile = new File(file, "sessionGraphics.scs2.yoGraphic");
            LogTools.info((String)"Exporting session yoGraphics. File: {}", (Object)graphicFile);
            DefinitionIOTools.saveYoGraphicListDefinition((OutputStream)new FileOutputStream(graphicFile), (YoGraphicListDefinition)new YoGraphicListDefinition(session.getYoGraphicDefinitions()));
            sessionInfo.setGraphicFileName(graphicFile.getName());
        }
        if (request.getExportSessionBufferRegistryDefinition()) {
            File registryFile = new File(file, "variables.scs2.registry");
            LogTools.info((String)"Exporting session variable structure. File: {}", (Object)registryFile);
            SharedMemoryIOTools.exportRegistry((YoRegistry)session.getRootRegistry(), (OutputStream)new FileOutputStream(registryFile), request.getVariableFilter(), request.getRegistryFilter());
            sessionInfo.setRegistryFileName(registryFile.getName());
        }
        if (request.getExportSessionBufferDataFormat() != null) {
            File dataFile = new File(file, "data" + request.getExportSessionBufferDataFormat().getFileExtension());
            LogTools.info((String)"Exporting session data. File: {}", (Object)dataFile);
            switch (request.getExportSessionBufferDataFormat()) {
                case ASCII: {
                    SharedMemoryIOTools.exportDataASCII((YoSharedBuffer)session.getBuffer(), (OutputStream)new FileOutputStream(dataFile), request.getVariableFilter(), request.getRegistryFilter());
                    break;
                }
                case CSV: {
                    SharedMemoryIOTools.exportDataCSV((YoSharedBuffer)session.getBuffer(), (OutputStream)new FileOutputStream(dataFile), request.getVariableFilter(), request.getRegistryFilter());
                    break;
                }
                case MATLAB: {
                    SharedMemoryIOTools.exportDataMatlab((YoSharedBuffer)session.getBuffer(), (File)dataFile, request.getVariableFilter(), request.getRegistryFilter());
                    break;
                }
                default: {
                    LogTools.error((String)"Unhandled data format: {}", (Object)request.getExportSessionBufferDataFormat());
                }
            }
            sessionInfo.setDataFileName(dataFile.getName());
            LogTools.info((String)"Done exporting session data.");
        }
        File sessionInfoFile = new File(file, "session.scs2.info");
        DefinitionIOTools.saveSessionInformationDefinition((OutputStream)new FileOutputStream(sessionInfoFile), (SessionInformationDefinition)sessionInfo);
    }

    public static boolean emptyDirectory(File directoryToEmpty) {
        if (!directoryToEmpty.isDirectory()) {
            return false;
        }
        try {
            FileUtils.deleteDirectory((File)directoryToEmpty);
            directoryToEmpty.mkdir();
            return true;
        }
        catch (IOException e) {
            e.printStackTrace();
            return false;
        }
    }

    public static File getTemporaryDirectory(String directoryName) {
        File tempDir = SCS2_TEMP_FOLDER_PATH.resolve(directoryName).toFile();
        if (tempDir.exists()) {
            try {
                FileUtils.forceDelete((File)tempDir);
            }
            catch (IOException e) {
                e.printStackTrace();
                return null;
            }
        }
        tempDir.mkdirs();
        return tempDir;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void unzipFile(File input, File destination) throws IOException {
        ZipInputStream zis = null;
        byte[] buffer = new byte[1024];
        try {
            zis = new ZipInputStream(new FileInputStream(input));
            ZipEntry ze = zis.getNextEntry();
            while (ze != null) {
                File newFile = SessionIOTools.newFile(destination, ze);
                if (ze.isDirectory()) {
                    if (!newFile.isDirectory() && !newFile.mkdirs()) {
                        throw new IOException("Failed to create directory " + newFile);
                    }
                } else {
                    int length;
                    File parent = newFile.getParentFile();
                    if (!parent.isDirectory() && !parent.mkdirs()) {
                        throw new IOException("Failed to create directory " + parent);
                    }
                    FileOutputStream fos = new FileOutputStream(newFile);
                    while ((length = zis.read(buffer)) > 0) {
                        fos.write(buffer, 0, length);
                    }
                    fos.close();
                }
                ze = zis.getNextEntry();
            }
        }
        finally {
            if (zis != null) {
                zis.closeEntry();
                zis.close();
            }
        }
    }

    public static void zipFile(File input, File destination) throws IOException {
        try (ZipOutputStream zipOut = new ZipOutputStream(new FileOutputStream(destination));){
            if (input.isDirectory()) {
                for (File subFile : input.listFiles()) {
                    SessionIOTools.zipFile(subFile.getName(), subFile, zipOut);
                }
            } else {
                SessionIOTools.zipFile(input.getName(), input, zipOut);
            }
        }
    }

    public static void zipFile(String fileName, File fileToZip, ZipOutputStream zipOut) throws IOException {
        if (fileToZip.isHidden()) {
            return;
        }
        if (fileToZip.isDirectory()) {
            File[] children;
            if (fileName.endsWith("/")) {
                zipOut.putNextEntry(new ZipEntry(fileName));
            } else {
                zipOut.putNextEntry(new ZipEntry(fileName + "/"));
            }
            zipOut.closeEntry();
            for (File childFile : children = fileToZip.listFiles()) {
                SessionIOTools.zipFile(fileName + "/" + childFile.getName(), childFile, zipOut);
            }
        } else {
            try (FileInputStream fis = new FileInputStream(fileToZip);){
                int length;
                ZipEntry zipEntry = new ZipEntry(fileName);
                zipOut.putNextEntry(zipEntry);
                byte[] bytes = new byte[1024];
                while ((length = fis.read(bytes)) >= 0) {
                    zipOut.write(bytes, 0, length);
                }
            }
        }
    }

    public static File newFile(File destinationParent, ZipEntry zipEntry) throws IOException {
        File destinationFile = new File(destinationParent, zipEntry.getName());
        if (destinationFile.getCanonicalPath().startsWith(destinationParent.getCanonicalPath() + File.separator)) {
            return destinationFile;
        }
        throw new IOException("Attempted to unzip outside destination: " + zipEntry.getName());
    }

    static {
        try {
            FileTools.ensureDirectoryExists((Path)SCS2_HOME);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

