/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.scs2.session;

import java.io.IOException;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumMap;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.BooleanSupplier;
import java.util.function.Consumer;
import javax.xml.bind.JAXBException;
import us.ihmc.commons.Conversions;
import us.ihmc.euclid.referenceFrame.ReferenceFrame;
import us.ihmc.euclid.referenceFrame.tools.ReferenceFrameTools;
import us.ihmc.log.LogTools;
import us.ihmc.messager.Messager;
import us.ihmc.messager.TopicListener;
import us.ihmc.scs2.definition.robot.RobotDefinition;
import us.ihmc.scs2.definition.terrain.TerrainObjectDefinition;
import us.ihmc.scs2.definition.yoGraphic.YoGraphicDefinition;
import us.ihmc.scs2.session.DaemonThreadFactory;
import us.ihmc.scs2.session.JVMStatisticsGenerator;
import us.ihmc.scs2.session.SessionDataExportRequest;
import us.ihmc.scs2.session.SessionIOTools;
import us.ihmc.scs2.session.SessionMessagerAPI;
import us.ihmc.scs2.session.SessionMode;
import us.ihmc.scs2.session.SessionProperties;
import us.ihmc.scs2.session.SessionState;
import us.ihmc.scs2.session.YoSharedBufferMessagerAPI;
import us.ihmc.scs2.session.YoTimer;
import us.ihmc.scs2.sharedMemory.CropBufferRequest;
import us.ihmc.scs2.sharedMemory.FillBufferRequest;
import us.ihmc.scs2.sharedMemory.YoSharedBuffer;
import us.ihmc.scs2.sharedMemory.interfaces.LinkedYoVariableFactory;
import us.ihmc.scs2.sharedMemory.interfaces.YoBufferPropertiesReadOnly;
import us.ihmc.yoVariables.registry.YoRegistry;
import us.ihmc.yoVariables.variable.YoDouble;

public abstract class Session {
    public static final String ROOT_REGISTRY_NAME = "root";
    public static final ReferenceFrame DEFAULT_INERTIAL_FRAME = ReferenceFrameTools.constructARootFrame((String)"worldFrame");
    protected final YoRegistry rootRegistry = new YoRegistry("root");
    protected final YoRegistry sessionRegistry = new YoRegistry(this.getClass().getSimpleName());
    protected final YoDouble time = new YoDouble("time", this.rootRegistry);
    private final JVMStatisticsGenerator jvmStatisticsGenerator = new JVMStatisticsGenerator(this.sessionRegistry);
    protected final YoRegistry runRegistry = new YoRegistry("runStatistics");
    private final YoTimer runActualDT = new YoTimer("runActualDT", TimeUnit.MILLISECONDS, this.runRegistry);
    private final YoTimer runTimer = new YoTimer("runTimer", TimeUnit.MILLISECONDS, this.runRegistry);
    private final YoTimer runInitializeTimer = new YoTimer("runInitializeTimer", TimeUnit.MILLISECONDS, this.runRegistry);
    private final YoTimer runSpecificTimer = new YoTimer("runSpecificTimer", TimeUnit.MILLISECONDS, this.runRegistry);
    private final YoTimer runFinalizeTimer = new YoTimer("runFinalizeTimer", TimeUnit.MILLISECONDS, this.runRegistry);
    protected final YoRegistry playbackRegistry = new YoRegistry("playbackStatistics");
    private final YoTimer playbackActualDT = new YoTimer("playbackActualDT", TimeUnit.MILLISECONDS, this.playbackRegistry);
    private final YoTimer playbackTimer = new YoTimer("playbackTimer", TimeUnit.MILLISECONDS, this.playbackRegistry);
    protected final YoRegistry pauseRegistry = new YoRegistry("pauseStatistics");
    private final YoTimer pauseActualDT = new YoTimer("pauseActualDT", TimeUnit.MILLISECONDS, this.pauseRegistry);
    private final YoTimer pauseTimer = new YoTimer("pauseTimer", TimeUnit.MILLISECONDS, this.pauseRegistry);
    protected final YoSharedBuffer sharedBuffer = new YoSharedBuffer(this.rootRegistry, 8192);
    private final AtomicReference<SessionMode> activeMode = new AtomicReference<SessionMode>(SessionMode.PAUSE);
    private final AtomicBoolean runAtRealTimeRate = new AtomicBoolean(false);
    private final AtomicReference<Double> playbackRealTimeRate = new AtomicReference<Double>(2.0);
    private int stepSizePerPlaybackTick = 1;
    private final AtomicInteger bufferRecordTickPeriod = new AtomicInteger(1);
    private final AtomicLong sessionDTNanoseconds = new AtomicLong(Conversions.secondsToNanoseconds((double)1.0E-4));
    private final AtomicLong desiredBufferPublishPeriod = new AtomicLong(-1L);
    private final long sessionPropertiesPublishPeriod = 500L;
    private long lastSessionPropertiesPublishTimestamp = -1L;
    private final List<SessionModeChangeListener> sessionModeChangeListeners = new ArrayList<SessionModeChangeListener>();
    private final List<Consumer<SessionState>> sessionStateChangedListeners = new ArrayList<Consumer<SessionState>>();
    private final List<Consumer<SessionProperties>> sessionPropertiesListeners = new ArrayList<Consumer<SessionProperties>>();
    private final List<Consumer<YoBufferPropertiesReadOnly>> currentBufferPropertiesListeners = new ArrayList<Consumer<YoBufferPropertiesReadOnly>>();
    private final List<Runnable> shutdownListeners = new ArrayList<Runnable>();
    private final List<Consumer<Throwable>> runThrowableListeners = new ArrayList<Consumer<Throwable>>();
    private final List<Consumer<Throwable>> playbackThrowableListeners = new ArrayList<Consumer<Throwable>>();
    private final AtomicReference<CropBufferRequest> pendingCropBufferRequest = new AtomicReference<Object>(null);
    private final AtomicReference<FillBufferRequest> pendingFillBufferRequest = new AtomicReference<Object>(null);
    private final AtomicReference<Integer> pendingBufferIndexRequest = new AtomicReference<Object>(null);
    private final AtomicReference<Integer> pendingBufferInPointIndexRequest = new AtomicReference<Object>(null);
    private final AtomicReference<Integer> pendingBufferOutPointIndexRequest = new AtomicReference<Object>(null);
    private final AtomicReference<Integer> pendingIncrementBufferIndexRequest = new AtomicReference<Object>(null);
    private final AtomicReference<Integer> pendingDecrementBufferIndexRequest = new AtomicReference<Object>(null);
    private final AtomicReference<Integer> pendingBufferSizeRequest = new AtomicReference<Object>(null);
    private final AtomicReference<SessionDataExportRequest> pendingDataExportRequest = new AtomicReference<Object>(null);
    private final List<SessionTopicListenerManager> sessionTopicListenerManagers = new ArrayList<SessionTopicListenerManager>();
    private boolean sessionStarted = false;
    private boolean sessionInitialized = false;
    private boolean isSessionShutdown = false;
    private long lastPublishedBufferTimestamp = -1L;
    protected boolean firstRunTick = true;
    protected boolean firstPauseTick = true;
    protected final ScheduledExecutorService executorService = Executors.newScheduledThreadPool(2, new DaemonThreadFactory("SCS2-Session-Thread"));
    protected PeriodicTaskWrapper activePeriodicTask;
    private final EnumMap<SessionMode, Runnable> sessionModeToTaskMap = new EnumMap(SessionMode.class);
    protected boolean hasBufferSizeBeenInitialized = false;
    protected boolean hasBufferRecordPeriodBeenInitialized = false;
    private int nextBufferRecordTickCounter = 0;

    public Session() {
        this(SessionMode.PAUSE);
    }

    public Session(SessionMode initialMode) {
        this.activeMode.set(initialMode);
        this.rootRegistry.addChild(this.sessionRegistry);
        this.sessionRegistry.addChild(this.runRegistry);
        this.sessionRegistry.addChild(this.playbackRegistry);
        this.sessionRegistry.addChild(this.pauseRegistry);
        this.sessionModeToTaskMap.put(SessionMode.RUNNING, this::runTick);
        this.sessionModeToTaskMap.put(SessionMode.PLAYBACK, this::playbackTick);
        this.sessionModeToTaskMap.put(SessionMode.PAUSE, this::pauseTick);
    }

    public static String retrieveCallerName() {
        StackTraceElement[] stackTrace = new Throwable().getStackTrace();
        String className = stackTrace[stackTrace.length - 1].getClassName();
        return className.substring(className.lastIndexOf(".") + 1);
    }

    public void setupWithMessager(Messager messager) {
        for (SessionTopicListenerManager manager : this.sessionTopicListenerManagers) {
            if (messager != manager.messager) continue;
            throw new IllegalArgumentException("Messager already registered.");
        }
        this.sessionTopicListenerManagers.add(new SessionTopicListenerManager(messager));
    }

    public void setSessionMode(SessionMode sessionMode) {
        this.setSessionMode(sessionMode, null);
    }

    protected void setSessionMode(SessionMode sessionMode, SessionModeTransition transition) {
        SessionMode currentMode = this.activeMode.get();
        if (sessionMode != currentMode) {
            this.scheduleSessionTask(sessionMode, transition);
        }
    }

    public void addSessionModeChangeListener(SessionModeChangeListener listener) {
        this.sessionModeChangeListeners.add(listener);
    }

    public void removeSessionModeChangeListener(SessionModeChangeListener listener) {
        this.sessionModeChangeListeners.remove(listener);
    }

    public void addSessionStateChangedListener(Consumer<SessionState> listener) {
        this.sessionStateChangedListeners.add(listener);
    }

    public void removeSessionStateChangedListener(Consumer<SessionState> listener) {
        this.sessionStateChangedListeners.remove(listener);
    }

    public void addShutdownListener(Runnable listener) {
        this.shutdownListeners.add(listener);
    }

    public void removeShutdownListener(Runnable listener) {
        this.shutdownListeners.remove(listener);
    }

    public void addSessionPropertiesListener(Consumer<SessionProperties> listener) {
        this.sessionPropertiesListeners.add(listener);
    }

    public void removeSessionPropertiesListener(Consumer<SessionProperties> listener) {
        this.sessionPropertiesListeners.remove(listener);
    }

    public void addCurrentBufferPropertiesListener(Consumer<YoBufferPropertiesReadOnly> listener) {
        this.currentBufferPropertiesListeners.add(listener);
    }

    public void removeCurrentBufferPropertiesListener(Consumer<YoBufferPropertiesReadOnly> listener) {
        this.currentBufferPropertiesListeners.remove(listener);
    }

    public void addRunThrowableListener(Consumer<Throwable> listener) {
        this.runThrowableListeners.add(listener);
    }

    public void removeRunThrowableListener(Consumer<Throwable> listener) {
        this.runThrowableListeners.remove(listener);
    }

    public void addPlaybackThrowableListener(Consumer<Throwable> listener) {
        this.playbackThrowableListeners.add(listener);
    }

    public void removePlaybackThrowableListener(Consumer<Throwable> listener) {
        this.playbackThrowableListeners.remove(listener);
    }

    public void setSessionDTSeconds(double sessionDTSeconds) {
        this.setSessionDTNanoseconds(Conversions.secondsToNanoseconds((double)sessionDTSeconds));
    }

    public void setSessionDTNanoseconds(long sessionDTNanoseconds) {
        if (this.sessionDTNanoseconds.get() == sessionDTNanoseconds) {
            return;
        }
        this.sessionDTNanoseconds.set(sessionDTNanoseconds);
        this.scheduleSessionTask(this.getActiveMode());
    }

    public boolean initializeBufferSize(int bufferSize) {
        if (this.hasBufferSizeBeenInitialized) {
            return false;
        }
        this.submitBufferSizeRequest(bufferSize);
        return true;
    }

    public boolean initializeBufferRecordTickPeriod(int bufferRecordTickPeriod) {
        if (this.hasBufferRecordPeriodBeenInitialized) {
            return false;
        }
        this.submitBufferRecordTickPeriod(bufferRecordTickPeriod);
        return true;
    }

    public void submitRunAtRealTimeRate(boolean runAtRealTimeRate) {
        if (this.runAtRealTimeRate.get() == runAtRealTimeRate) {
            return;
        }
        this.runAtRealTimeRate.set(runAtRealTimeRate);
        this.scheduleSessionTask(this.getActiveMode());
    }

    public void submitPlaybackRealTimeRate(double realTimeRate) {
        if (this.playbackRealTimeRate.get() == realTimeRate) {
            return;
        }
        this.playbackRealTimeRate.set(realTimeRate);
        this.scheduleSessionTask(this.getActiveMode());
    }

    public void submitBufferRecordTickPeriod(int bufferRecordTickPeriod) {
        this.hasBufferRecordPeriodBeenInitialized = true;
        if (bufferRecordTickPeriod == this.bufferRecordTickPeriod.get()) {
            return;
        }
        this.bufferRecordTickPeriod.set(Math.max(1, bufferRecordTickPeriod));
    }

    public void submitDesiredBufferPublishPeriod(long publishPeriod) {
        this.desiredBufferPublishPeriod.set(publishPeriod);
    }

    public void submitCropBufferRequest(CropBufferRequest cropBufferRequest) {
        this.pendingCropBufferRequest.set(cropBufferRequest);
    }

    public void submitFillBufferRequest(FillBufferRequest fillBufferRequest) {
        this.pendingFillBufferRequest.set(fillBufferRequest);
    }

    public void submitBufferSizeRequest(Integer bufferSizeRequest) {
        this.pendingBufferSizeRequest.set(bufferSizeRequest);
        this.hasBufferSizeBeenInitialized = true;
    }

    public void submitBufferIndexRequest(Integer bufferIndexRequest) {
        this.pendingBufferIndexRequest.set(bufferIndexRequest);
    }

    public void submitIncrementBufferIndexRequest(Integer incrementBufferIndexRequest) {
        this.pendingIncrementBufferIndexRequest.set(incrementBufferIndexRequest);
    }

    public void submitDecrementBufferIndexRequest(Integer incrementBufferIndexRequest) {
        this.pendingDecrementBufferIndexRequest.set(incrementBufferIndexRequest);
    }

    public void submitBufferInPointIndexRequest(Integer bufferInPointIndexRequest) {
        this.pendingBufferInPointIndexRequest.set(bufferInPointIndexRequest);
    }

    public void submitBufferOutPointIndexRequest(Integer bufferOutPointIndexRequest) {
        this.pendingBufferOutPointIndexRequest.set(bufferOutPointIndexRequest);
    }

    public void submitSessionDataExportRequest(SessionDataExportRequest sessionDataExportRequest) {
        this.pendingDataExportRequest.set(sessionDataExportRequest);
    }

    public void setSessionState(SessionState state) {
        if (state == SessionState.ACTIVE) {
            if (!this.sessionStarted) {
                LogTools.info((String)"Starting session");
                this.startSessionThread();
                this.sessionStateChangedListeners.forEach(listener -> listener.accept(state));
            }
        } else if (!this.isSessionShutdown) {
            this.shutdownSession();
            this.sessionStateChangedListeners.forEach(listener -> listener.accept(state));
        }
    }

    public void startSessionThread() {
        LogTools.info((String)"Started session's thread");
        this.sessionStarted = true;
        this.scheduleSessionTask(this.getActiveMode());
    }

    public void shutdownSession() {
        if (this.isSessionShutdown) {
            return;
        }
        this.isSessionShutdown = true;
        this.shutdownListeners.forEach(Runnable::run);
        LogTools.info((String)"Stopped session's thread");
        this.sessionStarted = false;
        if (this.activePeriodicTask != null) {
            this.activePeriodicTask.stopAndWait();
            this.activePeriodicTask = null;
        }
        this.sessionTopicListenerManagers.forEach(rec$ -> ((SessionTopicListenerManager)rec$).detachFromMessager());
        this.sessionTopicListenerManagers.clear();
        this.sharedBuffer.dispose();
        this.rootRegistry.clear();
        this.executorService.shutdown();
    }

    private void scheduleSessionTask(SessionMode sessionMode) {
        this.scheduleSessionTask(sessionMode, null);
    }

    private void scheduleSessionTask(SessionMode newMode, final SessionModeTransition transition) {
        Runnable command;
        if (!this.sessionStarted) {
            return;
        }
        SessionMode previousMode = this.activeMode.get();
        if (this.activePeriodicTask != null) {
            this.activePeriodicTask.stopAndWait();
            this.activePeriodicTask = null;
        }
        if (this.isSessionShutdown) {
            return;
        }
        if (newMode != previousMode) {
            this.firstRunTick = true;
            this.firstPauseTick = true;
        }
        this.runActualDT.reset();
        this.playbackActualDT.reset();
        this.pauseActualDT.reset();
        final Runnable sessionModeTask = this.sessionModeToTaskMap.get((Object)newMode);
        if (transition == null) {
            command = sessionModeTask;
        } else {
            Objects.requireNonNull(transition.getNextMode(), "nextMode argument is required when providing a terminalCondition");
            command = new Runnable(){
                private boolean terminated = false;

                @Override
                public void run() {
                    sessionModeTask.run();
                    if (this.terminated) {
                        return;
                    }
                    this.terminated = transition.isDone();
                    if (this.terminated) {
                        Session.this.executorService.execute(() -> {
                            Session.this.setSessionMode(transition.getNextMode());
                            transition.notifyTransitionComplete();
                        });
                    }
                }
            };
        }
        if (this.isSessionShutdown) {
            return;
        }
        this.activePeriodicTask = new PeriodicTaskWrapper(command, this.computeThreadPeriod(newMode), TimeUnit.NANOSECONDS);
        this.activeMode.set(newMode);
        this.schedulingSessionMode(previousMode, newMode);
        this.executorService.execute(this.activePeriodicTask);
        this.sessionModeChangeListeners.forEach(listener -> listener.onChange(previousMode, newMode));
        this.reportActiveMode();
    }

    protected void schedulingSessionMode(SessionMode previousMode, SessionMode newMode) {
    }

    private long computeThreadPeriod(SessionMode mode) {
        switch (mode) {
            case RUNNING: {
                return this.computeRunTaskPeriod();
            }
            case PAUSE: {
                return this.computePauseTaskPeriod();
            }
            case PLAYBACK: {
                return this.computePlaybackTaskPeriod();
            }
        }
        throw new UnsupportedOperationException("Unhandled session mode: " + (Object)((Object)mode));
    }

    protected void setSessionModeTask(SessionMode sessionMode, Runnable runnable) {
        this.sessionModeToTaskMap.put(sessionMode, runnable);
    }

    private void reportActiveMode() {
        for (Consumer<SessionProperties> listener : this.sessionPropertiesListeners) {
            listener.accept(this.getSessionProperties());
        }
    }

    public SessionProperties getSessionProperties() {
        return new SessionProperties(this.activeMode.get(), this.runAtRealTimeRate.get(), this.playbackRealTimeRate.get(), this.sessionDTNanoseconds.get(), this.bufferRecordTickPeriod.get());
    }

    public void initializeSession() {
    }

    protected long computeRunTaskPeriod() {
        return this.runAtRealTimeRate.get() ? this.sessionDTNanoseconds.get() : 1L;
    }

    protected void doGeneric(SessionMode currentMode) {
        long currentTimestamp;
        if (!this.sessionInitialized) {
            this.initializeSession();
            if (currentMode == SessionMode.PAUSE || currentMode == SessionMode.PLAYBACK) {
                this.sharedBuffer.writeBuffer();
            }
            this.sessionInitialized = true;
        }
        if ((currentTimestamp = System.nanoTime()) - this.lastSessionPropertiesPublishTimestamp > 500L) {
            this.lastSessionPropertiesPublishTimestamp = currentTimestamp;
            this.reportActiveMode();
        }
    }

    public void runTick() {
        boolean caughtException;
        this.runTimer.start();
        this.runActualDT.update();
        this.doGeneric(SessionMode.RUNNING);
        this.runInitializeTimer.start();
        this.initializeRunTick();
        this.runInitializeTimer.stop();
        try {
            this.runSpecificTimer.start();
            this.time.set(this.doSpecificRunTick());
            this.runSpecificTimer.stop();
            caughtException = false;
        }
        catch (Throwable e) {
            e.printStackTrace();
            this.runThrowableListeners.forEach(listener -> listener.accept(e));
            caughtException = true;
        }
        this.jvmStatisticsGenerator.update();
        this.runFinalizeTimer.start();
        this.finalizeRunTick(false);
        this.runFinalizeTimer.stop();
        this.runTimer.stop();
        if (caughtException) {
            this.setSessionMode(SessionMode.PAUSE);
        }
    }

    protected void initializeRunTick() {
        if (this.firstRunTick) {
            this.sharedBuffer.incrementBufferIndex(true);
            this.sharedBuffer.processLinkedPushRequests(false);
            this.nextBufferRecordTickCounter = 0;
            this.firstRunTick = false;
        } else if (this.nextBufferRecordTickCounter <= 0) {
            this.sharedBuffer.incrementBufferIndex(true);
            this.sharedBuffer.processLinkedPushRequests(false);
        }
    }

    protected abstract double doSpecificRunTick();

    protected void finalizeRunTick(boolean forceWriteBuffer) {
        boolean writeBuffer;
        boolean bl = writeBuffer = this.nextBufferRecordTickCounter <= 0;
        if (!writeBuffer && forceWriteBuffer) {
            this.sharedBuffer.incrementBufferIndex(true);
            writeBuffer = true;
        }
        if (writeBuffer) {
            this.sharedBuffer.writeBuffer();
            long currentTimestamp = System.nanoTime();
            if (currentTimestamp - this.lastPublishedBufferTimestamp > this.desiredBufferPublishPeriod.get()) {
                this.sharedBuffer.prepareLinkedBuffersForPull();
                this.lastPublishedBufferTimestamp = currentTimestamp;
            }
            this.processBufferRequests(false);
            this.publishBufferProperties(this.sharedBuffer.getProperties());
            this.nextBufferRecordTickCounter = Math.max(1, this.bufferRecordTickPeriod.get());
        }
        --this.nextBufferRecordTickCounter;
    }

    protected long computePlaybackTaskPeriod() {
        long timeIncrement = this.sessionDTNanoseconds.get() * (long)this.bufferRecordTickPeriod.get();
        if (this.playbackRealTimeRate.get() <= 0.5) {
            this.stepSizePerPlaybackTick = 1;
            return (long)((double)timeIncrement / this.playbackRealTimeRate.get());
        }
        this.stepSizePerPlaybackTick = 2 * Math.max(1, (int)Math.floor(this.playbackRealTimeRate.get()));
        return (long)((double)(timeIncrement * (long)this.stepSizePerPlaybackTick) / this.playbackRealTimeRate.get());
    }

    public void playbackTick() {
        boolean caughtException;
        this.playbackTimer.start();
        this.playbackActualDT.update();
        this.doGeneric(SessionMode.PLAYBACK);
        this.initializePlaybackTick();
        try {
            this.doSpecificPlaybackTick();
            caughtException = false;
        }
        catch (Exception e) {
            e.printStackTrace();
            this.playbackThrowableListeners.forEach(listener -> listener.accept(e));
            caughtException = true;
        }
        this.finalizePlaybackTick();
        this.playbackTimer.stop();
        if (caughtException) {
            this.setSessionMode(SessionMode.PAUSE);
        }
    }

    protected void initializePlaybackTick() {
        this.sharedBuffer.flushLinkedPushRequests();
        this.sharedBuffer.readBuffer();
    }

    protected void doSpecificPlaybackTick() {
    }

    protected void finalizePlaybackTick() {
        long currentTimestamp = System.nanoTime();
        if (currentTimestamp - this.lastPublishedBufferTimestamp > this.desiredBufferPublishPeriod.get()) {
            this.sharedBuffer.prepareLinkedBuffersForPull();
            this.lastPublishedBufferTimestamp = currentTimestamp;
        }
        this.sharedBuffer.incrementBufferIndex(false, this.stepSizePerPlaybackTick);
        this.processBufferRequests(false);
        this.publishBufferProperties(this.sharedBuffer.getProperties());
    }

    protected long computePauseTaskPeriod() {
        return Conversions.secondsToNanoseconds((double)0.01);
    }

    public void pauseTick() {
        this.pauseTimer.start();
        this.pauseActualDT.update();
        this.doGeneric(SessionMode.PAUSE);
        boolean shouldReadBuffer = this.initializePauseTick();
        this.finalizePauseTick(shouldReadBuffer |= this.doSpecificPauseTick());
        this.pauseTimer.stop();
    }

    protected boolean initializePauseTick() {
        boolean shouldReadBuffer = this.firstPauseTick;
        this.firstPauseTick = false;
        shouldReadBuffer |= this.sharedBuffer.processLinkedPushRequests(true);
        if (!(shouldReadBuffer |= this.processBufferRequests(true))) {
            shouldReadBuffer = this.sharedBuffer.hasRequestPending();
        }
        return shouldReadBuffer;
    }

    protected boolean doSpecificPauseTick() {
        return false;
    }

    protected void finalizePauseTick(boolean shouldReadBuffer) {
        if (shouldReadBuffer) {
            this.sharedBuffer.readBuffer();
        }
        this.sharedBuffer.prepareLinkedBuffersForPull();
        this.publishBufferProperties(this.sharedBuffer.getProperties());
    }

    protected void publishBufferProperties(YoBufferPropertiesReadOnly bufferProperties) {
        for (Consumer<YoBufferPropertiesReadOnly> listener : this.currentBufferPropertiesListeners) {
            listener.accept(bufferProperties.copy());
        }
    }

    protected boolean processBufferRequests(boolean bufferChangesPermitted) {
        CropBufferRequest newCropRequest;
        boolean hasBufferBeenUpdated = false;
        if (bufferChangesPermitted && (newCropRequest = (CropBufferRequest)this.pendingCropBufferRequest.getAndSet(null)) != null) {
            this.sharedBuffer.cropBuffer(newCropRequest);
            hasBufferBeenUpdated = true;
            bufferChangesPermitted = false;
        }
        if (bufferChangesPermitted) {
            SessionDataExportRequest dataExportRequest;
            FillBufferRequest fillBufferRequest;
            Integer newSize;
            Integer stepSize;
            Integer newOutPoint;
            Integer newInPoint;
            Integer newIndex = this.pendingBufferIndexRequest.getAndSet(null);
            if (newIndex != null) {
                hasBufferBeenUpdated |= this.sharedBuffer.setCurrentIndex(newIndex.intValue());
            }
            if ((newInPoint = (Integer)this.pendingBufferInPointIndexRequest.getAndSet(null)) != null) {
                hasBufferBeenUpdated |= this.sharedBuffer.setInPoint(newInPoint.intValue());
            }
            if ((newOutPoint = (Integer)this.pendingBufferOutPointIndexRequest.getAndSet(null)) != null) {
                hasBufferBeenUpdated |= this.sharedBuffer.setOutPoint(newOutPoint.intValue());
            }
            if ((stepSize = (Integer)this.pendingIncrementBufferIndexRequest.getAndSet(null)) != null) {
                this.sharedBuffer.incrementBufferIndex(false, stepSize.intValue());
                hasBufferBeenUpdated = true;
            }
            if ((stepSize = (Integer)this.pendingDecrementBufferIndexRequest.getAndSet(null)) != null) {
                this.sharedBuffer.decrementBufferIndex(stepSize.intValue());
                hasBufferBeenUpdated = true;
            }
            if ((newSize = (Integer)this.pendingBufferSizeRequest.getAndSet(null)) != null) {
                hasBufferBeenUpdated |= this.sharedBuffer.resizeBuffer(newSize.intValue());
            }
            if ((fillBufferRequest = (FillBufferRequest)this.pendingFillBufferRequest.getAndSet(null)) != null) {
                this.sharedBuffer.fillBuffer(fillBufferRequest);
                hasBufferBeenUpdated = true;
            }
            if ((dataExportRequest = (SessionDataExportRequest)this.pendingDataExportRequest.getAndSet(null)) != null) {
                try {
                    SessionIOTools.exportSessionData(this, dataExportRequest);
                }
                catch (IOException | URISyntaxException | JAXBException e) {
                    e.printStackTrace();
                }
            }
            return hasBufferBeenUpdated;
        }
        Integer newSize = this.pendingBufferSizeRequest.getAndSet(null);
        if (newSize != null) {
            this.sharedBuffer.resizeBuffer(newSize.intValue());
        }
        this.pendingBufferIndexRequest.set(null);
        this.pendingIncrementBufferIndexRequest.set(null);
        this.pendingDecrementBufferIndexRequest.set(null);
        this.pendingBufferInPointIndexRequest.set(null);
        this.pendingBufferOutPointIndexRequest.set(null);
        this.pendingCropBufferRequest.set(null);
        return hasBufferBeenUpdated;
    }

    public YoDouble getTime() {
        return this.time;
    }

    public YoRegistry getRootRegistry() {
        return this.rootRegistry;
    }

    public boolean hasSessionStarted() {
        return this.sessionStarted;
    }

    public SessionMode getActiveMode() {
        return this.activeMode.get();
    }

    public boolean getRunAtRealTimeRate() {
        return this.runAtRealTimeRate.get();
    }

    public double getPlaybackRealTimeRate() {
        return this.playbackRealTimeRate.get();
    }

    public int getBufferRecordTickPeriod() {
        return this.bufferRecordTickPeriod.get();
    }

    public double getSessionDTSeconds() {
        return (double)this.sessionDTNanoseconds.get() * 1.0E-9;
    }

    public long getSessionDTNanoseconds() {
        return this.sessionDTNanoseconds.get();
    }

    public long getDesiredBufferPublishPeriod() {
        return this.desiredBufferPublishPeriod.get();
    }

    public abstract String getSessionName();

    public ReferenceFrame getInertialFrame() {
        return DEFAULT_INERTIAL_FRAME;
    }

    public abstract List<RobotDefinition> getRobotDefinitions();

    public abstract List<TerrainObjectDefinition> getTerrainObjectDefinitions();

    public List<YoGraphicDefinition> getYoGraphicDefinitions() {
        return Collections.emptyList();
    }

    YoSharedBuffer getBuffer() {
        return this.sharedBuffer;
    }

    public LinkedYoVariableFactory getLinkedYoVariableFactory() {
        return this.sharedBuffer;
    }

    public static class PeriodicTaskWrapper
    implements Runnable {
        private static final int ONE_MILLION = 1000000;
        private final Runnable task;
        private final long periodInNanos;
        private final AtomicBoolean running = new AtomicBoolean(true);
        private final AtomicBoolean isDone = new AtomicBoolean(false);
        private final CountDownLatch startedLatch = new CountDownLatch(1);
        private final CountDownLatch doneLatch = new CountDownLatch(1);
        private Thread owner;

        public PeriodicTaskWrapper(Runnable task, long period, TimeUnit timeUnit) {
            this.task = task;
            this.periodInNanos = timeUnit.toNanos(period);
        }

        public void stop() {
            this.running.set(false);
        }

        public boolean isDone() {
            return this.isDone.get();
        }

        public void stopAndWait() {
            this.stop();
            if (Thread.currentThread() == this.owner) {
                return;
            }
            try {
                this.doneLatch.await();
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }

        public void waitUntilFirstTickDone() {
            if (Thread.currentThread() == this.owner) {
                return;
            }
            try {
                this.startedLatch.await();
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }

        @Override
        public void run() {
            if (this.owner == null) {
                this.owner = Thread.currentThread();
            }
            block4: while (true) {
                try {
                    while (this.running.get()) {
                        long timeElapsed = System.nanoTime();
                        this.task.run();
                        timeElapsed = System.nanoTime() - timeElapsed;
                        this.startedLatch.countDown();
                        if (timeElapsed >= this.periodInNanos) continue;
                        long nanos = this.periodInNanos - timeElapsed;
                        long millis = nanos / 1000000L;
                        nanos -= millis * 1000000L;
                        try {
                            Thread.sleep(millis, (int)nanos);
                            continue block4;
                        }
                        catch (InterruptedException e) {
                            e.printStackTrace();
                            this.running.set(false);
                        }
                    }
                    break;
                }
                catch (Throwable e) {
                    e.printStackTrace();
                    break;
                }
            }
            this.isDone.set(true);
            this.doneLatch.countDown();
        }
    }

    public static interface SessionModeChangeListener {
        public void onChange(SessionMode var1, SessionMode var2);
    }

    public static interface SessionModeTransition {
        public SessionMode getNextMode();

        public boolean isDone();

        default public void notifyTransitionComplete() {
        }

        public static SessionModeTransition newTransition(final BooleanSupplier doneCondition, final SessionMode nextMode) {
            return new SessionModeTransition(){

                @Override
                public boolean isDone() {
                    return doneCondition.getAsBoolean();
                }

                @Override
                public SessionMode getNextMode() {
                    return nextMode;
                }
            };
        }
    }

    private class SessionTopicListenerManager {
        private final Messager messager;
        private final TopicListener<CropBufferRequest> cropRequestListener = Session.this::submitCropBufferRequest;
        private final TopicListener<FillBufferRequest> fillRequestListener = Session.this::submitFillBufferRequest;
        private final TopicListener<Integer> currentIndexListener = Session.this::submitBufferIndexRequest;
        private final TopicListener<Integer> inPointIndexListener = Session.this::submitBufferInPointIndexRequest;
        private final TopicListener<Integer> outPointIndexListener = Session.this::submitBufferOutPointIndexRequest;
        private final TopicListener<Integer> incrementCurrentIndexListener = Session.this::submitIncrementBufferIndexRequest;
        private final TopicListener<Integer> decrementCurrentIndexListener = Session.this::submitDecrementBufferIndexRequest;
        private final TopicListener<Integer> currentBufferSizeListener = Session.this::submitBufferSizeRequest;
        private final TopicListener<Integer> initializeBufferSizeListener = Session.this::initializeBufferSize;
        private final TopicListener<SessionState> sessionCurrentStateListener = Session.this::setSessionState;
        private final TopicListener<SessionMode> sessionCurrentModeListener = Session.this::setSessionMode;
        private final TopicListener<Long> sessionDTNanosecondsListener = Session.this::setSessionDTNanoseconds;
        private final TopicListener<Boolean> runAtRealTimeRateListener = Session.this::submitRunAtRealTimeRate;
        private final TopicListener<Double> playbackRealTimeRateListener = Session.this::submitPlaybackRealTimeRate;
        private final TopicListener<Integer> bufferRecordTickPeriodListener = Session.this::submitBufferRecordTickPeriod;
        private final TopicListener<Integer> initializeBufferRecordTickPeriodListener = Session.this::initializeBufferRecordTickPeriod;
        private final TopicListener<SessionDataExportRequest> sessionDataExportRequestListener = Session.this::submitSessionDataExportRequest;
        private final Consumer<YoBufferPropertiesReadOnly> bufferPropertiesListener = this.createBufferPropertiesListener();
        private final Consumer<SessionProperties> sessionPropertiesListener = this.createSessionPropertiesListener();

        private SessionTopicListenerManager(Messager messager) {
            this.messager = messager;
            Session.this.addCurrentBufferPropertiesListener(this.bufferPropertiesListener);
            messager.registerTopicListener(YoSharedBufferMessagerAPI.CropRequest, this.cropRequestListener);
            messager.registerTopicListener(YoSharedBufferMessagerAPI.FillRequest, this.fillRequestListener);
            messager.registerTopicListener(YoSharedBufferMessagerAPI.CurrentIndexRequest, this.currentIndexListener);
            messager.registerTopicListener(YoSharedBufferMessagerAPI.InPointIndexRequest, this.inPointIndexListener);
            messager.registerTopicListener(YoSharedBufferMessagerAPI.OutPointIndexRequest, this.outPointIndexListener);
            messager.registerTopicListener(YoSharedBufferMessagerAPI.IncrementCurrentIndexRequest, this.incrementCurrentIndexListener);
            messager.registerTopicListener(YoSharedBufferMessagerAPI.DecrementCurrentIndexRequest, this.decrementCurrentIndexListener);
            messager.registerTopicListener(YoSharedBufferMessagerAPI.CurrentBufferSizeRequest, this.currentBufferSizeListener);
            messager.registerTopicListener(YoSharedBufferMessagerAPI.InitializeBufferSize, this.initializeBufferSizeListener);
            Session.this.addSessionPropertiesListener(this.sessionPropertiesListener);
            messager.registerTopicListener(SessionMessagerAPI.SessionCurrentState, this.sessionCurrentStateListener);
            messager.registerTopicListener(SessionMessagerAPI.SessionCurrentMode, this.sessionCurrentModeListener);
            messager.registerTopicListener(SessionMessagerAPI.SessionDTNanoseconds, this.sessionDTNanosecondsListener);
            messager.registerTopicListener(SessionMessagerAPI.RunAtRealTimeRate, this.runAtRealTimeRateListener);
            messager.registerTopicListener(SessionMessagerAPI.PlaybackRealTimeRate, this.playbackRealTimeRateListener);
            messager.registerTopicListener(SessionMessagerAPI.BufferRecordTickPeriod, this.bufferRecordTickPeriodListener);
            messager.registerTopicListener(SessionMessagerAPI.InitializeBufferRecordTickPeriod, this.initializeBufferRecordTickPeriodListener);
            messager.registerTopicListener(SessionMessagerAPI.SessionDataExportRequest, this.sessionDataExportRequestListener);
        }

        private void detachFromMessager() {
            if (this.messager == null) {
                return;
            }
            this.messager.removeTopicListener(YoSharedBufferMessagerAPI.CropRequest, this.cropRequestListener);
            this.messager.removeTopicListener(YoSharedBufferMessagerAPI.FillRequest, this.fillRequestListener);
            this.messager.removeTopicListener(YoSharedBufferMessagerAPI.CurrentIndexRequest, this.currentIndexListener);
            this.messager.removeTopicListener(YoSharedBufferMessagerAPI.InPointIndexRequest, this.inPointIndexListener);
            this.messager.removeTopicListener(YoSharedBufferMessagerAPI.OutPointIndexRequest, this.outPointIndexListener);
            this.messager.removeTopicListener(YoSharedBufferMessagerAPI.IncrementCurrentIndexRequest, this.incrementCurrentIndexListener);
            this.messager.removeTopicListener(YoSharedBufferMessagerAPI.DecrementCurrentIndexRequest, this.decrementCurrentIndexListener);
            this.messager.removeTopicListener(YoSharedBufferMessagerAPI.CurrentBufferSizeRequest, this.currentBufferSizeListener);
            this.messager.removeTopicListener(YoSharedBufferMessagerAPI.InitializeBufferSize, this.initializeBufferSizeListener);
            this.messager.removeTopicListener(SessionMessagerAPI.SessionCurrentState, this.sessionCurrentStateListener);
            this.messager.removeTopicListener(SessionMessagerAPI.SessionCurrentMode, this.sessionCurrentModeListener);
            this.messager.removeTopicListener(SessionMessagerAPI.SessionDTNanoseconds, this.sessionDTNanosecondsListener);
            this.messager.removeTopicListener(SessionMessagerAPI.RunAtRealTimeRate, this.runAtRealTimeRateListener);
            this.messager.removeTopicListener(SessionMessagerAPI.PlaybackRealTimeRate, this.playbackRealTimeRateListener);
            this.messager.removeTopicListener(SessionMessagerAPI.BufferRecordTickPeriod, this.bufferRecordTickPeriodListener);
            this.messager.removeTopicListener(SessionMessagerAPI.InitializeBufferRecordTickPeriod, this.initializeBufferRecordTickPeriodListener);
            this.messager.removeTopicListener(SessionMessagerAPI.SessionDataExportRequest, this.sessionDataExportRequestListener);
        }

        private Consumer<YoBufferPropertiesReadOnly> createBufferPropertiesListener() {
            return bufferProperties -> {
                if (!this.messager.isMessagerOpen()) {
                    return;
                }
                this.messager.submitMessage(YoSharedBufferMessagerAPI.CurrentBufferProperties, bufferProperties);
            };
        }

        private Consumer<SessionProperties> createSessionPropertiesListener() {
            return sessionProperties -> {
                if (!this.messager.isMessagerOpen()) {
                    return;
                }
                this.messager.submitMessage(SessionMessagerAPI.SessionCurrentMode, (Object)sessionProperties.getActiveMode());
                this.messager.submitMessage(SessionMessagerAPI.SessionDTNanoseconds, (Object)sessionProperties.getSessionDTNanoseconds());
                this.messager.submitMessage(SessionMessagerAPI.PlaybackRealTimeRate, (Object)sessionProperties.getPlaybackRealTimeRate());
                this.messager.submitMessage(SessionMessagerAPI.RunAtRealTimeRate, (Object)sessionProperties.isRunAtRealTimeRate());
                this.messager.submitMessage(SessionMessagerAPI.BufferRecordTickPeriod, (Object)sessionProperties.getBufferRecordTickPeriod());
            };
        }
    }
}

