/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.scs2.sessionVisualizer;

import us.ihmc.euclid.geometry.tools.EuclidGeometryTools;
import us.ihmc.euclid.matrix.RotationMatrix;
import us.ihmc.euclid.matrix.interfaces.Matrix3DReadOnly;
import us.ihmc.euclid.matrix.interfaces.RotationMatrixBasics;
import us.ihmc.euclid.matrix.interfaces.RotationMatrixReadOnly;
import us.ihmc.euclid.orientation.interfaces.Orientation3DBasics;
import us.ihmc.euclid.tuple2D.Point2D32;
import us.ihmc.euclid.tuple3D.Point3D32;
import us.ihmc.euclid.tuple3D.Vector3D;
import us.ihmc.euclid.tuple3D.Vector3D32;
import us.ihmc.euclid.tuple3D.interfaces.Point3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Vector3DReadOnly;
import us.ihmc.scs2.definition.geometry.TriangleMesh3DDefinition;

public final class SegmentedLine3DTriangleMeshFactory {
    private final TriangleMesh3DDefinition[] triangleMeshes;
    private final CircleVertices circleTemplate;
    private final CircleVertices[] circles;
    private final Vector3D previousDirection = new Vector3D();
    private final RotationMatrix rotation = new RotationMatrix();
    private final RotationMatrix previousRotation = new RotationMatrix();
    private final Vector3D tempDirection = new Vector3D();
    private final Vector3D tempPreviousSegment = new Vector3D();
    private final Vector3D tempNextSegment = new Vector3D();

    public SegmentedLine3DTriangleMeshFactory(int numberOfWaypoints, int radialResolution) {
        this(numberOfWaypoints, radialResolution, 1.0);
    }

    public SegmentedLine3DTriangleMeshFactory(int numberOfWaypoints, int radialResolution, double radius) {
        this.circleTemplate = new CircleVertices(radialResolution);
        this.circleTemplate.setRadius(radius);
        this.circles = new CircleVertices[numberOfWaypoints];
        for (int i = 0; i < numberOfWaypoints; ++i) {
            this.circles[i] = new CircleVertices(radialResolution);
        }
        this.triangleMeshes = SegmentedLine3DTriangleMeshFactory.createTriangleMesh3DDefinitions(this.circles);
    }

    public void compute(Point3DReadOnly[] waypointPositions) {
        this.compute(waypointPositions, null);
    }

    public void compute(Point3DReadOnly[] waypointPositions, Vector3DReadOnly[] waypointDirections) {
        if (waypointPositions.length != this.circles.length) {
            throw new RuntimeException("Unexpected array size. Expected: " + this.circles.length + ", but was: " + waypointPositions.length);
        }
        if (waypointDirections != null && waypointDirections.length != this.circles.length) {
            throw new RuntimeException("Unexpected array size. Expected: " + this.circles.length + ", but was: " + waypointDirections.length);
        }
        int sectionIndex = 0;
        this.previousDirection.set(0.0, 0.0, 1.0);
        this.previousRotation.setIdentity();
        for (sectionIndex = 0; sectionIndex < this.circles.length; ++sectionIndex) {
            Vector3DReadOnly sectionDirection = this.computeNormalizedSectionDirection(sectionIndex, waypointPositions, waypointDirections);
            this.computeRotation((Vector3DReadOnly)this.previousDirection, sectionDirection, (RotationMatrixReadOnly)this.previousRotation, (RotationMatrixBasics)this.rotation);
            this.previousDirection.set((Tuple3DReadOnly)sectionDirection);
            CircleVertices currentCircle = this.circles[sectionIndex];
            currentCircle.set(this.circleTemplate);
            currentCircle.rotate((Matrix3DReadOnly)this.rotation);
            currentCircle.translate((Tuple3DReadOnly)waypointPositions[sectionIndex]);
            this.previousRotation.set(this.rotation);
        }
    }

    public void setLineRadius(double radius) {
        this.circleTemplate.setRadius(radius);
    }

    public int getNumberOfWaypoints() {
        return this.circles.length;
    }

    public TriangleMesh3DDefinition[] getTriangleMesh3DDefinitions() {
        return this.triangleMeshes;
    }

    public double getLineRadius() {
        return this.circleTemplate.radius;
    }

    public int getRadialResolution() {
        return this.circleTemplate.getNumberOfVertices();
    }

    private static TriangleMesh3DDefinition[] createTriangleMesh3DDefinitions(CircleVertices[] circles) {
        int numberOfWaypoint = circles.length;
        TriangleMesh3DDefinition[] triangleMeshes = new TriangleMesh3DDefinition[numberOfWaypoint - 1];
        for (int waypointIndex = 0; waypointIndex < numberOfWaypoint - 1; ++waypointIndex) {
            CircleVertices currentCircle = circles[waypointIndex];
            CircleVertices nextCircle = circles[waypointIndex + 1];
            int radialResolution = currentCircle.getNumberOfVertices();
            int numberOfVertices = 2 * radialResolution;
            Point2D32[] texturePoints = new Point2D32[numberOfVertices];
            Point3D32[] vertices = new Point3D32[numberOfVertices];
            Vector3D32[] vertexNormals = new Vector3D32[numberOfVertices];
            for (int i = 0; i < radialResolution; ++i) {
                vertices[i] = currentCircle.vertices[i];
                vertexNormals[i] = currentCircle.normals[i];
                vertices[i + radialResolution] = nextCircle.vertices[i];
                vertexNormals[i + radialResolution] = nextCircle.normals[i];
            }
            int index = 0;
            int[] triangleIndices = new int[6 * radialResolution];
            for (int vertexIndex = 0; vertexIndex < radialResolution; ++vertexIndex) {
                int nextVertexIndex = (vertexIndex + 1) % radialResolution;
                triangleIndices[index++] = vertexIndex;
                triangleIndices[index++] = nextVertexIndex;
                triangleIndices[index++] = vertexIndex + radialResolution;
                triangleIndices[index++] = nextVertexIndex;
                triangleIndices[index++] = nextVertexIndex + radialResolution;
                triangleIndices[index++] = vertexIndex + radialResolution;
            }
            for (int i = 0; i < numberOfVertices; ++i) {
                texturePoints[i] = new Point2D32();
            }
            triangleMeshes[waypointIndex] = new TriangleMesh3DDefinition(vertices, texturePoints, vertexNormals, triangleIndices);
        }
        return triangleMeshes;
    }

    private void computeRotation(Vector3DReadOnly previousDirection, Vector3DReadOnly sectionDirection, RotationMatrixReadOnly previousRotation, RotationMatrixBasics rotationToPack) {
        EuclidGeometryTools.orientation3DFromFirstToSecondVector3D((Vector3DReadOnly)previousDirection, (Vector3DReadOnly)sectionDirection, (Orientation3DBasics)rotationToPack);
        rotationToPack.preMultiply(previousRotation);
    }

    private Vector3DReadOnly computeNormalizedSectionDirection(int sectionIndex, Point3DReadOnly[] sectionCenters, Vector3DReadOnly[] sectionDirections) {
        if (sectionDirections != null) {
            this.tempDirection.set((Tuple3DReadOnly)sectionDirections[sectionIndex]);
            double length = this.tempDirection.length();
            if (length > 1.0E-8) {
                this.tempDirection.scale(1.0 / length);
                return this.tempDirection;
            }
        }
        if (sectionIndex == 0) {
            this.tempDirection.sub((Tuple3DReadOnly)sectionCenters[1], (Tuple3DReadOnly)sectionCenters[0]);
        } else if (sectionIndex == sectionCenters.length - 1) {
            this.tempDirection.sub((Tuple3DReadOnly)sectionCenters[sectionCenters.length - 1], (Tuple3DReadOnly)sectionCenters[sectionCenters.length - 2]);
        } else {
            Point3DReadOnly previousCenter = sectionCenters[sectionIndex - 1];
            Point3DReadOnly currentCenter = sectionCenters[sectionIndex];
            Point3DReadOnly nextCenter = sectionCenters[sectionIndex + 1];
            this.tempPreviousSegment.sub((Tuple3DReadOnly)currentCenter, (Tuple3DReadOnly)previousCenter);
            this.tempNextSegment.sub((Tuple3DReadOnly)nextCenter, (Tuple3DReadOnly)currentCenter);
            double previousLength = this.tempPreviousSegment.length();
            double nextLength = this.tempNextSegment.length();
            double alpha = nextLength / (previousLength + nextLength);
            this.tempDirection.interpolate((Tuple3DReadOnly)this.tempPreviousSegment, (Tuple3DReadOnly)this.tempNextSegment, alpha);
        }
        this.tempDirection.normalize();
        return this.tempDirection;
    }

    private static final class CircleVertices {
        private final Point3D32[] vertices;
        private final Vector3D32[] normals;
        private double radius = 1.0;

        public CircleVertices(int numberOfVertices) {
            int i;
            this.vertices = new Point3D32[numberOfVertices];
            this.normals = new Vector3D32[numberOfVertices];
            for (i = 0; i < numberOfVertices; ++i) {
                this.vertices[i] = new Point3D32();
                this.normals[i] = new Vector3D32();
            }
            for (i = 0; i < numberOfVertices; ++i) {
                double angle = (double)i / (double)numberOfVertices * 2.0 * Math.PI;
                double ux = Math.cos(angle);
                double uy = Math.sin(angle);
                this.vertices[i].set(this.radius * ux, this.radius * uy, 0.0);
                this.normals[i].set(ux, uy, 0.0);
            }
        }

        public void setRadius(double radius) {
            double scale = radius / this.radius;
            for (Point3D32 vertex : this.vertices) {
                vertex.scale(scale);
            }
            this.radius = radius;
        }

        private void set(CircleVertices other) {
            int numberOfVertices = this.getNumberOfVertices();
            for (int i = 0; i < numberOfVertices; ++i) {
                this.vertices[i].set(other.vertices[i]);
                this.normals[i].set(other.normals[i]);
            }
        }

        public void translate(Tuple3DReadOnly translation) {
            for (Point3D32 vertex : this.vertices) {
                vertex.add(translation);
            }
        }

        public void rotate(Matrix3DReadOnly rotationMatrix) {
            double z;
            double y;
            double x;
            for (Point3D32 point3D32 : this.vertices) {
                x = rotationMatrix.getM00() * point3D32.getX() + rotationMatrix.getM01() * point3D32.getY();
                y = rotationMatrix.getM10() * point3D32.getX() + rotationMatrix.getM11() * point3D32.getY();
                z = rotationMatrix.getM20() * point3D32.getX() + rotationMatrix.getM21() * point3D32.getY();
                point3D32.set(x, y, z);
            }
            for (Point3D32 point3D32 : this.normals) {
                x = rotationMatrix.getM00() * point3D32.getX() + rotationMatrix.getM01() * point3D32.getY();
                y = rotationMatrix.getM10() * point3D32.getX() + rotationMatrix.getM11() * point3D32.getY();
                z = rotationMatrix.getM20() * point3D32.getX() + rotationMatrix.getM21() * point3D32.getY();
                point3D32.set(x, y, z);
            }
        }

        public int getNumberOfVertices() {
            return this.vertices.length;
        }
    }
}

