/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.scs2.sessionVisualizer;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import us.ihmc.euclid.tuple2D.Point2D32;
import us.ihmc.euclid.tuple3D.Point3D32;
import us.ihmc.euclid.tuple3D.Vector3D32;
import us.ihmc.scs2.definition.geometry.TriangleMesh3DDefinition;
import us.ihmc.scs2.sessionVisualizer.TriangleMesh3DFactories;

public class TriangleMesh3DFactoriesTest {
    @Test
    public void testCombine() {
        TriangleMesh3DDefinition originalTorus = TriangleMesh3DFactories.Torus((double)0.15, (double)0.05, (int)64);
        TriangleMesh3DDefinition originalSphere = TriangleMesh3DFactories.Sphere((double)0.1, (int)32, (int)32);
        TriangleMesh3DDefinition torus = TriangleMesh3DFactories.Torus((double)0.15, (double)0.05, (int)64);
        TriangleMesh3DDefinition sphere = TriangleMesh3DFactories.Sphere((double)0.1, (int)32, (int)32);
        TriangleMesh3DDefinition combined = TriangleMesh3DFactories.combine((boolean)false, (boolean)false, (TriangleMesh3DDefinition[])new TriangleMesh3DDefinition[]{torus, sphere});
        Assertions.assertEquals((int)(originalTorus.getVertices().length + originalSphere.getVertices().length), (int)combined.getVertices().length);
        Assertions.assertEquals((int)(originalTorus.getTextures().length + originalSphere.getTextures().length), (int)combined.getTextures().length);
        Assertions.assertEquals((int)(originalTorus.getNormals().length + originalSphere.getNormals().length), (int)combined.getNormals().length);
        Assertions.assertEquals((int)(originalTorus.getTriangleIndices().length + originalSphere.getTriangleIndices().length), (int)combined.getTriangleIndices().length);
        Assertions.assertIterableEquals(Arrays.asList(originalTorus.getVertices()), Arrays.asList(combined.getVertices()).subList(0, originalTorus.getVertices().length));
        Assertions.assertIterableEquals(Arrays.asList(originalTorus.getTextures()), Arrays.asList(combined.getTextures()).subList(0, originalTorus.getTextures().length));
        Assertions.assertIterableEquals(Arrays.asList(originalTorus.getNormals()), Arrays.asList(combined.getNormals()).subList(0, originalTorus.getNormals().length));
        Assertions.assertIterableEquals(TriangleMesh3DFactoriesTest.intArrayToList(originalTorus.getTriangleIndices()), TriangleMesh3DFactoriesTest.intArrayToList(combined.getTriangleIndices()).subList(0, originalTorus.getTriangleIndices().length));
        Assertions.assertIterableEquals(Arrays.asList(originalSphere.getVertices()), Arrays.asList(combined.getVertices()).subList(originalTorus.getVertices().length, combined.getVertices().length));
        Assertions.assertIterableEquals(Arrays.asList(originalSphere.getTextures()), Arrays.asList(combined.getTextures()).subList(originalTorus.getTextures().length, combined.getTextures().length));
        Assertions.assertIterableEquals(Arrays.asList(originalSphere.getNormals()), Arrays.asList(combined.getNormals()).subList(originalTorus.getNormals().length, combined.getNormals().length));
        Assertions.assertIterableEquals(TriangleMesh3DFactoriesTest.intArrayToList(originalSphere.getTriangleIndices()), TriangleMesh3DFactoriesTest.intArrayToList(combined.getTriangleIndices()).subList(originalTorus.getTriangleIndices().length, combined.getTriangleIndices().length));
        TriangleMesh3DDefinition originalShape1 = TriangleMesh3DFactories.Torus((double)0.15, (double)0.05, (int)64);
        TriangleMesh3DDefinition originalShape2 = TriangleMesh3DFactories.Sphere((double)0.1, (int)32, (int)32);
        TriangleMesh3DDefinition shape1 = TriangleMesh3DFactories.Torus((double)0.15, (double)0.05, (int)64);
        TriangleMesh3DDefinition shape2 = TriangleMesh3DFactories.Sphere((double)0.1, (int)32, (int)32);
        combined = TriangleMesh3DFactories.combine((boolean)true, (boolean)false, (TriangleMesh3DDefinition[])new TriangleMesh3DDefinition[]{shape1, shape2});
        Point3D32[] v1 = originalShape1.getVertices();
        Point2D32[] t1 = originalShape1.getTextures();
        Vector3D32[] n1 = originalShape1.getNormals();
        int[] i1 = originalShape1.getTriangleIndices();
        Point3D32[] v2 = originalShape2.getVertices();
        Point2D32[] t2 = originalShape2.getTextures();
        Vector3D32[] n2 = originalShape2.getNormals();
        int[] i2 = originalShape2.getTriangleIndices();
        Point3D32[] vc = combined.getVertices();
        Point2D32[] tc = combined.getTextures();
        Vector3D32[] nc = combined.getNormals();
        int[] ic = combined.getTriangleIndices();
        Assertions.assertEquals((int)(v1.length + v2.length), (int)vc.length);
        Assertions.assertEquals((int)(t1.length + t2.length), (int)tc.length);
        Assertions.assertEquals((int)(n1.length + n2.length), (int)nc.length);
        Assertions.assertEquals((int)(i1.length + i2.length), (int)ic.length);
        Assertions.assertIterableEquals(Arrays.asList(v1), Arrays.asList(vc).subList(0, v1.length));
        Assertions.assertIterableEquals(Arrays.asList(t1), Arrays.asList(tc).subList(0, t1.length));
        Assertions.assertIterableEquals(Arrays.asList(n1), Arrays.asList(nc).subList(0, n1.length));
        Assertions.assertIterableEquals(TriangleMesh3DFactoriesTest.intArrayToList(i1), TriangleMesh3DFactoriesTest.intArrayToList(ic).subList(0, i1.length));
        Assertions.assertIterableEquals(Arrays.asList(v2), Arrays.asList(vc).subList(v1.length, vc.length));
        Assertions.assertIterableEquals(Arrays.asList(t2), Arrays.asList(tc).subList(t1.length, tc.length));
        Assertions.assertIterableEquals(Arrays.asList(n2), Arrays.asList(nc).subList(n1.length, nc.length));
        Assertions.assertIterableEquals(TriangleMesh3DFactoriesTest.intArrayToList(TriangleMesh3DFactoriesTest.shift(i2, v1.length)), TriangleMesh3DFactoriesTest.intArrayToList(ic).subList(i1.length, ic.length));
        originalShape1 = TriangleMesh3DFactories.Torus((double)0.15, (double)0.05, (int)16);
        originalShape2 = TriangleMesh3DFactories.Sphere((double)0.1, (int)8, (int)8);
        TriangleMesh3DDefinition originalShape3 = TriangleMesh3DFactories.Box((double)0.1, (double)0.2, (double)0.3, (boolean)true);
        TriangleMesh3DDefinition shape12 = TriangleMesh3DFactories.Torus((double)0.15, (double)0.05, (int)16);
        TriangleMesh3DDefinition shape22 = TriangleMesh3DFactories.Sphere((double)0.1, (int)8, (int)8);
        TriangleMesh3DDefinition shape3 = TriangleMesh3DFactories.Box((double)0.1, (double)0.2, (double)0.3, (boolean)true);
        shape12.setName("shape1");
        shape22.setName("shape2");
        shape3.setName("shape3");
        TriangleMesh3DDefinition combined2 = TriangleMesh3DFactories.combine((boolean)true, (boolean)false, (TriangleMesh3DDefinition[])new TriangleMesh3DDefinition[]{shape12, shape22, shape3});
        Point3D32[] v12 = originalShape1.getVertices();
        Point2D32[] t12 = originalShape1.getTextures();
        Vector3D32[] n12 = originalShape1.getNormals();
        int[] i12 = originalShape1.getTriangleIndices();
        Point3D32[] v22 = originalShape2.getVertices();
        Point2D32[] t22 = originalShape2.getTextures();
        Vector3D32[] n22 = originalShape2.getNormals();
        int[] i22 = originalShape2.getTriangleIndices();
        Point3D32[] v3 = originalShape3.getVertices();
        Point2D32[] t3 = originalShape3.getTextures();
        Vector3D32[] n3 = originalShape3.getNormals();
        int[] i3 = originalShape3.getTriangleIndices();
        Point3D32[] vc2 = combined2.getVertices();
        Point2D32[] tc2 = combined2.getTextures();
        Vector3D32[] nc2 = combined2.getNormals();
        int[] ic2 = combined2.getTriangleIndices();
        Assertions.assertEquals((int)(v12.length + v22.length + v3.length), (int)vc2.length);
        Assertions.assertEquals((int)(t12.length + t22.length + t3.length), (int)tc2.length);
        Assertions.assertEquals((int)(n12.length + n22.length + n3.length), (int)nc2.length);
        Assertions.assertEquals((int)(i12.length + i22.length + i3.length), (int)ic2.length);
        Assertions.assertIterableEquals(Arrays.asList(v12), Arrays.asList(vc2).subList(0, v12.length));
        Assertions.assertIterableEquals(Arrays.asList(t12), Arrays.asList(tc2).subList(0, t12.length));
        Assertions.assertIterableEquals(Arrays.asList(n12), Arrays.asList(nc2).subList(0, n12.length));
        Assertions.assertIterableEquals(TriangleMesh3DFactoriesTest.intArrayToList(i12), TriangleMesh3DFactoriesTest.intArrayToList(ic2).subList(0, i12.length));
        Assertions.assertIterableEquals(Arrays.asList(v22), Arrays.asList(vc2).subList(v12.length, v12.length + v22.length));
        Assertions.assertIterableEquals(Arrays.asList(t22), Arrays.asList(tc2).subList(t12.length, t12.length + t22.length));
        Assertions.assertIterableEquals(Arrays.asList(n22), Arrays.asList(nc2).subList(n12.length, n12.length + n22.length));
        Assertions.assertIterableEquals(TriangleMesh3DFactoriesTest.intArrayToList(TriangleMesh3DFactoriesTest.shift(i22, v12.length)), TriangleMesh3DFactoriesTest.intArrayToList(ic2).subList(i12.length, i12.length + i22.length));
        Assertions.assertIterableEquals(Arrays.asList(v3), Arrays.asList(vc2).subList(v12.length + v22.length, vc2.length));
        Assertions.assertIterableEquals(Arrays.asList(t3), Arrays.asList(tc2).subList(t12.length + t22.length, tc2.length));
        Assertions.assertIterableEquals(Arrays.asList(n3), Arrays.asList(nc2).subList(n12.length + n22.length, nc2.length));
        Assertions.assertIterableEquals(TriangleMesh3DFactoriesTest.intArrayToList(TriangleMesh3DFactoriesTest.shift(i3, v12.length + v22.length)), TriangleMesh3DFactoriesTest.intArrayToList(ic2).subList(i12.length + i22.length, ic2.length));
    }

    private static List<Integer> intArrayToList(int[] array) {
        ArrayList<Integer> list = new ArrayList<Integer>(array.length);
        for (int e : array) {
            list.add(e);
        }
        return list;
    }

    private static int[] shift(int[] array, int shift) {
        int[] out = new int[array.length];
        for (int i = 0; i < array.length; ++i) {
            out[i] = array[i] + shift;
        }
        return out;
    }
}

