/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.scs2.sessionVisualizer.jfx.controllers.sliderboard;

import com.jfoenix.controls.JFXSpinner;
import com.jfoenix.controls.JFXTextField;
import java.util.ArrayList;
import java.util.List;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.SimpleDoubleProperty;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.scene.control.Slider;
import javafx.scene.control.TextFormatter;
import javafx.util.StringConverter;
import javafx.util.converter.DoubleStringConverter;
import org.apache.commons.lang3.mutable.MutableBoolean;
import us.ihmc.scs2.definition.yoSlider.YoKnobDefinition;
import us.ihmc.scs2.definition.yoSlider.YoSliderDefinition;
import us.ihmc.scs2.sessionVisualizer.jfx.controllers.sliderboard.YoVariableSlider;
import us.ihmc.scs2.sessionVisualizer.jfx.properties.YoDoubleProperty;
import us.ihmc.scs2.sessionVisualizer.jfx.tools.JavaFXMissingTools;
import us.ihmc.scs2.sessionVisualizer.sliderboard.SliderboardVariable;
import us.ihmc.scs2.sharedMemory.LinkedYoDouble;
import us.ihmc.scs2.sharedMemory.LinkedYoRegistry;
import us.ihmc.yoVariables.variable.YoDouble;
import us.ihmc.yoVariables.variable.YoVariable;

public class YoDoubleSlider
implements YoVariableSlider {
    private final YoDoubleProperty yoDoubleProperty;
    private final DoubleProperty minProperty = new SimpleDoubleProperty((Object)this, "min", 0.0);
    private final DoubleProperty maxProperty = new SimpleDoubleProperty((Object)this, "max", 1.0);
    private final List<Runnable> cleanupTasks = new ArrayList<Runnable>();

    public YoDoubleSlider(YoDouble yoDouble, LinkedYoRegistry linkedYoRegistry) {
        this.yoDoubleProperty = new YoDoubleProperty(yoDouble, this);
        this.yoDoubleProperty.setLinkedBuffer((LinkedYoDouble)linkedYoRegistry.linkYoVariable((YoVariable)yoDouble));
    }

    @Override
    public void bindMinTextField(JFXTextField minTextField) {
        TextFormatter minTextFormatter = new TextFormatter((StringConverter)new DoubleStringConverter());
        minTextFormatter.setValue((Object)Math.floor(this.yoDoubleProperty.get() - 1.0));
        minTextField.setTextFormatter(minTextFormatter);
        this.minProperty.bind((ObservableValue)minTextFormatter.valueProperty());
        minTextField.setDisable(false);
        this.cleanupTasks.add(() -> {
            this.minProperty.unbind();
            minTextField.setDisable(true);
        });
    }

    @Override
    public void bindMaxTextField(JFXTextField maxTextField) {
        TextFormatter maxTextFormatter = new TextFormatter((StringConverter)new DoubleStringConverter());
        maxTextFormatter.setValue((Object)Math.ceil(this.yoDoubleProperty.get() + 1.0));
        maxTextField.setTextFormatter(maxTextFormatter);
        this.maxProperty.bind((ObservableValue)maxTextFormatter.valueProperty());
        maxTextField.setDisable(false);
        this.cleanupTasks.add(() -> {
            this.maxProperty.unbind();
            maxTextField.setDisable(true);
        });
    }

    @Override
    public void bindVirtualSlider(Slider virtualSlider) {
        virtualSlider.minProperty().bind((ObservableValue)this.minProperty);
        virtualSlider.maxProperty().bind((ObservableValue)this.maxProperty);
        ChangeListener majorTickUnitUpdater = (o, oldValue, newValue) -> {
            double range = this.maxProperty.get() - this.minProperty.get();
            if (range <= 0.0) {
                return;
            }
            virtualSlider.setMajorTickUnit(range / 25.0);
        };
        this.minProperty.addListener(majorTickUnitUpdater);
        this.maxProperty.addListener(majorTickUnitUpdater);
        MutableBoolean updating = new MutableBoolean(false);
        virtualSlider.setValue(this.yoDoubleProperty.get());
        ChangeListener sliderUpdater = (o, oldValue, newValue) -> {
            if (updating.isTrue()) {
                return;
            }
            updating.setTrue();
            virtualSlider.valueProperty().set(this.yoDoubleProperty.get());
            updating.setFalse();
        };
        ChangeListener yoDoubleUpdater = (o, oldValue, newValue) -> {
            if (updating.isTrue()) {
                return;
            }
            JavaFXMissingTools.runLater(this.getClass(), () -> {
                updating.setTrue();
                this.yoDoubleProperty.set(virtualSlider.valueProperty().get());
                updating.setFalse();
            });
        };
        this.yoDoubleProperty.addListener(sliderUpdater);
        virtualSlider.valueProperty().addListener(yoDoubleUpdater);
        this.cleanupTasks.add(() -> {
            this.yoDoubleProperty.removeListener(sliderUpdater);
            this.minProperty.removeListener(majorTickUnitUpdater);
            this.maxProperty.removeListener(majorTickUnitUpdater);
            virtualSlider.valueProperty().removeListener(yoDoubleUpdater);
            virtualSlider.minProperty().unbind();
            virtualSlider.maxProperty().unbind();
        });
    }

    @Override
    public void bindVirtualKnob(JFXSpinner virtualKnob) {
        ChangeListener knobUpdater = (o, oldValue, newValue) -> {
            double value = (this.yoDoubleProperty.get() - this.minProperty.get()) / (this.maxProperty.get() - this.minProperty.get());
            virtualKnob.setProgress(value);
        };
        knobUpdater.changed(null, null, null);
        this.yoDoubleProperty.addListener(knobUpdater);
        this.minProperty.addListener(knobUpdater);
        this.maxProperty.addListener(knobUpdater);
        this.cleanupTasks.add(() -> {
            this.yoDoubleProperty.removeListener(knobUpdater);
            this.minProperty.removeListener(knobUpdater);
            this.maxProperty.removeListener(knobUpdater);
        });
    }

    @Override
    public void bindSliderVariable(SliderboardVariable sliderVariable) {
        MutableBoolean updating = new MutableBoolean(false);
        if (!this.minProperty.isBound()) {
            this.minProperty.set(Math.floor(this.yoDoubleProperty.get() - 1.0));
        }
        if (!this.maxProperty.isBound()) {
            this.maxProperty.set(Math.ceil(this.yoDoubleProperty.get() + 1.0));
        }
        sliderVariable.setValue(SliderboardVariable.doubleToInt((double)this.yoDoubleProperty.get(), (double)this.minProperty.get(), (double)this.maxProperty.get(), (int)sliderVariable.getMin(), (int)sliderVariable.getMax()));
        ChangeListener sliderUpdater = (o, oldValue, newValue) -> {
            if (updating.isTrue()) {
                return;
            }
            int sliderPosition = SliderboardVariable.doubleToInt((double)this.yoDoubleProperty.get(), (double)this.minProperty.get(), (double)this.maxProperty.get(), (int)sliderVariable.getMin(), (int)sliderVariable.getMax());
            updating.setTrue();
            sliderVariable.setValue(sliderPosition);
            updating.setFalse();
        };
        ChangeListener yoDoubleUpdater = (o, oldValue, newValue) -> {
            if (updating.isTrue()) {
                return;
            }
            double yoDoubleValue = SliderboardVariable.intToDouble((int)newValue.intValue(), (int)sliderVariable.getMin(), (int)sliderVariable.getMax(), (double)this.minProperty.get(), (double)this.maxProperty.get());
            JavaFXMissingTools.runLater(this.getClass(), () -> {
                updating.setTrue();
                this.yoDoubleProperty.set(yoDoubleValue);
                updating.setFalse();
            });
        };
        this.yoDoubleProperty.addListener(sliderUpdater);
        this.minProperty.addListener(sliderUpdater);
        this.maxProperty.addListener(sliderUpdater);
        sliderVariable.valueProperty().addListener(yoDoubleUpdater);
        this.cleanupTasks.add(() -> {
            this.yoDoubleProperty.removeListener(sliderUpdater);
            this.minProperty.removeListener(sliderUpdater);
            this.maxProperty.removeListener(sliderUpdater);
            sliderVariable.valueProperty().removeListener(yoDoubleUpdater);
        });
    }

    public YoDouble getYoVariable() {
        return this.yoDoubleProperty.getYoVariable();
    }

    @Override
    public YoSliderDefinition toYoSliderDefinition() {
        YoSliderDefinition definition = new YoSliderDefinition();
        definition.setVariableName(this.getYoVariable().getFullNameString());
        definition.setMinValue(this.minProperty.getValue().toString());
        definition.setMaxValue(this.maxProperty.getValue().toString());
        return definition;
    }

    @Override
    public YoKnobDefinition toYoKnobDefinition() {
        YoKnobDefinition definition = new YoKnobDefinition();
        definition.setVariableName(this.getYoVariable().getFullNameString());
        definition.setMinValue(this.minProperty.getValue().toString());
        definition.setMaxValue(this.maxProperty.getValue().toString());
        return definition;
    }

    @Override
    public void dispose() {
        this.yoDoubleProperty.dispose();
        this.cleanupTasks.forEach(Runnable::run);
    }
}

