/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.scs2.sessionVisualizer.jfx.managers;

import java.awt.image.BufferedImage;
import java.io.IOException;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.atomic.AtomicReference;
import javafx.animation.AnimationTimer;
import javafx.embed.swing.SwingFXUtils;
import javafx.geometry.Rectangle2D;
import javafx.scene.Group;
import javafx.scene.SnapshotParameters;
import javafx.scene.SubScene;
import javafx.scene.image.Image;
import javafx.scene.image.WritableImage;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import us.ihmc.codecs.builder.H264Settings;
import us.ihmc.codecs.builder.MP4H264MovieBuilder;
import us.ihmc.codecs.generated.EProfileIdc;
import us.ihmc.codecs.generated.EUsageType;
import us.ihmc.commons.Conversions;
import us.ihmc.log.LogTools;
import us.ihmc.scs2.session.SessionMode;
import us.ihmc.scs2.sessionVisualizer.jfx.SceneVideoRecordingRequest;
import us.ihmc.scs2.sessionVisualizer.jfx.SessionVisualizerTopics;
import us.ihmc.scs2.sessionVisualizer.jfx.managers.BackgroundExecutorManager;
import us.ihmc.scs2.sessionVisualizer.jfx.tools.BufferedJavaFXMessager;
import us.ihmc.scs2.sharedMemory.interfaces.YoBufferPropertiesReadOnly;
import us.ihmc.scs2.sharedMemory.tools.SharedMemoryTools;

public class VideoRecordingManager {
    private final SubScene scene;
    private final Group mainView3DRoot;
    private final SessionVisualizerTopics topics;
    private final BufferedJavaFXMessager messager;
    private final AtomicReference<YoBufferPropertiesReadOnly> currentBufferProperties;
    private final AtomicReference<SessionMode> currentSessionMode;
    private final AtomicReference<Long> sessionDT;
    private final AtomicReference<Integer> bufferRecordTickPeriod;
    private final AtomicReference<Recorder> activeRecorder = new AtomicReference<Object>(null);
    private final BackgroundExecutorManager backgroundExecutorManager;

    public VideoRecordingManager(SubScene scene, Group mainView3DRoot, SessionVisualizerTopics topics, BufferedJavaFXMessager messager, BackgroundExecutorManager backgroundExecutorManager) {
        this.scene = scene;
        this.mainView3DRoot = mainView3DRoot;
        this.messager = messager;
        this.topics = topics;
        this.backgroundExecutorManager = backgroundExecutorManager;
        this.currentBufferProperties = messager.createInput(topics.getYoBufferCurrentProperties());
        this.currentSessionMode = messager.createInput(topics.getSessionCurrentMode());
        this.sessionDT = messager.createInput(topics.getSessionDTNanoseconds());
        this.bufferRecordTickPeriod = messager.createInput(topics.getBufferRecordTickPeriod());
        messager.registerTopicListener(topics.getSceneVideoRecordingRequest(), request -> this.submitRequest((SceneVideoRecordingRequest)request));
    }

    private void submitRequest(SceneVideoRecordingRequest request) {
        LogTools.info((String)("Received video export request: " + request));
        if (this.activeRecorder.get() != null) {
            this.activeRecorder.get().stop();
        }
        SnapshotParameters params = new SnapshotParameters();
        params.setCamera(this.scene.getCamera());
        params.setViewport(new Rectangle2D(0.0, 0.0, (double)request.getWidth(), (double)request.getHeight()));
        params.setDepthBuffer(true);
        params.setFill((Paint)Color.GRAY);
        Recorder recorder = new Recorder(request, params, () -> {
            this.activeRecorder.set(null);
            try {
                if (request.getRecordingEndedCallback() != null) {
                    request.getRecordingEndedCallback().run();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            this.messager.submitMessage(this.topics.getDisableUserControls(), false);
        });
        this.activeRecorder.set(recorder);
        this.messager.submitMessage(this.topics.getDisableUserControls(), true);
        if (request.getRecordingStartedCallback() != null) {
            request.getRecordingStartedCallback().run();
        }
        recorder.start();
    }

    private class Recorder
    extends AnimationTimer {
        private final SceneVideoRecordingRequest request;
        private int inPoint = -1;
        private int outPoint = -1;
        private int currentRecordingBufferIndex;
        private int bufferIndexIncrement = -1;
        private int numberOfBufferTicks = -1;
        private int currentPhase = 0;
        private final SnapshotParameters params;
        private final Runnable stopListener;
        private boolean isDoneTakingJavaFXSnapshots = false;
        private boolean isDoneExporting = false;
        private final ConcurrentLinkedQueue<WritableImage> jfxImageQueue = new ConcurrentLinkedQueue();

        public Recorder(final SceneVideoRecordingRequest request, SnapshotParameters params, Runnable stopListener) {
            this.request = request;
            this.params = params;
            this.stopListener = stopListener;
            final H264Settings settings = new H264Settings();
            settings.setBitrate(request.getWidth() * request.getHeight() / 100);
            settings.setUsageType(EUsageType.CAMERA_VIDEO_REAL_TIME);
            settings.setProfileIdc(EProfileIdc.PRO_HIGH);
            VideoRecordingManager.this.backgroundExecutorManager.executeInBackground(new Runnable(){
                MP4H264MovieBuilder movieBuilder;
                BufferedImage bufferedImage;
                {
                    this.bufferedImage = new BufferedImage(request.getWidth(), request.getHeight(), 2);
                }

                @Override
                public void run() {
                    try {
                        this.movieBuilder = new MP4H264MovieBuilder(request.getFile(), request.getWidth(), request.getHeight(), (int)request.getFrameRate(), settings);
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                        return;
                    }
                    while (!Recorder.this.isDoneTakingJavaFXSnapshots || !Recorder.this.jfxImageQueue.isEmpty()) {
                        if (Recorder.this.jfxImageQueue.isEmpty()) continue;
                        this.encodeNextFrame(Recorder.this.jfxImageQueue.poll());
                    }
                    try {
                        this.movieBuilder.close();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                    finally {
                        Recorder.this.isDoneExporting = true;
                    }
                }

                private void encodeNextFrame(WritableImage jfxImageToEncode) {
                    if (jfxImageToEncode == null) {
                        return;
                    }
                    this.bufferedImage = SwingFXUtils.fromFXImage((Image)jfxImageToEncode, (BufferedImage)this.bufferedImage);
                    try {
                        this.movieBuilder.encodeFrame(this.bufferedImage);
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                        Recorder.this.stop();
                    }
                }
            });
        }

        public void handle(long now) {
            if (VideoRecordingManager.this.currentSessionMode.get() != SessionMode.PAUSE) {
                VideoRecordingManager.this.messager.submitMessage(VideoRecordingManager.this.topics.getSessionCurrentMode(), SessionMode.PAUSE);
                return;
            }
            if (VideoRecordingManager.this.sessionDT.get() == null || VideoRecordingManager.this.bufferRecordTickPeriod.get() == null) {
                return;
            }
            YoBufferPropertiesReadOnly bufferProperties = VideoRecordingManager.this.currentBufferProperties.getAndSet(null);
            if (bufferProperties == null) {
                return;
            }
            switch (this.currentPhase) {
                case 0: {
                    if (this.initialize(bufferProperties)) {
                        ++this.currentPhase;
                    }
                    return;
                }
                case 1: {
                    if (this.recordNextFrame(bufferProperties)) {
                        ++this.currentPhase;
                    }
                    return;
                }
                case 2: {
                    this.isDoneTakingJavaFXSnapshots = true;
                    if (this.isDoneExporting) {
                        ++this.currentPhase;
                    }
                    return;
                }
            }
            this.stop();
        }

        private boolean initialize(YoBufferPropertiesReadOnly bufferProperties) {
            if (this.inPoint < 0) {
                this.inPoint = bufferProperties.getInPoint();
            }
            if (this.outPoint < 0) {
                this.outPoint = bufferProperties.getOutPoint();
            }
            double dt = Conversions.nanosecondsToSeconds((long)VideoRecordingManager.this.sessionDT.get()) * (double)VideoRecordingManager.this.bufferRecordTickPeriod.get().intValue();
            double recordDT = this.request.getRealTimeRate() / this.request.getFrameRate();
            this.bufferIndexIncrement = (int)Math.ceil(recordDT / dt);
            this.currentRecordingBufferIndex = this.inPoint;
            this.numberOfBufferTicks = SharedMemoryTools.computeSubLength((int)this.inPoint, (int)this.outPoint, (int)bufferProperties.getSize());
            VideoRecordingManager.this.messager.submitMessage(VideoRecordingManager.this.topics.getYoBufferCurrentIndexRequest(), this.currentRecordingBufferIndex);
            return true;
        }

        private boolean recordNextFrame(YoBufferPropertiesReadOnly bufferProperties) {
            if (this.currentRecordingBufferIndex != bufferProperties.getCurrentIndex()) {
                return false;
            }
            this.jfxImageQueue.add(VideoRecordingManager.this.mainView3DRoot.snapshot(this.params, new WritableImage(this.request.getWidth(), this.request.getHeight())));
            this.numberOfBufferTicks -= this.bufferIndexIncrement;
            if (this.numberOfBufferTicks < 0) {
                return true;
            }
            this.currentRecordingBufferIndex = SharedMemoryTools.increment((int)this.currentRecordingBufferIndex, (int)this.bufferIndexIncrement, (int)bufferProperties.getSize());
            VideoRecordingManager.this.messager.submitMessage(VideoRecordingManager.this.topics.getYoBufferCurrentIndexRequest(), this.currentRecordingBufferIndex);
            return false;
        }

        public void stop() {
            super.stop();
            this.stopListener.run();
        }
    }
}

