/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.scs2.sessionVisualizer.jfx.controllers.yoGraphic.editor;

import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Stream;
import javafx.animation.AnimationTimer;
import javafx.beans.binding.BooleanBinding;
import javafx.beans.binding.BooleanExpression;
import javafx.beans.binding.DoubleBinding;
import javafx.beans.binding.NumberBinding;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.IntegerProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.Property;
import javafx.beans.property.ReadOnlyObjectProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleIntegerProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;
import javafx.beans.value.ObservableBooleanValue;
import javafx.beans.value.ObservableNumberValue;
import javafx.beans.value.ObservableValue;
import javafx.collections.ObservableList;
import javafx.fxml.FXML;
import javafx.fxml.FXMLLoader;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.ContentDisplay;
import javafx.scene.control.Label;
import javafx.scene.control.ListCell;
import javafx.scene.control.ListView;
import javafx.scene.control.ScrollPane;
import javafx.scene.control.SelectionMode;
import javafx.scene.control.TextField;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import javafx.scene.image.WritableImage;
import javafx.scene.input.ClipboardContent;
import javafx.scene.input.DataFormat;
import javafx.scene.input.DragEvent;
import javafx.scene.input.Dragboard;
import javafx.scene.input.MouseEvent;
import javafx.scene.input.TransferMode;
import javafx.scene.layout.AnchorPane;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.Pane;
import javafx.scene.layout.Region;
import javafx.scene.layout.VBox;
import us.ihmc.euclid.referenceFrame.ReferenceFrame;
import us.ihmc.scs2.definition.yoComposite.YoCompositeDefinition;
import us.ihmc.scs2.sessionVisualizer.jfx.SessionVisualizerIOTools;
import us.ihmc.scs2.sessionVisualizer.jfx.controllers.yoGraphic.YoGraphicFXControllerTools;
import us.ihmc.scs2.sessionVisualizer.jfx.controllers.yoGraphic.editor.YoCompositeEditorPaneController;
import us.ihmc.scs2.sessionVisualizer.jfx.controllers.yoGraphic.editor.yoTextField.YoCompositeListTextField;
import us.ihmc.scs2.sessionVisualizer.jfx.controllers.yoGraphic.editor.yoTextField.YoIntegerTextField;
import us.ihmc.scs2.sessionVisualizer.jfx.controllers.yoGraphic.editor.yoTextField.YoReferenceFrameTextField;
import us.ihmc.scs2.sessionVisualizer.jfx.managers.ReferenceFrameManager;
import us.ihmc.scs2.sessionVisualizer.jfx.managers.SessionVisualizerToolkit;
import us.ihmc.scs2.sessionVisualizer.jfx.managers.YoCompositeSearchManager;
import us.ihmc.scs2.sessionVisualizer.jfx.tools.ContextMenuTools;
import us.ihmc.scs2.sessionVisualizer.jfx.tools.JavaFXMissingTools;
import us.ihmc.scs2.sessionVisualizer.jfx.tools.ListViewTools;
import us.ihmc.scs2.sessionVisualizer.jfx.tools.ObservedAnimationTimer;
import us.ihmc.scs2.sessionVisualizer.jfx.yoComposite.CompositeProperty;
import us.ihmc.scs2.sessionVisualizer.jfx.yoComposite.YoComposite;
import us.ihmc.scs2.sessionVisualizer.jfx.yoComposite.YoCompositeCollection;
import us.ihmc.scs2.sharedMemory.LinkedYoRegistry;

public class YoCompositeListEditorPaneController {
    @FXML
    private VBox mainPane;
    @FXML
    private GridPane listSearchGridPane;
    @FXML
    private Label compositeListLabel;
    @FXML
    private Label listFrameLabel;
    @FXML
    private TextField compositeListSearchTextField;
    @FXML
    private TextField referenceFrameSearchTextField;
    @FXML
    private Button addCompositeButton;
    @FXML
    private ListView<YoCompositeEditorPaneController> listView;
    @FXML
    private Label numberOfCompositesLabel;
    @FXML
    private TextField numberOfCompositesTextField;
    @FXML
    private ImageView numberOfCompositesValidImageView;
    private final StringProperty compositeNameProperty = new SimpleStringProperty((Object)this, "compositeName", "composite");
    private final StringProperty compositesNameProperty = new SimpleStringProperty((Object)this, "compositesName", "composites");
    private ObservableBooleanValue inputsValidityProperty;
    private BooleanProperty compositesValidityProperty = new SimpleBooleanProperty((Object)this, "compositesValidity", false);
    private YoReferenceFrameTextField yoReferenceFrameTextField;
    private YoIntegerTextField yoNumberOfCompositesTextField;
    private final ObjectProperty<IntegerProperty> numberOfCompositesProperty = new SimpleObjectProperty((Object)this, "numberOfComposites", null);
    private final ObjectProperty<List<DoubleProperty[]>> compositeListProperty = new SimpleObjectProperty((Object)this, "compositeList", null);
    private SessionVisualizerToolkit toolkit;
    private URL yoCompositeEditorPaneFXML = SessionVisualizerIOTools.YO_COMPOSITE_EDITOR_URL;
    private YoCompositeCollection yoCompositeCollection;
    private boolean setupReferenceFrameFields;
    private AnimationTimer scrollPaneHeightAdjustmentAnimation;
    private ObjectProperty<NumberBinding> extraFieldsHeightProperty;
    private AnimationTimer nCellsHeightAdjustmentAnimation;
    private IntegerProperty numberOfCellsToViewProperty;
    private static final DataFormat YO_COMPOSITE_CELL = new DataFormat(new String[]{"yoCompositeListViewController/compositeCell"});
    private List<YoCompositeEditorPaneController> itemsToMove = null;
    private List<YoCompositeEditorPaneController> itemsOriginal = null;

    public void initialize(SessionVisualizerToolkit toolkit, YoCompositeCollection yoCompositeCollection, boolean setupReferenceFrameFields) {
        this.toolkit = toolkit;
        this.yoCompositeCollection = yoCompositeCollection;
        this.setupReferenceFrameFields = setupReferenceFrameFields;
        YoCompositeSearchManager yoCompositeSearchManager = toolkit.getYoCompositeSearchManager();
        LinkedYoRegistry linkedRootRegistry = toolkit.getYoManager().getLinkedRootRegistry();
        this.yoNumberOfCompositesTextField = new YoIntegerTextField(this.numberOfCompositesTextField, yoCompositeSearchManager, linkedRootRegistry, true, this.numberOfCompositesValidImageView);
        this.setupListViewControls();
        if (yoCompositeCollection != null) {
            yoCompositeSearchManager.requestSearchListOfYoComposites(yoCompositeCollection.getPattern(), compositeListMap -> {
                YoCompositeListTextField yoCompositeListTextField = new YoCompositeListTextField((Map<String, List<YoComposite>>)compositeListMap, this.compositeListSearchTextField);
                yoCompositeListTextField.setupAutoCompletion();
                yoCompositeListTextField.compositeListProperty().addListener((o, oldValue, newValue) -> this.setComposites((List<YoComposite>)newValue));
            });
        }
        if (!setupReferenceFrameFields) {
            this.listSearchGridPane.getChildren().removeAll((Object[])new Node[]{this.listFrameLabel, this.referenceFrameSearchTextField});
            this.listSearchGridPane.getRowConstraints().remove(1);
        } else {
            ReferenceFrameManager referenceFrameManager = toolkit.getReferenceFrameManager();
            this.yoReferenceFrameTextField = new YoReferenceFrameTextField(this.referenceFrameSearchTextField, referenceFrameManager);
            this.yoReferenceFrameTextField.setupAutoCompletion();
            this.yoReferenceFrameTextField.supplierProperty().addListener((o, oldValue, newValue) -> {
                if (newValue == null) {
                    return;
                }
                this.listView.getItems().forEach(controller -> controller.setReferenceFrame((ReferenceFrame)newValue.getValue()));
            });
        }
        this.yoNumberOfCompositesTextField.setupAutoCompletion();
        this.compositesNameProperty.addListener((observable, oldValue, newValue) -> {
            if (newValue == null || newValue.isEmpty()) {
                this.compositesNameProperty.set(oldValue);
                return;
            }
            this.numberOfCompositesLabel.setText(YoGraphicFXControllerTools.replaceAndMatchCase(this.numberOfCompositesLabel.getText(), oldValue, newValue));
        });
        this.compositeNameProperty.addListener((observable, oldValue, newValue) -> {
            if (newValue == null || newValue.isEmpty()) {
                this.compositeNameProperty.set(oldValue);
                return;
            }
            this.compositeListLabel.setText(YoGraphicFXControllerTools.replaceAndMatchCase(this.compositeListLabel.getText(), oldValue, newValue));
        });
        this.inputsValidityProperty = this.compositesValidityProperty.and((ObservableBooleanValue)this.yoNumberOfCompositesTextField.getValidityProperty());
        this.yoNumberOfCompositesTextField.supplierProperty().addListener((o, oldValue, newValue) -> this.numberOfCompositesProperty.set(newValue));
    }

    private void setupListViewControls() {
        this.listView.setCellFactory(param -> new CompositeEditorListCell());
        this.listView.getSelectionModel().setSelectionMode(SelectionMode.MULTIPLE);
        this.listView.getItems().addListener(change -> {
            if (change.getList().isEmpty()) {
                this.compositesValidityProperty.unbind();
                this.compositesValidityProperty.set(false);
            } else {
                BooleanExpression observable = BooleanBinding.booleanExpression((ObservableBooleanValue)((YoCompositeEditorPaneController)change.getList().get(0)).inputsValidityProperty());
                for (int i = 1; i < change.getList().size(); ++i) {
                    observable = observable.and(((YoCompositeEditorPaneController)change.getList().get(i)).inputsValidityProperty());
                }
                this.compositesValidityProperty.bind((ObservableValue)observable);
            }
        });
        this.listView.setOnDragDetected(this::handleDragDetected);
        ContextMenuTools.setupContextMenu(this.listView, new Function[]{ListViewTools.addBeforeMenuItemFactory(this::newYoCompositeEditor), ListViewTools.addAfterMenuItemFactory(this::newYoCompositeEditor), ListViewTools.removeMenuItemFactory(false)});
        this.listView.getItems().addListener(change -> {
            ArrayList<DoubleProperty[]> newCompositeList = new ArrayList<DoubleProperty[]>();
            for (YoCompositeEditorPaneController item : change.getList()) {
                int compositeIndex = newCompositeList.size();
                ReadOnlyObjectProperty<DoubleProperty[]> compositeSupplierProperty = item.compositeSupplierProperty();
                newCompositeList.add((DoubleProperty[])compositeSupplierProperty.get());
                compositeSupplierProperty.addListener((o, oldValue, newValue) -> {
                    ArrayList<DoubleProperty[]> listUpdated = new ArrayList<DoubleProperty[]>((Collection)this.compositeListProperty.get());
                    listUpdated.set(compositeIndex, (DoubleProperty[])newValue);
                    this.compositeListProperty.set(listUpdated);
                });
            }
            this.compositeListProperty.set(newCompositeList);
        });
    }

    @FXML
    public void addComposite() {
        YoCompositeEditorPaneController newCompositeEditor = this.newYoCompositeEditor();
        newCompositeEditor.setCompositeName((String)this.compositeNameProperty.get());
        if (this.setupReferenceFrameFields && this.yoReferenceFrameTextField.getSupplier() != null) {
            newCompositeEditor.setReferenceFrame((ReferenceFrame)this.yoReferenceFrameTextField.getSupplier().getValue());
        }
        this.listView.getItems().add((Object)newCompositeEditor);
        JavaFXMissingTools.runLater(this.getClass(), () -> newCompositeEditor.getSearchYoCompositeTextField().requestFocus());
    }

    private YoCompositeEditorPaneController newYoCompositeEditor() {
        FXMLLoader loader = new FXMLLoader(this.yoCompositeEditorPaneFXML);
        try {
            loader.load();
            YoCompositeEditorPaneController editor = (YoCompositeEditorPaneController)loader.getController();
            editor.initialize(this.toolkit, this.yoCompositeCollection, this.setupReferenceFrameFields);
            return editor;
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    private void setComposites(List<YoComposite> yoCompositeList) {
        ObservableList listViewItems = this.listView.getItems();
        while (listViewItems.size() < yoCompositeList.size()) {
            listViewItems.add((Object)this.newYoCompositeEditor());
        }
        while (listViewItems.size() > yoCompositeList.size()) {
            listViewItems.remove(listViewItems.size() - 1);
        }
        for (int i = 0; i < listViewItems.size(); ++i) {
            YoComposite yoComposite = yoCompositeList.get(i);
            ((YoCompositeEditorPaneController)listViewItems.get(i)).setInput(yoComposite);
        }
    }

    public void setInputFromDefinition(List<? extends YoCompositeDefinition> input, String numberOfComposites) {
        ObservableList listViewItems = this.listView.getItems();
        while (listViewItems.size() < input.size()) {
            listViewItems.add((Object)this.newYoCompositeEditor());
        }
        while (listViewItems.size() > input.size()) {
            listViewItems.remove(listViewItems.size() - 1);
        }
        for (int i = 0; i < listViewItems.size(); ++i) {
            ((YoCompositeEditorPaneController)listViewItems.get(i)).setInput(input.get(i));
        }
        this.numberOfCompositesTextField.setText(numberOfComposites);
    }

    public void setInputSingletonComposites(List<String> input, String numberOfComposites) {
        ObservableList listViewItems = this.listView.getItems();
        if (input == null) {
            listViewItems.clear();
        } else {
            while (listViewItems.size() < input.size()) {
                listViewItems.add((Object)this.newYoCompositeEditor());
            }
            while (listViewItems.size() > input.size()) {
                listViewItems.remove(listViewItems.size() - 1);
            }
            for (int i = 0; i < listViewItems.size(); ++i) {
                ((YoCompositeEditorPaneController)listViewItems.get(i)).setInput(input.get(i));
            }
        }
        this.numberOfCompositesTextField.setText(numberOfComposites);
    }

    public void setCompositeName(String compositeName) {
        this.setCompositeName(compositeName, null);
    }

    public void setCompositeName(String compositeName, String compositesName) {
        this.compositeNameProperty.set((Object)compositeName);
        this.compositesNameProperty.set(compositesName == null ? compositeName + "s" : compositesName);
    }

    public ObservableBooleanValue inputsValidityProperty() {
        return this.inputsValidityProperty;
    }

    public ReadOnlyObjectProperty<IntegerProperty> numberOfCompositesProperty() {
        return this.numberOfCompositesProperty;
    }

    public ReadOnlyObjectProperty<List<DoubleProperty[]>> compositeListProperty() {
        return this.compositeListProperty;
    }

    public void addInputNotification(Runnable callback) {
        this.listView.getItems().addListener(change -> {
            change.getList().forEach(controller -> controller.addInputNotification(callback));
            callback.run();
        });
        this.numberOfCompositesProperty.addListener((o, oldValue, newValue) -> callback.run());
    }

    public <T extends CompositeProperty> void addInputListener(Consumer<List<T>> listConsumer, Supplier<T> compositeBuilder) {
        this.listView.getItems().addListener(change -> {
            ObservableList newList = change.getList();
            ArrayList<CompositeProperty> compositePropertyList = new ArrayList<CompositeProperty>(newList.size());
            for (YoCompositeEditorPaneController controller : newList) {
                CompositeProperty composite = (CompositeProperty)compositeBuilder.get();
                if (this.setupReferenceFrameFields) {
                    composite.set((Property<ReferenceFrame>)((Property)controller.frameSupplierProperty().getValue()), (DoubleProperty[])controller.compositeSupplierProperty().get());
                } else {
                    composite.setComponentValueProperties((DoubleProperty[])controller.compositeSupplierProperty().get());
                }
                controller.bindYoCompositeDoubleProperty(composite);
                compositePropertyList.add(composite);
            }
            listConsumer.accept(compositePropertyList);
        });
    }

    public Pane getMainPane() {
        return this.mainPane;
    }

    public void setupHeightAdjustmentForScrollPane(final ScrollPane scrollPane) {
        if (this.nCellsHeightAdjustmentAnimation != null) {
            this.nCellsHeightAdjustmentAnimation.stop();
        }
        DoubleBinding extraFieldsHeight = ((Region)scrollPane.contentProperty().get()).heightProperty().subtract((ObservableNumberValue)this.listView.heightProperty());
        if (this.extraFieldsHeightProperty == null) {
            this.extraFieldsHeightProperty = new SimpleObjectProperty((Object)this, "extraFieldsHeight", null);
        }
        this.extraFieldsHeightProperty.set((Object)extraFieldsHeight);
        if (this.scrollPaneHeightAdjustmentAnimation == null) {
            this.scrollPaneHeightAdjustmentAnimation = new ObservedAnimationTimer(this.getClass().getSimpleName()){

                @Override
                public void handleImpl(long now) {
                    if (YoCompositeListEditorPaneController.this.extraFieldsHeightProperty.get() == null) {
                        return;
                    }
                    double containerHeight = scrollPane.getHeight();
                    double prefHeight = containerHeight - ((NumberBinding)YoCompositeListEditorPaneController.this.extraFieldsHeightProperty.get()).doubleValue() - 5.0;
                    if (prefHeight > 0.0) {
                        YoCompositeListEditorPaneController.this.listView.setPrefHeight(prefHeight);
                    } else {
                        YoCompositeListEditorPaneController.this.listView.setPrefHeight(-1.0);
                    }
                    if (YoCompositeListEditorPaneController.this.listView.getItems().isEmpty()) {
                        YoCompositeListEditorPaneController.this.listView.setMinHeight(0.0);
                        YoCompositeListEditorPaneController.this.listView.setMaxHeight(0.0);
                    } else {
                        double minHeight = ((YoCompositeEditorPaneController)YoCompositeListEditorPaneController.this.listView.getItems().get(0)).getMainPane().getHeight() + 10.0;
                        YoCompositeListEditorPaneController.this.listView.setMinHeight(minHeight);
                        YoCompositeListEditorPaneController.this.listView.setMaxHeight((double)YoCompositeListEditorPaneController.this.listView.getItems().size() * minHeight);
                    }
                }
            };
        }
        this.scrollPaneHeightAdjustmentAnimation.start();
    }

    public void setPrefHeight(int numberOfCellsToView) {
        if (this.scrollPaneHeightAdjustmentAnimation != null) {
            this.scrollPaneHeightAdjustmentAnimation.stop();
        }
        if (this.numberOfCellsToViewProperty == null) {
            this.numberOfCellsToViewProperty = new SimpleIntegerProperty((Object)this, "numberOfCellsToView", 0);
        }
        this.numberOfCellsToViewProperty.set(numberOfCellsToView);
        if (this.nCellsHeightAdjustmentAnimation == null) {
            this.nCellsHeightAdjustmentAnimation = new ObservedAnimationTimer(this.getClass().getSimpleName()){

                @Override
                public void handleImpl(long now) {
                    if (YoCompositeListEditorPaneController.this.listView.getItems().isEmpty()) {
                        YoCompositeListEditorPaneController.this.listView.setMinHeight(0.0);
                        YoCompositeListEditorPaneController.this.listView.setMaxHeight(0.0);
                        YoCompositeListEditorPaneController.this.listView.setPrefHeight(0.0);
                    } else {
                        double minHeight = ((YoCompositeEditorPaneController)YoCompositeListEditorPaneController.this.listView.getItems().get(0)).getMainPane().getHeight() + 10.0;
                        YoCompositeListEditorPaneController.this.listView.setMinHeight(minHeight);
                        YoCompositeListEditorPaneController.this.listView.setPrefHeight((double)YoCompositeListEditorPaneController.this.numberOfCellsToViewProperty.get() * minHeight);
                        YoCompositeListEditorPaneController.this.listView.setMaxHeight(2.0 * (double)YoCompositeListEditorPaneController.this.numberOfCellsToViewProperty.get() * minHeight);
                    }
                }
            };
        }
        this.nCellsHeightAdjustmentAnimation.start();
    }

    private void handleDragDetected(MouseEvent event) {
        ObservableList selectedItems = this.listView.getSelectionModel().getSelectedItems();
        if (this.listView.getItems().size() > selectedItems.size()) {
            Dragboard dragBoard = this.listView.startDragAndDrop(TransferMode.ANY);
            ClipboardContent clipboardContent = new ClipboardContent();
            clipboardContent.put((Object)YO_COMPOSITE_CELL, (Object)"Dummy");
            dragBoard.setContent((Map)clipboardContent);
            this.itemsToMove = new ArrayList<YoCompositeEditorPaneController>((Collection<YoCompositeEditorPaneController>)selectedItems);
            this.itemsOriginal = new ArrayList<YoCompositeEditorPaneController>((Collection<YoCompositeEditorPaneController>)this.listView.getItems());
            this.listView.getItems().removeAll(this.itemsToMove);
            this.listView.getSelectionModel().clearSelection();
            AnchorPane[] panes = (AnchorPane[])this.itemsToMove.stream().map(YoCompositeEditorPaneController::getMainPane).toArray(AnchorPane[]::new);
            int height = (int)Stream.of(panes).mapToDouble(Region::getHeight).sum();
            int width = (int)Stream.of(panes).mapToDouble(Region::getWidth).max().getAsDouble();
            VBox vBox = new VBox((Node[])panes);
            vBox.resize((double)width, (double)height);
            WritableImage image = new WritableImage(width, height);
            vBox.snapshot(null, image);
            dragBoard.setDragView((Image)image);
        }
        event.consume();
    }

    private class CompositeEditorListCell
    extends ListCell<YoCompositeEditorPaneController> {
        public CompositeEditorListCell() {
            this.setOnDragOver(this::handleDragOver);
            this.setOnDragEntered(this::handleDragEntered);
            this.setOnDragExited(this::handleDragExited);
            this.setOnDragDropped(this::handleDragDropped);
            this.setOnDragDone(this::handleDragDone);
        }

        protected void updateItem(YoCompositeEditorPaneController item, boolean empty) {
            super.updateItem((Object)item, empty);
            this.setText(null);
            if (empty) {
                this.setGraphic(null);
            } else {
                item.setCompositeName((String)YoCompositeListEditorPaneController.this.compositeNameProperty.get() + " " + this.getIndex());
                GridPane mainPane = item.getMainPane();
                this.setGraphic((Node)mainPane);
                this.setContentDisplay(ContentDisplay.BOTTOM);
                mainPane.prefWidthProperty().bind((ObservableValue)this.widthProperty().subtract(20));
            }
        }

        public void handleDragOver(DragEvent event) {
            if (!event.isAccepted() && this.acceptDragEventForDrop(event)) {
                event.acceptTransferModes(TransferMode.ANY);
            }
            event.consume();
        }

        private void handleDragEntered(DragEvent event) {
            if (!event.isAccepted() && this.acceptDragEventForDrop(event)) {
                this.setSelectionHighlight(true);
            }
            event.consume();
        }

        private void handleDragExited(DragEvent event) {
            if (this.acceptDragEventForDrop(event)) {
                this.setSelectionHighlight(false);
            }
            event.consume();
        }

        private void setSelectionHighlight(boolean isSelected) {
            if (isSelected) {
                this.setStyle("-fx-border-color:green; -fx-border-radius:5;");
            } else {
                this.setStyle("-fx-border-color: null;");
            }
        }

        private void handleDragDropped(DragEvent event) {
            Dragboard dragboard = event.getDragboard();
            boolean success = false;
            if (dragboard.hasContent(YO_COMPOSITE_CELL)) {
                ObservableList vertexListViewItems = YoCompositeListEditorPaneController.this.listView.getItems();
                if (YoCompositeListEditorPaneController.this.itemsToMove != null && !YoCompositeListEditorPaneController.this.itemsToMove.isEmpty()) {
                    int dropIndex = this.getIndex();
                    if (dropIndex < vertexListViewItems.size()) {
                        vertexListViewItems.addAll(dropIndex, YoCompositeListEditorPaneController.this.itemsToMove);
                    } else {
                        vertexListViewItems.addAll(YoCompositeListEditorPaneController.this.itemsToMove);
                    }
                    this.setSelectionHighlight(false);
                    success = true;
                }
            }
            event.setDropCompleted(success);
            event.consume();
        }

        private void handleDragDone(DragEvent event) {
            if (!event.isDropCompleted() && YoCompositeListEditorPaneController.this.itemsOriginal != null) {
                YoCompositeListEditorPaneController.this.listView.getItems().setAll(YoCompositeListEditorPaneController.this.itemsOriginal);
            }
            YoCompositeListEditorPaneController.this.itemsOriginal = null;
            YoCompositeListEditorPaneController.this.itemsToMove = null;
            event.consume();
        }

        private boolean acceptDragEventForDrop(DragEvent event) {
            if (!event.getDragboard().hasContent(YO_COMPOSITE_CELL)) {
                return false;
            }
            return !YoCompositeListEditorPaneController.this.listView.getSelectionModel().getSelectedItems().contains(this.getItem());
        }
    }
}

