/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.scs2.sessionVisualizer.jfx.yoGraphic;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.IntegerProperty;
import javafx.beans.property.SimpleIntegerProperty;
import javafx.beans.value.ObservableValue;
import javafx.scene.Node;
import javafx.scene.paint.Color;
import javafx.scene.paint.Material;
import javafx.scene.paint.PhongMaterial;
import javafx.scene.shape.Mesh;
import javafx.scene.shape.MeshView;
import javafx.scene.transform.Affine;
import javafx.scene.transform.Transform;
import us.ihmc.euclid.geometry.interfaces.Vertex3DSupplier;
import us.ihmc.euclid.orientation.interfaces.Orientation3DReadOnly;
import us.ihmc.euclid.referenceFrame.ReferenceFrame;
import us.ihmc.euclid.shape.convexPolytope.ConvexPolytope3D;
import us.ihmc.euclid.shape.convexPolytope.interfaces.ConvexPolytope3DReadOnly;
import us.ihmc.euclid.tuple3D.Point3D;
import us.ihmc.euclid.tuple3D.interfaces.Point3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DReadOnly;
import us.ihmc.javaFXToolkit.JavaFXTools;
import us.ihmc.scs2.definition.visual.TriangleMesh3DFactories;
import us.ihmc.scs2.sessionVisualizer.jfx.definition.JavaFXTriangleMesh3DDefinitionInterpreter;
import us.ihmc.scs2.sessionVisualizer.jfx.yoComposite.Orientation3DProperty;
import us.ihmc.scs2.sessionVisualizer.jfx.yoComposite.QuaternionProperty;
import us.ihmc.scs2.sessionVisualizer.jfx.yoComposite.Tuple3DProperty;
import us.ihmc.scs2.sessionVisualizer.jfx.yoGraphic.YoGraphicFX3D;
import us.ihmc.scs2.sessionVisualizer.jfx.yoGraphic.YoGraphicTools;

public class YoConvexPolytopeFX3D
extends YoGraphicFX3D {
    private final MeshView polytopeNode = new MeshView();
    private Tuple3DProperty position = new Tuple3DProperty(null, 0.0, 0.0, 0.0);
    private Orientation3DProperty orientation = new QuaternionProperty(null, 0.0, 0.0, 0.0, 1.0);
    private List<Tuple3DProperty> vertices = new ArrayList<Tuple3DProperty>();
    private IntegerProperty numberOfVertices = null;
    private final Affine affine = new Affine();
    private final PhongMaterial material = new PhongMaterial();
    private PolytopeData newData = null;
    private PolytopeData oldData = null;
    private Mesh newMesh = null;
    private boolean clearMesh = false;

    public YoConvexPolytopeFX3D() {
        this.polytopeNode.setMaterial((Material)this.material);
        this.polytopeNode.getTransforms().add((Object)this.affine);
        this.polytopeNode.idProperty().bind((ObservableValue)this.nameProperty());
    }

    public YoConvexPolytopeFX3D(ReferenceFrame worldFrame) {
        this();
        this.position.setReferenceFrame(worldFrame);
        this.orientation.setReferenceFrame(worldFrame);
    }

    @Override
    public void render() {
        this.newData = YoConvexPolytopeFX3D.newPolytopeData(this.vertices, this.numberOfVertices);
        this.affine.setToTransform((Transform)JavaFXTools.createAffineFromOrientation3DAndTuple((Orientation3DReadOnly)this.orientation.toQuaternionInWorld(), (Tuple3DReadOnly)this.position.toPoint3DInWorld()));
        if (this.color == null) {
            this.color = () -> null;
        }
        this.material.setDiffuseColor((Color)this.color.get());
        if (this.clearMesh) {
            this.clearMesh = false;
            this.polytopeNode.setMesh(null);
        }
        if (this.newMesh != null) {
            this.polytopeNode.setMesh(this.newMesh);
            this.newMesh = null;
        }
    }

    static PolytopeData newPolytopeData(List<Tuple3DProperty> vertices, IntegerProperty numberOfVertices) {
        PolytopeData data = new PolytopeData();
        if (YoGraphicTools.isAnyNull(vertices, numberOfVertices)) {
            return data;
        }
        if (vertices.size() <= 2) {
            return data;
        }
        if (numberOfVertices != null && numberOfVertices.get() >= 0 && numberOfVertices.get() < vertices.size()) {
            vertices = vertices.subList(0, numberOfVertices.get());
        }
        data.vertices = vertices.stream().map(Point3D::new).collect(Collectors.toList());
        return data;
    }

    @Override
    public void computeBackground() {
        PolytopeData newDataLocal = this.newData;
        this.newData = null;
        if (newDataLocal == null) {
            return;
        }
        if (newDataLocal.vertices == null) {
            this.clearMesh = true;
            return;
        }
        if (newDataLocal.equals(this.oldData) && this.polytopeNode.getMesh() != null) {
            return;
        }
        List<Point3DReadOnly> vertices = newDataLocal.vertices;
        this.newMesh = JavaFXTriangleMesh3DDefinitionInterpreter.interpretDefinition(TriangleMesh3DFactories.ConvexPolytope((ConvexPolytope3DReadOnly)new ConvexPolytope3D(Vertex3DSupplier.asVertex3DSupplier(vertices))));
        this.oldData = newDataLocal;
    }

    public void setPosition(Tuple3DProperty position) {
        this.position = position;
    }

    public void setOrientation(Orientation3DProperty orientation) {
        this.orientation = orientation;
    }

    public void setVertices(List<Tuple3DProperty> vertices) {
        this.vertices = vertices;
    }

    public void addVertex(DoubleProperty x, DoubleProperty y, DoubleProperty z) {
        this.addVertex(new Tuple3DProperty(null, x, y, z));
    }

    public void addVertex(Tuple3DProperty vertex) {
        this.vertices.add(vertex);
    }

    public void setNumberOfVertices(IntegerProperty numberOfVertices) {
        this.numberOfVertices = numberOfVertices;
    }

    public void setNumberOfVertices(int numberOfVertices) {
        this.setNumberOfVertices((IntegerProperty)new SimpleIntegerProperty(numberOfVertices));
    }

    @Override
    public void clear() {
        this.position = null;
        this.orientation = null;
        this.vertices = null;
        this.numberOfVertices = null;
        this.color = null;
    }

    @Override
    public YoConvexPolytopeFX3D clone() {
        YoConvexPolytopeFX3D clone = new YoConvexPolytopeFX3D();
        clone.setName(this.getName());
        clone.setPosition(new Tuple3DProperty(this.position));
        clone.setOrientation(this.orientation.clone());
        clone.setVertices(new ArrayList<Tuple3DProperty>(this.vertices));
        clone.setNumberOfVertices(this.numberOfVertices);
        clone.setColor(this.color);
        return clone;
    }

    public Tuple3DProperty getPosition() {
        return this.position;
    }

    public Orientation3DProperty getOrientation() {
        return this.orientation;
    }

    public List<Tuple3DProperty> getVertices() {
        return this.vertices;
    }

    public IntegerProperty getNumberOfVertices() {
        return this.numberOfVertices;
    }

    @Override
    public Node getNode() {
        return this.polytopeNode;
    }

    private static class PolytopeData {
        private List<Point3DReadOnly> vertices;

        private PolytopeData() {
        }

        public boolean equals(Object object) {
            if (object == this) {
                return true;
            }
            if (object instanceof PolytopeData) {
                PolytopeData other = (PolytopeData)object;
                return !(this.vertices == null ? other.vertices != null : !this.vertices.equals(other.vertices));
            }
            return false;
        }
    }
}

