/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.scs2.sessionVisualizer.jfx.managers;

import java.util.Collection;
import java.util.List;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.scene.Group;
import javafx.scene.Node;
import javafx.scene.SubScene;
import javafx.stage.Stage;
import us.ihmc.euclid.referenceFrame.ReferenceFrame;
import us.ihmc.log.LogTools;
import us.ihmc.messager.Messager;
import us.ihmc.messager.MessagerAPIFactory;
import us.ihmc.scs2.definition.robot.RobotDefinition;
import us.ihmc.scs2.definition.terrain.TerrainObjectDefinition;
import us.ihmc.scs2.session.Session;
import us.ihmc.scs2.session.SessionMessagerAPI;
import us.ihmc.scs2.session.SessionState;
import us.ihmc.scs2.session.YoSharedBufferMessagerAPI;
import us.ihmc.scs2.sessionVisualizer.jfx.SessionVisualizerMessagerAPI;
import us.ihmc.scs2.sessionVisualizer.jfx.SessionVisualizerTopics;
import us.ihmc.scs2.sessionVisualizer.jfx.managers.BackgroundExecutorManager;
import us.ihmc.scs2.sessionVisualizer.jfx.managers.CameraSensorsManager;
import us.ihmc.scs2.sessionVisualizer.jfx.managers.ChartDataManager;
import us.ihmc.scs2.sessionVisualizer.jfx.managers.ChartRenderManager;
import us.ihmc.scs2.sessionVisualizer.jfx.managers.EnvironmentManager;
import us.ihmc.scs2.sessionVisualizer.jfx.managers.KeyFrameManager;
import us.ihmc.scs2.sessionVisualizer.jfx.managers.ReferenceFrameManager;
import us.ihmc.scs2.sessionVisualizer.jfx.managers.SecondaryWindowManager;
import us.ihmc.scs2.sessionVisualizer.jfx.managers.SnapshotManager;
import us.ihmc.scs2.sessionVisualizer.jfx.managers.VideoRecordingManager;
import us.ihmc.scs2.sessionVisualizer.jfx.managers.YoCompositeSearchManager;
import us.ihmc.scs2.sessionVisualizer.jfx.managers.YoGraphicFXManager;
import us.ihmc.scs2.sessionVisualizer.jfx.managers.YoManager;
import us.ihmc.scs2.sessionVisualizer.jfx.managers.YoRobotFXManager;
import us.ihmc.scs2.sessionVisualizer.jfx.tools.BufferedJavaFXMessager;
import us.ihmc.scs2.sessionVisualizer.jfx.tools.ObservedAnimationTimer;
import us.ihmc.scs2.sessionVisualizer.jfx.yoGraphic.YoGroupFX;

public class SessionVisualizerToolkit
extends ObservedAnimationTimer {
    private final BufferedJavaFXMessager messager;
    private final SessionVisualizerTopics topics = new SessionVisualizerTopics();
    private final YoManager yoManager = new YoManager();
    private final ChartDataManager chartDataManager;
    private final ChartRenderManager chartRenderManager = new ChartRenderManager();
    private final YoGraphicFXManager yoGraphicFXManager;
    private final YoCompositeSearchManager yoCompositeSearchManager;
    private final SnapshotManager snapshotManager;
    private final VideoRecordingManager videoRecordingManager;
    private final KeyFrameManager keyFrameManager;
    private final CameraSensorsManager cameraSensorsManager;
    private final BackgroundExecutorManager backgroundExecutorManager = new BackgroundExecutorManager(4);
    private final EnvironmentManager environmentManager = new EnvironmentManager(this.backgroundExecutorManager);
    private final ReferenceFrameManager referenceFrameManager = new ReferenceFrameManager(this.yoManager, this.backgroundExecutorManager);
    private final YoRobotFXManager yoRobotFXManager;
    private final SecondaryWindowManager secondaryWindowManager;
    private final Stage mainWindow;
    private final SubScene mainScene3D;
    private final ObjectProperty<Session> activeSessionProperty = new SimpleObjectProperty((Object)this, "activeSession", null);
    private final ObservableList<RobotDefinition> sessionRobotDefinitions = FXCollections.observableArrayList();
    private final ObservableList<TerrainObjectDefinition> sessionTerrainObjectDefinitions = FXCollections.observableArrayList();

    public SessionVisualizerToolkit(Stage mainWindow, SubScene mainScene3D, Group mainView3DRoot) throws Exception {
        this.mainWindow = mainWindow;
        this.mainScene3D = mainScene3D;
        MessagerAPIFactory apiFactory = new MessagerAPIFactory();
        apiFactory.createRootCategory("SCS2");
        apiFactory.includeMessagerAPIs(new MessagerAPIFactory.MessagerAPI[]{SessionMessagerAPI.API, YoSharedBufferMessagerAPI.API, SessionVisualizerMessagerAPI.API});
        this.messager = new BufferedJavaFXMessager(apiFactory.getAPIAndCloseFactory());
        this.topics.setupTopics();
        this.messager.startMessager();
        this.snapshotManager = new SnapshotManager(mainWindow, this.messager, this.topics);
        this.videoRecordingManager = new VideoRecordingManager(mainScene3D, this.topics, this.messager);
        this.chartDataManager = new ChartDataManager(this.messager, this.topics, this.yoManager, this.backgroundExecutorManager);
        this.yoGraphicFXManager = new YoGraphicFXManager(this.messager, this.topics, this.yoManager, this.backgroundExecutorManager, this.referenceFrameManager);
        this.yoCompositeSearchManager = new YoCompositeSearchManager(this.messager, this.topics, this.yoManager, this.backgroundExecutorManager);
        this.keyFrameManager = new KeyFrameManager(this.messager, this.topics);
        this.yoRobotFXManager = new YoRobotFXManager(this.messager, this.topics, this.yoManager, this.referenceFrameManager, this.backgroundExecutorManager);
        this.secondaryWindowManager = new SecondaryWindowManager(this);
        this.cameraSensorsManager = new CameraSensorsManager((Node)mainView3DRoot, this.messager, this.topics, this.yoRobotFXManager);
        this.activeSessionProperty.addListener((o, oldValue, newValue) -> {
            List newTerrainObjectDefinitions;
            this.sessionRobotDefinitions.clear();
            this.sessionTerrainObjectDefinitions.clear();
            if (newValue == null) {
                return;
            }
            List newRobotDefinitions = newValue.getRobotDefinitions();
            if (newRobotDefinitions != null && !newRobotDefinitions.isEmpty()) {
                this.sessionRobotDefinitions.setAll((Collection)newRobotDefinitions);
            }
            if ((newTerrainObjectDefinitions = newValue.getTerrainObjectDefinitions()) != null && !newTerrainObjectDefinitions.isEmpty()) {
                this.sessionTerrainObjectDefinitions.setAll((Collection)newTerrainObjectDefinitions);
            }
        });
    }

    public void startSession(Session session, Runnable sessionLoadedCallback) {
        if (this.activeSessionProperty.get() != null) {
            LogTools.warn((String)"Session already in progress. Stop the current session before starting a new one.");
            return;
        }
        this.activeSessionProperty.set((Object)session);
        session.setupWithMessager((Messager)this.messager);
        this.backgroundExecutorManager.executeInBackground(() -> {
            try {
                this.yoManager.startSession(session);
                this.yoRobotFXManager.startSession(session);
                this.environmentManager.startSession(session);
                this.referenceFrameManager.startSession(session);
                this.chartDataManager.startSession(session);
                this.chartRenderManager.startSession(session);
                this.yoGraphicFXManager.startSession(session);
                this.yoCompositeSearchManager.startSession(session);
                this.keyFrameManager.startSession(session);
                this.secondaryWindowManager.startSession(session);
                while (!this.yoRobotFXManager.isSessionLoaded()) {
                    try {
                        Thread.sleep(100L);
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                        if (sessionLoadedCallback != null) {
                            sessionLoadedCallback.run();
                        }
                        return;
                    }
                }
                this.cameraSensorsManager.startSession(session);
                this.messager.submitMessage(this.topics.getSessionCurrentState(), SessionState.ACTIVE);
            }
            finally {
                if (sessionLoadedCallback != null) {
                    sessionLoadedCallback.run();
                }
            }
        });
        this.mainWindow.setTitle(session.getSessionName());
    }

    public void stopSession() {
        if (this.activeSessionProperty.get() == null) {
            return;
        }
        this.activeSessionProperty.set(null);
        this.yoRobotFXManager.stopSession();
        this.chartDataManager.stopSession();
        this.chartRenderManager.stopSession();
        this.yoGraphicFXManager.stopSession();
        this.referenceFrameManager.stopSession();
        this.yoCompositeSearchManager.stopSession();
        this.environmentManager.stopSession();
        this.keyFrameManager.stopSession();
        this.backgroundExecutorManager.stopSession();
        this.secondaryWindowManager.stopSession();
        this.cameraSensorsManager.stopSession();
        this.yoManager.stopSession();
        this.mainWindow.setTitle("No Active Session");
        this.messager.submitMessage(this.topics.getSessionCurrentState(), SessionState.INACTIVE);
    }

    public boolean hasActiveSession() {
        return this.activeSessionProperty.get() != null;
    }

    public Session getSession() {
        return (Session)this.activeSessionProperty.get();
    }

    @Override
    public void handleImpl(long now) {
    }

    public void stop() {
        super.stop();
        this.yoManager.stop();
        this.yoRobotFXManager.stop();
        this.yoGraphicFXManager.stop();
        this.backgroundExecutorManager.shutdown();
        this.environmentManager.dispose();
        this.messager.closeMessager();
    }

    public BufferedJavaFXMessager getMessager() {
        return this.messager;
    }

    public SessionVisualizerTopics getTopics() {
        return this.topics;
    }

    public Stage getMainWindow() {
        return this.mainWindow;
    }

    public SubScene getMainScene3D() {
        return this.mainScene3D;
    }

    public YoManager getYoManager() {
        return this.yoManager;
    }

    public YoGraphicFXManager getYoGraphicFXManager() {
        return this.yoGraphicFXManager;
    }

    public YoGroupFX getYoGraphicFXRootGroup() {
        return this.yoGraphicFXManager.getRootGroup();
    }

    public YoGroupFX getYoGraphicFXSessionRootGroup() {
        return this.yoGraphicFXManager.getSessionRootGroup();
    }

    public YoRobotFXManager getYoRobotFXManager() {
        return this.yoRobotFXManager;
    }

    public ChartDataManager getChartDataManager() {
        return this.chartDataManager;
    }

    public ChartRenderManager getChartRenderManager() {
        return this.chartRenderManager;
    }

    public YoCompositeSearchManager getYoCompositeSearchManager() {
        return this.yoCompositeSearchManager;
    }

    public ReferenceFrame getWorldFrame() {
        return this.referenceFrameManager.getWorldFrame();
    }

    public ReferenceFrameManager getReferenceFrameManager() {
        return this.referenceFrameManager;
    }

    public EnvironmentManager getEnvironmentManager() {
        return this.environmentManager;
    }

    public KeyFrameManager getKeyFrameManager() {
        return this.keyFrameManager;
    }

    public SnapshotManager getSnapshotManager() {
        return this.snapshotManager;
    }

    public BackgroundExecutorManager getBackgroundExecutorManager() {
        return this.backgroundExecutorManager;
    }

    public VideoRecordingManager getVideoRecordingManager() {
        return this.videoRecordingManager;
    }

    public SecondaryWindowManager getWindowManager() {
        return this.secondaryWindowManager;
    }

    public ObservableList<RobotDefinition> getSessionRobotDefinitions() {
        return this.sessionRobotDefinitions;
    }

    public ObservableList<TerrainObjectDefinition> getSessionTerrainObjectDefinitions() {
        return this.sessionTerrainObjectDefinitions;
    }
}

