/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.scs2.sessionVisualizer.jfx.managers;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.collections.FXCollections;
import javafx.collections.ObservableMap;
import us.ihmc.euclid.referenceFrame.FixedReferenceFrame;
import us.ihmc.euclid.referenceFrame.ReferenceFrame;
import us.ihmc.euclid.referenceFrame.ReferenceFrameChangedListener;
import us.ihmc.euclid.referenceFrame.tools.ReferenceFrameTools;
import us.ihmc.euclid.transform.interfaces.RigidBodyTransformReadOnly;
import us.ihmc.log.LogTools;
import us.ihmc.mecano.frames.FixedMovingReferenceFrame;
import us.ihmc.scs2.session.Session;
import us.ihmc.scs2.session.YoFixedMovingReferenceFrameUsingYawPitchRoll;
import us.ihmc.scs2.session.YoFixedReferenceFrameUsingYawPitchRoll;
import us.ihmc.scs2.sessionVisualizer.jfx.managers.BackgroundExecutorManager;
import us.ihmc.scs2.sessionVisualizer.jfx.managers.Manager;
import us.ihmc.scs2.sessionVisualizer.jfx.managers.YoManager;
import us.ihmc.scs2.sessionVisualizer.jfx.tools.JavaFXMissingTools;
import us.ihmc.scs2.sessionVisualizer.jfx.tools.ObservedAnimationTimer;
import us.ihmc.scs2.sessionVisualizer.jfx.yoComposite.YoCompositeTools;
import us.ihmc.scs2.sharedMemory.LinkedYoDouble;
import us.ihmc.scs2.sharedMemory.tools.SharedMemoryTools;
import us.ihmc.yoVariables.euclid.referenceFrame.YoFramePoseUsingYawPitchRoll;
import us.ihmc.yoVariables.registry.YoRegistry;
import us.ihmc.yoVariables.variable.YoDouble;
import us.ihmc.yoVariables.variable.YoVariable;

public class ReferenceFrameManager
implements Manager {
    public static final String WORLD_FRAME = "worldFrame";
    private final ReferenceFrame worldFrame = ReferenceFrameTools.constructARootFrame((String)"worldFrame");
    private final ObjectProperty<Map<String, ReferenceFrame>> uniqueNameToReferenceFrameMapProperty = new SimpleObjectProperty((Object)this, "uniqueNameToReferenceFrameMap", null);
    private final ObjectProperty<Map<ReferenceFrame, String>> referenceFrameToUniqueNameMapProperty = new SimpleObjectProperty((Object)this, "referenceFrameToUniqueNameMap", null);
    private final ObservableMap<String, ReferenceFrame> fullnameToReferenceFrameMap = FXCollections.observableMap(new ConcurrentHashMap());
    private YoManager yoManager;
    private final BackgroundExecutorManager backgroundExecutorManager;
    private List<Runnable> cleanupTasks = null;
    private List<Runnable> updateTasks = null;
    private ReferenceFrameChangedListener frameChangedListener = change -> {
        if (change.wasAdded()) {
            this.registerNewSessionFrames(ReferenceFrameTools.collectFramesInSubtree((ReferenceFrame)change.getTarget()));
        }
    };
    private final ObservedAnimationTimer taskRunner = new ObservedAnimationTimer(this.getClass().getSimpleName()){

        @Override
        public void handleImpl(long now) {
            if (ReferenceFrameManager.this.updateTasks != null) {
                for (int i = 0; i < ReferenceFrameManager.this.updateTasks.size(); ++i) {
                    ReferenceFrameManager.this.updateTasks.get(i).run();
                }
            }
        }
    };

    public ReferenceFrameManager(YoManager yoManager, BackgroundExecutorManager backgroundExecutorManager) {
        this.yoManager = yoManager;
        this.backgroundExecutorManager = backgroundExecutorManager;
    }

    @Override
    public void startSession(Session session) {
        this.computeFullnameMap(ReferenceFrameTools.getAllFramesInTree((ReferenceFrame)this.worldFrame));
        this.registerNewSessionFramesNow(ReferenceFrameTools.collectFramesInSubtree((ReferenceFrame)session.getInertialFrame()));
        session.getInertialFrame().addListener(this.frameChangedListener);
        this.addCleanupTask(() -> session.getInertialFrame().removeListener(this.frameChangedListener));
        this.taskRunner.start();
    }

    @Override
    public void stopSession() {
        this.taskRunner.stop();
        if (this.cleanupTasks != null) {
            this.cleanupTasks.forEach(Runnable::run);
            this.cleanupTasks.clear();
            this.cleanupTasks = null;
        }
        this.worldFrame.clearChildren();
        this.uniqueNameToReferenceFrameMapProperty.set(null);
        this.referenceFrameToUniqueNameMapProperty.set(null);
        this.fullnameToReferenceFrameMap.clear();
    }

    @Override
    public boolean isSessionLoaded() {
        if (this.uniqueNameToReferenceFrameMapProperty.get() == null) {
            return false;
        }
        if (this.referenceFrameToUniqueNameMapProperty.get() == null) {
            return false;
        }
        return !this.fullnameToReferenceFrameMap.isEmpty();
    }

    private void addCleanupTask(Runnable task) {
        if (this.cleanupTasks == null) {
            this.cleanupTasks = new ArrayList<Runnable>();
        }
        this.cleanupTasks.add(task);
    }

    private void addUpdateTask(Runnable task) {
        if (this.updateTasks == null) {
            this.updateTasks = new ArrayList<Runnable>();
        }
        this.updateTasks.add(task);
    }

    private void registerNewSessionFrames(Collection<ReferenceFrame> sessionFrames) {
        this.backgroundExecutorManager.queueTaskToExecuteInBackground(this, () -> this.registerNewSessionFramesNow(sessionFrames));
    }

    private void registerNewSessionFramesNow(Collection<ReferenceFrame> sessionFrames) {
        if (sessionFrames == null || sessionFrames.isEmpty()) {
            return;
        }
        ArrayList<ReferenceFrame> frames = new ArrayList<ReferenceFrame>();
        for (ReferenceFrame sessionFrame : sessionFrames) {
            ReferenceFrame frame = this.duplicateReferenceFrame(sessionFrame);
            if (frame == null) continue;
            this.fullnameToReferenceFrameMap.put((Object)frame.getNameId(), (Object)frame);
            frames.add(frame);
        }
        this.computeUniqueNameMaps(ReferenceFrameTools.getAllFramesInTree((ReferenceFrame)this.worldFrame));
    }

    private ReferenceFrame duplicateReferenceFrame(ReferenceFrame sessionFrame) {
        FixedReferenceFrame frame;
        if (sessionFrame == null || sessionFrame.isRootFrame()) {
            return null;
        }
        if (this.getReferenceFrameFromFullname(sessionFrame.getNameId()) != null) {
            return null;
        }
        String frameName = sessionFrame.getName();
        ReferenceFrame sessionParentFrame = sessionFrame.getParent();
        ReferenceFrame parentFrame = this.getReferenceFrameFromFullname(sessionParentFrame.getNameId());
        if (!sessionFrame.isFixedInParent()) {
            LogTools.warn((String)"Unhandled frame type: {}, {}.", (Object)sessionFrame.getNameId(), (Object)sessionFrame.getClass().getSimpleName());
            return null;
        }
        if (sessionFrame instanceof FixedReferenceFrame) {
            frame = new FixedReferenceFrame(frameName, parentFrame, (RigidBodyTransformReadOnly)sessionFrame.getTransformToParent());
        } else if (sessionFrame instanceof FixedMovingReferenceFrame) {
            frame = new FixedMovingReferenceFrame(frameName, parentFrame, (RigidBodyTransformReadOnly)sessionFrame.getTransformToParent());
        } else if (sessionFrame instanceof YoFixedReferenceFrameUsingYawPitchRoll) {
            YoFramePoseUsingYawPitchRoll sessionOffset = ((YoFixedReferenceFrameUsingYawPitchRoll)sessionFrame).getOffset();
            YoFramePoseUsingYawPitchRoll offset = SharedMemoryTools.duplicate((YoFramePoseUsingYawPitchRoll)sessionOffset, (YoRegistry)this.yoManager.getRootRegistry(), (ReferenceFrame)parentFrame);
            frame = new YoFixedReferenceFrameUsingYawPitchRoll(frameName, offset, parentFrame);
            YoDouble[] variablesToLink = new YoDouble[]{offset.getYoX(), offset.getYoY(), offset.getYoZ(), offset.getYoYaw(), offset.getYoPitch(), offset.getYoRoll()};
            LinkedYoDouble[] linkedVariables = new LinkedYoDouble[variablesToLink.length];
            for (int i = 0; i < variablesToLink.length; ++i) {
                linkedVariables[i] = (LinkedYoDouble)this.yoManager.getLinkedRootRegistry().linkYoVariable((YoVariable)variablesToLink[i]);
                linkedVariables[i].addUser((Object)frame);
            }
            this.addUpdateTask(() -> ReferenceFrameManager.lambda$duplicateReferenceFrame$3(linkedVariables, (ReferenceFrame)frame));
        } else if (sessionFrame instanceof YoFixedMovingReferenceFrameUsingYawPitchRoll) {
            YoFramePoseUsingYawPitchRoll sessionOffset = ((YoFixedMovingReferenceFrameUsingYawPitchRoll)sessionFrame).getOffset();
            YoFramePoseUsingYawPitchRoll offset = SharedMemoryTools.duplicate((YoFramePoseUsingYawPitchRoll)sessionOffset, (YoRegistry)this.yoManager.getRootRegistry(), (ReferenceFrame)parentFrame);
            frame = new YoFixedMovingReferenceFrameUsingYawPitchRoll(frameName, offset, parentFrame);
            YoDouble[] variablesToLink = new YoDouble[]{offset.getYoX(), offset.getYoY(), offset.getYoZ(), offset.getYoYaw(), offset.getYoPitch(), offset.getYoRoll()};
            LinkedYoDouble[] linkedVariables = new LinkedYoDouble[variablesToLink.length];
            for (int i = 0; i < variablesToLink.length; ++i) {
                linkedVariables[i] = (LinkedYoDouble)this.yoManager.getLinkedRootRegistry().linkYoVariable((YoVariable)variablesToLink[i]);
                linkedVariables[i].addUser((Object)frame);
            }
            this.addUpdateTask(() -> ReferenceFrameManager.lambda$duplicateReferenceFrame$4(linkedVariables, (ReferenceFrame)frame));
        } else {
            LogTools.warn((String)"Unhandled frame type: {}, {}.", (Object)sessionFrame.getNameId(), (Object)sessionFrame.getClass().getSimpleName());
            frame = null;
        }
        return frame;
    }

    public void refreshReferenceFramesNow() {
        Collection allReferenceFrames = ReferenceFrameTools.getAllFramesInTree((ReferenceFrame)this.worldFrame);
        this.computeFullnameMap(allReferenceFrames);
        this.computeUniqueNameMaps(allReferenceFrames);
    }

    public void refreshReferenceFrames() {
        Collection allReferenceFrames = ReferenceFrameTools.getAllFramesInTree((ReferenceFrame)this.worldFrame);
        this.backgroundExecutorManager.queueTaskToExecuteInBackground(this, () -> this.computeFullnameMap(allReferenceFrames));
        this.backgroundExecutorManager.queueTaskToExecuteInBackground(this, () -> this.computeUniqueNameMaps(allReferenceFrames));
    }

    private void computeUniqueNameMaps(Collection<ReferenceFrame> allReferenceFrames) {
        Map<ReferenceFrame, String> newMap = YoCompositeTools.computeUniqueNames(allReferenceFrames, ReferenceFrameManager::getFrameNamespace, ReferenceFrame::getName);
        LinkedHashMap newUniqueNameToReferenceFrameMap = new LinkedHashMap();
        LinkedHashMap newReferenceFrameToUniqueNameMap = new LinkedHashMap();
        newMap.entrySet().forEach(e -> {
            newUniqueNameToReferenceFrameMap.put((String)e.getValue(), (ReferenceFrame)e.getKey());
            newReferenceFrameToUniqueNameMap.put((ReferenceFrame)e.getKey(), (String)e.getValue());
        });
        JavaFXMissingTools.runLaterIfNeeded(this.getClass(), () -> {
            this.uniqueNameToReferenceFrameMapProperty.set((Object)newUniqueNameToReferenceFrameMap);
            this.referenceFrameToUniqueNameMapProperty.set((Object)newReferenceFrameToUniqueNameMap);
        });
    }

    private void computeFullnameMap(Collection<ReferenceFrame> allReferenceFrames) {
        allReferenceFrames.forEach(frame -> this.fullnameToReferenceFrameMap.computeIfAbsent((Object)frame.getNameId(), s -> frame));
    }

    private static List<String> getFrameNamespace(ReferenceFrame referenceFrame) {
        ArrayList<String> namespace = new ArrayList<String>();
        for (ReferenceFrame ancestor = referenceFrame.getParent(); ancestor != null; ancestor = ancestor.getParent()) {
            namespace.add(0, ancestor.getName());
        }
        return namespace;
    }

    public ReferenceFrame getWorldFrame() {
        return this.worldFrame;
    }

    public Collection<ReferenceFrame> getReferenceFrames() {
        if (this.uniqueNameToReferenceFrameMapProperty.get() == null) {
            return Collections.emptyList();
        }
        return ((Map)this.uniqueNameToReferenceFrameMapProperty.get()).values();
    }

    public Collection<String> getReferenceFrameUniqueNames() {
        if (this.uniqueNameToReferenceFrameMapProperty.get() == null) {
            return Collections.emptyList();
        }
        return ((Map)this.uniqueNameToReferenceFrameMapProperty.get()).keySet();
    }

    public Collection<String> getReferenceFrameFullnames() {
        return this.fullnameToReferenceFrameMap.keySet();
    }

    public ReferenceFrame getReferenceFrameFromUniqueName(String uniqueName) {
        if (this.uniqueNameToReferenceFrameMapProperty.get() == null) {
            return null;
        }
        return (ReferenceFrame)((Map)this.uniqueNameToReferenceFrameMapProperty.get()).get(uniqueName);
    }

    public ReferenceFrame getReferenceFrameFromFullname(String fullname) {
        return (ReferenceFrame)this.fullnameToReferenceFrameMap.get((Object)fullname);
    }

    public String getUniqueName(ReferenceFrame referenceFrame) {
        if (this.referenceFrameToUniqueNameMapProperty.get() == null) {
            return null;
        }
        return (String)((Map)this.referenceFrameToUniqueNameMapProperty.get()).get(referenceFrame);
    }

    public Map<ReferenceFrame, String> getReferenceFrameToUniqueNameMap() {
        return (Map)this.referenceFrameToUniqueNameMapProperty.get();
    }

    public Map<String, ReferenceFrame> getUniqueNameToReferenceFrameMap() {
        return (Map)this.uniqueNameToReferenceFrameMapProperty.get();
    }

    public Map<String, ReferenceFrame> getFullnameToReferenceFrameMap() {
        return this.fullnameToReferenceFrameMap;
    }

    private static /* synthetic */ void lambda$duplicateReferenceFrame$4(LinkedYoDouble[] linkedVariables, ReferenceFrame frame) {
        boolean updateFrame = false;
        for (LinkedYoDouble linkedVariable : linkedVariables) {
            updateFrame |= linkedVariable.pull();
        }
        if (updateFrame) {
            frame.update();
        }
    }

    private static /* synthetic */ void lambda$duplicateReferenceFrame$3(LinkedYoDouble[] linkedVariables, ReferenceFrame frame) {
        boolean updateFrame = false;
        for (LinkedYoDouble linkedVariable : linkedVariables) {
            updateFrame |= linkedVariable.pull();
        }
        if (updateFrame) {
            frame.update();
        }
    }
}

