/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.scs2.sessionVisualizer.jfx.session.log;

import java.io.File;
import java.io.IOException;
import javafx.scene.image.PixelWriter;
import javafx.scene.image.WritableImage;
import org.bytedeco.javacpp.Pointer;
import org.bytedeco.opencv.global.opencv_core;
import org.bytedeco.opencv.opencv_core.Mat;
import us.ihmc.robotDataLogger.Camera;
import us.ihmc.scs2.session.log.ProgressConsumer;
import us.ihmc.scs2.session.log.ZEDSVOScrubber;
import us.ihmc.scs2.sessionVisualizer.jfx.session.log.FrameData;
import us.ihmc.scs2.sessionVisualizer.jfx.session.log.VideoDataReader;
import us.ihmc.zed.global.zed;

public class ZEDSVOVideoDataReader
implements VideoDataReader {
    private final ZEDSVOScrubber zedScrubber;
    private final Camera camera = new Camera();
    private final FrameData frameData = new FrameData();

    public ZEDSVOVideoDataReader(File timestampsDatFile) {
        this.zedScrubber = new ZEDSVOScrubber(timestampsDatFile);
        this.camera.setVideoFile("%s.svo2".formatted(this.zedScrubber.getName()));
        this.camera.setTimestampFile(timestampsDatFile.toPath().getFileName().toString());
    }

    @Override
    public void readVideoFrame(long timestamp) {
        this.zedScrubber.scrub(timestamp);
        int imageHeight = this.zedScrubber.getImageHeight();
        int imageWidth = this.zedScrubber.getImageWidth();
        Pointer leftColorImageSlMatPointer = this.zedScrubber.getLeftColorImageSlMatPointer();
        Mat imageMat = new Mat(imageHeight, imageWidth, opencv_core.CV_8UC4, (Pointer)zed.sl_mat_get_ptr((Pointer)leftColorImageSlMatPointer, (int)0), (long)zed.sl_mat_get_step_bytes((Pointer)leftColorImageSlMatPointer, (int)0));
        WritableImage writableImage = new WritableImage(imageWidth, imageHeight);
        PixelWriter pixelWriter = writableImage.getPixelWriter();
        byte[] buffer = new byte[imageWidth * imageHeight * 4];
        imageMat.ptr(0, 0).get(buffer);
        for (int y = 0; y < imageHeight; ++y) {
            for (int x = 0; x < imageWidth; ++x) {
                int bufferIndex = (y * imageWidth + x) * 4;
                int b = buffer[bufferIndex] & 0xFF;
                int g = buffer[bufferIndex + 1] & 0xFF;
                int r = buffer[bufferIndex + 2] & 0xFF;
                int a = buffer[bufferIndex + 3] & 0xFF;
                int argb = a << 24 | r << 16 | g << 8 | b;
                pixelWriter.setArgb(x, y, argb);
            }
        }
        this.frameData.frame = writableImage;
        this.frameData.queryRobotTimestamp = timestamp;
        this.frameData.currentRobotTimestamp = this.zedScrubber.getTimestampScrubber().getCurrentRobotTimestamp();
        this.frameData.currentVideoTimestamp = this.zedScrubber.getTimestampScrubber().getCurrentVideoTimestamp();
        this.frameData.currentDemuxerTimestamp = this.zedScrubber.getCurrentTimestamp();
    }

    @Override
    public void cropVideo(File outputFile, File timestampFile, long startTimestamp, long endTimestamp, ProgressConsumer monitor) throws IOException {
        this.zedScrubber.cropVideo(outputFile, timestampFile, startTimestamp, endTimestamp, monitor);
    }

    @Override
    public Camera getCamera() {
        return this.camera;
    }

    public void close() {
        this.zedScrubber.close();
    }

    @Override
    public String getName() {
        return this.zedScrubber.getName();
    }

    @Override
    public FrameData pollCurrentFrame() {
        return this.frameData;
    }

    @Override
    public int getCurrentIndex() {
        return this.zedScrubber.getTimestampScrubber().getCurrentIndex();
    }

    @Override
    public boolean replacedRobotTimestampsContainsIndex(int index) {
        return this.zedScrubber.getTimestampScrubber().getReplacedRobotTimestampIndex(index);
    }

    @Override
    public int getImageHeight() {
        return this.zedScrubber.getImageHeight();
    }

    @Override
    public int getImageWidth() {
        return this.zedScrubber.getImageWidth();
    }
}

