/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.scs2.sessionVisualizer.jfx.controllers.yoComposite.search;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import javafx.fxml.FXML;
import javafx.fxml.FXMLLoader;
import javafx.scene.Node;
import javafx.scene.control.Tab;
import javafx.scene.control.TabPane;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.Pane;
import us.ihmc.log.LogTools;
import us.ihmc.scs2.sessionVisualizer.jfx.SessionVisualizerIOTools;
import us.ihmc.scs2.sessionVisualizer.jfx.controllers.yoComposite.search.YoCompositeSearchPaneController;
import us.ihmc.scs2.sessionVisualizer.jfx.controllers.yoComposite.search.YoRegistrySearchPaneController;
import us.ihmc.scs2.sessionVisualizer.jfx.managers.SessionVisualizerToolkit;
import us.ihmc.scs2.sessionVisualizer.jfx.tools.JavaFXMissingTools;
import us.ihmc.yoVariables.registry.YoRegistry;

public class YoSearchTabPaneController {
    @FXML
    private TabPane yoSearchTabPane;
    @FXML
    private YoRegistrySearchPaneController yoRegistrySearchPaneController;
    @FXML
    private YoCompositeSearchPaneController mainYoCompositeSearchPaneController;
    private SessionVisualizerToolkit toolkit;
    private final Map<YoRegistry, Tab> registryTabs = new HashMap<YoRegistry, Tab>();
    private final Map<Tab, YoCompositeSearchPaneController> tabCompositeControllerMap = new HashMap<Tab, YoCompositeSearchPaneController>();

    public void initialize(SessionVisualizerToolkit toolkit) {
        this.toolkit = toolkit;
        this.yoSearchTabPane.setTabClosingPolicy(TabPane.TabClosingPolicy.ALL_TABS);
        this.yoSearchTabPane.getSelectionModel().select(1);
        this.tabCompositeControllerMap.put((Tab)this.yoSearchTabPane.getSelectionModel().getSelectedItem(), this.mainYoCompositeSearchPaneController);
        this.yoRegistrySearchPaneController.initialize(toolkit);
        this.yoRegistrySearchPaneController.setRegistryViewRequestConsumer(newRequest -> {
            if (newRequest != null) {
                this.openRegistryTab((YoRegistry)newRequest, 1);
            }
        });
        this.mainYoCompositeSearchPaneController.initialize(toolkit);
        this.mainYoCompositeSearchPaneController.setRegistryViewRequestConsumer(newRequest -> {
            if (newRequest == null) {
                return;
            }
            try {
                YoRegistry registry = toolkit.getYoManager().getRootRegistry().findRegistry(newRequest);
                this.openRegistryTab(registry, -1);
            }
            catch (RuntimeException e) {
                LogTools.error((String)("Registry not found: " + String.valueOf(newRequest)));
            }
        });
        this.yoSearchTabPane.getSelectionModel().selectedItemProperty().addListener((o, oldValue, newValue) -> {
            for (Tab tab : this.yoSearchTabPane.getTabs()) {
                Node content = tab.getContent();
                if (content == null) continue;
                content.setDisable(tab != newValue);
            }
            JavaFXMissingTools.runLater(this.getClass(), this::requestFocusForActiveSearchBox);
        });
    }

    public void requestFocusForActiveSearchBox() {
        YoCompositeSearchPaneController controller = this.tabCompositeControllerMap.get(this.yoSearchTabPane.getSelectionModel().getSelectedItem());
        if (controller != null) {
            controller.requestFocusForSearchBox();
        } else {
            this.yoRegistrySearchPaneController.requestFocusForSearchBox();
        }
    }

    public void start() {
        this.yoRegistrySearchPaneController.start();
        this.mainYoCompositeSearchPaneController.start();
    }

    public void stop() {
        this.yoRegistrySearchPaneController.stop();
        this.mainYoCompositeSearchPaneController.stop();
    }

    private void openRegistryTab(YoRegistry registry, int tabIndex) {
        if (this.registryTabs.containsKey(registry)) {
            this.yoSearchTabPane.getSelectionModel().select((Object)this.registryTabs.get(registry));
        } else {
            Tab newTab = new Tab(registry.getName());
            FXMLLoader loader = new FXMLLoader(SessionVisualizerIOTools.YO_COMPOSITE_SEARCH_PANEL_URL);
            try {
                Pane rootPane = (Pane)loader.load();
                YoCompositeSearchPaneController controller = (YoCompositeSearchPaneController)((Object)loader.getController());
                controller.initialize(this.toolkit, registry);
                controller.start();
                this.registryTabs.put(registry, newTab);
                newTab.setContent((Node)rootPane);
                this.tabCompositeControllerMap.put(newTab, controller);
                newTab.setClosable(true);
                newTab.setOnClosed(e -> {
                    controller.stop();
                    this.registryTabs.remove(registry);
                    this.tabCompositeControllerMap.remove(newTab);
                });
                if (tabIndex == -1) {
                    this.yoSearchTabPane.getTabs().add(this.yoSearchTabPane.getTabs().size() - 1, (Object)newTab);
                } else {
                    this.yoSearchTabPane.getTabs().add(tabIndex, (Object)newTab);
                }
                this.yoSearchTabPane.getSelectionModel().select((Object)newTab);
            }
            catch (IOException e2) {
                throw new RuntimeException("Could not load the registry tab.", e2);
            }
        }
    }

    @FXML
    void startYoVariableDragAndDrop(MouseEvent event) {
        this.mainYoCompositeSearchPaneController.startYoVariableDragAndDrop(event);
    }
}

