/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.scs2.sessionVisualizer.jfx.tools;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.commons.text.similarity.LongestCommonSubsequence;
import org.apache.commons.text.similarity.SimilarityScore;
import us.ihmc.log.LogTools;
import us.ihmc.scs2.sessionVisualizer.jfx.tools.ScoredObject;
import us.ihmc.scs2.sessionVisualizer.jfx.tools.YoVariableTools;
import us.ihmc.scs2.sharedMemory.LinkedYoRegistry;
import us.ihmc.scs2.sharedMemory.LinkedYoVariable;
import us.ihmc.yoVariables.listener.YoRegistryChangedListener;
import us.ihmc.yoVariables.registry.YoNamespace;
import us.ihmc.yoVariables.registry.YoRegistry;
import us.ihmc.yoVariables.tools.YoGeometryNameTools;
import us.ihmc.yoVariables.tools.YoSearchTools;
import us.ihmc.yoVariables.variable.YoVariable;

public class YoVariableDatabase {
    private final YoRegistry rootRegistry;
    private final YoRegistryChangedListener registryChangedListener;
    private final LinkedYoRegistry linkedRootRegistry;
    private final List<YoVariable> allYoVariables = new ArrayList<YoVariable>();
    private final Map<Class<? extends YoVariable>, List<? extends YoVariable>> allTypedYoVariables = new HashMap<Class<? extends YoVariable>, List<? extends YoVariable>>();
    private final Map<YoNamespace, YoNamespace> changedNamespaceMap = new HashMap<YoNamespace, YoNamespace>();
    private final Map<String, YoVariable> previousSearchResults = new HashMap<String, YoVariable>();
    private final Map<String, String> fromSearchToBestSubname = new HashMap<String, String>();
    private final SimilarityScore<Double> searchEngine;
    private boolean enableFuzzySearch = false;

    public YoVariableDatabase(final YoRegistry rootRegistry, LinkedYoRegistry linkedRootRegistry) {
        this.rootRegistry = rootRegistry;
        this.linkedRootRegistry = linkedRootRegistry;
        this.searchEngine = new SimilarityScore<Double>(){
            SimilarityScore<Integer> caseSensitiveSearchEngine = new LongestCommonSubsequence();

            public Double apply(CharSequence left, CharSequence right) {
                return ((Integer)this.caseSensitiveSearchEngine.apply((CharSequence)left.toString().toLowerCase(), (CharSequence)right.toString().toLowerCase())).doubleValue() / (double)Math.max(left.length(), right.length());
            }
        };
        this.allYoVariables.addAll(rootRegistry.collectSubtreeVariables());
        this.allTypedYoVariables.put(YoVariable.class, this.allYoVariables);
        this.registryChangedListener = new YoRegistryChangedListener(){

            public void changed(YoRegistryChangedListener.Change change) {
                if (change.wasVariableAdded()) {
                    YoVariableDatabase.this.allYoVariables.add(change.getTargetVariable());
                }
                if (change.wasVariableRemoved()) {
                    YoVariableDatabase.this.allYoVariables.remove(change.getTargetVariable());
                }
                if (change.wasRegistryAdded()) {
                    YoVariableDatabase.this.allYoVariables.addAll(change.getTargetRegistry().collectSubtreeVariables());
                }
                if (change.wasRegistryRemoved()) {
                    YoVariableDatabase.this.allYoVariables.clear();
                    YoVariableDatabase.this.allYoVariables.addAll(rootRegistry.collectSubtreeVariables());
                }
                YoVariableDatabase.this.allTypedYoVariables.clear();
                YoVariableDatabase.this.allTypedYoVariables.put(YoVariable.class, YoVariableDatabase.this.allYoVariables);
            }
        };
        rootRegistry.addListener(this.registryChangedListener);
    }

    public void setEnableFuzzySearch(boolean enableFuzzySearch) {
        this.enableFuzzySearch = enableFuzzySearch;
    }

    public <L extends LinkedYoVariable<T>, T extends YoVariable> L linkYoVariable(T variableToLink, Object initialUser) {
        return (L)this.linkedRootRegistry.linkYoVariable(variableToLink, initialUser);
    }

    public YoVariable searchExact(String fullnameToSearch) {
        return this.rootRegistry.findVariable(fullnameToSearch);
    }

    public YoVariable searchSimilar(String fullnameToSearch, double minScore) {
        return this.searchSimilar(fullnameToSearch, minScore, YoVariable.class);
    }

    public <T extends YoVariable> T searchSimilar(String fullnameToSearch, double minScore, Class<? extends T> type) {
        ArrayList<Number> arrayList;
        List exactMatches;
        ScoredObject<T> result;
        if (!this.enableFuzzySearch) {
            return null;
        }
        if (this.previousSearchResults.containsKey(fullnameToSearch)) {
            return (T)((YoVariable)type.cast(this.previousSearchResults.get(fullnameToSearch)));
        }
        YoNamespace variableFullname = this.updateNamespaceToIncludeMove(new YoNamespace(fullnameToSearch));
        YoNamespace variableNamespace = variableFullname.getParent();
        String variableName = variableFullname.getShortName();
        YoRegistry parentRegistry = this.rootRegistry.findRegistry(variableNamespace);
        if (parentRegistry != null && (result = this.searchSimilarInRegistryShallow(variableFullname, minScore, type, parentRegistry)) != null) {
            this.previousSearchResults.put(fullnameToSearch, (YoVariable)result.getObject());
            return (T)((YoVariable)result.getObject());
        }
        List candidates = YoSearchTools.filterRegistries(candidate -> candidate.getName().equals(variableNamespace.getShortName()), (YoRegistry)this.rootRegistry);
        if (candidates != null && !candidates.isEmpty()) {
            if (candidates.size() == 1) {
                YoVariable variable = ((YoRegistry)candidates.get(0)).getVariable(variableName);
                if (variable != null && type.isInstance(variable)) {
                    LogTools.info((String)("Detected registry moved from: " + String.valueOf(variableNamespace) + " to: " + String.valueOf(((YoRegistry)candidates.get(0)).getNamespace()) + " when searching for variable: " + variableName));
                    this.previousSearchResults.put(fullnameToSearch, variable);
                    this.registerRegistryMoved(variableNamespace, ((YoRegistry)candidates.get(0)).getNamespace());
                    return (T)((YoVariable)type.cast(variable));
                }
                ScoredObject<T> scoredObject = this.searchSimilarInRegistryShallow(variableFullname, minScore, type, (YoRegistry)candidates.get(0));
                if (scoredObject != null) {
                    LogTools.info((String)("Detected registry moved from: " + String.valueOf(variableNamespace) + " to: " + String.valueOf(((YoRegistry)candidates.get(0)).getNamespace()) + " when searching for variable: " + variableName));
                    this.previousSearchResults.put(fullnameToSearch, (YoVariable)scoredObject.getObject());
                    this.registerRegistryMoved(variableNamespace, ((YoRegistry)candidates.get(0)).getNamespace());
                    return (T)((YoVariable)scoredObject.getObject());
                }
            } else {
                for (YoRegistry yoRegistry : candidates) {
                    YoVariable variable = yoRegistry.getVariable(variableName);
                    if (variable == null || !type.isInstance(variable)) continue;
                    LogTools.info((String)("Detected registry moved from: " + String.valueOf(variableNamespace) + " to: " + String.valueOf(yoRegistry.getNamespace()) + " when searching for variable: " + variableName));
                    this.previousSearchResults.put(fullnameToSearch, variable);
                    this.registerRegistryMoved(variableNamespace, yoRegistry.getNamespace());
                    return (T)((YoVariable)type.cast(variable));
                }
                List similarVariables = candidates.stream().map(candidate -> this.searchSimilarInRegistryShallow(variableFullname, minScore, type, (YoRegistry)candidate)).filter(Objects::nonNull).sorted().collect(Collectors.toList());
                if (!similarVariables.isEmpty()) {
                    YoVariable yoVariable = (YoVariable)((ScoredObject)similarVariables.get(0)).getObject();
                    double bestScore = ((ScoredObject)similarVariables.get(0)).getScore().doubleValue();
                    LogTools.info((String)("Score: " + bestScore + ", query: " + String.valueOf(variableFullname) + ", result:" + yoVariable.getFullNameString()));
                    LogTools.info((String)("Detected registry moved from: " + String.valueOf(variableNamespace) + " to: " + String.valueOf(yoVariable.getNamespace()) + " when searching for variable: " + variableName));
                    this.registerRegistryMoved(variableNamespace, yoVariable.getNamespace());
                    return (T)yoVariable;
                }
            }
        }
        if ((exactMatches = this.rootRegistry.findVariables(variableName).stream().filter(type::isInstance).map(type::cast).collect(Collectors.toList())).size() == 1) {
            LogTools.info((String)("Found single exact name match for query: " + fullnameToSearch + ", result: " + ((YoVariable)exactMatches.get(0)).getFullNameString()));
            this.previousSearchResults.put(fullnameToSearch, (YoVariable)exactMatches.get(0));
            return (T)((YoVariable)exactMatches.get(0));
        }
        for (Map.Entry entry : this.fromSearchToBestSubname.entrySet()) {
            YoVariable candidate3;
            String bestSubname = (String)entry.getKey();
            String searchSubname = (String)entry.getValue();
            if (!fullnameToSearch.contains(searchSubname) || (candidate3 = this.rootRegistry.findVariable(fullnameToSearch.replace(searchSubname, bestSubname))) == null || !type.isInstance(candidate3)) continue;
            LogTools.info((String)("Search for: " + fullnameToSearch + ", found: " + candidate3.getFullNameString()));
            this.previousSearchResults.put(fullnameToSearch, candidate3);
            return (T)((YoVariable)type.cast(candidate3));
        }
        List correctTypeVariables = this.allTypedYoVariables.computeIfAbsent(type, typeLocal -> this.allYoVariables.stream().filter(type::isInstance).map(type::cast).collect(Collectors.toList()));
        List<YoVariable> searchResult = YoVariableTools.search(correctTypeVariables, YoVariable::getFullNameString, fullnameToSearch, this.searchEngine, 1, arrayList = new ArrayList<Number>());
        if (searchResult != null) {
            YoVariable bestYoVariable = searchResult.get(0);
            String bestFullname = bestYoVariable.getFullNameString();
            String commonSuffix = YoGeometryNameTools.getCommonSuffix((String[])new String[]{fullnameToSearch, bestFullname});
            String searchSubname = fullnameToSearch.substring(0, fullnameToSearch.length() - commonSuffix.length());
            String bestSubname = bestFullname.substring(0, bestFullname.length() - commonSuffix.length());
            String commonPrefix = YoGeometryNameTools.getCommonPrefix((String[])new String[]{searchSubname, bestSubname});
            searchSubname = fullnameToSearch.substring(commonPrefix.length(), searchSubname.length());
            bestSubname = bestFullname.substring(commonPrefix.length(), bestSubname.length());
            LogTools.info((String)("Score: " + String.valueOf(arrayList.get(0)) + ", difference: [" + searchSubname + ", " + bestSubname + "], field: " + fullnameToSearch + ", result: " + bestFullname));
            if (((Number)arrayList.get(0)).doubleValue() >= minScore) {
                this.fromSearchToBestSubname.put(bestSubname, searchSubname);
                this.previousSearchResults.put(fullnameToSearch, bestYoVariable);
                return (T)bestYoVariable;
            }
        }
        return null;
    }

    private YoNamespace updateNamespaceToIncludeMove(YoNamespace variableNamespace) {
        for (Map.Entry<YoNamespace, YoNamespace> entry : this.changedNamespaceMap.entrySet()) {
            YoNamespace originalNamespace = entry.getKey();
            if (!variableNamespace.startsWith(originalNamespace)) continue;
            YoNamespace newNamespace = entry.getValue();
            return variableNamespace.removeStart(originalNamespace).prepend(newNamespace);
        }
        return variableNamespace;
    }

    private void registerRegistryMoved(YoNamespace originalNamespace, YoNamespace newNamespace) {
        if (!originalNamespace.getShortName().equals(newNamespace.getShortName())) {
            return;
        }
        YoNamespace originalParentNamespace = originalNamespace.getParent();
        YoNamespace newParentNamespace = newNamespace.getParent();
        while (originalParentNamespace.getShortName().equals(newParentNamespace.getShortName())) {
            originalNamespace = originalParentNamespace;
            newNamespace = newParentNamespace;
            originalParentNamespace = originalParentNamespace.getParent();
            newParentNamespace = newParentNamespace.getParent();
        }
        this.changedNamespaceMap.put(originalNamespace, newNamespace);
    }

    private <T extends YoVariable> ScoredObject<T> searchSimilarInRegistryShallow(YoNamespace variableFullname, double minScore, Class<? extends T> type, YoRegistry registry) {
        List registryVariables = registry.getVariables().stream().filter(type::isInstance).map(type::cast).collect(Collectors.toList());
        ArrayList<Number> score = new ArrayList<Number>();
        List<YoVariable> searchResult = YoVariableTools.search(registryVariables, YoVariable::getName, variableFullname.getShortName(), this.searchEngine, 1, score);
        if (searchResult != null) {
            YoVariable bestYoVariable = searchResult.get(0);
            LogTools.info((String)("Score: " + String.valueOf(score.get(0)) + ", query: " + String.valueOf(variableFullname) + ", result:" + bestYoVariable.getFullNameString()));
            if (((Number)score.get(0)).doubleValue() >= minScore) {
                return new ScoredObject<YoVariable>(bestYoVariable, (Number)score.get(0));
            }
        }
        return null;
    }

    public void dispose() {
        this.rootRegistry.removeListener(this.registryChangedListener);
        this.allYoVariables.clear();
        this.allTypedYoVariables.clear();
        this.changedNamespaceMap.clear();
        this.previousSearchResults.clear();
        this.fromSearchToBestSubname.clear();
    }
}

