/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.scs2.sessionVisualizer.jfx.tools;

import java.lang.ref.WeakReference;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Objects;

public class WeakList<E>
extends AbstractList<E> {
    private final ArrayList<WeakReference<E>> elements = new ArrayList();
    private ElementGarbageCollectedListener listener;

    public ElementGarbageCollectedListener setGCListener(ElementGarbageCollectedListener listener) {
        ElementGarbageCollectedListener oldListener = this.listener;
        this.listener = listener;
        return oldListener;
    }

    public ElementGarbageCollectedListener removeGCListener() {
        return this.setGCListener(null);
    }

    @Override
    public int size() {
        return this.elements.size();
    }

    public void cleanupReferences() {
        for (int i = this.elements.size() - 1; i >= 0; --i) {
            if (this.elements.get(i).get() != null) continue;
            this.removeGCedElement(i);
        }
    }

    private void removeGCedElement(int i) {
        this.elements.remove(i);
        if (this.listener != null) {
            this.listener.onCleanup(i);
        }
    }

    @Override
    public E get(int index) {
        Object element = this.elements.get(index).get();
        while (element == null) {
            this.removeGCedElement(index);
            if (index >= this.elements.size()) {
                return null;
            }
            element = this.elements.get(index).get();
        }
        return (E)element;
    }

    @Override
    public E set(int index, E element) {
        Objects.requireNonNull(element);
        WeakReference<E> elementReplaced = this.elements.set(index, new WeakReference<E>(element));
        return elementReplaced == null ? null : (E)elementReplaced.get();
    }

    @Override
    public void add(int index, E element) {
        Objects.requireNonNull(element);
        this.elements.add(index, new WeakReference<E>(element));
    }

    @Override
    public E remove(int index) {
        WeakReference<E> elementRemoved = this.elements.remove(index);
        return elementRemoved == null ? null : (E)elementRemoved.get();
    }

    @Override
    public int indexOf(Object query) {
        Objects.requireNonNull(query);
        int i = 0;
        while (i < this.elements.size()) {
            Object candidate = this.elements.get(i).get();
            if (candidate == null) {
                this.removeGCedElement(i);
                continue;
            }
            if (query.equals(candidate)) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    @Override
    public int lastIndexOf(Object query) {
        Objects.requireNonNull(query);
        this.cleanupReferences();
        for (int i = this.elements.size() - 1; i >= 0; --i) {
            Object candidate = this.elements.get(i).get();
            if (candidate == null) {
                this.removeGCedElement(i);
                continue;
            }
            if (!query.equals(candidate)) continue;
            return i;
        }
        return -1;
    }

    @Override
    public void clear() {
        this.elements.clear();
    }

    @Override
    public boolean equals(Object o) {
        this.cleanupReferences();
        return super.equals(o);
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        for (int i = 0; i < this.size(); ++i) {
            E e = this.get(i);
            hashCode = 31 * hashCode + (e == null ? 0 : e.hashCode());
        }
        return hashCode;
    }

    public static interface ElementGarbageCollectedListener {
        public void onCleanup(int var1);
    }
}

