/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.scs2.sessionVisualizer.jfx.tools;

import com.jfoenix.controls.JFXTextField;
import java.util.Collection;
import java.util.function.Function;
import java.util.function.IntFunction;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import javafx.beans.value.ObservableValue;
import javafx.collections.ObservableList;
import javafx.event.ActionEvent;
import javafx.scene.Node;
import javafx.scene.control.Label;
import javafx.scene.control.MenuItem;
import javafx.scene.control.Tab;
import javafx.scene.control.TabPane;
import javafx.scene.control.TextField;
import javafx.scene.input.MouseEvent;
import org.kordamp.ikonli.javafx.FontIcon;

public class TabPaneTools {
    public static Label editableTabHeader(Tab tab) {
        Label headerLabel = new Label();
        JFXTextField headerEditor = new JFXTextField();
        headerLabel.setText(tab.getText());
        tab.setGraphic((Node)headerLabel);
        tab.setText(null);
        headerLabel.setOnMouseClicked(arg_0 -> TabPaneTools.lambda$editableTabHeader$0((TextField)headerEditor, headerLabel, tab, arg_0));
        headerEditor.setOnAction(arg_0 -> TabPaneTools.lambda$editableTabHeader$1(headerLabel, (TextField)headerEditor, tab, arg_0));
        headerEditor.focusedProperty().addListener((arg_0, arg_1, arg_2) -> TabPaneTools.lambda$editableTabHeader$2(headerLabel, (TextField)headerEditor, tab, arg_0, arg_1, arg_2));
        return headerLabel;
    }

    public static Function<TabPane, MenuItem> removeMenuItemFactory() {
        return tabPane -> {
            FontIcon removeIcon = new FontIcon();
            removeIcon.getStyleClass().add((Object)"remove-icon-view");
            MenuItem removeMenuItem = new MenuItem("Remove", (Node)removeIcon);
            Tab selectedItem = (Tab)tabPane.getSelectionModel().getSelectedItem();
            if (selectedItem == null) {
                return null;
            }
            removeMenuItem.setOnAction(e2 -> tabPane.getTabs().remove((Object)selectedItem));
            return removeMenuItem;
        };
    }

    public static Function<TabPane, MenuItem> removeAllMenuItemFactory() {
        return TabPaneTools.removeAllMenuItemFactory(false);
    }

    public static Function<TabPane, MenuItem> removeAllMenuItemFactory(boolean removeOnlyClosableTabs) {
        return TabPaneTools.removeAllMenuItemFactory("Remove all", removeOnlyClosableTabs);
    }

    public static Function<TabPane, MenuItem> removeAllMenuItemFactory(String text, boolean removeOnlyClosableTabs) {
        return tabPane -> TabPaneTools.removeAllMenuItem(text, removeOnlyClosableTabs, tabPane);
    }

    public static MenuItem removeAllMenuItem(String text, boolean removeOnlyClosableTabs, TabPane tabPane) {
        FontIcon removeAllIcon = new FontIcon();
        removeAllIcon.getStyleClass().add((Object)"remove-icon-view");
        MenuItem removeMenuItem = new MenuItem(text, (Node)removeAllIcon);
        removeMenuItem.setOnAction(e2 -> {
            if (tabPane.getTabs().isEmpty()) {
                return;
            }
            Object tabsToclose = removeOnlyClosableTabs ? tabPane.getTabs().stream().filter(Tab::isClosable).collect(Collectors.toList()) : tabPane.getTabs();
            if (tabsToclose.isEmpty()) {
                return;
            }
            tabPane.getTabs().removeAll((Collection)tabsToclose);
        });
        return removeMenuItem;
    }

    public static Function<TabPane, MenuItem> addBeforeMenuItemFactory(Supplier<Tab> addAction) {
        return TabPaneTools.addBeforeMenuItemFactory(addAction, "Add before");
    }

    public static Function<TabPane, MenuItem> addBeforeMenuItemFactory(Supplier<Tab> addAction, String title) {
        return TabPaneTools.addBeforeMenuItemFactory((int i) -> (Tab)addAction.get(), title);
    }

    public static Function<TabPane, MenuItem> addBeforeMenuItemFactory(IntFunction<Tab> addAction, String title) {
        return tabPane -> {
            ObservableList tabs = tabPane.getTabs();
            int selectedIndex = tabPane.getSelectionModel().getSelectedIndex();
            FontIcon addBeforeIcon = new FontIcon();
            addBeforeIcon.getStyleClass().add((Object)"add-icon-view");
            MenuItem addBefore = new MenuItem(title, (Node)addBeforeIcon);
            addBefore.setOnAction(e2 -> {
                Tab newTab = (Tab)addAction.apply(selectedIndex);
                if (newTab != null) {
                    tabs.add(selectedIndex, (Object)newTab);
                    tabPane.getSelectionModel().select(selectedIndex);
                }
            });
            return addBefore;
        };
    }

    public static Function<TabPane, MenuItem> addAfterMenuItemFactory(Supplier<Tab> addAction) {
        return TabPaneTools.addAfterMenuItemFactory(addAction, "Add after");
    }

    public static Function<TabPane, MenuItem> addAfterMenuItemFactory(Supplier<Tab> addAction, String title) {
        return TabPaneTools.addAfterMenuItemFactory((int i) -> (Tab)addAction.get(), title);
    }

    public static Function<TabPane, MenuItem> addAfterMenuItemFactory(IntFunction<Tab> addAction, String title) {
        return tabPane -> {
            ObservableList tabs = tabPane.getTabs();
            int selectedIndex = tabPane.getSelectionModel().getSelectedIndex();
            FontIcon addAfterIcon = new FontIcon();
            addAfterIcon.getStyleClass().add((Object)"add-icon-view");
            MenuItem addAfter = new MenuItem(title, (Node)addAfterIcon);
            addAfter.setOnAction(e2 -> {
                Tab newTab = (Tab)addAction.apply(selectedIndex + 1);
                if (newTab != null) {
                    tabs.add(selectedIndex + 1, (Object)newTab);
                    tabPane.getSelectionModel().select(selectedIndex + 1);
                }
            });
            return addAfter;
        };
    }

    public static MenuItem addLastMenuItem(TabPane tabPane, Supplier<Tab> addAction, String title) {
        FontIcon addAfterIcon = new FontIcon();
        addAfterIcon.getStyleClass().add((Object)"add-icon-view");
        MenuItem addLast = new MenuItem(title, (Node)addAfterIcon);
        addLast.setOnAction(e2 -> {
            Tab newTab = (Tab)addAction.get();
            if (newTab != null) {
                ObservableList tabs = tabPane.getTabs();
                tabs.add((Object)newTab);
                tabPane.getSelectionModel().selectLast();
            }
        });
        return addLast;
    }

    public static MenuItem removeSelectedMenuItem(String title, TabPane tabPane) {
        FontIcon removeIcon = new FontIcon();
        removeIcon.getStyleClass().add((Object)"remove-icon-view");
        MenuItem removeMenuItem = new MenuItem(title, (Node)removeIcon);
        removeMenuItem.setOnAction(e2 -> {
            int selectedIndex = tabPane.getSelectionModel().getSelectedIndex();
            if (selectedIndex < 0) {
                return;
            }
            tabPane.getTabs().remove(selectedIndex);
            if (tabPane.getTabs().size() > 0) {
                if (selectedIndex == 0) {
                    tabPane.getSelectionModel().select(0);
                } else {
                    tabPane.getSelectionModel().select(selectedIndex - 1);
                }
            }
        });
        return removeMenuItem;
    }

    private static /* synthetic */ void lambda$editableTabHeader$2(Label headerLabel, TextField headerEditor, Tab tab, ObservableValue o, Boolean oldValue, Boolean newValue) {
        if (newValue.booleanValue()) {
            return;
        }
        headerLabel.setText(headerEditor.getText());
        tab.setGraphic((Node)headerLabel);
    }

    private static /* synthetic */ void lambda$editableTabHeader$1(Label headerLabel, TextField headerEditor, Tab tab, ActionEvent e) {
        headerLabel.setText(headerEditor.getText());
        tab.setGraphic((Node)headerLabel);
    }

    private static /* synthetic */ void lambda$editableTabHeader$0(TextField headerEditor, Label headerLabel, Tab tab, MouseEvent e) {
        if (e.getClickCount() != 2) {
            return;
        }
        headerEditor.setText(headerLabel.getText());
        headerEditor.setPrefWidth(2.0 * headerLabel.getWidth());
        tab.setGraphic((Node)headerEditor);
        headerEditor.selectAll();
        headerEditor.requestFocus();
    }
}

