/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.scs2.sessionVisualizer.jfx.session.log;

import java.util.ArrayList;
import java.util.List;
import javafx.scene.layout.Pane;
import javafx.stage.Window;
import us.ihmc.scs2.sessionVisualizer.jfx.session.log.MultiVideoDataReader;
import us.ihmc.scs2.sessionVisualizer.jfx.session.log.VideoDataReader;
import us.ihmc.scs2.sessionVisualizer.jfx.session.log.VideoViewer;
import us.ihmc.scs2.sessionVisualizer.jfx.tools.ObservedAnimationTimer;

public class MultiVideoViewer
extends ObservedAnimationTimer {
    private final Pane thumbnailsContainer;
    private final List<VideoViewer> videoViewers = new ArrayList<VideoViewer>();

    public MultiVideoViewer(Window owner, Pane thumbnailsContainer, MultiVideoDataReader multiReader, double defaultThumbnailWidth) {
        this.thumbnailsContainer = thumbnailsContainer;
        for (VideoDataReader reader : multiReader.getReaders()) {
            this.videoViewers.add(new VideoViewer(owner, reader, defaultThumbnailWidth));
        }
    }

    public void start() {
        super.start();
        for (VideoViewer videoViewer : this.videoViewers) {
            this.thumbnailsContainer.getChildren().add((Object)videoViewer.getThumbnail());
        }
    }

    @Override
    public void handleImpl(long now) {
        this.videoViewers.forEach(VideoViewer::update);
    }

    public void stop() {
        super.stop();
        for (VideoViewer videoViewer : this.videoViewers) {
            this.thumbnailsContainer.getChildren().remove((Object)videoViewer.getThumbnail());
            videoViewer.stop();
        }
    }
}

