/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.scs2.sessionVisualizer.jfx.controllers.yoPieChart;

import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Predicate;
import javafx.beans.binding.Bindings;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;
import javafx.beans.value.ObservableValue;
import javafx.scene.Node;
import javafx.scene.chart.PieChart;
import javafx.scene.control.ContextMenu;
import javafx.scene.control.Labeled;
import javafx.scene.control.MenuItem;
import javafx.scene.input.ClipboardContent;
import javafx.scene.input.DragEvent;
import javafx.scene.input.Dragboard;
import javafx.scene.input.MouseButton;
import javafx.scene.input.MouseEvent;
import javafx.scene.input.PickResult;
import javafx.scene.input.TransferMode;
import javafx.scene.layout.Region;
import javafx.scene.text.Text;
import us.ihmc.messager.MessagerAPIFactory;
import us.ihmc.messager.javafx.JavaFXMessager;
import us.ihmc.scs2.sessionVisualizer.jfx.managers.SessionVisualizerToolkit;
import us.ihmc.scs2.sessionVisualizer.jfx.managers.YoCompositeSearchManager;
import us.ihmc.scs2.sessionVisualizer.jfx.managers.YoManager;
import us.ihmc.scs2.sessionVisualizer.jfx.tools.DragAndDropTools;
import us.ihmc.scs2.sessionVisualizer.jfx.tools.YoVariableDatabase;
import us.ihmc.scs2.sessionVisualizer.jfx.yoComposite.YoComposite;
import us.ihmc.scs2.sessionVisualizer.jfx.yoComposite.YoCompositeTools;
import us.ihmc.yoVariables.variable.YoVariable;

public class YoPieChartInputController {
    private static final String HIGHLIGHTED_BORDER = "-fx-border-color:green; -fx-border-radius:10;";
    private static final String HIGHLIGHTED_BACKGROUND = "-fx-background-color: #d3d3d3AA;";
    private static final String DEFAULT_BORDER = null;
    private static final String DEFAULT_BACKGROUND = null;
    private final StringProperty backgroundStyle = new SimpleStringProperty((Object)this, "backgroundStyle", DEFAULT_BACKGROUND);
    private final StringProperty borderStyle = new SimpleStringProperty((Object)this, "borderStyle", DEFAULT_BORDER);
    private YoManager yoManager;
    private Region rootPane;
    private Labeled yoVariableDropLabel;
    private YoCompositeSearchManager yoCompositeSearchManager;
    private Predicate<YoVariable> filter;
    private YoVariable yoVariable;
    private final SimpleObjectProperty<ContextMenu> contextMenuProperty = new SimpleObjectProperty((Object)this, "buttonContextMenu", null);
    private JavaFXMessager messager;
    private MessagerAPIFactory.Topic<List<String>> yoCompositeSelectedTopic;
    private AtomicReference<List<String>> yoCompositeSelected;
    private final String defaultText = "Drop YoVariable here";
    private PieChart pieChart;
    private YoVariableDatabase rootRegistryDatabase = null;

    public void initialize(SessionVisualizerToolkit toolkit, Region rootPane, Labeled yoVariableDropLabel, Predicate<YoVariable> filter, PieChart pieChart) {
        this.rootPane = rootPane;
        this.yoVariableDropLabel = yoVariableDropLabel;
        this.filter = filter;
        this.pieChart = pieChart;
        this.yoCompositeSearchManager = toolkit.getYoCompositeSearchManager();
        this.rootRegistryDatabase = toolkit.getYoManager().getRootRegistryDatabase();
        this.messager = toolkit.getMessager();
        this.yoCompositeSelectedTopic = toolkit.getTopics().getYoCompositeSelected();
        this.yoCompositeSelected = this.messager.createInput(this.yoCompositeSelectedTopic);
        rootPane.styleProperty().bind((ObservableValue)Bindings.concat((Object[])new Object[]{this.backgroundStyle, "; ", this.borderStyle}));
        rootPane.setOnDragDetected(this::handleDragDetected);
        rootPane.setOnDragOver(this::handleDragOver);
        rootPane.setOnDragDropped(this::handleDragDropped);
        rootPane.setOnDragEntered(this::handleDragEntered);
        rootPane.setOnDragExited(this::handleDragExited);
        rootPane.setOnMousePressed(this::handleMousePressed);
        rootPane.setOnMouseReleased(this::handleMouseReleased);
    }

    public void clear() {
        this.backgroundStyle.set((Object)DEFAULT_BACKGROUND);
        this.yoVariableDropLabel.setText("Drop YoVariable here");
    }

    private void handleDragDetected(MouseEvent event) {
        if (event == null || this.yoVariable == null) {
            return;
        }
        if (!event.isPrimaryButtonDown()) {
            return;
        }
        PickResult pickResult = event.getPickResult();
        if (pickResult == null) {
            return;
        }
        Node intersectedNode = pickResult.getIntersectedNode();
        if (intersectedNode == null) {
            return;
        }
        if (intersectedNode instanceof Text) {
            Text legend = (Text)intersectedNode;
            String yoVariableName = legend.getText().split("\\s+")[0];
            if (!yoVariableName.equals(this.yoVariableDropLabel.toString())) {
                return;
            }
            Dragboard dragBoard = legend.startDragAndDrop(new TransferMode[]{TransferMode.COPY});
            ClipboardContent clipboardContent = new ClipboardContent();
            clipboardContent.put((Object)DragAndDropTools.YO_COMPOSITE_REFERENCE, Arrays.asList(YoCompositeTools.YO_VARIABLE, this.yoVariable.getFullNameString()));
            dragBoard.setContent((Map)clipboardContent);
        }
        event.consume();
    }

    private void handleDragEntered(DragEvent event) {
        if (!event.isAccepted() && this.acceptDragEventForDrop(event)) {
            this.setSelectionHighlight(true);
        }
        event.consume();
    }

    private void handleDragExited(DragEvent event) {
        if (this.acceptDragEventForDrop(event)) {
            this.setSelectionHighlight(false);
        }
        event.consume();
    }

    private void handleDragOver(DragEvent event) {
        if (!event.isAccepted() && this.acceptDragEventForDrop(event)) {
            event.acceptTransferModes(TransferMode.ANY);
        }
        event.consume();
    }

    private void handleDragDropped(DragEvent event) {
        Dragboard db = event.getDragboard();
        boolean success = false;
        List<YoComposite> yoComposites = DragAndDropTools.retrieveYoCompositesFromDragBoard(db, this.yoCompositeSearchManager);
        if (yoComposites != null) {
            this.setYoVariableInput(yoComposites.get(0).getYoComponents().get(0));
            success = true;
        }
        event.setDropCompleted(success);
        event.consume();
        if (success) {
            this.setSelectionHighlight(false);
        }
    }

    private void handleMousePressed(MouseEvent event) {
        if (event.getButton() == MouseButton.PRIMARY) {
            this.hideContextMenu();
        }
    }

    private void handleMouseReleased(MouseEvent event) {
        String fullname;
        YoComposite yoComposite;
        String type;
        if (event.getButton() == MouseButton.PRIMARY) {
            if (this.yoVariableDropLabel != null && event.isStillSincePress()) {
                this.messager.submitMessage(this.yoCompositeSelectedTopic, Arrays.asList(YoCompositeTools.YO_VARIABLE, this.yoVariableDropLabel.getText()));
            }
        } else if (event.getButton() == MouseButton.SECONDARY) {
            if (this.yoVariableDropLabel != null && event.isStillSincePress()) {
                ContextMenu contextMenu = this.newGraphContextMenu();
                if (!contextMenu.getItems().isEmpty()) {
                    this.contextMenuProperty.set((Object)contextMenu);
                    contextMenu.show((Node)this.rootPane, event.getScreenX(), event.getScreenY());
                }
                event.consume();
            }
        } else if (event.getButton() == MouseButton.MIDDLE && this.yoCompositeSelected.get() != null && (type = this.yoCompositeSelected.get().get(0)).equals(YoCompositeTools.YO_VARIABLE) && (yoComposite = this.yoCompositeSearchManager.getYoComposite(type, fullname = this.yoCompositeSelected.get().get(1))) != null && this.filter.test(yoComposite.getYoComponents().get(0))) {
            this.setYoVariableInput(yoComposite.getYoComponents().get(0));
            this.messager.submitMessage(this.yoCompositeSelectedTopic, null);
        }
    }

    private void hideContextMenu() {
        if (this.contextMenuProperty.get() != null) {
            this.contextMenuProperty.set(null);
        }
    }

    private ContextMenu newGraphContextMenu() {
        if (this.yoVariableDropLabel == null) {
            return null;
        }
        ContextMenu contextMenu = new ContextMenu();
        MenuItem menuItem = new MenuItem("Remove " + this.yoVariableDropLabel.getText());
        menuItem.setMnemonicParsing(false);
        menuItem.setOnAction(e -> {
            for (PieChart.Data data : this.pieChart.getData()) {
                if (!data.getName().equals(this.yoVariableDropLabel.getText())) continue;
                this.pieChart.getData().remove((Object)data);
                break;
            }
            this.setYoVariableInput(null);
        });
        contextMenu.getItems().add((Object)menuItem);
        return contextMenu;
    }

    public void setYoVariableInput(YoVariable yoVariable) {
        this.yoVariable = yoVariable;
        this.backgroundStyle.set((Object)(yoVariable == null ? DEFAULT_BACKGROUND : HIGHLIGHTED_BACKGROUND));
        if (yoVariable == null) {
            this.yoVariableDropLabel.setText("Drop YoVariable here");
        } else {
            boolean alreadyExists = this.pieChart.getData().stream().anyMatch(data -> data.getName().equals(yoVariable.getName()));
            if (!alreadyExists) {
                this.pieChart.getData().add((Object)new PieChart.Data(yoVariable.getName(), yoVariable.getValueAsDouble()));
            }
            this.yoVariableDropLabel.setText(yoVariable.getName());
        }
    }

    private boolean acceptDragEventForDrop(DragEvent event) {
        if (event.getGestureSource() == this.yoVariableDropLabel) {
            return false;
        }
        Dragboard dragboard = event.getDragboard();
        List<YoComposite> result = DragAndDropTools.retrieveYoCompositesFromDragBoard(dragboard, this.yoCompositeSearchManager);
        if (result == null || result.isEmpty()) {
            return false;
        }
        if (result.get(0).getYoComponents().isEmpty()) {
            return false;
        }
        return this.filter.test(result.get(0).getYoComponents().get(0));
    }

    private void setSelectionHighlight(boolean isSelected) {
        this.borderStyle.set((Object)(isSelected ? HIGHLIGHTED_BORDER : DEFAULT_BORDER));
    }

    public YoVariable getYoVariable() {
        return this.yoVariable;
    }

    public void setYoVariable(String yoVariableName) {
        this.setYoVariableInput(this.rootRegistryDatabase.searchExact(yoVariableName));
    }
}

