/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.scs2.sessionVisualizer.jfx.yoGraphic;

import javafx.beans.property.DoubleProperty;
import javafx.beans.property.SimpleDoubleProperty;
import javafx.beans.value.ObservableValue;
import javafx.scene.Group;
import javafx.scene.Node;
import javafx.scene.paint.Material;
import javafx.scene.paint.PhongMaterial;
import javafx.scene.shape.Cylinder;
import javafx.scene.shape.DrawMode;
import javafx.scene.shape.Mesh;
import javafx.scene.shape.MeshView;
import javafx.scene.transform.Affine;
import javafx.scene.transform.Rotate;
import javafx.scene.transform.Scale;
import javafx.scene.transform.Transform;
import javafx.scene.transform.Translate;
import us.ihmc.euclid.axisAngle.AxisAngle;
import us.ihmc.euclid.geometry.tools.EuclidGeometryTools;
import us.ihmc.euclid.orientation.interfaces.Orientation3DReadOnly;
import us.ihmc.euclid.tuple3D.Vector3D;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Vector3DReadOnly;
import us.ihmc.scs2.definition.geometry.Cone3DDefinition;
import us.ihmc.scs2.definition.geometry.GeometryDefinition;
import us.ihmc.scs2.sessionVisualizer.jfx.definition.JavaFXTriangleMesh3DDefinitionInterpreter;
import us.ihmc.scs2.sessionVisualizer.jfx.managers.ReferenceFrameWrapper;
import us.ihmc.scs2.sessionVisualizer.jfx.tools.JavaFXMissingTools;
import us.ihmc.scs2.sessionVisualizer.jfx.yoComposite.Tuple3DProperty;
import us.ihmc.scs2.sessionVisualizer.jfx.yoGraphic.YoGraphicFX3D;

public class YoArrowFX3D
extends YoGraphicFX3D {
    private Tuple3DProperty origin = new Tuple3DProperty(null, 0.0, 0.0, 0.0);
    private Tuple3DProperty direction = new Tuple3DProperty(null, 0.0, 0.0, 0.0);
    private boolean scaleLength;
    private boolean scaleRadius;
    private DoubleProperty bodyLength = new SimpleDoubleProperty(0.3);
    private DoubleProperty bodyRadius = new SimpleDoubleProperty(0.005);
    private DoubleProperty headLength = new SimpleDoubleProperty(0.02);
    private DoubleProperty headRadius = new SimpleDoubleProperty(0.01);
    private final PhongMaterial material = new PhongMaterial();
    private final Cylinder body = new Cylinder(1.0, 1.0);
    private final MeshView head = new MeshView((Mesh)JavaFXTriangleMesh3DDefinitionInterpreter.interpretDefinition((GeometryDefinition)new Cone3DDefinition(1.0, 1.0)));
    private final Group arrow = new Group(new Node[]{this.body, this.head});
    private final Affine arrowAffine = new Affine();
    private final Scale headScale = new Scale();

    public YoArrowFX3D() {
        this.drawModeProperty.addListener((o, oldValue, newValue) -> {
            if (newValue == null) {
                this.drawModeProperty.setValue((Object)DrawMode.FILL);
            }
            this.body.setDrawMode(newValue);
            this.head.setDrawMode(newValue);
        });
        this.body.setMaterial((Material)this.material);
        this.head.setMaterial((Material)this.material);
        this.body.idProperty().bind((ObservableValue)this.nameProperty().concat((Object)" (body)"));
        this.head.idProperty().bind((ObservableValue)this.nameProperty().concat((Object)" (head)"));
        Affine bodyAffineToZUp = new Affine();
        bodyAffineToZUp.appendTranslation(0.0, 0.0, 0.5);
        bodyAffineToZUp.append((Transform)new Rotate(90.0, Rotate.X_AXIS));
        this.body.getTransforms().add((Object)bodyAffineToZUp);
        this.head.getTransforms().addAll((Object[])new Transform[]{new Translate(0.0, 0.0, 1.0), this.headScale});
        this.arrow.getTransforms().addAll((Object[])new Transform[]{this.arrowAffine});
        this.arrow.getProperties().put((Object)YO_GRAPHICFX_ITEM_KEY, (Object)this);
    }

    public YoArrowFX3D(ReferenceFrameWrapper worldFrame) {
        this();
        this.origin.setReferenceFrame(worldFrame);
        this.direction.setReferenceFrame(worldFrame);
    }

    @Override
    public void render() {
        this.material.setDiffuseColor(this.color.get());
        if (this.origin.containsNaN() || this.direction.containsNaN() || Double.isNaN(this.bodyRadius.get()) || Double.isNaN(this.bodyLength.get())) {
            this.arrowAffine.setToIdentity();
            this.arrowAffine.appendScale(0.0, 0.0, 0.0);
            return;
        }
        Vector3D directionLocal = this.direction.toVector3DInWorld();
        AxisAngle axisAngle = EuclidGeometryTools.axisAngleFromZUpToVector3D((Vector3DReadOnly)directionLocal);
        this.arrowAffine.setToTransform((Transform)JavaFXMissingTools.createAffineFromOrientation3DAndTuple((Orientation3DReadOnly)axisAngle, (Tuple3DReadOnly)this.origin.toPoint3DInWorld()));
        double directionMagnitude = directionLocal.norm();
        double arrowScaleXY = this.scaleRadius ? this.bodyRadius.get() * directionMagnitude : this.bodyRadius.get();
        double arrowScaleZ = this.scaleLength ? this.bodyLength.get() * directionMagnitude : this.bodyLength.get();
        this.arrowAffine.appendScale(arrowScaleXY, arrowScaleXY, arrowScaleZ);
        if (Double.isNaN(this.headRadius.get()) || Double.isNaN(this.headLength.get())) {
            this.headScale.setX(0.0);
            this.headScale.setY(0.0);
            this.headScale.setZ(0.0);
            return;
        }
        double headScaleXY = this.scaleRadius ? this.headRadius.get() * directionMagnitude : this.headRadius.get();
        double headScaleZ = this.scaleLength ? this.headLength.get() * directionMagnitude : this.headLength.get();
        this.headScale.setX(headScaleXY /= arrowScaleXY);
        this.headScale.setY(headScaleXY);
        this.headScale.setZ(headScaleZ /= arrowScaleZ);
    }

    public void setOrigin(Tuple3DProperty origin) {
        this.origin = origin;
    }

    public void setDirection(Tuple3DProperty direction) {
        this.direction = direction;
    }

    public void setScaleLength(boolean scaleRadius) {
        this.scaleLength = scaleRadius;
    }

    public void setScaleRadius(boolean scaleRadius) {
        this.scaleRadius = scaleRadius;
    }

    public void setBodyLength(DoubleProperty bodyLength) {
        this.bodyLength = bodyLength;
    }

    public void setBodyLength(double bodyLength) {
        this.setBodyLength((DoubleProperty)new SimpleDoubleProperty(bodyLength));
    }

    public void setBodyRadius(DoubleProperty bodyRadius) {
        this.bodyRadius = bodyRadius;
    }

    public void setBodyRadius(double bodyRadius) {
        this.setBodyRadius((DoubleProperty)new SimpleDoubleProperty(bodyRadius));
    }

    public void setHeadLength(DoubleProperty headLength) {
        this.headLength = headLength;
    }

    public void setHeadLength(double headLength) {
        this.setHeadLength((DoubleProperty)new SimpleDoubleProperty(headLength));
    }

    public void setHeadRadius(DoubleProperty headRadius) {
        this.headRadius = headRadius;
    }

    public void setHeadRadius(double headRadius) {
        this.setHeadRadius((DoubleProperty)new SimpleDoubleProperty(headRadius));
    }

    @Override
    public void clear() {
        this.origin = null;
        this.direction = null;
        this.bodyLength = null;
        this.bodyRadius = null;
        this.headLength = null;
        this.headRadius = null;
        this.color = null;
    }

    @Override
    public YoArrowFX3D clone() {
        YoArrowFX3D clone = new YoArrowFX3D();
        clone.setName(this.getName());
        clone.setOrigin(new Tuple3DProperty(this.origin));
        clone.setDirection(new Tuple3DProperty(this.direction));
        clone.setScaleLength(this.scaleLength);
        clone.setScaleRadius(this.scaleRadius);
        clone.setBodyLength(this.bodyLength);
        clone.setBodyRadius(this.bodyRadius);
        clone.setHeadLength(this.headLength);
        clone.setHeadRadius(this.headRadius);
        clone.setColor(this.color);
        return clone;
    }

    public Tuple3DProperty getOrigin() {
        return this.origin;
    }

    public Tuple3DProperty getDirection() {
        return this.direction;
    }

    public boolean getScaleLength() {
        return this.scaleLength;
    }

    public DoubleProperty getBodyLength() {
        return this.bodyLength;
    }

    public DoubleProperty getHeadLength() {
        return this.headLength;
    }

    public boolean getScaleRadius() {
        return this.scaleRadius;
    }

    public DoubleProperty getBodyRadius() {
        return this.bodyRadius;
    }

    public DoubleProperty getHeadRadius() {
        return this.headRadius;
    }

    @Override
    public Node getNode() {
        return this.arrow;
    }
}

