/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.scs2.sessionVisualizer.jfx.controllers.yoComposite.search;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.Property;
import javafx.beans.property.ReadOnlyProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.collections.ObservableMap;
import javafx.fxml.FXML;
import javafx.scene.control.CheckMenuItem;
import javafx.scene.control.ComboBox;
import javafx.scene.control.ListView;
import javafx.scene.control.MenuItem;
import javafx.scene.control.SelectionMode;
import javafx.scene.control.TextField;
import javafx.scene.input.Clipboard;
import javafx.scene.input.ClipboardContent;
import javafx.scene.input.DataFormat;
import javafx.scene.input.Dragboard;
import javafx.scene.input.MouseEvent;
import javafx.scene.input.TransferMode;
import us.ihmc.messager.javafx.JavaFXMessager;
import us.ihmc.scs2.session.SessionState;
import us.ihmc.scs2.sessionVisualizer.jfx.SessionVisualizerTopics;
import us.ihmc.scs2.sessionVisualizer.jfx.YoNameDisplay;
import us.ihmc.scs2.sessionVisualizer.jfx.controllers.yoComposite.search.SearchEngines;
import us.ihmc.scs2.sessionVisualizer.jfx.controllers.yoComposite.search.YoCompositeListCell;
import us.ihmc.scs2.sessionVisualizer.jfx.managers.BackgroundExecutorManager;
import us.ihmc.scs2.sessionVisualizer.jfx.managers.SessionVisualizerToolkit;
import us.ihmc.scs2.sessionVisualizer.jfx.managers.YoCompositeSearchManager;
import us.ihmc.scs2.sessionVisualizer.jfx.managers.YoManager;
import us.ihmc.scs2.sessionVisualizer.jfx.tools.DragAndDropTools;
import us.ihmc.scs2.sessionVisualizer.jfx.tools.MenuTools;
import us.ihmc.scs2.sessionVisualizer.jfx.tools.ObservedAnimationTimer;
import us.ihmc.scs2.sessionVisualizer.jfx.tools.SCS2JavaFXMessager;
import us.ihmc.scs2.sessionVisualizer.jfx.tools.YoVariableTools;
import us.ihmc.scs2.sessionVisualizer.jfx.yoComposite.YoComposite;
import us.ihmc.scs2.sessionVisualizer.jfx.yoComposite.YoCompositeCollection;
import us.ihmc.scs2.sessionVisualizer.jfx.yoComposite.YoCompositeTools;
import us.ihmc.yoVariables.registry.YoNamespace;
import us.ihmc.yoVariables.registry.YoRegistry;

public class YoCompositeSearchPaneController
extends ObservedAnimationTimer {
    @FXML
    private TextField searchTextField;
    @FXML
    private ListView<YoComposite> yoCompositeListView;
    @FXML
    private ComboBox<String> searchTargetComboBox;
    private ObservableList<YoComposite> defaultItemList = FXCollections.emptyObservableList();
    private ObservableList<YoComposite> searchResult = null;
    private YoRegistry ownerRegistry = null;
    private YoCompositeSearchManager yoCompositeSearchManager;
    private BackgroundExecutorManager backgroundExecutorManager;
    private ObjectProperty<String> searchTargetProperty;
    private final Property<YoNameDisplay> yoVariableNameDisplay = new SimpleObjectProperty((Object)this, "yoVariableNameDisplay", (Object)YoNameDisplay.SHORT_NAME);
    private AtomicReference<SearchEngines> activeSearchEngine;
    private AtomicReference<Integer> maxNumberOfItemsReference;
    private Future<ObservableList<YoComposite>> backgroundSearch;
    private Consumer<YoNamespace> registryViewRequestConsumer = null;
    private Property<YoCompositeCollection> activeCompositeCollectionProperty = null;
    private final ChangeListener<Object> autoRefreshListener = (o, oldV, newV) -> this.refreshDefaultItemList(this.getSearchTarget());

    public void initialize(SessionVisualizerToolkit toolkit) {
        this.initialize(toolkit, null);
    }

    public void initialize(SessionVisualizerToolkit toolkit, YoRegistry ownerRegistry) {
        SCS2JavaFXMessager messager = toolkit.getMessager();
        SessionVisualizerTopics topics = toolkit.getTopics();
        YoManager yoManager = toolkit.getYoManager();
        this.backgroundExecutorManager = toolkit.getBackgroundExecutorManager();
        this.yoCompositeSearchManager = toolkit.getYoCompositeSearchManager();
        Property numberPrecision = messager.createPropertyInput(topics.getControlsNumberPrecision(), 3);
        SimpleObjectProperty yoVariableUserNameDisplay = new SimpleObjectProperty((Object)this, "yoVariableUserNameDisplay", (Object)YoNameDisplay.SHORT_NAME);
        messager.bindBidirectional(topics.getYoVariableNameDisplay(), (Property)yoVariableUserNameDisplay, false);
        yoVariableUserNameDisplay.addListener((o, oldValue, newValue) -> this.search(this.searchTextField.getText()));
        this.ownerRegistry = ownerRegistry;
        if (ownerRegistry != null) {
            this.yoVariableNameDisplay.setValue((Object)YoNameDisplay.SHORT_NAME);
        } else {
            this.yoVariableNameDisplay.bindBidirectional((Property)yoVariableUserNameDisplay);
        }
        this.yoCompositeListView.setCellFactory(param -> new YoCompositeListCell(yoManager, (ReadOnlyProperty<YoNameDisplay>)this.yoVariableNameDisplay, (Property<Integer>)numberPrecision, (ListView<YoComposite>)param));
        this.yoCompositeListView.getSelectionModel().setSelectionMode(SelectionMode.MULTIPLE);
        this.searchTextField.textProperty().addListener((observable, oldValue, newValue) -> this.search((String)newValue));
        this.activeSearchEngine = messager.createInput(topics.getYoSearchEngine(), (Object)SearchEngines.DEFAULT);
        this.maxNumberOfItemsReference = messager.createInput(topics.getYoSearchMaxListSize(), 500);
        Function<ListView, MenuItem> openNamespace = listView -> {
            if (this.registryViewRequestConsumer == null) {
                return null;
            }
            YoComposite selectedItem = (YoComposite)this.yoCompositeListView.getSelectionModel().getSelectedItem();
            if (selectedItem == null) {
                return null;
            }
            MenuItem menuItem = new MenuItem("Open namespace");
            YoNamespace namespace = selectedItem.getNamespace();
            menuItem.setOnAction(e -> this.registryViewRequestConsumer.accept(namespace));
            return menuItem;
        };
        Function<ListView, MenuItem> copyVariableName = listView -> {
            YoComposite selectedItem = (YoComposite)this.yoCompositeListView.getSelectionModel().getSelectedItem();
            if (selectedItem == null) {
                return null;
            }
            MenuItem menuItem = new MenuItem("Copy variable name");
            String name = selectedItem.getName();
            menuItem.setOnAction(e -> Clipboard.getSystemClipboard().setContent(Collections.singletonMap(DataFormat.PLAIN_TEXT, name)));
            return menuItem;
        };
        Function<ListView, MenuItem> copyVariableFullname = listView -> {
            YoComposite selectedItem = (YoComposite)this.yoCompositeListView.getSelectionModel().getSelectedItem();
            if (selectedItem == null) {
                return null;
            }
            MenuItem menuItem = new MenuItem("Copy variable fullname");
            String name = selectedItem.getFullname();
            menuItem.setOnAction(e -> Clipboard.getSystemClipboard().setContent(Collections.singletonMap(DataFormat.PLAIN_TEXT, name)));
            return menuItem;
        };
        Function<ListView, MenuItem> showUniqueNames = arg_0 -> this.lambda$initialize$10((JavaFXMessager)messager, topics, arg_0);
        MenuTools.setupContextMenu(this.yoCompositeListView, new Function[]{openNamespace, copyVariableName, copyVariableFullname, showUniqueNames});
        ObservableMap<String, Property<YoCompositeCollection>> nameToCompositeCollection = this.yoCompositeSearchManager.typeToCompositeCollection();
        this.searchTargetComboBox.setItems(FXCollections.observableArrayList((Collection)nameToCompositeCollection.keySet()));
        nameToCompositeCollection.addListener(change -> {
            ObservableList items = this.searchTargetComboBox.getItems();
            if (change.wasAdded()) {
                if (!items.contains(change.getKey())) {
                    items.add((Object)((String)change.getKey()));
                }
            } else if (change.wasRemoved()) {
                if (this.searchTargetComboBox.getValue() == change.getKey()) {
                    this.searchTargetComboBox.getSelectionModel().select((Object)YoCompositeTools.YO_VARIABLE);
                }
                items.remove(change.getKey());
            }
        });
        this.searchTargetProperty = this.searchTargetComboBox.valueProperty();
        this.searchTargetProperty.set((Object)YoCompositeTools.YO_VARIABLE);
        this.searchTargetProperty.addListener((o, oldValue, newValue) -> {
            if (newValue == null) {
                this.searchTargetProperty.set(oldValue);
                return;
            }
            if (Objects.equals(newValue, oldValue) && !this.defaultItemList.isEmpty()) {
                return;
            }
            this.refreshDefaultItemList((String)newValue);
            this.search(this.searchTextField.getText());
        });
        messager.addFXTopicListener(topics.getSessionCurrentState(), state -> {
            if (state == SessionState.ACTIVE) {
                this.start();
            } else if (state == SessionState.INACTIVE) {
                this.stop();
            }
        });
        this.yoCompositeListView.getSelectionModel().selectedItemProperty().addListener((arg_0, arg_1, arg_2) -> YoCompositeSearchPaneController.lambda$initialize$14((JavaFXMessager)messager, topics, arg_0, arg_1, arg_2));
    }

    public void requestFocusForSearchBox() {
        this.searchTextField.requestFocus();
    }

    public void setRegistryViewRequestConsumer(Consumer<YoNamespace> consumer) {
        this.registryViewRequestConsumer = consumer;
    }

    public String getSearchTarget() {
        return (String)this.searchTargetProperty.get();
    }

    @Override
    public void handleImpl(long now) {
        if (this.defaultItemList.isEmpty()) {
            if (this.searchTargetProperty.get() == null) {
                this.searchTargetProperty.set((Object)YoCompositeTools.YO_VARIABLE);
            } else {
                this.refreshDefaultItemList((String)this.searchTargetProperty.get());
                if (!this.searchTextField.getText().isEmpty()) {
                    this.search(this.searchTextField.getText());
                }
            }
        }
        if (this.backgroundSearch != null && this.backgroundSearch.isDone() && !this.backgroundSearch.isCancelled()) {
            try {
                this.searchResult = this.backgroundSearch.get();
            }
            catch (InterruptedException | ExecutionException e) {
                e.printStackTrace();
            }
        }
        if (this.searchResult != null) {
            ObservableList<YoComposite> result = this.searchResult;
            this.searchResult = null;
            this.yoCompositeListView.setItems(result);
        }
    }

    public void stop() {
        super.stop();
        this.defaultItemList = FXCollections.emptyObservableList();
        this.searchResult = null;
        this.yoCompositeListView.getItems().clear();
        this.searchTextField.clear();
        if (this.activeCompositeCollectionProperty != null) {
            this.activeCompositeCollectionProperty.removeListener(this.autoRefreshListener);
        }
        this.activeCompositeCollectionProperty = null;
    }

    private void refreshDefaultItemList(String searchTarget) {
        if (this.activeCompositeCollectionProperty != null) {
            this.activeCompositeCollectionProperty.removeListener(this.autoRefreshListener);
        }
        this.activeCompositeCollectionProperty = (Property)this.yoCompositeSearchManager.typeToCompositeCollection().get((Object)searchTarget);
        this.activeCompositeCollectionProperty.addListener(this.autoRefreshListener);
        YoCompositeCollection yoVariableTypeReferenceCollection = (YoCompositeCollection)this.activeCompositeCollectionProperty.getValue();
        this.defaultItemList = yoVariableTypeReferenceCollection == null ? FXCollections.emptyObservableList() : (this.ownerRegistry == null ? FXCollections.observableArrayList(yoVariableTypeReferenceCollection.getYoComposites()) : FXCollections.observableArrayList(yoVariableTypeReferenceCollection.getYoComposite(this.ownerRegistry)));
        this.searchResult = this.defaultItemList;
    }

    private void search(String searchQuery) {
        if (this.backgroundSearch != null) {
            this.backgroundSearch.cancel(true);
            this.backgroundSearch = null;
        }
        if (searchQuery != null && !searchQuery.isEmpty() && this.defaultItemList != null && !this.defaultItemList.isEmpty()) {
            this.backgroundSearch = this.backgroundExecutorManager.executeInBackground(() -> this.performSearch(searchQuery));
        } else {
            this.searchResult = this.defaultItemList;
        }
    }

    private ObservableList<YoComposite> performSearch(String searchQuery) {
        Function<YoComposite, String> nameExtractor = switch ((YoNameDisplay)((Object)this.yoVariableNameDisplay.getValue())) {
            default -> throw new IncompatibleClassChangeError();
            case YoNameDisplay.UNIQUE_NAME -> YoComposite::getUniqueName;
            case YoNameDisplay.UNIQUE_SHORT_NAME -> YoComposite::getUniqueShortName;
            case YoNameDisplay.SHORT_NAME -> YoComposite::getName;
            case YoNameDisplay.FULL_NAME -> YoComposite::getFullname;
        };
        List<YoComposite> yoVariables = YoVariableTools.search(this.defaultItemList, nameExtractor, searchQuery, YoVariableTools.fromSearchEnginesEnum(this.activeSearchEngine.get()), this.maxNumberOfItemsReference.get());
        return yoVariables == null ? FXCollections.emptyObservableList() : FXCollections.observableArrayList(yoVariables);
    }

    @FXML
    public void startYoVariableDragAndDrop(MouseEvent event) {
        if (!event.isPrimaryButtonDown()) {
            return;
        }
        ObservableList yoComposites = this.yoCompositeListView.getSelectionModel().getSelectedItems();
        Dragboard dragBoard = this.yoCompositeListView.startDragAndDrop(new TransferMode[]{TransferMode.COPY});
        ClipboardContent clipboardContent = new ClipboardContent();
        if (yoComposites.size() == 1) {
            YoComposite yoComposite = (YoComposite)yoComposites.get(0);
            if (yoComposite == null) {
                return;
            }
            clipboardContent.put((Object)DragAndDropTools.YO_COMPOSITE_REFERENCE, Arrays.asList(yoComposite.getPattern().getType(), yoComposite.getFullname()));
        } else {
            List content = yoComposites.stream().flatMap(c -> Arrays.asList(c.getPattern().getType(), c.getFullname()).stream()).collect(Collectors.toList());
            clipboardContent.put((Object)DragAndDropTools.YO_COMPOSITE_LIST_REFERENCE, content);
        }
        dragBoard.setContent((Map)clipboardContent);
        event.consume();
    }

    private static /* synthetic */ void lambda$initialize$14(JavaFXMessager messager, SessionVisualizerTopics topics, ObservableValue o, YoComposite oldValue, YoComposite newValue) {
        if (newValue != null) {
            messager.submitMessage(topics.getYoCompositeSelected(), Arrays.asList(newValue.getPattern().getType(), newValue.getFullname()));
        }
    }

    private /* synthetic */ MenuItem lambda$initialize$10(JavaFXMessager messager, SessionVisualizerTopics topics, ListView listView) {
        YoComposite selectedItem = (YoComposite)this.yoCompositeListView.getSelectionModel().getSelectedItem();
        if (selectedItem == null) {
            return null;
        }
        CheckMenuItem menuItem = new CheckMenuItem("Show unique names");
        menuItem.setSelected(this.yoVariableNameDisplay.getValue() == YoNameDisplay.UNIQUE_SHORT_NAME);
        menuItem.setOnAction(e -> messager.submitMessage(topics.getYoVariableNameDisplay(), (Object)(menuItem.isSelected() ? YoNameDisplay.UNIQUE_SHORT_NAME : YoNameDisplay.SHORT_NAME)));
        return menuItem;
    }
}

