/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.scs2.sessionVisualizer.jfx.yoGraphic.color;

import javafx.beans.property.DoubleProperty;
import javafx.scene.paint.Color;
import us.ihmc.commons.MathTools;
import us.ihmc.scs2.sessionVisualizer.jfx.yoGraphic.color.BaseColorFX;

public class YoColorRGBADoubleFX
implements BaseColorFX {
    private DoubleProperty red;
    private DoubleProperty green;
    private DoubleProperty blue;
    private DoubleProperty alpha;

    public YoColorRGBADoubleFX() {
    }

    public YoColorRGBADoubleFX(DoubleProperty red, DoubleProperty green, DoubleProperty blue) {
        this(red, green, blue, null);
    }

    public YoColorRGBADoubleFX(DoubleProperty red, DoubleProperty green, DoubleProperty blue, DoubleProperty alpha) {
        this.red = red;
        this.green = green;
        this.blue = blue;
        this.alpha = alpha;
    }

    public YoColorRGBADoubleFX(YoColorRGBADoubleFX other) {
        this.red = other.red;
        this.green = other.green;
        this.blue = other.blue;
        this.alpha = other.alpha;
    }

    @Override
    public void clear() {
        this.red = null;
        this.green = null;
        this.blue = null;
        this.alpha = null;
    }

    public void setRed(DoubleProperty red) {
        this.red = red;
    }

    public void setGreen(DoubleProperty green) {
        this.green = green;
    }

    public void setBlue(DoubleProperty blue) {
        this.blue = blue;
    }

    public void setAlpha(DoubleProperty alpha) {
        this.alpha = alpha;
    }

    public DoubleProperty getRed() {
        return this.red;
    }

    public DoubleProperty getGreen() {
        return this.green;
    }

    public DoubleProperty getBlue() {
        return this.blue;
    }

    public DoubleProperty getAlpha() {
        return this.alpha;
    }

    @Override
    public YoColorRGBADoubleFX clone() {
        return new YoColorRGBADoubleFX(this);
    }

    @Override
    public Color get() {
        if (this.red == null && this.green == null && this.blue == null && this.alpha == null) {
            return null;
        }
        double r = this.red == null ? 0.0 : MathTools.clamp((double)this.red.get(), (double)0.0, (double)1.0);
        double g = this.green == null ? 0.0 : MathTools.clamp((double)this.green.get(), (double)0.0, (double)1.0);
        double b = this.blue == null ? 0.0 : MathTools.clamp((double)this.blue.get(), (double)0.0, (double)1.0);
        double o = this.alpha == null ? 1.0 : MathTools.clamp((double)this.alpha.get(), (double)0.0, (double)1.0);
        return Color.color((double)r, (double)g, (double)b, (double)o);
    }

    public String toString() {
        return "[red=" + String.valueOf(this.red) + ", green=" + String.valueOf(this.green) + ", blue=" + String.valueOf(this.blue) + ", alpha=" + String.valueOf(this.alpha) + "]";
    }
}

