/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.scs2.sessionVisualizer.jfx.yoComposite;

import gnu.trove.list.array.TIntArrayList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javafx.util.Pair;
import org.apache.commons.lang3.StringUtils;
import us.ihmc.euclid.tools.EuclidCoreIOTools;
import us.ihmc.log.LogTools;
import us.ihmc.scs2.definition.yoComposite.YoCompositePatternDefinition;
import us.ihmc.scs2.definition.yoComposite.YoCompositePatternListDefinition;
import us.ihmc.scs2.sessionVisualizer.jfx.charts.ChartGroupModel;
import us.ihmc.scs2.sessionVisualizer.jfx.tools.ChartTools;
import us.ihmc.scs2.sessionVisualizer.jfx.yoComposite.YoComposite;
import us.ihmc.scs2.sessionVisualizer.jfx.yoComposite.YoCompositeCollection;
import us.ihmc.scs2.sessionVisualizer.jfx.yoComposite.YoCompositeName;
import us.ihmc.scs2.sessionVisualizer.jfx.yoComposite.YoCompositePattern;
import us.ihmc.yoVariables.registry.YoNamespace;
import us.ihmc.yoVariables.registry.YoRegistry;
import us.ihmc.yoVariables.variable.YoBoolean;
import us.ihmc.yoVariables.variable.YoDouble;
import us.ihmc.yoVariables.variable.YoEnum;
import us.ihmc.yoVariables.variable.YoInteger;
import us.ihmc.yoVariables.variable.YoLong;
import us.ihmc.yoVariables.variable.YoVariable;

public class YoCompositeTools {
    public static final String YO_VARIABLE = YoVariable.class.getSimpleName();
    public static final String YO_BOOLEAN = YoBoolean.class.getSimpleName();
    public static final String YO_DOUBLE = YoDouble.class.getSimpleName();
    public static final String YO_INTEGER = YoInteger.class.getSimpleName();
    public static final String YO_LONG = YoLong.class.getSimpleName();
    public static final String YO_TUPLE2D = "YoTuple2D";
    public static final String YO_TUPLE3D = "YoTuple3D";
    public static final String YO_QUATERNION = "YoQuaternion";
    public static final String YO_YAW_PITCH_ROLL = "YoYawPitchRoll";
    private static final Class<? extends YoVariable>[] yoPrimitives = new Class[]{YoDouble.class, YoBoolean.class, YoInteger.class, YoEnum.class, YoLong.class};

    public static String getYoCompositeName(YoCompositePattern definition, List<YoVariable> yoCompositeComponents) {
        HashSet<YoVariable> yoCompositeComponentSet = new HashSet<YoVariable>(yoCompositeComponents);
        int numberOfComponents = definition.getComponentIdentifiers().length;
        if (numberOfComponents != yoCompositeComponentSet.size()) {
            return null;
        }
        YoVariable firstYoVariable = yoCompositeComponents.get(0);
        YoCompositeName[] candidateNames = YoCompositeTools.fromComponentIdentifiers(firstYoVariable.getName(), definition.getComponentIdentifiers());
        if (candidateNames == null || candidateNames.length == 0) {
            return null;
        }
        Map yoVariableMap = yoCompositeComponentSet.stream().collect(Collectors.toMap(yoVariable -> yoVariable.getName().toLowerCase(), Function.identity()));
        for (YoCompositeName candidateName : candidateNames) {
            String[] componentNames = YoCompositeTools.toComponentNames(definition.getComponentIdentifiers(), candidateName);
            boolean isCompositeValid = Stream.of(componentNames).map(String::toLowerCase).allMatch(yoVariableMap::containsKey);
            if (!isCompositeValid) continue;
            Object[] components = (YoVariable[])Stream.of(componentNames).map(String::toLowerCase).map(yoVariableMap::remove).toArray(YoVariable[]::new);
            if (!YoCompositeTools.areAllOfSameType(components)) break;
            return candidateName.getName();
        }
        return null;
    }

    public static Map<String, List<YoComposite>> searchYoCompositeLists(YoCompositeCollection collection) {
        LinkedHashMap<String, List<YoComposite>> result = new LinkedHashMap<String, List<YoComposite>>();
        List candidates = collection.getYoComposites().stream().filter(yoComposite -> YoCompositeTools.containsInteger(yoComposite.getName(), 0)).collect(Collectors.toList());
        List<YoComposite> others = collection.getYoComposites();
        others = others.stream().filter(yoComposite -> yoComposite.getName().split("[^0-9]+").length > 0).collect(Collectors.toList());
        for (YoComposite candidate : candidates) {
            List<YoCompositeName> listCandidateNames = YoCompositeTools.fromComponentIdentifier(candidate.getName(), "0");
            for (YoCompositeName listCandidateName : listCandidateNames) {
                List possibleOtherElements;
                int uniquePrefixLength = candidate.getUniqueName().indexOf(listCandidateName.getPrefix());
                YoCompositeName listCandidateUniqueName = uniquePrefixLength == 0 ? listCandidateName : new YoCompositeName(candidate.getUniqueName().substring(0, uniquePrefixLength) + listCandidateName.getPrefix(), listCandidateName.getSuffix());
                if (listCandidateUniqueName.getPrefix().isEmpty()) {
                    if (listCandidateUniqueName.getSuffix().isEmpty()) continue;
                    possibleOtherElements = others.stream().filter(yoComposite -> yoComposite.getUniqueName().endsWith(listCandidateUniqueName.getSuffix())).collect(Collectors.toList());
                } else {
                    possibleOtherElements = listCandidateUniqueName.getSuffix().isEmpty() ? others.stream().filter(yoComposite -> yoComposite.getUniqueName().startsWith(listCandidateUniqueName.getPrefix())).collect(Collectors.toList()) : others.stream().filter(yoComposite -> yoComposite.getUniqueName().startsWith(listCandidateUniqueName.getPrefix()) && yoComposite.getUniqueName().endsWith(listCandidateUniqueName.getSuffix())).collect(Collectors.toList());
                }
                if (possibleOtherElements.isEmpty()) continue;
                ArrayList<YoComposite> compositeList = new ArrayList<YoComposite>();
                compositeList.add(candidate);
                int listIndex = 1;
                boolean foundNextElement = false;
                do {
                    foundNextElement = false;
                    for (YoComposite possibleOtherElement : possibleOtherElements) {
                        String indexString = possibleOtherElement.getName().substring(listCandidateName.getPrefix().length(), possibleOtherElement.getName().length() - listCandidateName.getSuffix().length());
                        try {
                            if (Integer.parseInt(indexString) != listIndex) continue;
                            compositeList.add(possibleOtherElement);
                            foundNextElement = true;
                            break;
                        }
                        catch (NumberFormatException numberFormatException) {
                        }
                    }
                    ++listIndex;
                } while (foundNextElement);
                if (compositeList.size() <= 1) continue;
                result.put(listCandidateUniqueName.getName(), compositeList);
            }
        }
        return result;
    }

    public static boolean containsInteger(String string, int integer) {
        String[] numbers;
        for (String number : numbers = string.split("[^0-9]+")) {
            if (number.isEmpty() || Integer.parseInt(number) != integer) continue;
            return true;
        }
        return false;
    }

    public static List<YoComposite> searchYoComposites(YoCompositePattern pattern, YoRegistry registry, Predicate<YoRegistry> registryFilter) {
        return (List)YoCompositeTools.searchYoCompositesRecursive(pattern, registry, registryFilter).getKey();
    }

    private static Pair<List<YoComposite>, List<YoVariable>> searchYoCompositesRecursive(YoCompositePattern pattern, YoRegistry registry, Predicate<YoRegistry> registryFilter) {
        if (!registryFilter.test(registry)) {
            return new Pair(Collections.emptyList(), Collections.emptyList());
        }
        Pair result = new Pair(new ArrayList(), new ArrayList());
        HashMap<YoNamespace, List<YoComposite>> namespaceToYoCompositesMap = new HashMap<YoNamespace, List<YoComposite>>();
        List yoVariables = registry.getVariables();
        for (Class<? extends YoVariable> yoPrimitive : yoPrimitives) {
            ArrayList<YoVariable> searchPool = new ArrayList<YoVariable>();
            for (int i = 0; i < yoVariables.size(); ++i) {
                YoVariable yoVariable = (YoVariable)yoVariables.get(i);
                if (!yoPrimitive.isInstance(yoVariable)) continue;
                searchPool.add(yoVariable);
            }
            Pair<List<YoComposite>, List<YoVariable>> primitiveResult = YoCompositeTools.searchYoComposites(pattern, searchPool, registry.getNamespace(), false, namespaceToYoCompositesMap);
            ((List)result.getKey()).addAll((Collection)primitiveResult.getKey());
            ((List)result.getValue()).addAll((Collection)primitiveResult.getValue());
        }
        List children = registry.getChildren();
        for (int i = 0; i < children.size(); ++i) {
            YoRegistry childRegistry = (YoRegistry)children.get(i);
            Pair<List<YoComposite>, List<YoVariable>> childResult = YoCompositeTools.searchYoCompositesRecursive(pattern, childRegistry, registryFilter);
            ((List)result.getKey()).addAll((Collection)childResult.getKey());
            ((List)result.getValue()).addAll((Collection)childResult.getValue());
        }
        if (pattern.isCrossRegistry() && !registry.getChildren().isEmpty()) {
            Pair<List<YoComposite>, List<YoVariable>> crossRegistryResult = YoCompositeTools.searchYoComposites(pattern, (List)result.getValue(), null, true, namespaceToYoCompositesMap);
            ((List)result.getKey()).addAll((Collection)crossRegistryResult.getKey());
            result = new Pair((Object)((List)result.getKey()), (Object)((List)crossRegistryResult.getValue()));
        }
        return result;
    }

    private static Pair<List<YoComposite>, List<YoVariable>> searchYoComposites(YoCompositePattern pattern, List<YoVariable> variables, YoNamespace namespace, boolean useUniqueNames, Map<YoNamespace, List<YoComposite>> namespaceToYoCompositesMap) {
        ArrayList<String[]> allComponentIdentifiers = new ArrayList<String[]>();
        allComponentIdentifiers.add(pattern.getComponentIdentifiers());
        allComponentIdentifiers.addAll(pattern.getAlternateComponentIdentifiers());
        ArrayList<YoComposite> result = new ArrayList<YoComposite>();
        ArrayList<YoVariable> unresolvedCandidates = new ArrayList<YoVariable>();
        for (String[] componentIdentifiers : allComponentIdentifiers) {
            Object container;
            List candidates = variables.stream().filter(variable -> YoCompositeTools.containsAnyIgnoreCase(variable.getName(), componentIdentifiers)).collect(Collectors.toList());
            if (candidates.isEmpty()) continue;
            LinkedHashMap<String, List> variableMap = new LinkedHashMap<String, List>();
            if (useUniqueNames) {
                Map<YoVariable, String> variableToUniqueNameMap = YoCompositeTools.computeUniqueNames(candidates, v -> v.getNamespace().getSubNames(), YoVariable::getName);
                for (Map.Entry entry : variableToUniqueNameMap.entrySet()) {
                    String variableKey = ((String)entry.getValue()).toLowerCase();
                    List container2 = variableMap.computeIfAbsent(variableKey, k -> new ArrayList());
                    container2.add(NamedObjectHolder.newUniqueNamedYoVariable((String)entry.getValue(), (YoVariable)entry.getKey()));
                }
            } else {
                for (YoVariable variable2 : candidates) {
                    String variableKey = variable2.getName().toLowerCase();
                    container = variableMap.computeIfAbsent(variableKey, k -> new ArrayList());
                    container.add(NamedObjectHolder.newUniqueNamedYoVariable(variable2.getName(), variable2));
                }
            }
            while (!variableMap.isEmpty()) {
                String yoVariableName = ((NamedObjectHolder)((List)variableMap.values().iterator().next()).get(0)).getUniqueName();
                String variableKey = yoVariableName.toLowerCase();
                YoCompositeName[] candidateNames = YoCompositeTools.fromComponentIdentifiers(yoVariableName, componentIdentifiers);
                container = candidateNames;
                int n = ((YoCompositeName[])container).length;
                for (int i = 0; i < n; ++i) {
                    Optional<YoComposite> homonym;
                    List<YoComposite> siblings;
                    YoCompositeName candidateName = container[i];
                    String[] componentNames = YoCompositeTools.toComponentNames(componentIdentifiers, candidateName);
                    boolean isCompositeValid = Stream.of(componentNames).map(String::toLowerCase).allMatch(variableMap::containsKey);
                    if (!isCompositeValid) continue;
                    Object[] components = new YoVariable[componentNames.length];
                    for (int i2 = 0; i2 < componentNames.length; ++i2) {
                        String componentName = componentNames[i2];
                        String componentKey = componentName.toLowerCase();
                        List container3 = (List)variableMap.get(componentKey);
                        if (container3.size() != 1) {
                            throw new RuntimeException("Implement this edge case. Name collision: " + EuclidCoreIOTools.getCollectionString((String)"\n\t", (String)"", (String)"\n\t", (Collection)container3, Object::toString));
                        }
                        components[i2] = (YoVariable)((NamedObjectHolder)container3.get(0)).getOriginalObject();
                        variableMap.remove(componentKey);
                    }
                    if (namespace == null) {
                        namespace = YoCompositeTools.findCommonNamespace((YoVariable[])components);
                    }
                    if ((siblings = namespaceToYoCompositesMap.get(namespace)) != null && (homonym = siblings.stream().filter(sibling -> sibling.getName().equalsIgnoreCase(candidateName.getName())).findFirst()).isPresent()) {
                        LogTools.error((String)("Name collision in composites: pattern: " + String.valueOf(pattern) + ", name: " + candidateName.getName() + ", components:\n\t-composite 1:" + EuclidCoreIOTools.getArrayString((String)"[", (String)"]", (String)", ", (Object[])components, YoVariable::getName) + "\n\t-composite 2:" + EuclidCoreIOTools.getCollectionString((String)"[", (String)"]", (String)", ", homonym.get().getYoComponents(), YoVariable::getName)));
                        break;
                    }
                    YoComposite newComposite = new YoComposite(pattern, candidateName.getName(), namespace, Arrays.asList(components));
                    result.add(newComposite);
                    namespaceToYoCompositesMap.computeIfAbsent(namespace, k -> new ArrayList()).add(newComposite);
                    break;
                }
                if ((container = (List)variableMap.get(variableKey)) == null) continue;
                unresolvedCandidates.add((YoVariable)((NamedObjectHolder)container.remove(0)).getOriginalObject());
                if (!container.isEmpty()) continue;
                variableMap.remove(variableKey);
            }
        }
        return new Pair(result, unresolvedCandidates);
    }

    private static YoNamespace findCommonNamespace(YoVariable[] components) {
        if (components == null || components.length == 0) {
            return null;
        }
        if (components.length == 1) {
            return components[0].getNamespace();
        }
        List commonNamespace = components[0].getNamespace().getSubNames();
        block0: for (int i = 1; i < components.length; ++i) {
            List componentNamespace = components[i].getNamespace().getSubNames();
            for (int j = 0; j < commonNamespace.size(); ++j) {
                if (((String)commonNamespace.get(j)).equals(componentNamespace.get(j))) continue;
                commonNamespace.subList(0, j + 1);
                continue block0;
            }
        }
        return new YoNamespace(commonNamespace);
    }

    public static boolean areAllOfSameType(Object[] array) {
        if (array == null) {
            return false;
        }
        if (array.length == 1) {
            return true;
        }
        Object firstElement = array[0];
        for (int i = 1; i < array.length; ++i) {
            if (array[i].getClass() == firstElement.getClass()) continue;
            return false;
        }
        return true;
    }

    static boolean containsAnyIgnoreCase(CharSequence str, CharSequence ... searchStrs) {
        if (searchStrs == null) {
            return false;
        }
        return Stream.of(searchStrs).anyMatch(searchStr -> StringUtils.containsIgnoreCase((CharSequence)str, (CharSequence)searchStr));
    }

    static YoCompositeName[] fromComponentIdentifiers(String variableName, String[] identifiers) {
        if (identifiers == null || identifiers.length == 0) {
            return new YoCompositeName[0];
        }
        List<YoCompositeName> candidateNames = YoCompositeTools.fromComponentIdentifier(variableName, identifiers[0]);
        for (int i = 1; i < identifiers.length; ++i) {
            candidateNames.addAll(YoCompositeTools.fromComponentIdentifier(variableName, identifiers[i]));
        }
        return candidateNames.toArray(new YoCompositeName[candidateNames.size()]);
    }

    static List<YoCompositeName> fromComponentIdentifier(String variableName, String identifier) {
        int indexOfAxisName = StringUtils.indexOfIgnoreCase((CharSequence)variableName, (CharSequence)identifier);
        if (indexOfAxisName == -1) {
            return new ArrayList<YoCompositeName>();
        }
        ArrayList<YoCompositeName> candidateNames = new ArrayList<YoCompositeName>();
        while (indexOfAxisName >= 0) {
            String prefix = variableName.substring(0, indexOfAxisName);
            String suffix = indexOfAxisName + 1 < variableName.length() ? variableName.substring(indexOfAxisName + identifier.length(), variableName.length()) : "";
            candidateNames.add(new YoCompositeName(prefix, suffix));
            if (indexOfAxisName + 1 >= variableName.length()) break;
            indexOfAxisName = StringUtils.indexOfIgnoreCase((CharSequence)variableName, (CharSequence)identifier, (int)(indexOfAxisName + 1));
        }
        return candidateNames;
    }

    static String[] toComponentNames(String[] componentIdentifiers, YoCompositeName yoCompositeName) {
        if (componentIdentifiers == null || componentIdentifiers.length == 0) {
            return new String[0];
        }
        String[] componentNames = new String[componentIdentifiers.length];
        for (int i = 0; i < componentNames.length; ++i) {
            componentNames[i] = yoCompositeName.getPrefix() + componentIdentifiers[i] + yoCompositeName.getSuffix();
        }
        return componentNames;
    }

    public static <T> Map<T, String> computeUniqueNames(Collection<T> nameObjectCollection, Function<T, List<String>> namespaceFunction, Function<T, String> nameFunction) {
        ArrayList<NamedObjectHolder<T>> nameObjectHolderList = new ArrayList<NamedObjectHolder<T>>();
        LinkedHashMap nameToHolderMap = new LinkedHashMap();
        for (T t : nameObjectCollection) {
            String name = nameFunction.apply(t);
            ArrayList<NamedObjectHolder<T>> container = (ArrayList<NamedObjectHolder<T>>)nameToHolderMap.get(name.toLowerCase());
            if (container == null) {
                container = new ArrayList<NamedObjectHolder<T>>();
                nameToHolderMap.put(name.toLowerCase(), container);
            }
            NamedObjectHolder<T> namedObjectHolder = new NamedObjectHolder<T>(name, namespaceFunction.apply(t), t);
            container.add(namedObjectHolder);
            nameObjectHolderList.add(namedObjectHolder);
        }
        for (Map.Entry entry : nameToHolderMap.entrySet()) {
            ArrayList<NamedObjectHolder> homonyms = (ArrayList<NamedObjectHolder>)entry.getValue();
            if (homonyms.size() == 1) {
                ((NamedObjectHolder)homonyms.get((int)0)).uniqueName = ((NamedObjectHolder)homonyms.get((int)0)).name;
                continue;
            }
            if (homonyms.size() == 2) {
                NamedObjectHolder h1 = (NamedObjectHolder)homonyms.get(0);
                NamedObjectHolder h2 = (NamedObjectHolder)homonyms.get(1);
                List<String> namespace1 = h1.namespace;
                List<String> namespace2 = h2.namespace;
                if (Objects.equals(namespace1, namespace2)) {
                    throw new IllegalArgumentException("Unsupported data structure, two elements have the same fullname: " + String.valueOf(h1.originalObject) + " and " + String.valueOf(h2.originalObject));
                }
                if (namespace1 == null || namespace2 == null) continue;
                int namespaceIndex1 = namespace1.size() - 1;
                int namespaceIndex2 = namespace2.size() - 1;
                h1.uniqueName = h1.name;
                h2.uniqueName = h2.name;
                do {
                    if (namespaceIndex1 >= 0) {
                        h1.uniqueName = namespace1.get(namespaceIndex1) + "." + h1.uniqueName;
                        --namespaceIndex1;
                    }
                    if (namespaceIndex2 >= 0) {
                        h2.uniqueName = namespace2.get(namespaceIndex2) + "." + h2.uniqueName;
                        --namespaceIndex2;
                    }
                    if (namespaceIndex1 != 0 || namespaceIndex2 != 0 || !h1.uniqueName.equalsIgnoreCase(h2.uniqueName)) continue;
                    throw new IllegalArgumentException("Unsupported data structure, two elements have the same fullname: " + String.valueOf(h1.originalObject) + " and " + String.valueOf(h2.originalObject));
                } while (h1.uniqueName.equalsIgnoreCase(h2.uniqueName));
                continue;
            }
            TIntArrayList namespaceIndices = new TIntArrayList();
            for (NamedObjectHolder homonym : homonyms) {
                homonym.uniqueName = homonym.name;
                namespaceIndices.add(homonym.namespace.size() - 1);
            }
            do {
                int numberOfUnmodifiedUniqueNames = 0;
                for (int i = 0; i < homonyms.size(); ++i) {
                    NamedObjectHolder homonym = (NamedObjectHolder)homonyms.get(i);
                    int namespaceIndex = namespaceIndices.get(i);
                    if (namespaceIndex >= 0) {
                        homonym.uniqueName = homonym.namespace.get(namespaceIndex) + "." + homonym.uniqueName;
                        namespaceIndices.set(i, namespaceIndex - 1);
                        continue;
                    }
                    ++numberOfUnmodifiedUniqueNames;
                }
                if (numberOfUnmodifiedUniqueNames >= 2) {
                    throw new IllegalArgumentException("Cannot compute unique names for the homonyms: " + String.valueOf(homonyms));
                }
                ArrayList<NamedObjectHolder> homonymsToProcess = new ArrayList<NamedObjectHolder>();
                TIntArrayList namespaceIndexOfHomonymsToProcess = new TIntArrayList();
                int h1Index = 0;
                while (h1Index < homonyms.size()) {
                    boolean isH1Unique = true;
                    NamedObjectHolder h1 = (NamedObjectHolder)homonyms.get(h1Index);
                    int h2Index = h1Index + 1;
                    while (h2Index < homonyms.size()) {
                        NamedObjectHolder h2 = (NamedObjectHolder)homonyms.get(h2Index);
                        if (h1.uniqueName.equalsIgnoreCase(h2.uniqueName)) {
                            isH1Unique = false;
                            homonymsToProcess.add((NamedObjectHolder)homonyms.remove(h2Index));
                            namespaceIndexOfHomonymsToProcess.add(namespaceIndices.removeAt(h2Index));
                            continue;
                        }
                        ++h2Index;
                    }
                    if (!isH1Unique) {
                        homonymsToProcess.add((NamedObjectHolder)homonyms.remove(h1Index));
                        namespaceIndexOfHomonymsToProcess.add(namespaceIndices.removeAt(h1Index));
                        continue;
                    }
                    ++h1Index;
                }
                homonyms = homonymsToProcess;
                namespaceIndices = namespaceIndexOfHomonymsToProcess;
            } while (!homonyms.isEmpty());
        }
        return nameObjectHolderList.stream().collect(Collectors.toMap(NamedObjectHolder::getOriginalObject, NamedObjectHolder::getUniqueName));
    }

    public static <T> Map<T, String> computeUniqueShortNames(Collection<T> nameObjectCollection, Function<T, String> nameFunction, Function<T, String> uniqueNameFunction) {
        Map uniqueNameToNamedObjectMap = nameObjectCollection.stream().collect(Collectors.toMap(uniqueNameFunction, Function.identity()));
        HashMap<String, List> shortNameToUniqueNamesMap = new HashMap<String, List>();
        HashMap result = new HashMap();
        for (Map.Entry entry : uniqueNameToNamedObjectMap.entrySet()) {
            String uniqueName = entry.getKey();
            Object namedObject = entry.getValue();
            String name = nameFunction.apply(namedObject);
            shortNameToUniqueNamesMap.computeIfAbsent(name, k -> new ArrayList()).add(uniqueName);
        }
        for (Map.Entry<String, Object> entry : shortNameToUniqueNamesMap.entrySet()) {
            List uniqueNames = (List)entry.getValue();
            String shortName = entry.getKey();
            ArrayList<String> uniqueShortNames = new ArrayList<String>();
            boolean isNaiveApproachSuccessful = true;
            for (String uniqueName : uniqueNames) {
                int lastSeparatorIndex;
                int firstSeparatorIndex = uniqueName.indexOf(".");
                Object uniqueShortName = firstSeparatorIndex != (lastSeparatorIndex = uniqueName.lastIndexOf(".")) ? uniqueName.substring(0, firstSeparatorIndex) + "..." + uniqueName.substring(lastSeparatorIndex + 1) : uniqueName;
                if (uniqueShortNames.contains(uniqueShortName)) {
                    isNaiveApproachSuccessful = false;
                    break;
                }
                uniqueShortNames.add((String)uniqueShortName);
            }
            if (isNaiveApproachSuccessful) {
                for (int i = 0; i < uniqueNames.size(); ++i) {
                    result.put(uniqueNameToNamedObjectMap.get(uniqueNames.get(i)), (String)uniqueShortNames.get(i));
                }
                continue;
            }
            for (String uniqueName : uniqueNames) {
                result.put(uniqueNameToNamedObjectMap.get(uniqueName), uniqueName);
            }
        }
        return result;
    }

    public static List<YoCompositePattern> toYoCompositePatterns(YoCompositePatternListDefinition definition) {
        if (definition.getYoCompositePatterns() == null) {
            return Collections.emptyList();
        }
        return definition.getYoCompositePatterns().stream().map(YoCompositeTools::toYoCompositePattern).collect(Collectors.toList());
    }

    public static YoCompositePattern toYoCompositePattern(YoCompositePatternDefinition definition) {
        String type = definition.getName();
        boolean crossRegistry = definition.isCrossRegistry();
        String[] componentIdentifiers = definition.getIdentifiers();
        List alternateIdentifiers = definition.getAlternateIdentifiers();
        List<ChartGroupModel> preferredChartConfigurations = definition.getPreferredConfigurations().stream().map(ChartTools::toChartIdentifierList).collect(Collectors.toList());
        return new YoCompositePattern(type, crossRegistry, componentIdentifiers, alternateIdentifiers, preferredChartConfigurations);
    }

    public static YoCompositePatternListDefinition toYoCompositePatternListDefinition(List<YoCompositePattern> yoCompositePatterns) {
        YoCompositePatternListDefinition definition = new YoCompositePatternListDefinition();
        definition.setYoCompositePatterns(yoCompositePatterns.stream().map(YoCompositeTools::toYoCompositePatternDefinition).collect(Collectors.toList()));
        return definition;
    }

    public static List<YoCompositePatternDefinition> toYoCompositePatternDefinitions(Collection<? extends YoCompositePattern> yoCompositePatterns) {
        return yoCompositePatterns.stream().map(YoCompositeTools::toYoCompositePatternDefinition).collect(Collectors.toList());
    }

    public static YoCompositePatternDefinition toYoCompositePatternDefinition(YoCompositePattern yoCompositePattern) {
        YoCompositePatternDefinition definition = new YoCompositePatternDefinition();
        definition.setName(yoCompositePattern.getType());
        definition.setCrossRegistry(yoCompositePattern.isCrossRegistry());
        if (yoCompositePattern.getComponentIdentifiers() != null) {
            definition.setIdentifiers(yoCompositePattern.getComponentIdentifiers());
        }
        definition.setPreferredConfigurations(ChartTools.toYoChartGroupModelDefinitions(yoCompositePattern.getPreferredChartConfigurations()));
        return definition;
    }

    private static class NamedObjectHolder<T> {
        private String name;
        private String uniqueName;
        private List<String> namespace;
        private T originalObject;

        public static NamedObjectHolder<YoVariable> newUniqueNamedYoVariable(String uniqueName, YoVariable yoVariable) {
            NamedObjectHolder<YoVariable> namedObjectHolder = new NamedObjectHolder<YoVariable>(yoVariable.getName(), yoVariable.getNamespace().getSubNames(), yoVariable);
            namedObjectHolder.uniqueName = uniqueName;
            return namedObjectHolder;
        }

        public NamedObjectHolder(String name, List<String> namespace, T originalObject) {
            this.name = name;
            this.namespace = namespace;
            this.originalObject = originalObject;
        }

        public String getUniqueName() {
            return this.uniqueName;
        }

        public T getOriginalObject() {
            return this.originalObject;
        }

        public String toString() {
            return this.name + ", unique name: " + this.uniqueName + ", namespace: " + String.valueOf(this.namespace);
        }
    }
}

