/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.scs2.sessionVisualizer.jfx.session.log;

import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import javafx.scene.image.Image;
import javafx.scene.image.PixelReader;
import javafx.scene.image.PixelWriter;
import javafx.scene.image.WritableImage;
import org.bytedeco.javacv.Frame;
import org.bytedeco.javacv.JavaFXFrameConverter;
import us.ihmc.robotDataLogger.Camera;
import us.ihmc.robotDataLogger.logger.MagewellDemuxer;
import us.ihmc.robotDataLogger.logger.MagewellMuxer;
import us.ihmc.scs2.session.log.ProgressConsumer;
import us.ihmc.scs2.sessionVisualizer.jfx.session.log.FrameData;
import us.ihmc.scs2.sessionVisualizer.jfx.session.log.TimestampScrubber;
import us.ihmc.scs2.sessionVisualizer.jfx.session.log.VideoDataReader;
import us.ihmc.tools.CaptureTimeTools;

public class MagewellVideoDataReader
implements VideoDataReader {
    private final TimestampScrubber timestampScrubber;
    private final String name;
    private final MagewellDemuxer magewellDemuxer;
    private final Camera camera;
    private final FrameData frameData = new FrameData();

    public MagewellVideoDataReader(Camera camera, File dataDirectory, boolean hasTimeBase) throws IOException {
        File videoFile;
        this.camera = camera;
        this.name = camera.getNameAsString();
        boolean interlaced = camera.getInterlaced();
        if (!hasTimeBase) {
            System.err.println("Video data is using timestamps instead of frame numbers. Falling back to seeking based on timestamp.");
        }
        if (!(videoFile = new File(dataDirectory, camera.getVideoFileAsString())).exists()) {
            throw new IOException("Cannot find video: " + String.valueOf(videoFile));
        }
        this.magewellDemuxer = new MagewellDemuxer(videoFile);
        File timestampFile = new File(dataDirectory, camera.getTimestampFileAsString());
        this.timestampScrubber = new TimestampScrubber(timestampFile, hasTimeBase, interlaced);
    }

    @Override
    public int getImageHeight() {
        return this.magewellDemuxer.getImageHeight();
    }

    @Override
    public int getImageWidth() {
        return this.magewellDemuxer.getImageWidth();
    }

    @Override
    public void readVideoFrame(long queryRobotTimestamp) {
        long currentVideoTimestamps = this.timestampScrubber.getVideoTimestampFromRobotTimestamp(queryRobotTimestamp);
        long currentRobotTimestamp = this.timestampScrubber.getCurrentRobotTimestamp();
        this.magewellDemuxer.seekToPTS(currentVideoTimestamps);
        FrameData copyForWriting = this.frameData;
        copyForWriting.queryRobotTimestamp = queryRobotTimestamp;
        copyForWriting.currentRobotTimestamp = currentRobotTimestamp;
        copyForWriting.currentVideoTimestamp = currentVideoTimestamps;
        copyForWriting.currentDemuxerTimestamp = this.magewellDemuxer.getCurrentPTS();
        Frame nextFrame = this.magewellDemuxer.getNextFrame();
        this.frameData.frame = this.convertFrameToWritableImage(nextFrame);
    }

    public WritableImage convertFrameToWritableImage(Frame frameToConvert) {
        Image currentImage;
        if (frameToConvert == null) {
            return null;
        }
        try (JavaFXFrameConverter frameConverter = new JavaFXFrameConverter();){
            currentImage = frameConverter.convert(frameToConvert);
        }
        WritableImage writableImage = new WritableImage((int)currentImage.getWidth(), (int)currentImage.getHeight());
        PixelReader pixelReader = currentImage.getPixelReader();
        PixelWriter pixelWriter = writableImage.getPixelWriter();
        int y = 0;
        while ((double)y < currentImage.getHeight()) {
            int x = 0;
            while ((double)x < currentImage.getWidth()) {
                pixelWriter.setArgb(x, y, pixelReader.getArgb(x, y));
                ++x;
            }
            ++y;
        }
        return writableImage;
    }

    public Frame getFrame() {
        return this.magewellDemuxer.getNextFrame();
    }

    @Override
    public void cropVideo(File outputFile, File timestampFile, long startTimestamp, long endTimestamp, ProgressConsumer progressConsumer) throws IOException {
        Frame frame;
        long startVideoTimestamp = this.timestampScrubber.getVideoTimestampFromRobotTimestamp(startTimestamp);
        long endVideoTimestamp = this.timestampScrubber.getVideoTimestampFromRobotTimestamp(endTimestamp);
        long[] robotTimestampsForCroppedLog = this.timestampScrubber.getCroppedRobotTimestamps(startTimestamp, endTimestamp);
        long[] videoTimestampsForCroppedLog = new long[robotTimestampsForCroppedLog.length];
        int i = 0;
        long startFrame = MagewellVideoDataReader.getFrameAtTimestamp(startVideoTimestamp, this.magewellDemuxer);
        long endFrame = MagewellVideoDataReader.getFrameAtTimestamp(endVideoTimestamp, this.magewellDemuxer);
        long numberOfFrames = endFrame - startFrame;
        int frameRate = (int)this.magewellDemuxer.getFrameRate();
        this.magewellDemuxer.seekToPTS(startVideoTimestamp);
        PrintWriter timestampWriter = new PrintWriter(timestampFile);
        timestampWriter.println("1\n" + frameRate);
        long startTime = System.currentTimeMillis();
        MagewellMuxer magewellMuxer = new MagewellMuxer(outputFile, this.magewellDemuxer.getImageWidth(), this.magewellDemuxer.getImageHeight());
        magewellMuxer.start();
        while ((frame = this.magewellDemuxer.getNextFrame()) != null && (long)this.magewellDemuxer.getFrameNumber() <= endFrame) {
            long videoTimestamp = CaptureTimeTools.timeSinceStartedCaptureInSeconds((long)System.currentTimeMillis(), (long)startTime);
            magewellMuxer.recordFrame(frame, videoTimestamp);
            videoTimestampsForCroppedLog[i] = magewellMuxer.getTimeStamp();
            ++i;
            if (progressConsumer == null) continue;
            progressConsumer.info("frame %d/%d".formatted((long)this.magewellDemuxer.getFrameNumber() - startFrame, numberOfFrames));
            progressConsumer.progress((double)((long)this.magewellDemuxer.getFrameNumber() - startFrame) / (double)numberOfFrames);
        }
        for (i = 0; i < videoTimestampsForCroppedLog.length; ++i) {
            timestampWriter.print(robotTimestampsForCroppedLog[i]);
            timestampWriter.print(" ");
            timestampWriter.println(videoTimestampsForCroppedLog[i]);
        }
        magewellMuxer.close();
        timestampWriter.close();
    }

    private static long getFrameAtTimestamp(long endCameraTimestamp, MagewellDemuxer magewellDemuxer) {
        magewellDemuxer.seekToPTS(endCameraTimestamp);
        return magewellDemuxer.getFrameNumber();
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public Camera getCamera() {
        return this.camera;
    }

    @Override
    public FrameData pollCurrentFrame() {
        return this.frameData;
    }

    @Override
    public int getCurrentIndex() {
        return this.timestampScrubber.getCurrentIndex();
    }

    @Override
    public boolean replacedRobotTimestampsContainsIndex(int index) {
        return this.timestampScrubber.getReplacedRobotTimestampIndex(index);
    }
}

