/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.scs2.sessionVisualizer.jfx.plotter;

import javafx.animation.AnimationTimer;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.Property;
import javafx.beans.property.ReadOnlyObjectProperty;
import javafx.beans.property.SimpleDoubleProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.collections.ListChangeListener;
import javafx.collections.ObservableMap;
import javafx.event.EventHandler;
import javafx.scene.Group;
import javafx.scene.Node;
import javafx.scene.control.Tooltip;
import javafx.scene.input.MouseButton;
import javafx.scene.input.MouseEvent;
import javafx.scene.input.ScrollEvent;
import javafx.scene.layout.Region;
import javafx.scene.transform.Scale;
import javafx.scene.transform.Transform;
import javafx.scene.transform.Translate;
import javafx.util.Duration;
import us.ihmc.euclid.tuple2D.Point2D;
import us.ihmc.euclid.tuple2D.Vector2D;
import us.ihmc.euclid.tuple2D.interfaces.Tuple2DReadOnly;
import us.ihmc.scs2.sessionVisualizer.jfx.plotter.PlotterGrid2D;
import us.ihmc.scs2.sessionVisualizer.jfx.tools.JavaFXMissingTools;
import us.ihmc.scs2.sessionVisualizer.jfx.tools.JavaFXToEuclidConversions;
import us.ihmc.scs2.sessionVisualizer.jfx.yoComposite.Tuple2DProperty;
import us.ihmc.scs2.sessionVisualizer.jfx.yoGraphic.YoGraphicFXItem;
import us.ihmc.scs2.sessionVisualizer.jfx.yoGraphic.YoGroupFX;
import us.ihmc.scs2.sessionVisualizer.jfx.yoGraphic.YoLineFX2D;
import us.ihmc.scs2.sessionVisualizer.jfx.yoGraphic.YoPolygonFX2D;

public class Plotter2D
extends Region {
    private final Group root = new Group();
    private final PlotterGrid2D grid2D = new PlotterGrid2D((ReadOnlyObjectProperty<Transform>)this.root.localToSceneTransformProperty());
    private final Translate rootTranslation = new Translate();
    private final Translate trackingTranslation = new Translate();
    private final ObjectProperty<MouseButton> mouseButtonForTranslation = new SimpleObjectProperty((Object)this, "mouseButtonForTranslation", (Object)MouseButton.PRIMARY);
    private final Scale rootScale = new Scale(1.0, -1.0);
    private final DoubleProperty scaleModifier = new SimpleDoubleProperty((Object)this, "scaleModifier", -0.0025);
    private final DoubleProperty minScale = new SimpleDoubleProperty((Object)this, "minScale", 0.01);
    private final Point2D center = new Point2D();
    private final Property<Tuple2DProperty> coordinateToTrack = new SimpleObjectProperty((Object)this, "coordinateToTrackProperty", null);
    private final AnimationTimer trackingAnimation = new AnimationTimer(){
        private boolean initialized = false;

        public void start() {
            this.initialized = false;
            super.start();
        }

        public void handle(long now) {
            Tuple2DProperty coordinateProperty = (Tuple2DProperty)Plotter2D.this.coordinateToTrack.getValue();
            if (coordinateProperty == null) {
                this.stop();
                return;
            }
            Point2D coordinateInWorld = coordinateProperty.toPoint2DInWorld();
            if (coordinateInWorld.containsNaN()) {
                return;
            }
            if (!this.initialized) {
                Plotter2D.this.rootTranslation.setX(0.5 * Plotter2D.this.contentWidth());
                Plotter2D.this.rootTranslation.setY(0.5 * Plotter2D.this.contentHeight());
                Plotter2D.this.trackingTranslation.setX(-coordinateInWorld.getX());
                Plotter2D.this.trackingTranslation.setY(-coordinateInWorld.getY());
                Plotter2D.this.center.set(coordinateInWorld);
                this.initialized = true;
            } else {
                Plotter2D.this.trackingTranslation.setX(-coordinateInWorld.getX());
                Plotter2D.this.trackingTranslation.setY(-coordinateInWorld.getY());
                Plotter2D.this.center.set(Plotter2D.this.computeCenterLocal());
            }
        }
    };
    private final ObjectProperty<Tooltip> activeTooltip = new SimpleObjectProperty((Object)this, "activeTooltipProperty", null);

    public Plotter2D() {
        this.getChildren().add((Object)this.grid2D.getRoot());
        this.getChildren().add((Object)this.root);
        this.root.getTransforms().addAll((Object[])new Transform[]{this.rootTranslation, this.rootScale, this.trackingTranslation});
        this.addEventHandler(MouseEvent.ANY, this.createTranslationEventHandler());
        this.addEventHandler(ScrollEvent.ANY, this.createScaleEventHandler());
        this.requestParentLayout();
        this.setManaged(false);
        this.coordinateToTrack.addListener((o, oldValue, newValue) -> {
            this.trackingAnimation.stop();
            if (oldValue != null) {
                this.trackingTranslation.setX(0.0);
                this.trackingTranslation.setY(0.0);
            }
            if (newValue != null) {
                this.trackingAnimation.start();
            }
        });
        this.root.getChildren().addListener((ListChangeListener)new GroupTooltipHandler());
        this.activeTooltip.addListener((o, oldValue, newValue) -> {
            if (oldValue != null) {
                oldValue.hide();
            }
        });
    }

    public Property<Tuple2DProperty> coordinateToTrackProperty() {
        return this.coordinateToTrack;
    }

    public void setScale(double scale) {
        this.rootScale.setX(scale);
        this.rootScale.setY(-scale);
    }

    public void setFieldOfView(double centerX, double centerY, double rangeX, double rangeY) {
        this.setFieldOfView(centerX, centerY, rangeX, rangeY, true);
    }

    public void setFieldOfView(double centerX, double centerY, double rangeX, double rangeY, boolean axisEquals) {
        double contentWidth = this.contentWidth();
        double contentHeight = this.contentHeight();
        double scaleX = contentWidth / rangeX;
        double scaleY = contentHeight / rangeY;
        if (axisEquals) {
            double scale;
            scaleX = scale = Math.min(scaleX, scaleY);
            scaleY = scale;
        }
        this.rootScale.setX(scaleX);
        this.rootScale.setY(-scaleY);
        this.rootTranslation.setX(0.5 * contentWidth - centerX * this.rootScale.getX());
        this.rootTranslation.setY(0.5 * contentHeight - centerY * this.rootScale.getY());
        this.activeTooltip.set(null);
    }

    public EventHandler<MouseEvent> createTranslationEventHandler() {
        return new EventHandler<MouseEvent>(){
            Point2D oldMouseLocation;

            public void handle(MouseEvent event) {
                if (event.getButton() != Plotter2D.this.mouseButtonForTranslation.get() || event.isStillSincePress()) {
                    return;
                }
                if (event.getEventType() == MouseEvent.MOUSE_PRESSED) {
                    this.oldMouseLocation = Plotter2D.this.getMouseSceneLocation(event);
                    return;
                }
                if (event.getEventType() != MouseEvent.MOUSE_DRAGGED) {
                    return;
                }
                Point2D newMouseLocation = Plotter2D.this.getMouseSceneLocation(event);
                if (this.oldMouseLocation != null) {
                    Vector2D drag = new Vector2D();
                    drag.sub((Tuple2DReadOnly)newMouseLocation, (Tuple2DReadOnly)this.oldMouseLocation);
                    JavaFXMissingTools.addEquals(Plotter2D.this.rootTranslation, (Tuple2DReadOnly)drag);
                    Plotter2D.this.center.set(Plotter2D.this.computeCenterLocal());
                    Plotter2D.this.updateGrid();
                }
                this.oldMouseLocation = newMouseLocation;
                Plotter2D.this.activeTooltip.set(null);
            }
        };
    }

    private Point2D getMouseSceneLocation(MouseEvent event) {
        if (Double.isNaN(event.getX()) || Double.isNaN(event.getY())) {
            javafx.geometry.Point2D local = this.root.screenToLocal(event.getScreenX(), event.getScreenY());
            javafx.geometry.Point2D scene = this.root.localToScene(local);
            return new Point2D(scene.getX(), scene.getY());
        }
        return new Point2D(event.getX(), event.getY());
    }

    public EventHandler<ScrollEvent> createScaleEventHandler() {
        return new EventHandler<ScrollEvent>(){

            public void handle(ScrollEvent event) {
                javafx.geometry.Point2D postScaleLocation;
                javafx.geometry.Point2D preScaleLocation;
                double verticalDrag = event.getDeltaY();
                double oldScale = Plotter2D.this.rootScale.getX();
                double newScale = oldScale * (1.0 - Plotter2D.this.scaleModifier.get() * verticalDrag);
                newScale = Math.max(Plotter2D.this.minScale.get(), newScale);
                double trackedLocationX = event.getX();
                double trackedLocationY = event.getY();
                if (Double.isNaN(trackedLocationX) || Double.isNaN(trackedLocationY)) {
                    trackedLocationX = event.getScreenX();
                    trackedLocationY = event.getScreenY();
                    preScaleLocation = Plotter2D.this.root.screenToLocal(trackedLocationX, trackedLocationY);
                    Plotter2D.this.rootScale.setX(newScale);
                    Plotter2D.this.rootScale.setY(-newScale);
                    postScaleLocation = Plotter2D.this.root.screenToLocal(trackedLocationX, trackedLocationY);
                } else {
                    preScaleLocation = Plotter2D.this.root.sceneToLocal(trackedLocationX, trackedLocationY);
                    Plotter2D.this.rootScale.setX(newScale);
                    Plotter2D.this.rootScale.setY(-newScale);
                    postScaleLocation = Plotter2D.this.root.sceneToLocal(trackedLocationX, trackedLocationY);
                }
                Plotter2D.this.rootTranslation.setX(Plotter2D.this.rootTranslation.getX() + Plotter2D.this.rootScale.getX() * (postScaleLocation.getX() - preScaleLocation.getX()));
                Plotter2D.this.rootTranslation.setY(Plotter2D.this.rootTranslation.getY() + Plotter2D.this.rootScale.getY() * (postScaleLocation.getY() - preScaleLocation.getY()));
                Plotter2D.this.activeTooltip.set(null);
                Plotter2D.this.center.set(Plotter2D.this.computeCenterLocal());
                Plotter2D.this.updateGrid();
            }
        };
    }

    private Point2D computeCenterLocal() {
        return JavaFXToEuclidConversions.convertPoint2D(this.root.sceneToLocal(0.5 * this.contentWidth(), 0.5 * this.contentHeight()));
    }

    public void updateGrid() {
        this.grid2D.update(this.snappedTopInset(), this.snappedLeftInset(), this.contentWidth(), this.contentHeight());
    }

    private double contentWidth() {
        return this.getWidth() - (this.snappedLeftInset() + this.snappedRightInset());
    }

    private double contentHeight() {
        return this.getHeight() - (this.snappedTopInset() + this.snappedBottomInset());
    }

    protected void layoutChildren() {
        this.recenter();
        this.updateGrid();
    }

    private void recenter() {
        Vector2D translation = new Vector2D();
        translation.sub((Tuple2DReadOnly)this.computeCenterLocal(), (Tuple2DReadOnly)this.center);
        translation.scale(this.rootScale.getX(), this.rootScale.getY());
        JavaFXMissingTools.addEquals(this.rootTranslation, (Tuple2DReadOnly)translation);
    }

    public ObjectProperty<MouseButton> mouseButtonForTranslationProperty() {
        return this.mouseButtonForTranslation;
    }

    public Group getRoot() {
        return this.root;
    }

    public PlotterGrid2D getGrid2D() {
        return this.grid2D;
    }

    private class GroupTooltipHandler
    implements ListChangeListener<Node> {
        private static final String TOOLTIP_LISTENER_PROPERTY_KEY = GroupTooltipHandler.class.getName() + " - TooltipListener";
        private final ObservableMap<Node, Tooltip> installedTooltips = FXCollections.observableHashMap();

        private GroupTooltipHandler() {
        }

        public void onChanged(ListChangeListener.Change<? extends Node> change) {
            while (change.next()) {
                for (Node node : change.getAddedSubList()) {
                    this.installTooltip(node);
                }
                for (Node node : change.getRemoved()) {
                    Tooltip tooltip = (Tooltip)this.installedTooltips.remove((Object)node);
                    if (tooltip == null) {
                        if (!(node instanceof Group)) continue;
                        ((Group)node).getChildren().removeListener((ListChangeListener)this);
                        continue;
                    }
                    tooltip.textProperty().unbind();
                    Tooltip.uninstall((Node)node, (Tooltip)tooltip);
                }
            }
        }

        public void installTooltip(Node node) {
            YoGraphicFXItem yoGraphicFX = (YoGraphicFXItem)node.getProperties().get((Object)YoGraphicFXItem.YO_GRAPHICFX_ITEM_KEY);
            if (yoGraphicFX == null || yoGraphicFX instanceof YoGroupFX) {
                if (node instanceof Group) {
                    Group group = (Group)node;
                    this.installTooltipsToDescendants(group);
                }
            } else {
                Tooltip tooltip = new Tooltip(node.getId());
                tooltip.setShowDelay(Duration.millis((double)200.0));
                tooltip.setShowDuration(Duration.seconds((double)20.0));
                tooltip.textProperty().bind((ObservableValue)node.idProperty());
                ChangeListener listener = (o, oldValue, newValue) -> {
                    if (newValue.booleanValue()) {
                        Plotter2D.this.activeTooltip.set((Object)tooltip);
                    }
                };
                tooltip.getProperties().put((Object)TOOLTIP_LISTENER_PROPERTY_KEY, (Object)listener);
                tooltip.showingProperty().addListener(listener);
                ChangeListener tooltipShowingListener = (o, oldValue, newValue) -> {
                    if (newValue.booleanValue()) {
                        Plotter2D.this.activeTooltip.set((Object)tooltip);
                    }
                };
                tooltip.showingProperty().addListener(tooltipShowingListener);
                if (!(yoGraphicFX instanceof YoPolygonFX2D) && !(yoGraphicFX instanceof YoLineFX2D)) {
                    node.setPickOnBounds(true);
                }
                this.installedTooltips.put((Object)node, (Object)tooltip);
                Tooltip.install((Node)node, (Tooltip)tooltip);
            }
        }

        public void installTooltipsToDescendants(Group group) {
            for (Node child : group.getChildren()) {
                this.installTooltip(child);
            }
            group.getChildren().addListener((ListChangeListener)this);
        }

        public void uninstallTooltip(Node node) {
            Tooltip tooltip = (Tooltip)this.installedTooltips.remove((Object)node);
            if (tooltip == null) {
                if (node instanceof Group) {
                    Group group = (Group)node;
                    this.uninstallTooltipsFromDescendants(group);
                }
            } else {
                tooltip.textProperty().unbind();
                ChangeListener listener = (ChangeListener)tooltip.getProperties().remove((Object)TOOLTIP_LISTENER_PROPERTY_KEY);
                tooltip.showingProperty().removeListener(listener);
                Tooltip.uninstall((Node)node, (Tooltip)tooltip);
            }
        }

        public void uninstallTooltipsFromDescendants(Group group) {
            group.getChildren().removeListener((ListChangeListener)this);
            for (Node child : group.getChildren()) {
                this.uninstallTooltip(child);
            }
        }
    }
}

