/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.scs2.sessionVisualizer.jfx;

import com.jfoenix.controls.JFXDrawer;
import com.jfoenix.controls.JFXHamburger;
import com.jfoenix.controls.events.JFXDrawerEvent;
import java.io.File;
import java.io.IOException;
import java.util.concurrent.TimeUnit;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.Property;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.value.ObservableBooleanValue;
import javafx.beans.value.ObservableValue;
import javafx.event.Event;
import javafx.fxml.FXML;
import javafx.fxml.FXMLLoader;
import javafx.scene.Cursor;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.SubScene;
import javafx.scene.control.Label;
import javafx.scene.control.SplitPane;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyEvent;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.AnchorPane;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Pane;
import javafx.scene.layout.Priority;
import javafx.scene.layout.StackPane;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.stage.Window;
import org.apache.commons.lang3.mutable.MutableBoolean;
import us.ihmc.commons.Conversions;
import us.ihmc.messager.javafx.JavaFXMessager;
import us.ihmc.scs2.definition.yoComposite.YoCompositeDefinition;
import us.ihmc.scs2.sessionVisualizer.jfx.HamburgerAnimationTransition;
import us.ihmc.scs2.sessionVisualizer.jfx.SessionVisualizerIOTools;
import us.ihmc.scs2.sessionVisualizer.jfx.SessionVisualizerTopics;
import us.ihmc.scs2.sessionVisualizer.jfx.SidePaneController;
import us.ihmc.scs2.sessionVisualizer.jfx.UserSidePaneController;
import us.ihmc.scs2.sessionVisualizer.jfx.YoNameDisplay;
import us.ihmc.scs2.sessionVisualizer.jfx.controllers.SessionAdvancedControlsController;
import us.ihmc.scs2.sessionVisualizer.jfx.controllers.SessionSimpleControlsController;
import us.ihmc.scs2.sessionVisualizer.jfx.controllers.VisualizerController;
import us.ihmc.scs2.sessionVisualizer.jfx.controllers.chart.YoChartGroupPanelController;
import us.ihmc.scs2.sessionVisualizer.jfx.controllers.menu.MainWindowMenuBarController;
import us.ihmc.scs2.sessionVisualizer.jfx.managers.ReferenceFrameManager;
import us.ihmc.scs2.sessionVisualizer.jfx.managers.SessionVisualizerToolkit;
import us.ihmc.scs2.sessionVisualizer.jfx.managers.SessionVisualizerWindowToolkit;
import us.ihmc.scs2.sessionVisualizer.jfx.plotter.Plotter2D;
import us.ihmc.scs2.sessionVisualizer.jfx.tools.CompositePropertyTools;
import us.ihmc.scs2.sessionVisualizer.jfx.tools.JavaFXMissingTools;
import us.ihmc.scs2.sessionVisualizer.jfx.tools.ObservedAnimationTimer;
import us.ihmc.scs2.sessionVisualizer.jfx.tools.YoVariableDatabase;

public class MainWindowController
extends ObservedAnimationTimer
implements VisualizerController {
    @FXML
    private AnchorPane rootPane;
    @FXML
    private SplitPane mainGUIPane;
    @FXML
    private AnchorPane sceneAnchorPane;
    @FXML
    private SplitPane mainViewSplitPane;
    @FXML
    private JFXHamburger leftDrawerBurger;
    @FXML
    private JFXHamburger rightDrawerBurger;
    @FXML
    private Label fpsLabel;
    @FXML
    private MainWindowMenuBarController mainWindowMenuBarController;
    @FXML
    private SessionSimpleControlsController sessionSimpleControlsController;
    @FXML
    private SessionAdvancedControlsController sessionAdvancedControlsController;
    @FXML
    private YoChartGroupPanelController yoChartGroupPanelController;
    private final JFXDrawer leftDrawer = new JFXDrawer();
    private final JFXDrawer rightDrawer = new JFXDrawer();
    private final BooleanProperty leftDrawerOpen = new SimpleBooleanProperty((Object)this, "leftDrawerOpenProperty", false);
    private final BooleanProperty rightDrawerOpen = new SimpleBooleanProperty((Object)this, "rightDrawerOpenProperty", false);
    private final BooleanProperty disableUserControls = new SimpleBooleanProperty((Object)this, "disableUserControlsProperty", false);
    private final Property<YoNameDisplay> yoNameDisplayProperty = new SimpleObjectProperty((Object)this, "yoNameDisplayProperty", (Object)YoNameDisplay.UNIQUE_SHORT_NAME);
    private SidePaneController sidePaneController;
    private UserSidePaneController userSidePaneController;
    private final Plotter2D plotter2D = new Plotter2D();
    private SessionVisualizerToolkit globalToolkit;
    private SessionVisualizerWindowToolkit windowToolkit;
    private SessionVisualizerTopics topics;
    private JavaFXMessager messager;
    private Property<Boolean> showOverheadPlotterProperty;
    private long timeLast = -1L;
    private long timeIntervalBetweenUpdates = TimeUnit.MILLISECONDS.toNanos(500L);
    private int frameCounter = 0;
    private double goodFPSLowerThreshold = 40.0;
    private double mediumFPSLowerThreshold = 20.0;
    private Color goodFPSColor = Color.FORESTGREEN;
    private Color mediumFPSColor = Color.DARKORANGE;
    private Color poorFPSColor = Color.RED;

    @Override
    public void initialize(SessionVisualizerWindowToolkit toolkit) {
        FXMLLoader loader;
        this.windowToolkit = toolkit;
        this.globalToolkit = toolkit.getGlobalToolkit();
        this.topics = toolkit.getTopics();
        this.messager = toolkit.getMessager();
        this.messager.addFXTopicListener(this.topics.getDisableUserControls(), m -> this.disableUserControls.set(m.booleanValue()));
        this.messager.bindBidirectional(this.topics.getYoVariableNameDisplay(), this.yoNameDisplayProperty, true);
        this.mainWindowMenuBarController.initialize(this.windowToolkit);
        this.sessionSimpleControlsController.initialize(this.windowToolkit);
        this.sessionAdvancedControlsController.initialize(this.windowToolkit);
        this.sessionSimpleControlsController.show(false);
        this.sessionAdvancedControlsController.showProperty().set(true);
        this.yoChartGroupPanelController.initialize(this.windowToolkit);
        this.rootPane.getChildren().set(1, (Object)this.leftDrawer);
        JavaFXMissingTools.setAnchorConstraints((Node)this.leftDrawer, 25.0, 0.0, 0.0, 0.0);
        this.leftDrawer.getChildren().add((Object)this.rightDrawer);
        this.leftDrawer.setDefaultDrawerSize(300.0);
        this.leftDrawer.setDirection(JFXDrawer.DrawerDirection.LEFT);
        this.rightDrawer.getChildren().add((Object)this.mainGUIPane);
        this.rightDrawer.setDirection(JFXDrawer.DrawerDirection.RIGHT);
        this.rightDrawer.setDefaultDrawerSize(300.0);
        try {
            loader = new FXMLLoader(SessionVisualizerIOTools.SIDE_PANE_URL);
            this.setupLeftDrawer((Pane)loader.load());
            this.sidePaneController = (SidePaneController)loader.getController();
            this.sidePaneController.initialize(toolkit.getGlobalToolkit());
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        try {
            loader = new FXMLLoader(SessionVisualizerIOTools.USER_SIDE_PANE_URL);
            this.setupRightDrawer((Pane)loader.load());
            this.userSidePaneController = (UserSidePaneController)loader.getController();
            this.userSidePaneController.initialize(toolkit);
            this.userSidePaneController.computedPrefWidthProperty().addListener((o, oldValue, newValue) -> this.rightDrawer.setDefaultDrawerSize(newValue.doubleValue()));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        this.setupViewport3D(toolkit.getGlobalToolkit().getViewport3DManager().getPane());
        this.setupPlotter2D(this.plotter2D);
        this.messager.addFXTopicListener(this.topics.getPlotter2DTrackCoordinateRequest(), m -> {
            YoVariableDatabase rootRegistryDatabase = toolkit.getYoManager().getRootRegistryDatabase();
            ReferenceFrameManager referenceFrameManager = toolkit.getReferenceFrameManager();
            this.plotter2D.coordinateToTrackProperty().setValue((Object)CompositePropertyTools.toTuple2DProperty(rootRegistryDatabase, referenceFrameManager, (YoCompositeDefinition)m));
        });
        this.messager.addFXTopicListener(this.topics.getYoChartGroupLoadConfiguration(), m -> this.yoChartGroupPanelController.loadChartGroupConfiguration((Window)m.getKey(), (File)m.getValue()));
        this.messager.addFXTopicListener(this.topics.getYoChartGroupSaveConfiguration(), m -> this.yoChartGroupPanelController.saveChartGroupConfiguration((Window)m.getKey(), (File)m.getValue()));
    }

    public void setupViewport3D(Pane viewportPane) {
        this.sceneAnchorPane.getChildren().set(0, (Object)viewportPane);
        AnchorPane.setTopAnchor((Node)viewportPane, (Double)0.0);
        AnchorPane.setRightAnchor((Node)viewportPane, (Double)0.0);
        AnchorPane.setBottomAnchor((Node)viewportPane, (Double)0.0);
        AnchorPane.setLeftAnchor((Node)viewportPane, (Double)0.0);
        this.globalToolkit.getSnapshotManager().registerRecordable(viewportPane);
    }

    public Property<Boolean> setupPlotter2D(Plotter2D plotter2D) {
        SubScene plotter2DScene = new SubScene((Parent)plotter2D, 100.0, 10.0);
        Pane pane = new Pane(new Node[]{plotter2DScene});
        plotter2DScene.heightProperty().bind((ObservableValue)pane.heightProperty());
        plotter2DScene.widthProperty().bind((ObservableValue)pane.widthProperty());
        plotter2D.getRoot().getChildren().add((Object)this.globalToolkit.getYoGraphicFXManager().getRootNode2D());
        this.showOverheadPlotterProperty = this.messager.createPropertyInput(this.topics.getShowOverheadPlotter(), (Object)false);
        this.showOverheadPlotterProperty.addListener((o, oldValue, newValue) -> {
            if (newValue.booleanValue()) {
                if (!this.mainViewSplitPane.getItems().contains((Object)pane)) {
                    this.mainViewSplitPane.getItems().add((Object)pane);
                    plotter2D.setScale(80.0);
                }
            } else {
                this.mainViewSplitPane.getItems().remove((Object)pane);
            }
        });
        return this.showOverheadPlotterProperty;
    }

    public void setupLeftDrawer(Pane sidePane) {
        this.configureDrawer(sidePane, this.leftDrawer, (Node)this.leftDrawerBurger, this.leftDrawerOpen);
        HamburgerAnimationTransition transition = new HamburgerAnimationTransition(this.leftDrawerBurger, HamburgerAnimationTransition.FrameType.BURGER, HamburgerAnimationTransition.FrameType.LEFT_CLOSE);
        this.leftDrawer.addEventHandler(Event.ANY, e -> {
            if (e.getTarget() != this.leftDrawer) {
                return;
            }
            if (e.getEventType() == JFXDrawerEvent.OPENED) {
                this.sidePaneController.getYoSearchTabPaneController().requestFocusForActiveSearchBox();
            } else if (e.getEventType() == JFXDrawerEvent.CLOSING) {
                transition.setRate(-1.0);
                transition.play();
            } else if (e.getEventType() == JFXDrawerEvent.OPENING) {
                transition.setRate(1.0);
                transition.play();
            }
        });
    }

    public void setupRightDrawer(Pane sidePane) {
        this.configureDrawer(sidePane, this.rightDrawer, (Node)this.rightDrawerBurger, this.rightDrawerOpen);
        HamburgerAnimationTransition transition = new HamburgerAnimationTransition(this.rightDrawerBurger, HamburgerAnimationTransition.FrameType.LEFT_ANGLE, HamburgerAnimationTransition.FrameType.RIGHT_CLOSE);
        this.rightDrawer.addEventHandler(Event.ANY, e -> {
            if (e.getTarget() != this.rightDrawer) {
                return;
            }
            if (e.getEventType() != JFXDrawerEvent.OPENED) {
                if (e.getEventType() == JFXDrawerEvent.CLOSING) {
                    transition.setRate(-1.0);
                    transition.play();
                } else if (e.getEventType() == JFXDrawerEvent.OPENING) {
                    transition.setRate(1.0);
                    transition.play();
                }
            }
        });
    }

    public void configureDrawer(Pane sidePane, JFXDrawer drawer, Node openCloseControl, BooleanProperty drawerOpenProperty) {
        Pane drawerSidePane = this.addEdgeToSidePane(sidePane, drawer.getDirection());
        drawer.setSidePane(new Node[]{drawerSidePane});
        Node remove = (Node)drawer.getChildren().remove(drawer.getChildren().size() - 1);
        this.rootPane.addEventHandler(KeyEvent.KEY_PRESSED, e -> {
            if (e.isConsumed()) {
                return;
            }
            if (e.getCode() == KeyCode.ESCAPE && drawer.isOpened()) {
                drawer.close();
                e.consume();
            }
        });
        drawer.setResizeContent(true);
        drawer.setResizableOnDrag(true);
        drawer.setOverLayVisible(false);
        drawer.setContent(new Node[]{remove});
        SimpleBooleanProperty drawerFullyClosed = new SimpleBooleanProperty((Object)drawer, "drawerFullyClosedProperty", !drawerOpenProperty.get());
        drawerOpenProperty.set(drawer.isOpened());
        MutableBoolean ignoreOpenChange = new MutableBoolean(false);
        drawerOpenProperty.addListener((o, oldValue, newValue) -> {
            if (ignoreOpenChange.booleanValue()) {
                return;
            }
            if (newValue.booleanValue() && (drawer.isClosing() || drawer.isClosed())) {
                drawer.open();
            } else if (drawer.isOpening() || drawer.isOpened()) {
                drawer.close();
            }
        });
        drawer.addEventHandler(Event.ANY, arg_0 -> MainWindowController.lambda$configureDrawer$10(drawer, ignoreOpenChange, drawerOpenProperty, (BooleanProperty)drawerFullyClosed, arg_0));
        openCloseControl.setOnMouseClicked(e -> {
            if (drawer.isClosed() || drawer.isClosing()) {
                drawer.open();
            } else {
                drawer.close();
            }
        });
        drawerSidePane.visibleProperty().bind((ObservableValue)drawerFullyClosed.not());
        drawerSidePane.disableProperty().bind((ObservableValue)drawerFullyClosed.or((ObservableBooleanValue)this.disableUserControls));
    }

    private Pane addEdgeToSidePane(Pane sidePane, JFXDrawer.DrawerDirection contentSide) {
        if (contentSide == JFXDrawer.DrawerDirection.LEFT || contentSide == JFXDrawer.DrawerDirection.RIGHT) {
            StackPane edge = new StackPane();
            edge.setStyle("-fx-background-color:white;-fx-effect:innershadow(three-pass-box, #A9A9A9, 2.5, 0.0, -1.0, 0.0)");
            edge.setPrefWidth(5.0);
            edge.setMinWidth(5.0);
            edge.setCursor(Cursor.E_RESIZE);
            HBox drawerSidePane = contentSide == JFXDrawer.DrawerDirection.LEFT ? new HBox(new Node[]{sidePane, edge}) : new HBox(new Node[]{edge, sidePane});
            edge.addEventHandler(MouseEvent.ANY, event -> {
                if (drawerSidePane.getParent() != null) {
                    drawerSidePane.getParent().fireEvent(event);
                }
            });
            HBox.setHgrow((Node)sidePane, (Priority)Priority.ALWAYS);
            HBox.setHgrow((Node)edge, (Priority)Priority.NEVER);
            return drawerSidePane;
        }
        throw new UnsupportedOperationException("Not implemented for: " + contentSide);
    }

    @Override
    public void handleImpl(long timeNow) {
        if (this.timeLast == -1L) {
            this.timeLast = timeNow;
            this.frameCounter = 0;
            return;
        }
        ++this.frameCounter;
        if (timeNow - this.timeLast < this.timeIntervalBetweenUpdates) {
            return;
        }
        double framesPerSecond = (double)this.frameCounter / Conversions.nanosecondsToSeconds((long)(timeNow - this.timeLast));
        this.fpsLabel.setText(String.format("%6.2f FPS", framesPerSecond));
        if (framesPerSecond >= this.goodFPSLowerThreshold) {
            this.fpsLabel.setTextFill((Paint)this.goodFPSColor);
        } else if (framesPerSecond >= this.mediumFPSLowerThreshold) {
            this.fpsLabel.setTextFill((Paint)this.mediumFPSColor);
        } else {
            this.fpsLabel.setTextFill((Paint)this.poorFPSColor);
        }
        this.timeLast = timeNow;
        this.frameCounter = 0;
    }

    public void start() {
        super.start();
        this.windowToolkit.start();
    }

    public void stop() {
        this.stopSession();
        super.stop();
        this.windowToolkit.stop();
    }

    public void startSession() {
        this.yoChartGroupPanelController.start();
        this.sidePaneController.start();
    }

    public void stopSession() {
        this.yoChartGroupPanelController.stopAndClear();
        this.sidePaneController.stop();
        this.plotter2D.coordinateToTrackProperty().setValue(null);
    }

    public AnchorPane getMainPane() {
        return this.rootPane;
    }

    public AnchorPane getSceneAnchorPane() {
        return this.sceneAnchorPane;
    }

    public SplitPane getMainViewSplitPane() {
        return this.mainViewSplitPane;
    }

    public MainWindowMenuBarController getMainWindowMenuBarController() {
        return this.mainWindowMenuBarController;
    }

    public SessionSimpleControlsController getSessionSimpleControlsController() {
        return this.sessionSimpleControlsController;
    }

    public SessionAdvancedControlsController getSessionAdvancedControlsController() {
        return this.sessionAdvancedControlsController;
    }

    public YoChartGroupPanelController getYoChartGroupPanelController() {
        return this.yoChartGroupPanelController;
    }

    public SidePaneController getSidePaneController() {
        return this.sidePaneController;
    }

    public UserSidePaneController getUserSidePaneController() {
        return this.userSidePaneController;
    }

    public BooleanProperty leftSidePaneOpenProperty() {
        return this.leftDrawerOpen;
    }

    public BooleanProperty rightSidePaneOpenProperty() {
        return this.rightDrawerOpen;
    }

    public Property<Boolean> showOverheadPlotterProperty() {
        return this.showOverheadPlotterProperty;
    }

    public BooleanProperty showAdvancedControlsProperty() {
        return this.sessionAdvancedControlsController.showProperty();
    }

    public Property<YoNameDisplay> yoNameDisplayProperty() {
        return this.yoNameDisplayProperty;
    }

    private static /* synthetic */ void lambda$configureDrawer$10(JFXDrawer drawer, MutableBoolean ignoreOpenChange, BooleanProperty drawerOpenProperty, BooleanProperty drawerFullyClosed, Event e) {
        if (e.getTarget() != drawer) {
            return;
        }
        if (e.getEventType() == JFXDrawerEvent.CLOSED) {
            ignoreOpenChange.setTrue();
            drawerOpenProperty.set(false);
            ignoreOpenChange.setFalse();
            drawerFullyClosed.set(true);
        }
        if (e.getEventType() == JFXDrawerEvent.OPENING || e.getEventType() == JFXDrawerEvent.OPENED) {
            ignoreOpenChange.setTrue();
            drawerOpenProperty.set(true);
            ignoreOpenChange.setFalse();
            drawerFullyClosed.set(false);
        }
    }
}

