/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.scs2.sessionVisualizer.jfx.controllers.yoComposite.search;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import javafx.beans.property.Property;
import javafx.beans.property.ReadOnlyProperty;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.CheckBox;
import javafx.scene.control.ComboBox;
import javafx.scene.control.ContentDisplay;
import javafx.scene.control.Control;
import javafx.scene.control.Label;
import javafx.scene.control.Labeled;
import javafx.scene.control.ListCell;
import javafx.scene.control.ListView;
import javafx.scene.control.Spinner;
import javafx.scene.control.SpinnerValueFactory;
import javafx.scene.control.Tooltip;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Region;
import javafx.scene.layout.VBox;
import javafx.scene.text.Font;
import javafx.scene.text.FontWeight;
import javafx.util.StringConverter;
import javafx.util.converter.DoubleStringConverter;
import us.ihmc.javaFXExtensions.control.LongSpinnerValueFactory;
import us.ihmc.scs2.sessionVisualizer.jfx.YoNameDisplay;
import us.ihmc.scs2.sessionVisualizer.jfx.controllers.yoComposite.search.YoDoubleSpinnerValueFactory;
import us.ihmc.scs2.sessionVisualizer.jfx.managers.YoManager;
import us.ihmc.scs2.sessionVisualizer.jfx.properties.YoBooleanProperty;
import us.ihmc.scs2.sessionVisualizer.jfx.properties.YoDoubleProperty;
import us.ihmc.scs2.sessionVisualizer.jfx.properties.YoEnumAsStringProperty;
import us.ihmc.scs2.sessionVisualizer.jfx.properties.YoIntegerProperty;
import us.ihmc.scs2.sessionVisualizer.jfx.properties.YoLongProperty;
import us.ihmc.scs2.sessionVisualizer.jfx.properties.YoVariableProperty;
import us.ihmc.scs2.sessionVisualizer.jfx.tools.ScientificDoubleStringConverter;
import us.ihmc.scs2.sessionVisualizer.jfx.yoComposite.YoComposite;
import us.ihmc.scs2.sharedMemory.LinkedYoBoolean;
import us.ihmc.scs2.sharedMemory.LinkedYoDouble;
import us.ihmc.scs2.sharedMemory.LinkedYoEnum;
import us.ihmc.scs2.sharedMemory.LinkedYoInteger;
import us.ihmc.scs2.sharedMemory.LinkedYoLong;
import us.ihmc.scs2.sharedMemory.LinkedYoRegistry;
import us.ihmc.yoVariables.variable.YoBoolean;
import us.ihmc.yoVariables.variable.YoDouble;
import us.ihmc.yoVariables.variable.YoEnum;
import us.ihmc.yoVariables.variable.YoInteger;
import us.ihmc.yoVariables.variable.YoLong;
import us.ihmc.yoVariables.variable.YoVariable;

public class YoCompositeListCell
extends ListCell<YoComposite> {
    private static final double GRAPHIC_PREF_WIDTH = 110.0;
    private final YoManager yoManager;
    private final ListView<YoComposite> owner;
    private final ReadOnlyProperty<YoNameDisplay> nameDisplay;
    private YoComposite yoComposite;
    private Labeled yoCompositeNameDisplay = this;
    private final Property<Integer> numberPrecision;
    private final List<YoVariableProperty<?, ?>> yoVariableProperties = new ArrayList();

    public YoCompositeListCell(YoManager yoManager, ReadOnlyProperty<YoNameDisplay> nameDisplay, Property<Integer> numberPrecision, ListView<YoComposite> owner) {
        this.yoManager = yoManager;
        this.nameDisplay = nameDisplay;
        this.numberPrecision = numberPrecision;
        this.owner = owner;
        this.getStyleClass().add((Object)"yo-variable-list-cell");
    }

    protected void updateItem(YoComposite yoComposite, boolean empty) {
        this.yoComposite = yoComposite;
        super.updateItem((Object)yoComposite, empty);
        this.yoVariableProperties.forEach(YoVariableProperty::dispose);
        this.yoVariableProperties.clear();
        this.prefWidthProperty().bind((ObservableValue)this.owner.widthProperty().subtract(15.0));
        this.setMinWidth(100.0);
        if (empty || this.yoManager.getLinkedRootRegistry() == null) {
            this.setGraphic(null);
            this.setText(null);
            this.setTooltip(null);
            return;
        }
        if (yoComposite.getPattern().getComponentIdentifiers() == null) {
            YoVariable yoVariable = yoComposite.getYoComponents().get(0);
            Region yoVariableControl = this.createYoVariableControl(yoVariable, this.numberPrecision, this.yoManager.getLinkedRootRegistry());
            this.setGraphic((Node)yoVariableControl);
            this.setContentDisplay(ContentDisplay.LEFT);
            this.setAlignment(Pos.CENTER_LEFT);
            this.setGraphicTextGap(5.0);
            this.yoCompositeNameDisplay = this;
        } else {
            List<Region> yoVariableControls = this.createYoVariableControls(yoComposite.getYoComponents(), this.numberPrecision, this.yoManager.getLinkedRootRegistry());
            GridPane cellGraphic = new GridPane();
            cellGraphic.setHgap(5.0);
            cellGraphic.setVgap(2.0);
            for (int i = 0; i < yoVariableControls.size(); ++i) {
                YoVariable component = yoComposite.getYoComponents().get(i);
                String componentIdentifier = yoComposite.getPattern().getComponentIdentifiers()[i];
                Label idLabel = new Label(componentIdentifier);
                idLabel.setTooltip(new Tooltip(component.getName() + "\n" + String.valueOf(component.getNamespace())));
                Region componentControl = yoVariableControls.get(i);
                cellGraphic.getChildren().addAll((Object[])new Node[]{idLabel, componentControl});
                GridPane.setConstraints((Node)idLabel, (int)0, (int)i);
                GridPane.setConstraints((Node)componentControl, (int)1, (int)i);
            }
            Label label = new Label();
            this.yoCompositeNameDisplay = label;
            label.setFont(Font.font((String)"System", (FontWeight)FontWeight.BOLD, (double)12.0));
            this.setGraphic((Node)new VBox(3.0, new Node[]{label, cellGraphic}));
            this.setContentDisplay(ContentDisplay.GRAPHIC_ONLY);
            this.setAlignment(Pos.TOP_LEFT);
            this.setGraphicTextGap(0.0);
            this.setText(null);
            this.setTooltip(null);
        }
        this.updateYoCompositeName((YoNameDisplay)((Object)this.nameDisplay.getValue()));
        this.nameDisplay.addListener((o, oldValue, newValue) -> this.updateYoCompositeName((YoNameDisplay)((Object)newValue)));
        this.yoCompositeNameDisplay.setTooltip(new Tooltip(yoComposite.getName() + "\n" + String.valueOf(yoComposite.getNamespace())));
    }

    private void updateYoCompositeName(YoNameDisplay nameDisplay) {
        if (this.yoCompositeNameDisplay == null || this.yoComposite == null) {
            return;
        }
        this.yoCompositeNameDisplay.setText(switch (nameDisplay) {
            default -> throw new MatchException(null, null);
            case YoNameDisplay.SHORT_NAME -> this.yoComposite.getName();
            case YoNameDisplay.UNIQUE_NAME -> this.yoComposite.getUniqueName();
            case YoNameDisplay.UNIQUE_SHORT_NAME -> this.yoComposite.getUniqueShortName();
            case YoNameDisplay.FULL_NAME -> this.yoComposite.getFullname();
        });
    }

    public List<Region> createYoVariableControls(Collection<YoVariable> yoVariables, Property<Integer> numberPrecision, LinkedYoRegistry linkedRegistry) {
        return yoVariables.stream().map(v -> this.createYoVariableControl((YoVariable)v, numberPrecision, linkedRegistry)).collect(Collectors.toList());
    }

    public Region createYoVariableControl(YoVariable yoVariable, Property<Integer> numberPrecision, LinkedYoRegistry linkedRegistry) {
        if (yoVariable instanceof YoDouble) {
            return this.createYoDoubleControl((YoDouble)yoVariable, numberPrecision, linkedRegistry);
        }
        if (yoVariable instanceof YoBoolean) {
            return this.createYoBooleanControl((YoBoolean)yoVariable, linkedRegistry);
        }
        if (yoVariable instanceof YoLong) {
            return this.createYoLongControl((YoLong)yoVariable, linkedRegistry);
        }
        if (yoVariable instanceof YoInteger) {
            return this.createYoIntegerControl((YoInteger)yoVariable, linkedRegistry);
        }
        if (yoVariable instanceof YoEnum) {
            return this.createYoEnumControl((YoEnum)yoVariable, linkedRegistry);
        }
        throw new UnsupportedOperationException("Unhandled YoVariable type: " + yoVariable.getClass().getSimpleName());
    }

    public Control createYoDoubleControl(YoDouble yoDouble, Property<Integer> numberPrecision, LinkedYoRegistry linkedRegistry) {
        YoDoubleProperty yoDoubleProperty = new YoDoubleProperty(yoDouble, (Object)this);
        yoDoubleProperty.setLinkedBuffer(this.isDisabled() ? null : (LinkedYoDouble)linkedRegistry.linkYoVariable((YoVariable)yoDouble, (Object)yoDoubleProperty));
        this.disabledProperty().addListener((o, oldValue, newValue) -> yoDoubleProperty.setLinkedBuffer(newValue != false ? null : (LinkedYoDouble)linkedRegistry.linkYoVariable((YoVariable)yoDouble, (Object)yoDoubleProperty)));
        this.yoVariableProperties.add(yoDoubleProperty);
        YoDoubleSpinnerValueFactory valueFactory = new YoDoubleSpinnerValueFactory(yoDoubleProperty.getValue());
        DoubleStringConverter rawDoubleStringConverter = new DoubleStringConverter();
        ScientificDoubleStringConverter scientificDoubleStringConverter = new ScientificDoubleStringConverter(numberPrecision);
        valueFactory.setConverter(scientificDoubleStringConverter);
        Spinner spinner = new Spinner((SpinnerValueFactory)valueFactory);
        spinner.setPrefWidth(110.0);
        spinner.setEditable(true);
        spinner.focusedProperty().addListener((o, oldValue, newValue) -> {
            valueFactory.setConverter((StringConverter)(newValue != false ? rawDoubleStringConverter : scientificDoubleStringConverter));
            spinner.getEditor().setText(valueFactory.getConverter().toString((Object)((Double)valueFactory.getValue())));
        });
        yoDoubleProperty.bindDoubleProperty((Property<Double>)spinner.getValueFactory().valueProperty());
        Tooltip tooltip = new Tooltip();
        tooltip.textProperty().bind((ObservableValue)spinner.valueProperty().asString());
        spinner.setTooltip(tooltip);
        return spinner;
    }

    public Region createYoBooleanControl(YoBoolean yoBoolean, LinkedYoRegistry linkedRegistry) {
        YoBooleanProperty yoBooleanProperty = new YoBooleanProperty(yoBoolean, (Object)this);
        yoBooleanProperty.setLinkedBuffer(this.isDisabled() ? null : (LinkedYoBoolean)linkedRegistry.linkYoVariable((YoVariable)yoBoolean, (Object)yoBooleanProperty));
        this.disabledProperty().addListener((o, oldValue, newValue) -> yoBooleanProperty.setLinkedBuffer(newValue != false ? null : (LinkedYoBoolean)linkedRegistry.linkYoVariable((YoVariable)yoBoolean, (Object)yoBooleanProperty)));
        this.yoVariableProperties.add(yoBooleanProperty);
        CheckBox checkBox = new CheckBox();
        HBox root = new HBox(new Node[]{checkBox});
        root.setPrefWidth(110.0);
        root.alignmentProperty().set((Object)Pos.CENTER_LEFT);
        checkBox.setSelected(yoBooleanProperty.getValue().booleanValue());
        yoBooleanProperty.bindBooleanProperty((Property<Boolean>)checkBox.selectedProperty());
        return root;
    }

    public Control createYoLongControl(YoLong yoLong, LinkedYoRegistry linkedRegistry) {
        YoLongProperty yoLongProperty = new YoLongProperty(yoLong, (Object)this);
        yoLongProperty.setLinkedBuffer(this.isDisabled() ? null : (LinkedYoLong)linkedRegistry.linkYoVariable((YoVariable)yoLong, (Object)yoLongProperty));
        this.disabledProperty().addListener((o, oldValue, newValue) -> yoLongProperty.setLinkedBuffer(newValue != false ? null : (LinkedYoLong)linkedRegistry.linkYoVariable((YoVariable)yoLong, (Object)yoLongProperty)));
        this.yoVariableProperties.add(yoLongProperty);
        LongSpinnerValueFactory valueFactory = new LongSpinnerValueFactory(Long.MIN_VALUE, Long.MAX_VALUE, yoLongProperty.getValue().longValue(), 1L);
        Spinner spinner = new Spinner((SpinnerValueFactory)valueFactory);
        spinner.setPrefWidth(110.0);
        spinner.setEditable(true);
        spinner.focusedProperty().addListener((o, oldValue, newValue) -> {
            if (!newValue.booleanValue()) {
                spinner.getEditor().setText(valueFactory.getConverter().toString((Object)((Long)valueFactory.getValue())));
            }
        });
        yoLongProperty.bindLongProperty((Property<Long>)spinner.getValueFactory().valueProperty());
        Tooltip tooltip = new Tooltip();
        tooltip.textProperty().bind((ObservableValue)spinner.valueProperty().asString());
        spinner.setTooltip(tooltip);
        return spinner;
    }

    public Control createYoIntegerControl(YoInteger yoInteger, LinkedYoRegistry linkedRegistry) {
        YoIntegerProperty yoIntegerProperty = new YoIntegerProperty(yoInteger, (Object)this);
        yoIntegerProperty.setLinkedBuffer(this.isDisabled() ? null : (LinkedYoInteger)linkedRegistry.linkYoVariable((YoVariable)yoInteger, (Object)yoIntegerProperty));
        this.disabledProperty().addListener((o, oldValue, newValue) -> yoIntegerProperty.setLinkedBuffer(newValue != false ? null : (LinkedYoInteger)linkedRegistry.linkYoVariable((YoVariable)yoInteger, (Object)yoIntegerProperty)));
        this.yoVariableProperties.add(yoIntegerProperty);
        SpinnerValueFactory.IntegerSpinnerValueFactory valueFactory = new SpinnerValueFactory.IntegerSpinnerValueFactory(Integer.MIN_VALUE, Integer.MAX_VALUE, yoIntegerProperty.getValue().intValue(), 1);
        Spinner spinner = new Spinner((SpinnerValueFactory)valueFactory);
        spinner.setPrefWidth(110.0);
        spinner.setEditable(true);
        spinner.focusedProperty().addListener((o, oldValue, newValue) -> {
            if (!newValue.booleanValue()) {
                spinner.getEditor().setText(valueFactory.getConverter().toString((Object)((Integer)valueFactory.getValue())));
            }
        });
        yoIntegerProperty.bindIntegerProperty((Property<Integer>)spinner.getValueFactory().valueProperty());
        Tooltip tooltip = new Tooltip();
        tooltip.textProperty().bind((ObservableValue)spinner.valueProperty().asString());
        spinner.setTooltip(tooltip);
        return spinner;
    }

    public <E extends Enum<E>> Control createYoEnumControl(YoEnum<E> yoEnum, LinkedYoRegistry linkedRegistry) {
        YoEnumAsStringProperty yoEnumProperty = new YoEnumAsStringProperty(yoEnum, (Object)this);
        yoEnumProperty.setLinkedBuffer(this.isDisabled() ? null : (LinkedYoEnum)linkedRegistry.linkYoVariable(yoEnum, yoEnumProperty));
        this.disabledProperty().addListener((o, oldValue, newValue) -> yoEnumProperty.setLinkedBuffer(newValue != false ? null : (LinkedYoEnum)linkedRegistry.linkYoVariable((YoVariable)yoEnum, (Object)yoEnumProperty)));
        this.yoVariableProperties.add(yoEnumProperty);
        ObservableList items = FXCollections.observableArrayList((Object[])yoEnumProperty.getYoVariable().getEnumValuesAsString());
        if (yoEnumProperty.getYoVariable().isNullAllowed()) {
            items.add((Object)"null");
        }
        ComboBox comboBox = new ComboBox(items);
        comboBox.setValue((Object)yoEnumProperty.getValue());
        comboBox.setPrefWidth(110.0);
        comboBox.setEditable(false);
        yoEnumProperty.bindStringProperty((Property<String>)comboBox.valueProperty());
        Tooltip tooltip = new Tooltip();
        tooltip.textProperty().bind((ObservableValue)comboBox.valueProperty());
        comboBox.setTooltip(tooltip);
        return comboBox;
    }
}

