/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.scs2.sessionVisualizer.jfx.charts;

import java.util.Optional;
import java.util.concurrent.Executor;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.geometry.Orientation;
import javafx.geometry.Side;
import javafx.scene.Group;
import javafx.scene.Node;
import javafx.scene.chart.FastAxisBase;
import us.ihmc.javaFXExtensions.chart.DynamicXYChart;
import us.ihmc.scs2.sessionVisualizer.jfx.charts.ChartDoubleBounds;
import us.ihmc.scs2.sessionVisualizer.jfx.charts.ChartIntegerBounds;
import us.ihmc.scs2.sessionVisualizer.jfx.charts.ChartMarker;
import us.ihmc.scs2.sessionVisualizer.jfx.charts.DynamicChartLegend;
import us.ihmc.scs2.sessionVisualizer.jfx.charts.NumberSeries;
import us.ihmc.scs2.sessionVisualizer.jfx.charts.NumberSeriesLayer;
import us.ihmc.scs2.sessionVisualizer.jfx.managers.ChartRenderManager;

public class DynamicLineChart
extends DynamicXYChart {
    private final Group seriesGroup = new Group(this){

        public void requestLayout() {
        }
    };
    private final Group markerGroup = new Group(this){

        public void requestLayout() {
        }
    };
    private final BooleanProperty markerAutoUpdateProperty = new SimpleBooleanProperty((Object)this, "markerAutoUpdate", true);
    private final ObjectProperty<ChartStyle> chartStyleProperty = new SimpleObjectProperty((Object)this, "chartStyle", (Object)ChartStyle.RAW);
    private final ObservableList<NumberSeriesLayer> seriesLayers = FXCollections.observableArrayList();
    private final ChangeListener<Object> chartUpdaterListener = (o, oldValue, newValue) -> this.requestChartLayout();
    private final ObservableList<ChartMarker> markers = FXCollections.observableArrayList();
    private final DynamicChartLegend legend = new DynamicChartLegend();
    private final BooleanProperty updateIndexMarkersVisible = new SimpleBooleanProperty((Object)this, "updateIndexMarkersVisible", false);
    private final Executor backgroundExecutor;
    private final ChartRenderManager chartRenderManager;
    private final ChangeListener<? super Boolean> autoRangingListener = (ov, t, t1) -> this.updateAxisRange();

    public DynamicLineChart(FastAxisBase xAxis, FastAxisBase yAxis, Executor backgroundExecutor, ChartRenderManager chartRenderManager) {
        super(xAxis, yAxis);
        this.chartRenderManager = chartRenderManager;
        this.backgroundExecutor = backgroundExecutor;
        ChangeListener xAxisChangeListener = (o, oldAxis, newAxis) -> {
            if (oldAxis != null) {
                oldAxis.autoRangingProperty().removeListener(this.autoRangingListener);
            }
            if (newAxis.getSide() == null) {
                newAxis.setSide(Side.BOTTOM);
            }
            newAxis.setEffectiveOrientation(Orientation.HORIZONTAL);
            newAxis.autoRangingProperty().addListener(this.autoRangingListener);
        };
        this.xAxisProperty().addListener(xAxisChangeListener);
        xAxisChangeListener.changed(null, null, (Object)xAxis);
        ChangeListener yAxisChangeListener = (o, oldAxis, newAxis) -> {
            if (oldAxis != null) {
                oldAxis.autoRangingProperty().removeListener(this.autoRangingListener);
            }
            if (newAxis.getSide() == null) {
                newAxis.setSide(Side.LEFT);
            }
            newAxis.setEffectiveOrientation(Orientation.VERTICAL);
            newAxis.autoRangingProperty().addListener(this.autoRangingListener);
        };
        this.yAxisProperty().addListener(yAxisChangeListener);
        yAxisChangeListener.changed(null, null, (Object)yAxis);
        this.chartStyleProperty.addListener(this.chartUpdaterListener);
        this.plotContent.getChildren().addAll((Object[])new Node[]{this.seriesGroup, this.markerGroup});
        this.seriesGroup.setAutoSizeChildren(false);
        this.markerGroup.setAutoSizeChildren(false);
        this.seriesGroup.getStyleClass().setAll((Object[])new String[]{"series-group"});
        this.markerGroup.getStyleClass().setAll((Object[])new String[]{"marker-group"});
        this.seriesGroup.setManaged(false);
        this.markerGroup.setManaged(false);
        ChangeListener updateMarkerListener = (o, oldValue, newValue) -> this.updateMarkers();
        this.markers.addListener(change -> {
            while (change.next()) {
                if (change.wasAdded()) {
                    for (ChartMarker newMarker : change.getAddedSubList()) {
                        this.markerGroup.getChildren().add((Object)newMarker);
                        if (!this.markerAutoUpdateProperty.get()) continue;
                        newMarker.addListener((ChangeListener<Object>)updateMarkerListener);
                    }
                    this.updateMarkers();
                }
                if (!change.wasRemoved()) continue;
                for (ChartMarker oldMarker : change.getRemoved()) {
                    this.markerGroup.getChildren().remove((Object)oldMarker);
                    oldMarker.destroy();
                }
            }
        });
        this.markerAutoUpdateProperty.addListener((o, oldValue, newValue) -> {
            if (newValue.booleanValue()) {
                this.markers.forEach(marker -> marker.addListener((ChangeListener<Object>)updateMarkerListener));
            } else {
                this.markers.forEach(marker -> marker.removeListener((ChangeListener<Object>)updateMarkerListener));
            }
        });
        this.setLegend((Node)this.legend);
    }

    public void addSeries(NumberSeries series) {
        int seriesIndex = this.seriesLayers.size();
        series.negatedProperty().addListener(this.chartUpdaterListener);
        series.customYBoundsProperty().addListener(this.chartUpdaterListener);
        series.dirtyProperty().addListener(this.chartUpdaterListener);
        NumberSeriesLayer layer = new NumberSeriesLayer((ObjectProperty<FastAxisBase>)this.xAxis, (ObjectProperty<FastAxisBase>)this.yAxis, series, this.backgroundExecutor, this.chartRenderManager);
        layer.chartStyleProperty().bind(this.chartStyleProperty);
        layer.updateIndexMarkerVisibleProperty().bind((ObservableValue)this.updateIndexMarkersVisible);
        DynamicLineChart.setSeriesDefaultStyleClass(layer, seriesIndex);
        this.seriesLayers.add((Object)layer);
        this.legend.getItems().add((Object)layer.getLegendNode());
        this.seriesGroup.getChildren().add((Object)layer);
        this.chartUpdaterListener.changed(null, null, null);
    }

    public void removeSeries(NumberSeries series) {
        Optional<NumberSeriesLayer> containingLayer = this.seriesLayers.stream().filter(layer -> layer.getNumberSeries() == series).findFirst();
        if (containingLayer.isPresent()) {
            int indexOf = this.seriesLayers.indexOf((Object)containingLayer.get());
            NumberSeriesLayer removedLayer = (NumberSeriesLayer)((Object)this.seriesLayers.remove(indexOf));
            removedLayer.chartStyleProperty().unbind();
            removedLayer.updateIndexMarkerVisibleProperty().unbind();
            series.negatedProperty().removeListener(this.chartUpdaterListener);
            series.customYBoundsProperty().removeListener(this.chartUpdaterListener);
            series.dirtyProperty().removeListener(this.chartUpdaterListener);
            containingLayer.get().chartStyleProperty().unbind();
            this.seriesGroup.getChildren().remove((Object)containingLayer.get());
            this.legend.getItems().remove((Object)containingLayer.get().getLegendNode());
            for (int i = indexOf; i < this.seriesLayers.size(); ++i) {
                DynamicLineChart.setSeriesDefaultStyleClass((NumberSeriesLayer)((Object)this.seriesLayers.get(i)), i);
            }
            this.chartUpdaterListener.changed(null, null, null);
        }
    }

    public void addMarker(ChartMarker marker) {
        this.markers.add((Object)marker);
    }

    public void removeMarker(ChartMarker marker) {
        this.markers.remove((Object)marker);
    }

    private void updateSeriesList(double top, double left, double width, double height) {
        for (NumberSeriesLayer seriesLayer : this.seriesLayers) {
            seriesLayer.scheduleRender();
        }
    }

    protected void layoutPlotChildren(double top, double left, double width, double height) {
        this.seriesGroup.setLayoutX(left);
        this.seriesGroup.setLayoutY(top);
        this.seriesGroup.requestLayout();
        this.markerGroup.setLayoutX(left);
        this.markerGroup.setLayoutY(top);
        this.markerGroup.requestLayout();
        this.updateSeriesList(top, left, width, height);
        if (this.markerAutoUpdateProperty.get()) {
            this.updateMarkers();
        }
    }

    public void updateMarkers() {
        this.markers.forEach(marker -> marker.updateMarker(this.getXAxis(), this.getYAxis()));
    }

    protected void updateAxisRange() {
        this.updateXAxisRange();
        this.updateYAxisRange();
    }

    protected void updateXAxisRange() {
        ChartIntegerBounds xBounds = null;
        FastAxisBase xAxis = this.getXAxis();
        if (xAxis.isAutoRanging()) {
            for (NumberSeriesLayer layer : this.seriesLayers) {
                NumberSeries series = layer.getNumberSeries();
                ChartIntegerBounds dataXBounds = (ChartIntegerBounds)series.xBoundsProperty().getValue();
                if (dataXBounds == null) continue;
                if (xBounds == null) {
                    xBounds = new ChartIntegerBounds(dataXBounds);
                    continue;
                }
                xBounds = xBounds.union(dataXBounds);
            }
            if (xBounds != null) {
                xAxis.invalidateRange((double)xBounds.getLower(), (double)xBounds.getUpper());
            }
        }
    }

    protected void updateYAxisRange() {
        ChartDoubleBounds yBounds = null;
        FastAxisBase yAxis = this.getYAxis();
        if (yAxis.isAutoRanging()) {
            if (this.chartStyleProperty.get() == ChartStyle.NORMALIZED) {
                yAxis.invalidateRange(0.0, 1.0);
            } else {
                for (NumberSeriesLayer layer : this.seriesLayers) {
                    NumberSeries series = layer.getNumberSeries();
                    ChartDoubleBounds dataYBounds = (ChartDoubleBounds)series.yBoundsProperty().getValue();
                    if (dataYBounds == null) continue;
                    if (series.getCustomYBounds() != null) {
                        dataYBounds = series.getCustomYBounds();
                    }
                    if (series.isNegated()) {
                        dataYBounds = dataYBounds.negate();
                    }
                    if (yBounds == null) {
                        yBounds = dataYBounds;
                        continue;
                    }
                    yBounds = yBounds.union(dataYBounds);
                }
                if (yBounds != null) {
                    yAxis.invalidateRange(yBounds.getLower(), yBounds.getUpper());
                }
            }
        }
    }

    public BooleanProperty updateIndexMarkersVisible() {
        return this.updateIndexMarkersVisible;
    }

    public BooleanProperty markerAutoUpdateProperty() {
        return this.markerAutoUpdateProperty;
    }

    public void setChartStyle(ChartStyle style) {
        this.chartStyleProperty.set((Object)style);
    }

    public ChartStyle getChartStyle() {
        return (ChartStyle)((Object)this.chartStyleProperty.get());
    }

    public ObjectProperty<ChartStyle> chartStyleProperty() {
        return this.chartStyleProperty;
    }

    private static void setSeriesDefaultStyleClass(NumberSeriesLayer seriesLayer, int seriesIndex) {
        seriesLayer.getStyleClass().setAll((Object[])new String[]{"chart-series-line", "series" + seriesIndex, DynamicLineChart.getDefaultColorStyle(seriesIndex)});
    }

    public static String getDefaultColorStyle(int index) {
        return "default-color" + index % 8;
    }

    public static enum ChartStyle {
        RAW,
        NORMALIZED;

    }
}

