/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.scs2.sessionVisualizer.jfx.session.log;

import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import us.ihmc.codecs.demuxer.MP4VideoDemuxer;
import us.ihmc.codecs.generated.YUVPicture;
import us.ihmc.concurrent.ConcurrentCopier;
import us.ihmc.robotDataLogger.Camera;
import us.ihmc.scs2.session.log.ProgressConsumer;
import us.ihmc.scs2.sessionVisualizer.jfx.session.log.FrameData;
import us.ihmc.scs2.sessionVisualizer.jfx.session.log.JavaFXPictureConverter;
import us.ihmc.scs2.sessionVisualizer.jfx.session.log.TimestampScrubber;
import us.ihmc.scs2.sessionVisualizer.jfx.session.log.VideoConverter;
import us.ihmc.scs2.sessionVisualizer.jfx.session.log.VideoDataReader;

public class BlackMagicVideoDataReader
implements VideoDataReader {
    private final TimestampScrubber timestampScrubber;
    private final String name;
    private final MP4VideoDemuxer demuxer;
    private final JavaFXPictureConverter converter = new JavaFXPictureConverter();
    private final File videoFile;
    private final Camera camera;
    private final ConcurrentCopier<FrameData> imageBuffer = new ConcurrentCopier(FrameData::new);

    public BlackMagicVideoDataReader(Camera camera, File dataDirectory, boolean hasTimeBase) throws IOException {
        this.camera = camera;
        this.name = camera.getNameAsString();
        boolean interlaced = camera.getInterlaced();
        if (!hasTimeBase) {
            System.err.println("Video data is using timestamps instead of frame numbers. Falling back to seeking based on timestamp.");
        }
        this.videoFile = new File(dataDirectory, camera.getVideoFileAsString());
        if (!this.videoFile.exists()) {
            throw new IOException("Cannot find video: " + this.videoFile);
        }
        this.demuxer = new MP4VideoDemuxer(this.videoFile);
        File timestampFile = new File(dataDirectory, camera.getTimestampFileAsString());
        this.timestampScrubber = new TimestampScrubber(timestampFile, hasTimeBase, interlaced);
    }

    @Override
    public int getImageHeight() {
        return 0;
    }

    @Override
    public int getImageWidth() {
        return 0;
    }

    @Override
    public void readVideoFrame(long queryRobotTimestamp) {
        long videoTimestamp = this.timestampScrubber.getVideoTimestampFromRobotTimestamp(queryRobotTimestamp);
        long currentRobotTimestamp = this.timestampScrubber.getCurrentRobotTimestamp();
        try {
            this.demuxer.seekToPTS(videoTimestamp);
            FrameData copyForWriting = (FrameData)this.imageBuffer.getCopyForWriting();
            copyForWriting.queryRobotTimestamp = queryRobotTimestamp;
            copyForWriting.currentRobotTimestamp = currentRobotTimestamp;
            copyForWriting.currentVideoTimestamp = videoTimestamp;
            copyForWriting.currentDemuxerTimestamp = this.demuxer.getCurrentPTS();
            YUVPicture nextFrame = this.demuxer.getNextFrame();
            copyForWriting.frame = this.converter.toFXImage(nextFrame, copyForWriting.frame);
            this.imageBuffer.commit();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @Override
    public void cropVideo(File outputFile, File timestampFile, long startTimestamp, long endTimestamp, ProgressConsumer monitor) throws IOException {
        long startVideoTimestamp = this.timestampScrubber.getVideoTimestampFromRobotTimestamp(startTimestamp);
        long endVideoTimestamp = this.timestampScrubber.getVideoTimestampFromRobotTimestamp(endTimestamp);
        int framerate = VideoConverter.cropBlackMagicVideo(this.videoFile, outputFile, startVideoTimestamp, endVideoTimestamp, monitor);
        PrintWriter timestampWriter = new PrintWriter(timestampFile);
        timestampWriter.println(1);
        timestampWriter.println(framerate);
        long pts = 0L;
        for (int i = 0; i < this.timestampScrubber.getRobotTimestampsLength(); ++i) {
            long robotTimestamp = this.timestampScrubber.getRobotTimestampAtIndex(i);
            if (robotTimestamp >= startTimestamp && robotTimestamp <= endTimestamp) {
                timestampWriter.print(robotTimestamp);
                timestampWriter.print(" ");
                timestampWriter.println(pts);
                ++pts;
                continue;
            }
            if (robotTimestamp > endTimestamp) break;
        }
        timestampWriter.close();
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public Camera getCamera() {
        return this.camera;
    }

    @Override
    public FrameData pollCurrentFrame() {
        return (FrameData)this.imageBuffer.getCopyForReading();
    }

    @Override
    public int getCurrentIndex() {
        return this.timestampScrubber.getCurrentIndex();
    }

    @Override
    public boolean replacedRobotTimestampsContainsIndex(int index) {
        return this.timestampScrubber.getReplacedRobotTimestampIndex(index);
    }
}

