/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.scs2.sessionVisualizer.jfx.controllers.yoComposite.creator;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import javafx.animation.KeyFrame;
import javafx.animation.KeyValue;
import javafx.animation.Timeline;
import javafx.beans.property.Property;
import javafx.beans.property.ReadOnlyProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.value.ObservableValue;
import javafx.beans.value.WritableValue;
import javafx.collections.ObservableList;
import javafx.fxml.FXML;
import javafx.fxml.FXMLLoader;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.control.Label;
import javafx.scene.control.ListCell;
import javafx.scene.control.ListView;
import javafx.scene.control.MenuItem;
import javafx.scene.control.SelectionMode;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyEvent;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Pane;
import javafx.scene.layout.Priority;
import javafx.scene.layout.VBox;
import javafx.scene.text.Font;
import javafx.scene.text.FontPosture;
import javafx.stage.Stage;
import javafx.stage.StageStyle;
import javafx.stage.Window;
import javafx.stage.WindowEvent;
import javafx.util.Duration;
import org.kordamp.ikonli.javafx.FontIcon;
import us.ihmc.messager.javafx.JavaFXMessager;
import us.ihmc.scs2.definition.DefinitionIOTools;
import us.ihmc.scs2.definition.yoVariable.YoEquationDefinition;
import us.ihmc.scs2.definition.yoVariable.YoEquationListDefinition;
import us.ihmc.scs2.sessionVisualizer.jfx.SessionVisualizerIOTools;
import us.ihmc.scs2.sessionVisualizer.jfx.SessionVisualizerTopics;
import us.ihmc.scs2.sessionVisualizer.jfx.YoNameDisplay;
import us.ihmc.scs2.sessionVisualizer.jfx.controllers.yoComposite.creator.YoCompositeCreatorDialogController;
import us.ihmc.scs2.sessionVisualizer.jfx.controllers.yoComposite.creator.YoEquationEditorHelpPaneController;
import us.ihmc.scs2.sessionVisualizer.jfx.controllers.yoComposite.creator.YoEquationEditorPaneController;
import us.ihmc.scs2.sessionVisualizer.jfx.controllers.yoComposite.search.YoCompositeListCell;
import us.ihmc.scs2.sessionVisualizer.jfx.managers.SessionVisualizerToolkit;
import us.ihmc.scs2.sessionVisualizer.jfx.managers.YoCompositeSearchManager;
import us.ihmc.scs2.sessionVisualizer.jfx.managers.YoManager;
import us.ihmc.scs2.sessionVisualizer.jfx.tools.ListViewTools;
import us.ihmc.scs2.sessionVisualizer.jfx.tools.MenuTools;
import us.ihmc.scs2.sessionVisualizer.jfx.yoComposite.YoComposite;
import us.ihmc.scs2.symbolic.YoEquationManager;
import us.ihmc.yoVariables.registry.YoRegistry;
import us.ihmc.yoVariables.variable.YoVariable;

public class YoCompositeAndEquationEditorWindowController {
    public static final String NEW_EQUATION_NAME = "NewEquation";
    @FXML
    private Pane mainPane;
    @FXML
    private ListView<YoComposite> yoCompositeListView;
    @FXML
    private ListView<YoEquationEditorPaneController> yoEquationEditorListView;
    @FXML
    private VBox equationEditorContainer;
    private final Property<YoNameDisplay> yoVariableNameDisplay = new SimpleObjectProperty((Object)this, "yoVariableNameDisplay", (Object)YoNameDisplay.SHORT_NAME);
    private Stage window;
    private SessionVisualizerToolkit toolkit;
    private SessionVisualizerTopics topics;
    private JavaFXMessager messager;
    private YoManager yoManager;

    public void initialize(SessionVisualizerToolkit toolkit) {
        this.toolkit = toolkit;
        this.messager = toolkit.getMessager();
        this.topics = toolkit.getTopics();
        this.yoManager = toolkit.getYoManager();
        Property numberPrecision = this.messager.createPropertyInput(this.topics.getControlsNumberPrecision(), (Object)3);
        this.yoCompositeListView.setCellFactory(param -> new YoCompositeListCell(this.yoManager, (ReadOnlyProperty<YoNameDisplay>)this.yoVariableNameDisplay, (Property<Integer>)numberPrecision, (ListView<YoComposite>)param));
        this.yoCompositeListView.getSelectionModel().setSelectionMode(SelectionMode.SINGLE);
        Function<ListView, MenuItem> newYoVariable = listView -> {
            FontIcon addAfterIcon = new FontIcon();
            addAfterIcon.getStyleClass().add((Object)"add-icon-view");
            MenuItem menuItem = new MenuItem("New YoComposite", (Node)addAfterIcon);
            menuItem.setOnAction(e -> this.newYoComposite());
            return menuItem;
        };
        Function<ListView, MenuItem> deleteYoVariable = listView -> {
            FontIcon removeIcon = new FontIcon();
            removeIcon.getStyleClass().add((Object)"remove-icon-view");
            MenuItem menuItem = new MenuItem("Delete YoComposite", (Node)removeIcon);
            menuItem.setOnAction(e -> this.deleteYoComposite((YoComposite)listView.getSelectionModel().getSelectedItem()));
            return menuItem;
        };
        MenuTools.setupContextMenu(this.yoCompositeListView, new Function[]{newYoVariable, deleteYoVariable});
        this.yoEquationEditorListView.setCellFactory(param -> new YoEquationListCell());
        toolkit.getSession().getYoEquationDefinitions().forEach(this::newEquation);
        this.yoEquationEditorListView.getSelectionModel().setSelectionMode(SelectionMode.SINGLE);
        this.yoEquationEditorListView.getSelectionModel().selectedItemProperty().addListener((o, oldValue, newValue) -> {
            if (newValue == null) {
                this.hideEquationEditorPane();
            } else {
                this.showEquationEditorPane((YoEquationEditorPaneController)newValue);
            }
        });
        this.messager.addFXTopicListener(this.topics.getSessionYoEquationListChangeState(), m -> {
            if (this.yoEquationEditorListView.getSelectionModel().getSelectedIndex() >= m.getEquations().size()) {
                this.yoEquationEditorListView.getSelectionModel().clearSelection();
            }
            for (int i = 0; i < m.getEquations().size(); ++i) {
                YoEquationDefinition equationDefinition = (YoEquationDefinition)m.getEquations().get(i);
                YoEquationEditorPaneController controller = (YoEquationEditorPaneController)this.yoEquationEditorListView.getItems().get(i);
                controller.definitionProperty().setValue((Object)equationDefinition);
            }
            this.yoEquationEditorListView.getItems().remove(m.getEquations().size(), this.yoEquationEditorListView.getItems().size());
        });
        MenuTools.setupContextMenu(this.yoEquationEditorListView, new Function[]{ListViewTools.removeMenuItemFactory(false)});
        this.window = new Stage(StageStyle.UTILITY);
        this.window.addEventHandler(KeyEvent.KEY_PRESSED, e -> {
            if (e.getCode() == KeyCode.ESCAPE) {
                this.window.close();
            }
        });
        toolkit.getMainWindow().addEventFilter(WindowEvent.WINDOW_CLOSE_REQUEST, e -> {
            if (!e.isConsumed()) {
                this.window.close();
            }
        });
        this.window.setTitle("YoEquation editor");
        this.window.setScene(new Scene((Parent)this.mainPane));
        this.window.initOwner((Window)toolkit.getMainWindow());
        this.refreshYoCompositeListView();
    }

    private void showEquationEditorPane(YoEquationEditorPaneController controller) {
        if (this.equationEditorContainer.getChildren().size() == 1) {
            this.equationEditorContainer.getChildren().add((Object)controller.getMainPane());
        } else {
            this.equationEditorContainer.getChildren().set(1, (Object)controller.getMainPane());
        }
        VBox.setVgrow((Node)controller.getMainPane(), (Priority)Priority.ALWAYS);
    }

    private void hideEquationEditorPane() {
        while (this.equationEditorContainer.getChildren().size() > 1) {
            this.equationEditorContainer.getChildren().remove(1);
        }
    }

    @FXML
    public void newYoComposite() {
        try {
            FXMLLoader loader = new FXMLLoader(SessionVisualizerIOTools.YO_COMPOSITE_CREATOR_DIALOG_URL);
            loader.load();
            YoCompositeCreatorDialogController yoCompositeCreatorDialogController = (YoCompositeCreatorDialogController)loader.getController();
            YoRegistry userRegistry = this.yoManager.getUserRegistry();
            YoComposite yoComposite = yoCompositeCreatorDialogController.showAndWait((Window)this.window, userRegistry);
            if (yoComposite != null) {
                this.refreshYoCompositeListView();
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public void deleteYoComposite(YoComposite selectedComposite) {
        if (selectedComposite == null) {
            return;
        }
        this.yoCompositeListView.getItems().remove((Object)selectedComposite);
        for (YoVariable yoVariable : selectedComposite.getYoComponents()) {
            yoVariable.destroy();
        }
    }

    private void refreshYoCompositeListView() {
        this.yoCompositeListView.getItems().clear();
        YoRegistry userRegistry = this.yoManager.getUserRegistry();
        userRegistry.getVariables().forEach(yoVariable -> this.yoCompositeListView.getItems().add((Object)new YoComposite(YoCompositeSearchManager.yoVariablePattern, (YoVariable)yoVariable)));
    }

    @FXML
    public void newEquation() {
        YoEquationDefinition newEquation = new YoEquationDefinition();
        newEquation.setName(NEW_EQUATION_NAME);
        newEquation.setEquation("a = b + c");
        int index = 0;
        while (!this.isEquationNameUnique(newEquation)) {
            newEquation.setName(NEW_EQUATION_NAME + "(%d)".formatted(index++));
        }
        this.newEquation(newEquation);
        this.yoEquationEditorListView.getSelectionModel().selectLast();
    }

    public void newEquation(YoEquationDefinition equation) {
        try {
            FXMLLoader loader = new FXMLLoader(SessionVisualizerIOTools.YO_EQUATION_EDITOR_PANE_URL);
            loader.load();
            YoEquationEditorPaneController yoEquationEditorPaneController = (YoEquationEditorPaneController)loader.getController();
            yoEquationEditorPaneController.initialize(this.toolkit, this::isEquationNameUnique);
            this.yoEquationEditorListView.getItems().add((Object)yoEquationEditorPaneController);
            yoEquationEditorPaneController.setUpdateListener(() -> {
                if (this.areAllEquationsValid()) {
                    this.messager.submitMessage(this.topics.getSessionYoEquationListChangeRequest(), (Object)YoEquationManager.YoEquationListChange.newList(this.collectEquationDefinitions()));
                }
            });
            yoEquationEditorPaneController.definitionProperty().setValue((Object)equation);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private boolean areAllEquationsValid() {
        ObservableList items = this.yoEquationEditorListView.getItems();
        return !items.isEmpty() && items.stream().allMatch(item -> item.validityProperty().get());
    }

    private boolean isEquationNameUnique(YoEquationDefinition query) {
        return this.yoEquationEditorListView.getItems().stream().map(YoEquationEditorPaneController::getDefinition).noneMatch(equation -> equation != query && Objects.equals(equation.getName(), query.getName()));
    }

    private List<YoEquationDefinition> collectEquationDefinitions() {
        return this.yoEquationEditorListView.getItems().stream().map(YoEquationEditorPaneController::getDefinition).toList();
    }

    public Pane getMainPane() {
        return this.mainPane;
    }

    public void showWindow() {
        this.window.setOpacity(0.0);
        this.window.toFront();
        this.window.show();
        Timeline timeline = new Timeline();
        KeyFrame key = new KeyFrame(Duration.seconds((double)0.125), new KeyValue[]{new KeyValue((WritableValue)this.window.opacityProperty(), (Object)1.0)});
        timeline.getKeyFrames().add((Object)key);
        timeline.play();
    }

    public Stage getWindow() {
        return this.window;
    }

    public void closeAndDispose() {
        this.window.close();
        this.yoEquationEditorListView.getItems().clear();
    }

    @FXML
    public void openHelpDialog() {
        try {
            FXMLLoader loader = new FXMLLoader(SessionVisualizerIOTools.YO_EQUATION_EDITOR_HELP_PANE_URL);
            loader.load();
            YoEquationEditorHelpPaneController controller = (YoEquationEditorHelpPaneController)loader.getController();
            controller.show((Window)this.window);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @FXML
    public void exportYoEquations() {
        File file = SessionVisualizerIOTools.yoEquationSaveFileDialog((Window)this.window);
        if (file == null) {
            return;
        }
        try (FileOutputStream outputStream = new FileOutputStream(file);){
            DefinitionIOTools.saveYoEquationListDefinition((OutputStream)outputStream, this.collectEquationDefinitions());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @FXML
    public void importYoEquations() {
        File file = SessionVisualizerIOTools.yoEquationOpenFileDialog((Window)this.window);
        if (file == null) {
            return;
        }
        try (FileInputStream inputStream = new FileInputStream(file);){
            YoEquationListDefinition yoEquationListDefinition = DefinitionIOTools.loadYoEquationListDefinition((InputStream)inputStream);
            if (yoEquationListDefinition == null) {
                return;
            }
            YoRegistry userRegistry = this.yoManager.getUserRegistry();
            for (YoEquationDefinition yoEquationDefinition : yoEquationListDefinition.getYoEquations()) {
                YoEquationManager.ensureUserAliasesExist((YoEquationDefinition)yoEquationDefinition, (YoRegistry)userRegistry);
                this.newEquation(yoEquationDefinition);
                this.refreshYoCompositeListView();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static class YoEquationListCell
    extends ListCell<YoEquationEditorPaneController> {
        private final Font equationFont = Font.font((String)Font.getDefault().getFamily(), (FontPosture)FontPosture.ITALIC, (double)12.0);

        private YoEquationListCell() {
        }

        protected void updateItem(YoEquationEditorPaneController item, boolean empty) {
            super.updateItem((Object)item, empty);
            this.textProperty().unbind();
            if (empty || item == null) {
                this.setGraphic(null);
                this.setText(null);
            } else {
                HBox graphic = new HBox(10.0);
                Label equationNameLabel = new Label();
                equationNameLabel.textProperty().bind((ObservableValue)item.getEquationNameTextField().textProperty());
                graphic.getChildren().add((Object)equationNameLabel);
                Label equationLabel = new Label();
                equationLabel.setFont(this.equationFont);
                equationLabel.textProperty().bind((ObservableValue)item.getEquationTextArea().textProperty());
                graphic.getChildren().add((Object)equationLabel);
                this.setGraphic((Node)graphic);
            }
        }
    }
}

