/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.scs2.sessionVisualizer.jfx.controllers.yoGraphic.graphic3D;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import javafx.beans.binding.Bindings;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.Property;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.value.ObservableBooleanValue;
import javafx.beans.value.ObservableValue;
import javafx.fxml.FXML;
import javafx.fxml.FXMLLoader;
import javafx.scene.control.Button;
import javafx.scene.control.CheckBox;
import javafx.scene.control.ComboBox;
import javafx.scene.control.Label;
import javafx.scene.control.ListCell;
import javafx.scene.control.RadioButton;
import javafx.scene.control.TextField;
import javafx.scene.control.Toggle;
import javafx.scene.control.ToggleGroup;
import javafx.stage.FileChooser;
import javafx.stage.Window;
import javafx.util.Pair;
import javafx.util.StringConverter;
import javax.xml.bind.JAXBException;
import org.jetbrains.annotations.NotNull;
import us.ihmc.log.LogTools;
import us.ihmc.scs2.definition.robot.JointDefinition;
import us.ihmc.scs2.definition.robot.OneDoFJointDefinition;
import us.ihmc.scs2.definition.robot.RobotDefinition;
import us.ihmc.scs2.definition.robot.sdf.SDFTools;
import us.ihmc.scs2.definition.robot.sdf.items.SDFModel;
import us.ihmc.scs2.definition.robot.sdf.items.SDFRoot;
import us.ihmc.scs2.definition.robot.urdf.URDFTools;
import us.ihmc.scs2.definition.robot.urdf.items.URDFModel;
import us.ihmc.scs2.definition.yoComposite.YoCompositeDefinition;
import us.ihmc.scs2.definition.yoComposite.YoCompositePatternDefinition;
import us.ihmc.scs2.definition.yoComposite.YoOrientation3DDefinition;
import us.ihmc.scs2.definition.yoGraphic.YoGraphic3DDefinition;
import us.ihmc.scs2.definition.yoGraphic.YoGraphicRobotDefinition;
import us.ihmc.scs2.sessionVisualizer.jfx.SessionVisualizerIOTools;
import us.ihmc.scs2.sessionVisualizer.jfx.controllers.editor.YoCompositeEditorPaneController;
import us.ihmc.scs2.sessionVisualizer.jfx.controllers.yoGraphic.graphic3D.YoGraphicFX3DEditorController;
import us.ihmc.scs2.sessionVisualizer.jfx.managers.SessionVisualizerToolkit;
import us.ihmc.scs2.sessionVisualizer.jfx.tools.CompositePropertyTools;
import us.ihmc.scs2.sessionVisualizer.jfx.tools.JavaFXMissingTools;
import us.ihmc.scs2.sessionVisualizer.jfx.yoComposite.YoCompositeCollection;
import us.ihmc.scs2.sessionVisualizer.jfx.yoComposite.YoCompositePattern;
import us.ihmc.scs2.sessionVisualizer.jfx.yoComposite.YoCompositeTools;
import us.ihmc.scs2.sessionVisualizer.jfx.yoGraphic.YoGhostRobotFX;
import us.ihmc.scs2.sessionVisualizer.jfx.yoGraphic.YoGraphicTools;
import us.ihmc.scs2.sessionVisualizer.jfx.yoGraphic.color.BaseColorFX;

public class YoGhostRobotFXEditorController
extends YoGraphicFX3DEditorController<YoGhostRobotFX> {
    private static final String ROBOT_MODEL_PATH_KEY = "ROBOT_MODEL_PATH";
    @FXML
    private RadioButton robotModelFromSessionRadioButton;
    @FXML
    private RadioButton robotModelFromFileRadioButton;
    @FXML
    private ComboBox<RobotDefinition> sessionRobotModelsComboBox;
    @FXML
    private TextField loadedRobotModelFileTextField;
    @FXML
    private Button browseRobotModelsButton;
    @FXML
    private YoCompositeEditorPaneController rootJointPositionEditorController;
    @FXML
    private YoCompositeEditorPaneController rootJointOrientationEditorController;
    @FXML
    private Label oneDoFJointsPlaceholderLabel;
    private YoCompositeEditorPaneController oneDoFJointPositionsEditorController;
    @FXML
    private CheckBox enableColorCheckBox;
    private YoGraphicRobotDefinition definitionBeforeEdits;
    private final Property<RobotDefinition> lastRobotModelFromFile = new SimpleObjectProperty((Object)this, "lastRobotModelFromFile", null);
    private final Property<RobotDefinition> selectedRobotModel = new SimpleObjectProperty((Object)this, "selectedRobotModel", null);
    private final Property<YoCompositePattern> oneDoFJointPattern = new SimpleObjectProperty((Object)this, "currentOneDoFJointPattern", null);
    private final BooleanProperty oneDoFJointPositionValidityProperty = new SimpleBooleanProperty((Object)this, "oneDoFJointPositionValidity", false);

    @Override
    public void initialize(SessionVisualizerToolkit toolkit, YoGhostRobotFX yoGraphicToEdit) {
        super.initialize(toolkit, yoGraphicToEdit);
        this.definitionBeforeEdits = YoGraphicTools.toYoGraphicRobotDefinition(yoGraphicToEdit);
        yoGraphicToEdit.visibleProperty().addListener((observable, oldValue, newValue) -> this.definitionBeforeEdits.setVisible(newValue.booleanValue()));
        this.robotModelFromSessionRadioButton.setSelected(true);
        new ToggleGroup().getToggles().addAll((Object[])new Toggle[]{this.robotModelFromSessionRadioButton, this.robotModelFromFileRadioButton});
        this.sessionRobotModelsComboBox.disableProperty().bind((ObservableValue)this.robotModelFromFileRadioButton.selectedProperty());
        this.loadedRobotModelFileTextField.disableProperty().bind((ObservableValue)this.robotModelFromSessionRadioButton.selectedProperty());
        this.browseRobotModelsButton.disableProperty().bind((ObservableValue)this.robotModelFromSessionRadioButton.selectedProperty());
        this.sessionRobotModelsComboBox.getItems().setAll(toolkit.getSessionRobotDefinitions());
        if (this.definitionBeforeEdits.getRobotDefinition() != null) {
            this.sessionRobotModelsComboBox.getSelectionModel().select((Object)this.definitionBeforeEdits.getRobotDefinition());
        }
        this.sessionRobotModelsComboBox.setCellFactory(param -> new ListCell<RobotDefinition>(){

            protected void updateItem(RobotDefinition item, boolean empty) {
                super.updateItem((Object)item, empty);
                if (empty || item == null) {
                    this.setText(null);
                } else {
                    this.setText(item.getName());
                }
            }
        });
        this.sessionRobotModelsComboBox.setConverter((StringConverter)new StringConverter<RobotDefinition>(){

            public String toString(RobotDefinition object) {
                return object == null ? "null" : object.getName();
            }

            public RobotDefinition fromString(String string) {
                return YoGhostRobotFXEditorController.this.sessionRobotModelsComboBox.getItems().stream().filter(r -> r.getName().equals(string)).findFirst().orElse(null);
            }
        });
        this.sessionRobotModelsComboBox.getSelectionModel().selectedItemProperty().addListener((o, oldValue, newValue) -> this.selectedRobotModel.setValue(newValue));
        this.robotModelFromSessionRadioButton.selectedProperty().addListener((o, oldValue, newValue) -> {
            if (newValue.booleanValue()) {
                this.selectedRobotModel.setValue((Object)((RobotDefinition)this.sessionRobotModelsComboBox.getSelectionModel().getSelectedItem()));
            }
        });
        this.robotModelFromFileRadioButton.selectedProperty().addListener((o, oldValue, newValue) -> {
            if (newValue.booleanValue()) {
                this.selectedRobotModel.setValue((Object)((RobotDefinition)this.lastRobotModelFromFile.getValue()));
            }
        });
        this.browseRobotModelsButton.setOnAction(e -> {
            Pair<File, RobotDefinition> fileRobotDefinitionPair = this.loadRobotModelFromFile();
            if (fileRobotDefinitionPair != null) {
                this.lastRobotModelFromFile.setValue((Object)((RobotDefinition)fileRobotDefinitionPair.getValue()));
                this.loadedRobotModelFileTextField.setText(((File)fileRobotDefinitionPair.getKey()).getAbsolutePath());
                this.selectedRobotModel.setValue((Object)((RobotDefinition)fileRobotDefinitionPair.getValue()));
            }
        });
        this.selectedRobotModel.addListener((o, oldValue, newValue) -> {
            if (newValue != null) {
                RobotDefinition robotDefinition = new RobotDefinition(newValue);
                yoGraphicToEdit.setRobotStateDefinition(null);
                yoGraphicToEdit.setRobotDefinition(robotDefinition);
                this.setRobotStateFields(robotDefinition, null);
                YoCompositePatternDefinition oneDoFJointPatternDefinition = YoGhostRobotFXEditorController.createOneDoFJointPatternDefinition(newValue);
                String newPatternType = oneDoFJointPatternDefinition.getName();
                YoCompositePattern currentPattern = (YoCompositePattern)this.oneDoFJointPattern.getValue();
                if (currentPattern != null && !Objects.equals(newPatternType, currentPattern.getType())) {
                    this.yoCompositeSearchManager.discardYoComposite(currentPattern.getType());
                }
                if (this.yoCompositeSearchManager.getCollectionFromType(newPatternType) == null) {
                    YoCompositePattern newPattern = YoCompositeTools.toYoCompositePattern(oneDoFJointPatternDefinition);
                    this.oneDoFJointPattern.setValue((Object)newPattern);
                    this.yoCompositeSearchManager.searchYoCompositeInBackground(newPattern, this::setupOneDoFJointPositionEditor);
                } else {
                    this.oneDoFJointPattern.setValue((Object)this.yoCompositeSearchManager.getPatternFromType(newPatternType));
                    this.setupOneDoFJointPositionEditor(this.yoCompositeSearchManager.getCollectionFromType(newPatternType));
                }
            }
        });
        this.setupCompositePropertyEditor(this.rootJointPositionEditorController, "Root Joint Position", false, "YoTuple3D", null);
        this.setupCompositePropertyEditor(this.rootJointOrientationEditorController, "Root Joint Orientation", false, "YoQuaternion", null);
        this.rootJointPositionEditorController.addInputListener(coordinates -> {
            YoGraphicRobotDefinition.YoRobotStateDefinition newState = new YoGraphicRobotDefinition.YoRobotStateDefinition(yoGraphicToEdit.getRobotStateDefinition());
            newState.setRootJointPosition(CompositePropertyTools.toYoTuple3DDefinition(coordinates));
            yoGraphicToEdit.setRobotStateDefinition(newState);
        });
        this.rootJointOrientationEditorController.addInputListener(orientation -> {
            YoGraphicRobotDefinition.YoRobotStateDefinition newState = new YoGraphicRobotDefinition.YoRobotStateDefinition(yoGraphicToEdit.getRobotStateDefinition());
            newState.setRootJointOrientation((YoOrientation3DDefinition)CompositePropertyTools.toYoQuaternionDefinition(orientation));
            yoGraphicToEdit.setRobotStateDefinition(newState);
        });
        this.inputsValidityProperty = Bindings.and((ObservableBooleanValue)this.inputsValidityProperty, (ObservableBooleanValue)this.oneDoFJointPositionValidityProperty);
        this.enableColorCheckBox.setSelected(this.definitionBeforeEdits.getColor() != null);
        this.styleEditorController.getMainPane().setDisable(!this.enableColorCheckBox.isSelected());
        this.styleEditorController.bindYoGraphicFX3D(yoGraphicToEdit);
        this.enableColorCheckBox.selectedProperty().addListener((o, oldValue, newValue) -> {
            this.styleEditorController.getMainPane().setDisable(newValue == false);
            if (!newValue.booleanValue()) {
                yoGraphicToEdit.setColor((BaseColorFX)null);
            } else {
                yoGraphicToEdit.setColor((BaseColorFX)this.styleEditorController.colorProperty().get());
            }
        });
        this.resetFields();
    }

    private void setupOneDoFJointPositionEditor(YoCompositeCollection collection) {
        JavaFXMissingTools.runLaterIfNeeded(this.getClass(), () -> this.setupOneDoFJointPositionEditorNow(collection));
    }

    private void setupOneDoFJointPositionEditorNow(YoCompositeCollection collection) {
        int index = this.oneDoFJointPositionsEditorController != null ? this.mainPane.getChildren().indexOf((Object)this.oneDoFJointPositionsEditorController.getMainPane()) : this.mainPane.getChildren().indexOf((Object)this.oneDoFJointsPlaceholderLabel);
        FXMLLoader fxmlLoader = new FXMLLoader(SessionVisualizerIOTools.YO_COMPOSITE_EDITOR_URL);
        try {
            fxmlLoader.load();
            this.oneDoFJointPositionsEditorController = (YoCompositeEditorPaneController)fxmlLoader.getController();
            this.setupCompositePropertyEditor(this.oneDoFJointPositionsEditorController, "One DoF Joint Positions", false, collection.getPattern().getType(), null);
            this.oneDoFJointPositionsEditorController.addInputListener(positions -> {
                YoGraphicRobotDefinition.YoRobotStateDefinition newState = new YoGraphicRobotDefinition.YoRobotStateDefinition(((YoGhostRobotFX)this.yoGraphicToEdit).getRobotStateDefinition());
                List oneDoFJoints = ((YoGhostRobotFX)this.yoGraphicToEdit).getRobotDefinition().getAllOneDoFJoints();
                if (oneDoFJoints.size() != ((DoubleProperty[])positions).length) {
                    LogTools.warn((String)"Mismatch in the number of 1-DoF joints: expected={}, actual={}", (Object)oneDoFJoints.size(), (Object)((DoubleProperty[])positions).length);
                    return;
                }
                ArrayList<YoGraphicRobotDefinition.YoOneDoFJointStateDefinition> newOneDoFJointStates = new ArrayList<YoGraphicRobotDefinition.YoOneDoFJointStateDefinition>(oneDoFJoints.size());
                for (int i = 0; i < oneDoFJoints.size(); ++i) {
                    YoGraphicRobotDefinition.YoOneDoFJointStateDefinition newOneDoFJointState = new YoGraphicRobotDefinition.YoOneDoFJointStateDefinition();
                    newOneDoFJointState.setJointName(((OneDoFJointDefinition)oneDoFJoints.get(i)).getName());
                    newOneDoFJointState.setJointPosition(CompositePropertyTools.toDoublePropertyName(positions[i]));
                    newOneDoFJointStates.add(newOneDoFJointState);
                }
                newState.setJointPositions(newOneDoFJointStates);
                ((YoGhostRobotFX)this.yoGraphicToEdit).setRobotStateDefinition(newState);
            });
            this.oneDoFJointPositionsEditorController.addInputNotification(() -> this.updateHasChangesPendingProperty(null, null, null));
            this.oneDoFJointPositionValidityProperty.bind((ObservableValue)this.oneDoFJointPositionsEditorController.inputsValidityProperty());
            this.mainPane.getChildren().set(index, (Object)this.oneDoFJointPositionsEditorController.getMainPane());
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @NotNull
    private static YoCompositePatternDefinition createOneDoFJointPatternDefinition(RobotDefinition newValue) {
        YoCompositePatternDefinition oneDoFJointPatternDefinition = new YoCompositePatternDefinition();
        List oneDoFJoints = newValue.getAllOneDoFJoints();
        oneDoFJointPatternDefinition.setName(newValue.getName() + "OneDoFJoints[%d]".formatted(oneDoFJoints.size()));
        oneDoFJointPatternDefinition.setIdentifiers((String[])oneDoFJoints.stream().map(JointDefinition::getName).toArray(String[]::new));
        oneDoFJointPatternDefinition.setCrossRegistry(true);
        return oneDoFJointPatternDefinition;
    }

    @Override
    public void resetFields() {
        this.enableColorCheckBox.setSelected(this.definitionBeforeEdits.getColor() != null);
        this.styleEditorController.setInput((YoGraphic3DDefinition)this.definitionBeforeEdits);
        this.nameEditorController.setInput(this.definitionBeforeEdits.getName(), ((YoGhostRobotFX)this.yoGraphicToEdit).getNamespace());
        RobotDefinition robotDefinition = this.definitionBeforeEdits.getRobotDefinition();
        if (robotDefinition != null) {
            if (this.loadedRobotModelFileTextField.getText().isBlank() || !Objects.equals(robotDefinition, this.lastRobotModelFromFile.getValue())) {
                if (!this.sessionRobotModelsComboBox.getItems().contains((Object)robotDefinition)) {
                    boolean hasHomonym = this.sessionRobotModelsComboBox.getItems().stream().anyMatch(r -> r.getName().equals(robotDefinition.getName()));
                    if (hasHomonym) {
                        robotDefinition.setName("%s-Imported-DoFs[%d]".formatted(robotDefinition.getName(), robotDefinition.getAllOneDoFJoints().size()));
                    }
                    this.sessionRobotModelsComboBox.getItems().add((Object)robotDefinition);
                    this.sessionRobotModelsComboBox.getSelectionModel().select((Object)robotDefinition);
                } else {
                    this.sessionRobotModelsComboBox.getSelectionModel().select((Object)robotDefinition);
                }
                this.robotModelFromSessionRadioButton.setSelected(true);
            }
        } else {
            this.robotModelFromSessionRadioButton.setSelected(true);
        }
        this.setRobotStateFields(robotDefinition, this.definitionBeforeEdits.getRobotStateDefinition());
    }

    private void setRobotStateFields(RobotDefinition robotDefinition, YoGraphicRobotDefinition.YoRobotStateDefinition robotStateDefinition) {
        if (robotDefinition == null) {
            this.rootJointPositionEditorController.clearInput();
            this.rootJointOrientationEditorController.clearInput();
            if (this.oneDoFJointPositionsEditorController != null) {
                int index = this.mainPane.getChildren().indexOf((Object)this.oneDoFJointPositionsEditorController.getMainPane());
                this.mainPane.getChildren().set(index, (Object)this.oneDoFJointsPlaceholderLabel);
                this.oneDoFJointPositionsEditorController = null;
            }
            return;
        }
        if (robotStateDefinition == null) {
            this.rootJointPositionEditorController.clearInput();
            this.rootJointOrientationEditorController.clearInput();
        } else {
            this.rootJointPositionEditorController.setInput((YoCompositeDefinition)robotStateDefinition.getRootJointPosition());
            this.rootJointOrientationEditorController.setInput((YoCompositeDefinition)robotStateDefinition.getRootJointOrientation());
        }
        YoCompositePatternDefinition patternDefinition = YoGhostRobotFXEditorController.createOneDoFJointPatternDefinition(robotDefinition);
        if (this.oneDoFJointPositionsEditorController != null && this.oneDoFJointPattern.getValue() != null && patternDefinition.getName().equals(((YoCompositePattern)this.oneDoFJointPattern.getValue()).getType())) {
            if (robotStateDefinition == null) {
                this.oneDoFJointPositionsEditorController.clearInput();
            } else {
                this.oneDoFJointPositionsEditorController.setInput((String[])robotStateDefinition.getJointPositions().stream().map(YoGraphicRobotDefinition.YoOneDoFJointStateDefinition::getJointPosition).toArray(String[]::new));
            }
        } else {
            YoCompositePattern newPattern = YoCompositeTools.toYoCompositePattern(patternDefinition);
            this.oneDoFJointPattern.setValue((Object)newPattern);
            if (this.yoCompositeSearchManager.getCollectionFromType(newPattern.getType()) == null) {
                this.yoCompositeSearchManager.searchYoCompositeNow(newPattern, this::setupOneDoFJointPositionEditor);
            } else {
                this.setupOneDoFJointPositionEditor(this.yoCompositeSearchManager.getCollectionFromType(newPattern.getType()));
            }
        }
        if (robotStateDefinition == null) {
            this.oneDoFJointPositionsEditorController.clearInput();
        } else {
            this.oneDoFJointPositionsEditorController.setInput((String[])robotStateDefinition.getJointPositions().stream().map(YoGraphicRobotDefinition.YoOneDoFJointStateDefinition::getJointPosition).toArray(String[]::new));
        }
    }

    @Override
    public void saveChanges() {
        this.definitionBeforeEdits = YoGraphicTools.toYoGraphicRobotDefinition((YoGhostRobotFX)this.yoGraphicToEdit);
        this.hasChangesPendingProperty.set(false);
    }

    @Override
    public boolean hasChangesPending() {
        return super.hasChangesPending();
    }

    @Override
    protected <T> void updateHasChangesPendingProperty(ObservableValue<? extends T> observable, T oldValue, T newValue) {
        this.hasChangesPendingProperty.set(!this.definitionBeforeEdits.equals((Object)YoGraphicTools.toYoGraphicRobotDefinition((YoGhostRobotFX)this.yoGraphicToEdit)));
    }

    private Pair<File, RobotDefinition> loadRobotModelFromFile() {
        File result = SessionVisualizerIOTools.showOpenDialog((Window)this.toolkit.getMainWindow(), "Load Robot Model", List.of(new FileChooser.ExtensionFilter("All Model Files", new String[]{"*.urdf", "*.sdf"}), new FileChooser.ExtensionFilter("URDF Files", new String[]{"*.urdf"}), new FileChooser.ExtensionFilter("SDF Files", new String[]{"*.sdf"})), ROBOT_MODEL_PATH_KEY);
        if (result == null) {
            return null;
        }
        ClassLoader resourceClassLoader = null;
        try {
            resourceClassLoader = YoGhostRobotFXEditorController.createResourceClassLoader(result);
        }
        catch (MalformedURLException e) {
            throw new RuntimeException(e);
        }
        BufferedInputStream inputStream = null;
        try {
            inputStream = new BufferedInputStream(new FileInputStream(result));
        }
        catch (FileNotFoundException e) {
            throw new RuntimeException(e);
        }
        if (result.getName().toLowerCase().endsWith("urdf")) {
            try {
                URDFModel urdfModel = URDFTools.loadURDFModel((InputStream)inputStream, Collections.emptyList(), (ClassLoader)resourceClassLoader);
                RobotDefinition robotDefinition = URDFTools.toRobotDefinition((URDFModel)urdfModel);
                robotDefinition.setResourceClassLoader(resourceClassLoader);
                return new Pair((Object)result, (Object)robotDefinition);
            }
            catch (JAXBException e) {
                throw new RuntimeException(e);
            }
        }
        if (result.getName().toLowerCase().endsWith("sdf")) {
            try {
                SDFRoot sdfRoot = SDFTools.loadSDFRoot((InputStream)inputStream, Collections.emptyList(), (ClassLoader)resourceClassLoader);
                RobotDefinition robotDefinition = SDFTools.toFloatingRobotDefinition((SDFModel)((SDFModel)sdfRoot.getModels().get(0)));
                robotDefinition.setResourceClassLoader(resourceClassLoader);
                return new Pair((Object)result, (Object)robotDefinition);
            }
            catch (JAXBException e) {
                throw new RuntimeException(e);
            }
        }
        return null;
    }

    private static ClassLoader createResourceClassLoader(File modelFile) throws MalformedURLException {
        ArrayList<URL> resourceURLs = new ArrayList<URL>();
        resourceURLs.add(modelFile.getParentFile().toURI().normalize().toURL());
        File candidate = modelFile.getParentFile();
        for (int i = 0; i < 3 && (candidate = candidate.getParentFile()) != null; ++i) {
            if (!candidate.getName().equals("models")) continue;
            resourceURLs.add(candidate.toURI().normalize().toURL());
            break;
        }
        return new URLClassLoader((URL[])resourceURLs.toArray(URL[]::new));
    }
}

