/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.scs2.sessionVisualizer.jfx.controllers.camera;

import java.util.ArrayList;
import java.util.List;
import java.util.function.DoubleUnaryOperator;
import java.util.function.Predicate;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleDoubleProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableNumberValue;
import javafx.beans.value.ObservableValue;
import javafx.event.EventHandler;
import javafx.scene.Node;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyEvent;
import javafx.scene.transform.Transform;
import us.ihmc.euclid.matrix.RotationMatrix;
import us.ihmc.euclid.tools.EuclidCoreFactories;
import us.ihmc.euclid.tuple3D.Vector3D;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DBasics;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Vector3DBasics;
import us.ihmc.euclid.tuple3D.interfaces.Vector3DReadOnly;
import us.ihmc.scs2.sessionVisualizer.jfx.tools.JavaFXMissingTools;
import us.ihmc.scs2.sessionVisualizer.jfx.tools.TranslateSCS2;
import us.ihmc.scs2.sessionVisualizer.jfx.yoComposite.Tuple3DProperty;

public class CameraFocalPointHandler {
    private final TranslateSCS2 focalPointTranslation = new TranslateSCS2();
    private final TranslateSCS2 offsetTranslation = new TranslateSCS2();
    private final ObjectProperty<Transform> cameraOrientation = new SimpleObjectProperty((Object)this, "cameraOrientation", null);
    private final BooleanProperty keepTranslationLeveled = new SimpleBooleanProperty((Object)this, "keepTranslationLeveled", true);
    private final ObjectProperty<Predicate<KeyEvent>> fastModifierPredicate = new SimpleObjectProperty((Object)this, "fastModifierPredicate", null);
    private final DoubleProperty slowModifier = new SimpleDoubleProperty((Object)this, "slowModifier", 0.0075);
    private final DoubleProperty fastModifier = new SimpleDoubleProperty((Object)this, "fastModifier", 0.0125);
    private DoubleUnaryOperator translationRateModifier;
    private final ObjectProperty<KeyCode> forwardKey = new SimpleObjectProperty((Object)this, "forwardKey", (Object)KeyCode.W);
    private final ObjectProperty<KeyCode> backwardKey = new SimpleObjectProperty((Object)this, "backwardKey", (Object)KeyCode.S);
    private final ObjectProperty<KeyCode> leftKey = new SimpleObjectProperty((Object)this, "leftKey", (Object)KeyCode.A);
    private final ObjectProperty<KeyCode> rightKey = new SimpleObjectProperty((Object)this, "rightKey", (Object)KeyCode.D);
    private final ObjectProperty<KeyCode> upKey = new SimpleObjectProperty((Object)this, "upKey", (Object)KeyCode.Q);
    private final ObjectProperty<KeyCode> downKey = new SimpleObjectProperty((Object)this, "downKey", (Object)KeyCode.Z);
    private final ObjectProperty<TrackingTargetType> targetType = new SimpleObjectProperty((Object)this, "", (Object)TrackingTargetType.Disabled);
    private final ObjectProperty<Tuple3DProperty> coordinatesTracked = new SimpleObjectProperty((Object)this, "coordinatesTracked", null);
    private final ObjectProperty<Node> nodeTracked = new SimpleObjectProperty((Object)this, "nodeTracked", null);
    private final TranslateSCS2 trackingTranslate = new TranslateSCS2();
    private final ChangeListener<Transform> nodeTrackingListener = (o, oldTransform, newTransform) -> {
        if (this.targetType.get() == TrackingTargetType.Node) {
            this.trackingTranslate.setFrom((Transform)newTransform);
        }
    };
    private final Vector3DReadOnly down;
    private final List<Runnable> updateTasks = new ArrayList<Runnable>();

    public CameraFocalPointHandler(Vector3DReadOnly up) {
        this.down = EuclidCoreFactories.newNegativeLinkedVector3D((Vector3DReadOnly)up);
        this.targetType.addListener((o, oldValue, newValue) -> {
            if (newValue == TrackingTargetType.Disabled) {
                this.offsetTranslation.set((Tuple3DReadOnly)this.trackingTranslate);
                this.trackingTranslate.setToZero();
            }
        });
        this.nodeTracked.addListener((o, oldValue, newValue) -> {
            if (oldValue != null) {
                oldValue.localToSceneTransformProperty().removeListener(this.nodeTrackingListener);
            }
            if (newValue != null) {
                this.targetType.set((Object)TrackingTargetType.Node);
                this.offsetTranslation.setToZero();
                newValue.localToSceneTransformProperty().addListener(this.nodeTrackingListener);
                this.nodeTrackingListener.changed(null, null, (Object)newValue.getLocalToSceneTransform());
            } else if (this.targetType.get() == TrackingTargetType.Node) {
                this.disableTracking();
            }
        });
        this.coordinatesTracked.addListener((ChangeListener)new ChangeListener<Tuple3DProperty>(){
            private final ChangeListener<Number> trackingTranslateUpdater = (o, oldValue, newValue) -> CameraFocalPointHandler.this.trackingTranslate.set((Tuple3DReadOnly)CameraFocalPointHandler.this.coordinatesTracked.get());

            public void changed(ObservableValue<? extends Tuple3DProperty> o, Tuple3DProperty oldValue, Tuple3DProperty newValue) {
                if (newValue != null) {
                    CameraFocalPointHandler.this.targetType.set((Object)TrackingTargetType.YoCoordinates);
                    CameraFocalPointHandler.this.offsetTranslation.setToZero();
                    newValue.xProperty().addListener(this.trackingTranslateUpdater);
                    newValue.yProperty().addListener(this.trackingTranslateUpdater);
                    newValue.zProperty().addListener(this.trackingTranslateUpdater);
                } else if (CameraFocalPointHandler.this.targetType.get() == TrackingTargetType.YoCoordinates) {
                    CameraFocalPointHandler.this.disableTracking();
                }
                if (oldValue != null) {
                    oldValue.xProperty().removeListener(this.trackingTranslateUpdater);
                    oldValue.yProperty().removeListener(this.trackingTranslateUpdater);
                    oldValue.zProperty().removeListener(this.trackingTranslateUpdater);
                }
            }
        });
        this.focalPointTranslation.xProperty().bind((ObservableValue)this.trackingTranslate.xProperty().add((ObservableNumberValue)this.offsetTranslation.xProperty()));
        this.focalPointTranslation.yProperty().bind((ObservableValue)this.trackingTranslate.yProperty().add((ObservableNumberValue)this.offsetTranslation.yProperty()));
        this.focalPointTranslation.zProperty().bind((ObservableValue)this.trackingTranslate.zProperty().add((ObservableNumberValue)this.offsetTranslation.zProperty()));
    }

    public void disableTracking() {
        this.targetType.set((Object)TrackingTargetType.Disabled);
    }

    public boolean isTrackingDisabled() {
        return this.targetType.get() == TrackingTargetType.Disabled;
    }

    public void update() {
        for (int i = 0; i < this.updateTasks.size(); ++i) {
            this.updateTasks.get(i).run();
        }
    }

    public FocalPointKeyEventHandler createKeyEventHandler() {
        FocalPointKeyEventHandler keyEventHandler = new FocalPointKeyEventHandler();
        this.updateTasks.add(() -> keyEventHandler.update());
        return keyEventHandler;
    }

    public void toWorldFrame(Vector3DReadOnly inCameraFrame, Vector3DBasics outWorldFrame) {
        outWorldFrame.set((Tuple3DReadOnly)inCameraFrame);
        if (outWorldFrame.getX() == 0.0 && outWorldFrame.getY() == 0.0 && outWorldFrame.getZ() == 0.0) {
            return;
        }
        if (this.cameraOrientation.get() == null) {
            return;
        }
        if (this.keepTranslationLeveled.get()) {
            double mxz = ((Transform)this.cameraOrientation.get()).getMxz();
            double myz = ((Transform)this.cameraOrientation.get()).getMyz();
            double mzz = ((Transform)this.cameraOrientation.get()).getMzz();
            Vector3D cameraZAxis = new Vector3D(mxz, myz, mzz);
            Vector3D xAxisLeveled = new Vector3D();
            xAxisLeveled.cross((Tuple3DReadOnly)this.down, (Tuple3DReadOnly)cameraZAxis);
            xAxisLeveled.normalize();
            Vector3D yAxisLeveled = new Vector3D((Tuple3DReadOnly)this.down);
            Vector3D zAxisLeveled = new Vector3D();
            zAxisLeveled.cross((Tuple3DReadOnly)xAxisLeveled, (Tuple3DReadOnly)yAxisLeveled);
            RotationMatrix rotation = new RotationMatrix();
            rotation.setColumns((Tuple3DReadOnly)xAxisLeveled, (Tuple3DReadOnly)yAxisLeveled, (Tuple3DReadOnly)zAxisLeveled);
            rotation.transform((Tuple3DBasics)outWorldFrame);
        } else {
            JavaFXMissingTools.applyTranform((Transform)this.cameraOrientation.get(), outWorldFrame);
        }
    }

    public void translateCameraFrame(Vector3DReadOnly translationOffset) {
        this.translateCameraFrame(translationOffset.getX(), translationOffset.getY(), translationOffset.getZ());
    }

    public void translateCameraFrame(double dx, double dy, double dz) {
        if (this.cameraOrientation.get() == null) {
            this.translateWorldFrame(dx, dy, dz);
            return;
        }
        Vector3D shift = new Vector3D(dx, dy, dz);
        if (this.keepTranslationLeveled.get()) {
            double mxz = ((Transform)this.cameraOrientation.get()).getMxz();
            double myz = ((Transform)this.cameraOrientation.get()).getMyz();
            double mzz = ((Transform)this.cameraOrientation.get()).getMzz();
            Vector3D cameraZAxis = new Vector3D(mxz, myz, mzz);
            Vector3D xAxisLeveled = new Vector3D();
            xAxisLeveled.cross((Tuple3DReadOnly)this.down, (Tuple3DReadOnly)cameraZAxis);
            xAxisLeveled.normalize();
            Vector3D yAxisLeveled = new Vector3D((Tuple3DReadOnly)this.down);
            Vector3D zAxisLeveled = new Vector3D();
            zAxisLeveled.cross((Tuple3DReadOnly)xAxisLeveled, (Tuple3DReadOnly)yAxisLeveled);
            RotationMatrix rotation = new RotationMatrix();
            rotation.setColumns((Tuple3DReadOnly)xAxisLeveled, (Tuple3DReadOnly)yAxisLeveled, (Tuple3DReadOnly)zAxisLeveled);
            rotation.transform((Tuple3DBasics)shift);
        } else {
            JavaFXMissingTools.applyTranform((Transform)this.cameraOrientation.get(), (Vector3DBasics)shift);
        }
        this.offsetTranslation.add((Tuple3DReadOnly)shift);
    }

    public void translateWorldFrame(Tuple3DReadOnly translation) {
        this.translateWorldFrame(translation.getX(), translation.getY(), translation.getZ());
    }

    public void translateWorldFrame(double dx, double dy, double dz) {
        if (Double.isFinite(dx)) {
            this.offsetTranslation.addX(dx);
        }
        if (Double.isFinite(dy)) {
            this.offsetTranslation.addY(dy);
        }
        if (Double.isFinite(dz)) {
            this.offsetTranslation.addZ(dz);
        }
    }

    public void setPositionWorldFrame(Tuple3DReadOnly position) {
        this.setPositionWorldFrame(position.getX(), position.getY(), position.getZ());
    }

    public void setPositionWorldFrame(double x, double y, double z) {
        if (Double.isFinite(x)) {
            this.offsetTranslation.setX(x);
            if (this.targetType.get() != TrackingTargetType.Disabled) {
                this.offsetTranslation.subX(this.trackingTranslate.getX());
            }
        }
        if (Double.isFinite(y)) {
            this.offsetTranslation.setY(y);
            if (this.targetType.get() != TrackingTargetType.Disabled) {
                this.offsetTranslation.subY(this.trackingTranslate.getY());
            }
        }
        if (Double.isFinite(z)) {
            this.offsetTranslation.setZ(z);
            if (this.targetType.get() != TrackingTargetType.Disabled) {
                this.offsetTranslation.subZ(this.trackingTranslate.getZ());
            }
        }
    }

    public void setCameraOrientation(Transform cameraOrientation) {
        this.cameraOrientation.set((Object)cameraOrientation);
    }

    public void setTranslationRateModifier(DoubleUnaryOperator translationRateModifier) {
        this.translationRateModifier = translationRateModifier;
    }

    public TranslateSCS2 getTranslation() {
        return this.focalPointTranslation;
    }

    public TranslateSCS2 getOffsetTranslation() {
        return this.offsetTranslation;
    }

    public final BooleanProperty keepTranslationLeveledProperty() {
        return this.keepTranslationLeveled;
    }

    public final ObjectProperty<Predicate<KeyEvent>> fastModifierPredicateProperty() {
        return this.fastModifierPredicate;
    }

    public final DoubleProperty slowModifierProperty() {
        return this.slowModifier;
    }

    public final DoubleProperty fastModifierProperty() {
        return this.fastModifier;
    }

    public final ObjectProperty<KeyCode> forwardKeyProperty() {
        return this.forwardKey;
    }

    public final ObjectProperty<KeyCode> backwardKeyProperty() {
        return this.backwardKey;
    }

    public final ObjectProperty<KeyCode> leftKeyProperty() {
        return this.leftKey;
    }

    public final ObjectProperty<KeyCode> rightKeyProperty() {
        return this.rightKey;
    }

    public final ObjectProperty<KeyCode> upKeyProperty() {
        return this.upKey;
    }

    public final ObjectProperty<KeyCode> downKeyProperty() {
        return this.downKey;
    }

    public TranslateSCS2 getTrackingTranslate() {
        return this.trackingTranslate;
    }

    public ObjectProperty<TrackingTargetType> targetTypeProperty() {
        return this.targetType;
    }

    public ObjectProperty<Tuple3DProperty> coordinatesToTrackProperty() {
        return this.coordinatesTracked;
    }

    public ObjectProperty<Node> nodeToTrackProperty() {
        return this.nodeTracked;
    }

    public static enum TrackingTargetType {
        Disabled,
        Node,
        YoCoordinates;

    }

    public class FocalPointKeyEventHandler
    implements EventHandler<KeyEvent> {
        private boolean isTranslating = false;
        private final Vector3D activeTranslationCameraFrame = new Vector3D();
        private final Vector3D activeTranslationWorldFrame = new Vector3D();

        private void update() {
            CameraFocalPointHandler.this.translateWorldFrame((Tuple3DReadOnly)this.activeTranslationWorldFrame);
        }

        public void handle(KeyEvent event) {
            boolean isKeyReleased;
            double modifier = CameraFocalPointHandler.this.fastModifierPredicate.get() == null || !((Predicate)CameraFocalPointHandler.this.fastModifierPredicate.get()).test(event) ? CameraFocalPointHandler.this.slowModifier.get() : CameraFocalPointHandler.this.fastModifier.get();
            if (CameraFocalPointHandler.this.translationRateModifier != null) {
                modifier = CameraFocalPointHandler.this.translationRateModifier.applyAsDouble(modifier);
            }
            KeyCode keyDown = event.getCode();
            boolean bl = isKeyReleased = event.getEventType() == KeyEvent.KEY_RELEASED;
            if (keyDown == CameraFocalPointHandler.this.forwardKey.get()) {
                this.activeTranslationCameraFrame.setZ(isKeyReleased ? 0.0 : modifier);
            }
            if (keyDown == CameraFocalPointHandler.this.backwardKey.get()) {
                this.activeTranslationCameraFrame.setZ(isKeyReleased ? 0.0 : -modifier);
            }
            if (keyDown == CameraFocalPointHandler.this.rightKey.get()) {
                this.activeTranslationCameraFrame.setX(isKeyReleased ? 0.0 : modifier);
            }
            if (keyDown == CameraFocalPointHandler.this.leftKey.get()) {
                this.activeTranslationCameraFrame.setX(isKeyReleased ? 0.0 : -modifier);
            }
            if (keyDown == CameraFocalPointHandler.this.downKey.get()) {
                this.activeTranslationCameraFrame.setY(isKeyReleased ? 0.0 : modifier);
            }
            if (keyDown == CameraFocalPointHandler.this.upKey.get()) {
                this.activeTranslationCameraFrame.setY(isKeyReleased ? 0.0 : -modifier);
            }
            this.isTranslating = this.activeTranslationCameraFrame.getX() != 0.0 || this.activeTranslationCameraFrame.getY() != 0.0 || this.activeTranslationCameraFrame.getZ() != 0.0;
            CameraFocalPointHandler.this.toWorldFrame((Vector3DReadOnly)this.activeTranslationCameraFrame, (Vector3DBasics)this.activeTranslationWorldFrame);
        }

        public boolean isTranslating() {
            return this.isTranslating;
        }

        public Vector3DReadOnly getActiveTranslationCameraFrame() {
            return this.activeTranslationCameraFrame;
        }

        public Vector3DReadOnly getActiveTranslationWorldFrame() {
            return this.activeTranslationWorldFrame;
        }
    }
}

