/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.scs2.sessionVisualizer.jfx.charts;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import us.ihmc.scs2.sessionVisualizer.jfx.charts.ChartIdentifier;

public class ChartGroupModel {
    private final String name;
    private final List<ChartIdentifier> chartIdentifiers;

    public ChartGroupModel(String name) {
        this(name, new ArrayList<ChartIdentifier>());
    }

    public ChartGroupModel(ChartGroupModel other) {
        this.name = other.name;
        this.chartIdentifiers = new ArrayList<ChartIdentifier>(other.chartIdentifiers);
    }

    public ChartGroupModel(String name, List<ChartIdentifier> chartIdentifiers) {
        this.name = name;
        this.chartIdentifiers = chartIdentifiers;
    }

    public void clear() {
        this.chartIdentifiers.clear();
    }

    public int size() {
        return this.chartIdentifiers.size();
    }

    public boolean add(ChartIdentifier chartIdentifier) {
        return this.chartIdentifiers.add(chartIdentifier);
    }

    public boolean remove(ChartIdentifier chartIdentifier) {
        return this.chartIdentifiers.remove(chartIdentifier);
    }

    public String getName() {
        return this.name;
    }

    public List<ChartIdentifier> getChartIdentifiers() {
        return this.chartIdentifiers;
    }

    public int rowStart() {
        return this.chartIdentifiers.stream().mapToInt(ChartIdentifier::getRow).min().orElse(-1);
    }

    public int rowEnd() {
        return this.chartIdentifiers.stream().mapToInt(ChartIdentifier::getRow).max().orElse(-1);
    }

    public int rowSpan() {
        return this.rowEnd() - this.rowStart();
    }

    public int columnStart() {
        return this.chartIdentifiers.stream().mapToInt(ChartIdentifier::getColumn).min().orElse(-1);
    }

    public int columnEnd() {
        return this.chartIdentifiers.stream().mapToInt(ChartIdentifier::getColumn).max().orElse(-1);
    }

    public int columnSpan() {
        return this.columnEnd() - this.columnStart();
    }

    public ChartGroupModel shift(int rowShift, int columnShift) {
        return new ChartGroupModel(this.name, this.chartIdentifiers.stream().map(id -> id.shift(rowShift, columnShift)).collect(Collectors.toList()));
    }

    public int hashCode() {
        return this.chartIdentifiers.hashCode();
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object instanceof ChartGroupModel) {
            ChartGroupModel other = (ChartGroupModel)object;
            return this.chartIdentifiers.equals(other.chartIdentifiers);
        }
        return false;
    }

    public String toString() {
        return this.name + ": " + this.chartIdentifiers.toString();
    }
}

