/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.scs2.sessionVisualizer.jfx.controllers.yoGraphic.graphic3D;

import javafx.beans.value.ObservableValue;
import javafx.fxml.FXML;
import javafx.scene.control.TextField;
import javafx.scene.image.ImageView;
import us.ihmc.scs2.definition.yoComposite.YoCompositeDefinition;
import us.ihmc.scs2.definition.yoGraphic.YoGraphic3DDefinition;
import us.ihmc.scs2.definition.yoGraphic.YoGraphicCoordinateSystem3DDefinition;
import us.ihmc.scs2.sessionVisualizer.jfx.controllers.editor.YoCompositeEditorPaneController;
import us.ihmc.scs2.sessionVisualizer.jfx.controllers.yoGraphic.graphic3D.YoGraphicFX3DEditorController;
import us.ihmc.scs2.sessionVisualizer.jfx.managers.SessionVisualizerToolkit;
import us.ihmc.scs2.sessionVisualizer.jfx.yoGraphic.YoCoordinateSystemFX3D;
import us.ihmc.scs2.sessionVisualizer.jfx.yoGraphic.YoGraphicTools;

public class YoCoordinateSystemFX3DEditorController
extends YoGraphicFX3DEditorController<YoCoordinateSystemFX3D> {
    @FXML
    private YoCompositeEditorPaneController positionEditorController;
    @FXML
    private YoCompositeEditorPaneController orientationEditorController;
    @FXML
    private TextField bodyLengthTextField;
    @FXML
    private TextField headLengthTextField;
    @FXML
    private TextField bodyRadiusTextField;
    @FXML
    private TextField headRadiusTextField;
    @FXML
    private ImageView bodyLengthValidImageView;
    @FXML
    private ImageView headLengthValidImageView;
    @FXML
    private ImageView bodyRadiusValidImageView;
    @FXML
    private ImageView headRadiusValidImageView;
    private YoGraphicCoordinateSystem3DDefinition definitionBeforeEdits;

    @Override
    public void initialize(SessionVisualizerToolkit toolkit, YoCoordinateSystemFX3D yoGraphicToEdit) {
        super.initialize(toolkit, yoGraphicToEdit);
        this.definitionBeforeEdits = YoGraphicTools.toYoGraphicCoordinateSystem3DDefinition(yoGraphicToEdit);
        yoGraphicToEdit.visibleProperty().addListener((observable, oldValue, newValue) -> this.definitionBeforeEdits.setVisible(newValue.booleanValue()));
        this.setupTuple3DPropertyEditor(this.positionEditorController, "Position", true, yoGraphicToEdit.getPosition());
        this.setupOrientation3DProperty(this.orientationEditorController, "Orientation", true, yoGraphicToEdit.getOrientation());
        this.setupDoublePropertyEditor(this.bodyLengthTextField, this.bodyLengthValidImageView, YoCoordinateSystemFX3D::setBodyLength);
        this.setupDoublePropertyEditor(this.headLengthTextField, this.headLengthValidImageView, YoCoordinateSystemFX3D::setHeadLength);
        this.setupDoublePropertyEditor(this.bodyRadiusTextField, this.bodyRadiusValidImageView, YoCoordinateSystemFX3D::setBodyRadius);
        this.setupDoublePropertyEditor(this.headRadiusTextField, this.headRadiusValidImageView, YoCoordinateSystemFX3D::setHeadRadius);
        this.resetFields();
    }

    @Override
    public <T> void updateHasChangesPendingProperty(ObservableValue<? extends T> observable, T oldValue, T newValue) {
        this.hasChangesPendingProperty.set(!this.definitionBeforeEdits.equals((Object)YoGraphicTools.toYoGraphicCoordinateSystem3DDefinition((YoCoordinateSystemFX3D)this.yoGraphicToEdit)));
    }

    @Override
    public void resetFields() {
        this.positionEditorController.setInput((YoCompositeDefinition)this.definitionBeforeEdits.getPosition());
        this.orientationEditorController.setInput((YoCompositeDefinition)this.definitionBeforeEdits.getOrientation());
        this.bodyLengthTextField.setText(this.definitionBeforeEdits.getBodyLength());
        this.headLengthTextField.setText(this.definitionBeforeEdits.getHeadLength());
        this.bodyRadiusTextField.setText(this.definitionBeforeEdits.getBodyRadius());
        this.headRadiusTextField.setText(this.definitionBeforeEdits.getHeadRadius());
        this.styleEditorController.setInput((YoGraphic3DDefinition)this.definitionBeforeEdits);
        this.nameEditorController.setInput(this.definitionBeforeEdits.getName(), ((YoCoordinateSystemFX3D)this.yoGraphicToEdit).getNamespace());
    }

    @Override
    public void saveChanges() {
        this.definitionBeforeEdits = YoGraphicTools.toYoGraphicCoordinateSystem3DDefinition((YoCoordinateSystemFX3D)this.yoGraphicToEdit);
        this.hasChangesPendingProperty.set(false);
    }
}

