/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.scs2.sessionVisualizer.jfx.controllers;

import com.jfoenix.controls.JFXTreeTableColumn;
import com.jfoenix.controls.RecursiveTreeItem;
import com.jfoenix.controls.datamodels.treetable.RecursiveTreeObject;
import java.util.function.Function;
import javafx.animation.KeyFrame;
import javafx.animation.KeyValue;
import javafx.animation.Timeline;
import javafx.beans.property.Property;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;
import javafx.beans.value.ObservableValue;
import javafx.beans.value.WritableValue;
import javafx.collections.FXCollections;
import javafx.fxml.FXML;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.control.TreeItem;
import javafx.scene.control.TreeTableColumn;
import javafx.scene.control.TreeTableView;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyEvent;
import javafx.scene.layout.AnchorPane;
import javafx.stage.Stage;
import javafx.stage.Window;
import javafx.stage.WindowEvent;
import javafx.util.Duration;
import us.ihmc.scs2.sessionVisualizer.jfx.SessionVisualizerIOTools;
import us.ihmc.scs2.sessionVisualizer.jfx.managers.SessionVisualizerToolkit;
import us.ihmc.yoVariables.registry.YoRegistry;

public class YoRegistryStatisticsPaneController {
    @FXML
    private AnchorPane mainAnchorPane;
    @FXML
    private TreeTableView<YoRegistryInfo> treeTableView;
    private TreeItem<YoRegistryInfo> rootTreeItem;
    private Stage window;

    public void initialize(SessionVisualizerToolkit toolkit) {
        TreeTableColumn nameCol = this.createColumn("Registry", 300.0, 200.0, 800.0, YoRegistryInfo::getName);
        TreeTableColumn nVarsShallowCol = this.createColumn("Number of\nvariables\n(shallow)", 100.0, YoRegistryInfo::getNumberOfVariablesShallow);
        TreeTableColumn nVarsDeepCol = this.createColumn("Number of\nvariables\n(deep)", 100.0, YoRegistryInfo::getNumberOfVariablesDeep);
        TreeTableColumn nChildShallowCol = this.createColumn("Number of\nchildren\n(shallow)", 100.0, YoRegistryInfo::getNumberOfChildrenShallow);
        nameCol.setStyle("-fx-alignment:center-left");
        nVarsShallowCol.setStyle("-fx-alignment:center-right");
        nVarsDeepCol.setStyle("-fx-alignment:center-right");
        nChildShallowCol.setStyle("-fx-alignment:center-right");
        this.rootTreeItem = new RecursiveTreeItem(FXCollections.observableArrayList(), RecursiveTreeObject::getChildren);
        this.treeTableView.setRoot(this.rootTreeItem);
        this.treeTableView.setShowRoot(false);
        this.treeTableView.getColumns().setAll((Object[])new TreeTableColumn[]{nameCol, nVarsShallowCol, nVarsDeepCol, nChildShallowCol});
        this.window = new Stage();
        this.window.addEventHandler(KeyEvent.KEY_PRESSED, e -> {
            if (e.getCode() == KeyCode.ESCAPE) {
                this.close();
            }
        });
        toolkit.getMainWindow().addEventFilter(WindowEvent.WINDOW_CLOSE_REQUEST, e -> {
            if (!e.isConsumed()) {
                this.close();
            }
        });
        this.window.setTitle("YoRegistry statistics");
        SessionVisualizerIOTools.addSCSIconToWindow((Window)this.window);
        this.window.setScene(new Scene((Parent)this.mainAnchorPane));
        this.window.initOwner((Window)toolkit.getMainWindow());
    }

    public void setInput(YoRegistry registry) {
        this.rootTreeItem.getChildren().clear();
        YoRegistryStatisticsPaneController.addRegistryRecurvise(this.rootTreeItem, registry);
        this.window.setTitle(registry.getName() + " YoRegistry statistics");
    }

    private static void addRegistryRecurvise(TreeItem<YoRegistryInfo> parentTreeItem, YoRegistry registryToAdd) {
        TreeItem treeItem = new TreeItem((Object)new YoRegistryInfo(registryToAdd));
        for (YoRegistry childRegistry : registryToAdd.getChildren()) {
            YoRegistryStatisticsPaneController.addRegistryRecurvise((TreeItem<YoRegistryInfo>)treeItem, childRegistry);
        }
        parentTreeItem.getChildren().add((Object)treeItem);
    }

    private <T> TreeTableColumn<YoRegistryInfo, T> createColumn(String name, double prefWidth, Function<YoRegistryInfo, Property<T>> fieldProvider) {
        return this.createColumn(name, prefWidth, prefWidth, prefWidth, fieldProvider);
    }

    private <T> TreeTableColumn<YoRegistryInfo, T> createColumn(String name, double prefWidth, double minWidth, double maxWidth, Function<YoRegistryInfo, Property<T>> fieldProvider) {
        JFXTreeTableColumn column = new JFXTreeTableColumn(name);
        column.setPrefWidth(prefWidth);
        column.setMinWidth(minWidth);
        column.setMaxWidth(maxWidth);
        column.setCellValueFactory(param -> (ObservableValue)fieldProvider.apply((YoRegistryInfo)((Object)((Object)param.getValue().getValue()))));
        return column;
    }

    public void close() {
        this.window.close();
    }

    public void showWindow() {
        this.window.setOpacity(0.0);
        this.window.toFront();
        this.window.show();
        Timeline timeline = new Timeline();
        KeyFrame key = new KeyFrame(Duration.seconds((double)0.125), new KeyValue[]{new KeyValue((WritableValue)this.window.opacityProperty(), (Object)1.0)});
        timeline.getKeyFrames().add((Object)key);
        timeline.play();
    }

    public Stage getWindow() {
        return this.window;
    }

    private static class YoRegistryInfo
    extends RecursiveTreeObject<YoRegistryInfo> {
        private final StringProperty name = new SimpleStringProperty((Object)this, "registryName", null);
        private final Property<Integer> numberOfVariablesShallow = new SimpleObjectProperty((Object)this, "numberOfVariablesShallow", (Object)-1);
        private final Property<Integer> numberOfVariablesDeep = new SimpleObjectProperty((Object)this, "numberOfVariablesDeep", (Object)-1);
        private final Property<Integer> numberOfChildrenShallow = new SimpleObjectProperty((Object)this, "numberOfChildrenShallow", (Object)-1);

        public YoRegistryInfo(YoRegistry registry) {
            this.name.set((Object)registry.getName());
            this.numberOfVariablesShallow.setValue((Object)registry.getNumberOfVariables());
            this.numberOfVariablesDeep.setValue((Object)registry.getNumberOfVariablesDeep());
            this.numberOfChildrenShallow.setValue((Object)registry.getChildren().size());
        }

        public StringProperty getName() {
            return this.name;
        }

        public Property<Integer> getNumberOfVariablesShallow() {
            return this.numberOfVariablesShallow;
        }

        public Property<Integer> getNumberOfVariablesDeep() {
            return this.numberOfVariablesDeep;
        }

        public Property<Integer> getNumberOfChildrenShallow() {
            return this.numberOfChildrenShallow;
        }
    }
}

