/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.scs2.sessionVisualizer.jfx;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.SimpleDoubleProperty;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.geometry.Point3D;
import javafx.geometry.Rectangle2D;
import javafx.scene.Camera;
import javafx.scene.Group;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import javafx.scene.transform.Affine;
import javafx.scene.transform.Rotate;
import javafx.scene.transform.Transform;
import javafx.scene.transform.Translate;
import us.ihmc.log.LogTools;
import us.ihmc.scs2.sessionVisualizer.jfx.SessionVisualizerIOTools;

public class Skybox
extends Group {
    private final Translate translate = new Translate();
    private final DoubleProperty size = new SimpleDoubleProperty((Object)this, "size", 100000.0);
    private final Affine backAffine = new Affine();
    private final Affine frontAffine = new Affine();
    private final Affine topAffine = new Affine();
    private final Affine bottomAffine = new Affine();
    private final Affine leftAffine = new Affine();
    private final Affine rightAffine = new Affine();
    private final ImageView topView = new ImageView();
    private final ImageView bottomView = new ImageView();
    private final ImageView leftView = new ImageView();
    private final ImageView rightView = new ImageView();
    private final ImageView backView = new ImageView();
    private final ImageView frontView = new ImageView();
    private final ImageView[] views = new ImageView[]{this.topView, this.leftView, this.backView, this.rightView, this.frontView, this.bottomView};
    private Camera camera;
    private ChangeListener<Transform> cameraMotionListener = (observable, oldValue, newValue) -> {
        this.translate.setX(newValue.getTx());
        this.translate.setY(newValue.getTy());
        this.translate.setZ(newValue.getTz());
    };

    public Skybox() {
        for (ImageView view : this.views) {
            view.setSmooth(true);
            view.setPreserveRatio(true);
            view.fitWidthProperty().bind((ObservableValue)this.size);
            view.fitHeightProperty().bind((ObservableValue)this.size);
        }
        this.updateTransforms(this.size.get());
        this.backView.getTransforms().addAll((Object[])new Transform[]{this.backAffine});
        this.frontView.getTransforms().addAll((Object[])new Transform[]{this.frontAffine});
        this.topView.getTransforms().addAll((Object[])new Transform[]{this.topAffine});
        this.bottomView.getTransforms().addAll((Object[])new Transform[]{this.bottomAffine});
        this.leftView.getTransforms().addAll((Object[])new Transform[]{this.leftAffine});
        this.rightView.getTransforms().addAll((Object[])new Transform[]{this.rightAffine});
        this.getTransforms().add((Object)this.translate);
        this.getChildren().addAll((Object[])this.views);
        this.setMouseTransparent(true);
    }

    private void updateTransforms(double size) {
        this.backAffine.setToIdentity();
        this.backAffine.appendTranslation(-0.5 * size, -0.5 * size, 0.5 * size);
        this.backAffine.appendRotation(90.0, Point3D.ZERO, Rotate.Z_AXIS);
        this.backAffine.appendRotation(-90.0, Point3D.ZERO, Rotate.X_AXIS);
        this.frontAffine.setToIdentity();
        this.frontAffine.appendTranslation(0.5 * size, 0.5 * size, 0.5 * size);
        this.frontAffine.appendRotation(-90.0, Point3D.ZERO, Rotate.Z_AXIS);
        this.frontAffine.appendRotation(-90.0, Point3D.ZERO, Rotate.X_AXIS);
        this.topAffine.setToIdentity();
        this.topAffine.appendTranslation(-0.5 * size, 0.5 * size, 0.5 * size);
        this.topAffine.appendRotation(-90.0, Point3D.ZERO, Rotate.Z_AXIS);
        this.bottomAffine.setToIdentity();
        this.bottomAffine.appendTranslation(0.5 * size, 0.5 * size, -0.5 * size);
        this.bottomAffine.appendRotation(180.0, Point3D.ZERO, Rotate.X_AXIS);
        this.bottomAffine.appendRotation(90.0, Point3D.ZERO, Rotate.Z_AXIS);
        this.leftAffine.setToIdentity();
        this.leftAffine.appendTranslation(-0.5 * size, 0.5 * size, 0.5 * size);
        this.leftAffine.appendRotation(-90.0, Point3D.ZERO, Rotate.X_AXIS);
        this.rightAffine.setToIdentity();
        this.rightAffine.appendTranslation(0.5 * size, -0.5 * size, 0.5 * size);
        this.rightAffine.appendRotation(180.0, Point3D.ZERO, Rotate.Z_AXIS);
        this.rightAffine.appendRotation(-90.0, Point3D.ZERO, Rotate.X_AXIS);
    }

    public void setupSkybox(Image skybox) {
        int sideSize;
        if (skybox.getWidth() / 4.0 != skybox.getHeight() / 3.0) {
            throw new IllegalArgumentException("Unexpected size ratio");
        }
        int topX = sideSize = (int)(skybox.getWidth() - skybox.getHeight());
        int bottomX = sideSize;
        boolean leftX = false;
        int frontX = 3 * sideSize;
        int rightX = 2 * sideSize;
        int backX = 1 * sideSize;
        boolean topY = false;
        int bottomY = 2 * sideSize;
        int leftY = sideSize;
        int rightY = sideSize;
        int frontY = sideSize;
        int backY = sideSize;
        this.backView.setImage(skybox);
        this.frontView.setImage(skybox);
        this.topView.setImage(skybox);
        this.bottomView.setImage(skybox);
        this.leftView.setImage(skybox);
        this.rightView.setImage(skybox);
        this.topView.setViewport(new Rectangle2D((double)topX, (double)topY, (double)sideSize, (double)sideSize));
        this.bottomView.setViewport(new Rectangle2D((double)bottomX, (double)bottomY, (double)sideSize, (double)sideSize));
        this.leftView.setViewport(new Rectangle2D((double)leftX, (double)leftY, (double)sideSize, (double)sideSize));
        this.backView.setViewport(new Rectangle2D((double)frontX, (double)frontY, (double)sideSize, (double)sideSize));
        this.rightView.setViewport(new Rectangle2D((double)rightX, (double)rightY, (double)sideSize, (double)sideSize));
        this.frontView.setViewport(new Rectangle2D((double)backX, (double)backY, (double)sideSize, (double)sideSize));
    }

    public void setupSkybox(Image topImage, Image bottomImage, Image leftImage, Image rightImage, Image frontImage, Image backImage) {
        this.backView.setImage(backImage);
        this.frontView.setImage(frontImage);
        this.topView.setImage(topImage);
        this.bottomView.setImage(bottomImage);
        this.leftView.setImage(leftImage);
        this.rightView.setImage(rightImage);
    }

    public boolean loadSkyboxFlexible(File file) {
        if (!file.exists()) {
            LogTools.warn((String)("File: " + file.getAbsolutePath() + " does not exist."));
            return false;
        }
        if (file.isDirectory()) {
            File[] imageFiles = new File[6];
            for (String extension : new String[]{".png", ".jpg", ".bmp"}) {
                if (!this.findSkyboxImageFiles(file, extension, imageFiles, false)) continue;
                return this.loadSkyboxFromImageFiles(imageFiles);
            }
            LogTools.warn((String)"Could not find skybox images in (%s).".formatted(file.getAbsolutePath()));
            return false;
        }
        return this.loadSkyboxFromSingleImageFile(file);
    }

    public boolean loadSkyboxFromSingleImageFile(File file) {
        if (!file.exists()) {
            LogTools.warn((String)("File: " + file.getAbsolutePath() + " does not exist."));
            return false;
        }
        if (file.isDirectory()) {
            LogTools.warn((String)("Given file: " + file.getAbsolutePath() + " is a directory."));
            return false;
        }
        Image image = Skybox.loadImage(file);
        if (image == null) {
            return false;
        }
        this.setupSkybox(image);
        return true;
    }

    public boolean loadSkyboxFromDirectory(File directory, String fileExtension) {
        if (!directory.exists()) {
            LogTools.warn((String)("Directory: " + directory.getAbsolutePath() + " does not exist."));
            return false;
        }
        if (!directory.isDirectory()) {
            LogTools.warn((String)("Given file: " + directory.getAbsolutePath() + " is not a directory."));
            return false;
        }
        File[] imageFiles = new File[6];
        if (!this.findSkyboxImageFiles(directory, fileExtension, imageFiles, true)) {
            return false;
        }
        return this.loadSkyboxFromImageFiles(imageFiles);
    }

    public boolean loadSkyboxFromImageFiles(File[] imageFiles) {
        File topFile = imageFiles[0];
        File bottomFile = imageFiles[1];
        File leftFile = imageFiles[2];
        File rightFile = imageFiles[3];
        File frontFile = imageFiles[4];
        File backFile = imageFiles[5];
        return this.loadSkyboxFromImageFiles(topFile, bottomFile, leftFile, rightFile, frontFile, backFile);
    }

    public boolean loadSkyboxFromImageFiles(File topFile, File bottomFile, File leftFile, File rightFile, File frontFile, File backFile) {
        Image topImage = Skybox.loadImage(topFile);
        Image bottomImage = Skybox.loadImage(bottomFile);
        Image leftImage = Skybox.loadImage(leftFile);
        Image rightImage = Skybox.loadImage(rightFile);
        Image frontImage = Skybox.loadImage(frontFile);
        Image backImage = Skybox.loadImage(backFile);
        if (topImage == null || bottomImage == null || leftImage == null || rightImage == null || frontImage == null || backImage == null) {
            return false;
        }
        this.setupSkybox(topImage, bottomImage, leftImage, rightImage, frontImage, backImage);
        return true;
    }

    public boolean findSkyboxImageFiles(File directory, String fileExtension, File[] imageFiles, boolean printWarnings) {
        String topName = "Up." + fileExtension;
        String bottomName = "Down." + fileExtension;
        String leftName = "Left." + fileExtension;
        String rightName = "Right." + fileExtension;
        String frontName = "Front." + fileExtension;
        String backName = "Back." + fileExtension;
        String[] filenames = new String[]{topName, bottomName, leftName, rightName, frontName, backName};
        for (int i = 0; i < filenames.length; ++i) {
            String filename = filenames[i];
            File[] result = directory.listFiles(name -> name.getName().equalsIgnoreCase(filename));
            if (result.length == 0) {
                if (printWarnings) {
                    LogTools.warn((String)"Could not find the file for (%s) image of the skybox.".formatted(filename));
                }
                return false;
            }
            imageFiles[i] = result[0];
        }
        return true;
    }

    public boolean loadSkyboxFromResource(String directoryPath, String fileExtension) {
        Image topImage = Skybox.loadImage(SessionVisualizerIOTools.getSkyboxResource(directoryPath + "/Up." + fileExtension));
        Image bottomImage = Skybox.loadImage(SessionVisualizerIOTools.getSkyboxResource(directoryPath + "/Down." + fileExtension));
        Image leftImage = Skybox.loadImage(SessionVisualizerIOTools.getSkyboxResource(directoryPath + "/Left." + fileExtension));
        Image rightImage = Skybox.loadImage(SessionVisualizerIOTools.getSkyboxResource(directoryPath + "/Right." + fileExtension));
        Image frontImage = Skybox.loadImage(SessionVisualizerIOTools.getSkyboxResource(directoryPath + "/Front." + fileExtension));
        Image backImage = Skybox.loadImage(SessionVisualizerIOTools.getSkyboxResource(directoryPath + "/Back." + fileExtension));
        if (topImage == null || bottomImage == null || leftImage == null || rightImage == null || frontImage == null || backImage == null) {
            return false;
        }
        this.setupSkybox(topImage, bottomImage, leftImage, rightImage, frontImage, backImage);
        return true;
    }

    private static Image loadImage(File file) {
        if (file == null) {
            return null;
        }
        try {
            return Skybox.loadImage(new FileInputStream(file));
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
            return null;
        }
    }

    private static Image loadImage(InputStream is) {
        if (is == null) {
            return null;
        }
        Image image = new Image(is);
        try {
            is.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return image;
    }

    public void setupCloudyCrown() {
        Image topImage = SessionVisualizerIOTools.SKYBOX_TOP_IMAGE;
        Image bottomImage = SessionVisualizerIOTools.SKYBOX_BOTTOM_IMAGE;
        Image leftImage = SessionVisualizerIOTools.SKYBOX_LEFT_IMAGE;
        Image rightImage = SessionVisualizerIOTools.SKYBOX_RIGHT_IMAGE;
        Image frontImage = SessionVisualizerIOTools.SKYBOX_FRONT_IMAGE;
        Image backImage = SessionVisualizerIOTools.SKYBOX_BACK_IMAGE;
        this.setupSkybox(topImage, bottomImage, leftImage, rightImage, frontImage, backImage);
    }

    public void setupSCS1Skybox() {
        Image topImage = SessionVisualizerIOTools.SCS1_SKYBOX_TOP_IMAGE;
        Image bottomImage = SessionVisualizerIOTools.SCS1_SKYBOX_BOTTOM_IMAGE;
        Image leftImage = SessionVisualizerIOTools.SCS1_SKYBOX_LEFT_IMAGE;
        Image rightImage = SessionVisualizerIOTools.SCS1_SKYBOX_RIGHT_IMAGE;
        Image frontImage = SessionVisualizerIOTools.SCS1_SKYBOX_FRONT_IMAGE;
        Image backImage = SessionVisualizerIOTools.SCS1_SKYBOX_BACK_IMAGE;
        this.setupSkybox(topImage, bottomImage, leftImage, rightImage, frontImage, backImage);
    }

    public void setupCamera(Camera camera) {
        if (this.camera != null) {
            this.camera.localToSceneTransformProperty().removeListener(this.cameraMotionListener);
        }
        this.camera = camera;
        if (camera != null) {
            camera.localToSceneTransformProperty().addListener(this.cameraMotionListener);
        }
    }

    public void setSize(double size) {
        this.size.set(size);
    }

    public double getSize() {
        return this.size.get();
    }

    public DoubleProperty sizeProperty() {
        return this.size;
    }

    public void dispose() {
        this.setupCamera(null);
        for (ImageView view : this.views) {
            view.setImage(null);
        }
    }

    public static enum SkyboxTheme {
        CLOUDY_CROWN_MIDDAY,
        SCS1,
        OFF,
        CUSTOM;

    }
}

