/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.scs2.sessionVisualizer.jfx.tools;

import java.util.HashMap;
import java.util.concurrent.atomic.AtomicReference;
import javafx.animation.AnimationTimer;
import javafx.beans.property.Property;
import us.ihmc.messager.MessagerAPIFactory;
import us.ihmc.messager.javafx.SharedMemoryJavaFXMessager;
import us.ihmc.scs2.sessionVisualizer.jfx.tools.JavaFXMissingTools;
import us.ihmc.scs2.sessionVisualizer.jfx.tools.ObservedAnimationTimer;

public class SCS2JavaFXMessager
extends SharedMemoryJavaFXMessager {
    private final AnimationTimer animationTimer;
    private final HashMap<MessagerAPIFactory.Topic<?>, AtomicReference<?>> internalBuffer = new HashMap();

    public SCS2JavaFXMessager(MessagerAPIFactory.MessagerAPI messagerAPI) {
        super(messagerAPI, true);
        this.animationTimer = new ObservedAnimationTimer(((Object)((Object)this)).getClass().getSimpleName()){

            @Override
            public void handleImpl(long now) {
                SCS2JavaFXMessager.this.updateFXTopicListeners();
            }
        };
        for (MessagerAPIFactory.Topic topic : messagerAPI.getAllTopics()) {
            this.internalBuffer.put(topic, super.createInput(topic, null));
        }
    }

    public void startMessager() {
        super.startMessager();
        this.animationTimer.start();
    }

    public void closeMessager() {
        this.animationTimer.stop();
        super.closeMessager();
    }

    protected void runFXLater(Runnable fxTask) {
        JavaFXMissingTools.runLater(((Object)((Object)this)).getClass(), fxTask);
    }

    protected void runFXAndWait(Runnable fxTask) {
        JavaFXMissingTools.runAndWait(((Object)((Object)this)).getClass(), fxTask);
    }

    public <T> T getLastValue(MessagerAPIFactory.Topic<T> topic) {
        return (T)this.internalBuffer.get(topic).get();
    }

    public <T> AtomicReference<T> createInput(MessagerAPIFactory.Topic<T> topic, T defaultValue) {
        if (defaultValue == null) {
            return super.createInput(topic, this.internalBuffer.get(topic).get());
        }
        return super.createInput(topic, defaultValue);
    }

    public <T> Property<T> createPropertyInput(MessagerAPIFactory.Topic<T> topic, T initialValue) {
        if (initialValue == null) {
            return super.createPropertyInput(topic, this.internalBuffer.get(topic).get());
        }
        return super.createPropertyInput(topic, initialValue);
    }
}

