/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.scs2.sessionVisualizer.jfx.session.log;

import com.jfoenix.controls.JFXTrimSlider;
import java.io.File;
import java.io.IOException;
import java.util.List;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.function.ToLongFunction;
import java.util.stream.Collectors;
import javafx.beans.binding.StringBinding;
import javafx.beans.property.LongProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleLongProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableLongValue;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.fxml.FXML;
import javafx.fxml.FXMLLoader;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.control.Button;
import javafx.scene.control.ComboBox;
import javafx.scene.control.Label;
import javafx.scene.control.ProgressIndicator;
import javafx.scene.control.TitledPane;
import javafx.scene.control.ToggleButton;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.AnchorPane;
import javafx.scene.layout.FlowPane;
import javafx.scene.layout.Pane;
import javafx.stage.DirectoryChooser;
import javafx.stage.FileChooser;
import javafx.stage.Stage;
import javafx.stage.Window;
import javafx.stage.WindowEvent;
import us.ihmc.log.LogTools;
import us.ihmc.messager.javafx.JavaFXMessager;
import us.ihmc.robotDataLogger.LogProperties;
import us.ihmc.robotDataLogger.logger.LogPropertiesReader;
import us.ihmc.scs2.session.Session;
import us.ihmc.scs2.session.log.LogDataReader;
import us.ihmc.scs2.session.log.LogSession;
import us.ihmc.scs2.sessionVisualizer.jfx.SessionVisualizerIOTools;
import us.ihmc.scs2.sessionVisualizer.jfx.SessionVisualizerTopics;
import us.ihmc.scs2.sessionVisualizer.jfx.controllers.SessionVariableFilterPaneController;
import us.ihmc.scs2.sessionVisualizer.jfx.managers.BackgroundExecutorManager;
import us.ihmc.scs2.sessionVisualizer.jfx.managers.SessionVisualizerToolkit;
import us.ihmc.scs2.sessionVisualizer.jfx.session.SessionControlsController;
import us.ihmc.scs2.sessionVisualizer.jfx.session.log.LogCropProgressController;
import us.ihmc.scs2.sessionVisualizer.jfx.session.log.MultiVideoDataReader;
import us.ihmc.scs2.sessionVisualizer.jfx.session.log.MultiVideoViewer;
import us.ihmc.scs2.sessionVisualizer.jfx.session.log.YoVariableLogCropper;
import us.ihmc.scs2.sessionVisualizer.jfx.tools.JavaFXMissingTools;
import us.ihmc.scs2.sharedMemory.interfaces.YoBufferPropertiesReadOnly;
import us.ihmc.yoVariables.registry.YoRegistry;
import us.ihmc.yoVariables.variable.YoVariable;

public class LogSessionManagerController
implements SessionControlsController {
    private static final double THUMBNAIL_WIDTH = 200.0;
    private static final String LOG_FILE_KEY = "logFilePath";
    @FXML
    private AnchorPane mainPane;
    @FXML
    private ProgressIndicator loadingSpinner;
    @FXML
    private Button openSessionButton;
    @FXML
    private Button endSessionButton;
    @FXML
    private Label sessionNameLabel;
    @FXML
    private Label dateLabel;
    @FXML
    private Label logPathLabel;
    @FXML
    private Pane cropControlsContainer;
    @FXML
    private ToggleButton showTrimsButton;
    @FXML
    private Button startTrimToCurrentButton;
    @FXML
    private Button endTrimToCurrentButton;
    @FXML
    private Button resetTrimsButton;
    @FXML
    private Button cropAndExportButton;
    @FXML
    private ToggleButton enableVariableFilterToggleButton;
    @FXML
    private ComboBox<OutputFormat> outputFormatComboBox;
    @FXML
    private JFXTrimSlider logPositionSlider;
    @FXML
    private Pane cropProgressMonitorPane;
    @FXML
    private TitledPane thumbnailsTitledPane;
    @FXML
    private FlowPane videoThumbnailPane;
    private final ObjectProperty<MultiVideoViewer> multiVideoViewerProperty = new SimpleObjectProperty((Object)this, "multiVideoThumbnailViewer", null);
    private final ObjectProperty<LogSession> activeSessionProperty = new SimpleObjectProperty((Object)this, "activeSession", null);
    private final ObjectProperty<YoVariableLogCropper> logCropperProperty = new SimpleObjectProperty((Object)this, "logCropper", null);
    private BackgroundExecutorManager backgroundExecutorManager;
    private final ObjectProperty<SessionVariableFilterPaneController> variableFilterControllerProperty = new SimpleObjectProperty(null);
    private Stage stage;
    private SessionVisualizerTopics topics;
    private JavaFXMessager messager;

    @Override
    public void initialize(SessionVisualizerToolkit toolkit) {
        this.stage = new Stage();
        this.topics = toolkit.getTopics();
        this.messager = toolkit.getMessager();
        this.backgroundExecutorManager = toolkit.getBackgroundExecutorManager();
        this.logPositionSlider.setValueFactory(param -> new TimeStringBinding(param.valueProperty(), position -> {
            if (this.activeSessionProperty.get() == null) {
                return 0L;
            }
            LogDataReader logDataReader = ((LogSession)this.activeSessionProperty.get()).getLogDataReader();
            return logDataReader.getRelativeTimestamp(position.intValue());
        }));
        ChangeListener activeSessionListener = (o, oldValue, newValue) -> {
            if (oldValue != null) {
                LogDataReader logDataReader = oldValue.getLogDataReader();
                logDataReader.getTimestamp().removeListeners();
            }
            if (newValue == null) {
                this.clearControls();
            } else {
                this.messager.submitMessage(this.topics.getStartNewSessionRequest(), newValue);
                this.initializeControls((LogSession)newValue);
            }
        };
        AtomicBoolean logPositionUpdate = new AtomicBoolean(true);
        this.logPositionSlider.valueProperty().addListener((o, oldValue, newValue) -> {
            LogSession logSession = (LogSession)this.activeSessionProperty.get();
            if (logSession == null || logPositionUpdate.get()) {
                return;
            }
            logSession.submitLogPositionRequest(newValue.intValue());
        });
        AtomicBoolean sliderFeedbackEnabled = new AtomicBoolean(true);
        this.logPositionSlider.addEventFilter(MouseEvent.MOUSE_PRESSED, e -> sliderFeedbackEnabled.set(false));
        this.logPositionSlider.addEventFilter(MouseEvent.MOUSE_DRAGGED, e -> sliderFeedbackEnabled.set(false));
        this.logPositionSlider.addEventFilter(MouseEvent.MOUSE_RELEASED, e -> sliderFeedbackEnabled.set(true));
        Consumer<YoBufferPropertiesReadOnly> logPositionUpdateListener = properties -> {
            LogSession logSession = (LogSession)this.activeSessionProperty.get();
            if (sliderFeedbackEnabled.get()) {
                int currentLogPosition = logSession.getLogDataReader().getCurrentLogPosition();
                JavaFXMissingTools.runLater(this.getClass(), () -> {
                    if (logSession == null || logSession.getLogDataReader() == null) {
                        return;
                    }
                    if (currentLogPosition != this.logPositionSlider.valueProperty().intValue()) {
                        logPositionUpdate.set(true);
                        this.logPositionSlider.setValue((double)currentLogPosition);
                        logPositionUpdate.set(false);
                    }
                });
            }
        };
        this.activeSessionProperty.addListener((o, oldValue, newValue) -> {
            if (oldValue != null) {
                oldValue.removeCurrentBufferPropertiesListener(logPositionUpdateListener);
            }
            if (newValue != null) {
                newValue.addCurrentBufferPropertiesListener(logPositionUpdateListener);
            }
        });
        this.multiVideoViewerProperty.addListener((o, oldValue, newValue) -> {
            if (oldValue != null) {
                oldValue.stop();
            }
            if (newValue != null) {
                newValue.start();
            }
        });
        Session session = toolkit.getSession();
        if (session instanceof LogSession) {
            LogSession logSession = (LogSession)session;
            this.activeSessionProperty.set((Object)logSession);
            this.initializeControls(logSession);
        } else {
            this.clearControls();
        }
        this.activeSessionProperty.addListener(activeSessionListener);
        this.thumbnailsTitledPane.expandedProperty().addListener((o, oldValue, newValue) -> JavaFXMissingTools.runLater(this.getClass(), () -> ((Stage)this.stage).sizeToScene()));
        this.logPositionSlider.showTrimProperty().bind((ObservableValue)this.showTrimsButton.selectedProperty());
        this.logPositionSlider.showTrimProperty().addListener((o, oldValue, newValue) -> {
            if (newValue.booleanValue()) {
                this.resetTrims();
            }
        });
        this.startTrimToCurrentButton.disableProperty().bind((ObservableValue)this.showTrimsButton.selectedProperty().not());
        this.endTrimToCurrentButton.disableProperty().bind((ObservableValue)this.showTrimsButton.selectedProperty().not());
        this.resetTrimsButton.disableProperty().bind((ObservableValue)this.showTrimsButton.selectedProperty().not());
        this.outputFormatComboBox.disableProperty().bind((ObservableValue)this.showTrimsButton.selectedProperty().not());
        this.cropAndExportButton.disableProperty().bind((ObservableValue)this.showTrimsButton.selectedProperty().not());
        this.cropProgressMonitorPane.getChildren().addListener(c -> {
            c.getList().forEach(node -> JavaFXMissingTools.setAnchorConstraints(node, 0.0));
            this.stage.sizeToScene();
        });
        this.loadingSpinner.visibleProperty().addListener((o, oldValue, newValue) -> this.openSessionButton.setDisable(newValue.booleanValue()));
        this.openSessionButton.setOnAction(e -> this.openLogFile());
        this.endSessionButton.setOnAction(e -> {
            LogSession logSession = (LogSession)this.activeSessionProperty.get();
            if (logSession != null) {
                logSession.shutdownSession();
            }
            this.activeSessionProperty.set(null);
        });
        this.outputFormatComboBox.setItems(FXCollections.observableArrayList((Object[])OutputFormat.values()));
        this.outputFormatComboBox.getSelectionModel().select((Object)OutputFormat.Default);
        this.enableVariableFilterToggleButton.setDisable(true);
        this.outputFormatComboBox.getSelectionModel().selectedItemProperty().addListener((o, oldValue, newValue) -> {
            if (newValue == OutputFormat.Default || !this.showTrimsButton.isSelected()) {
                this.enableVariableFilterToggleButton.setSelected(false);
                this.enableVariableFilterToggleButton.setDisable(true);
            } else {
                this.enableVariableFilterToggleButton.setDisable(false);
            }
        });
        this.showTrimsButton.selectedProperty().addListener((o, oldValue, newValue) -> {
            if (newValue.booleanValue() && this.outputFormatComboBox.getSelectionModel().getSelectedItem() != OutputFormat.Default) {
                this.enableVariableFilterToggleButton.setDisable(false);
            } else {
                this.enableVariableFilterToggleButton.setSelected(false);
                this.enableVariableFilterToggleButton.setDisable(true);
            }
        });
        this.messager.addFXTopicListener(this.topics.getDisableUserControls(), m -> {
            this.openSessionButton.setDisable(m.booleanValue());
            this.endSessionButton.setDisable(m.booleanValue());
            this.cropControlsContainer.setDisable(m.booleanValue());
            this.logPositionSlider.setDisable(m.booleanValue());
        });
        this.enableVariableFilterToggleButton.selectedProperty().addListener((o, oldValue, newValue) -> {
            if (newValue.booleanValue()) {
                if (this.variableFilterControllerProperty.get() == null) {
                    try {
                        FXMLLoader loader = new FXMLLoader(SessionVisualizerIOTools.SESSION_VARIABLE_FILTER_PANE_URL);
                        loader.load();
                        SessionVariableFilterPaneController controller = (SessionVariableFilterPaneController)loader.getController();
                        Set logVariableSet = ((LogSession)this.activeSessionProperty.get()).getLogDataReader().getParser().getYoVariablesList().stream().map(YoVariable::getFullNameString).collect(Collectors.toSet());
                        controller.initialize(toolkit, var -> logVariableSet.contains(var.getFullNameString()));
                        this.variableFilterControllerProperty.set((Object)controller);
                    }
                    catch (IOException e1) {
                        e1.printStackTrace();
                    }
                }
                this.cropControlsContainer.getChildren().add((Object)((SessionVariableFilterPaneController)this.variableFilterControllerProperty.get()).getMainPane());
            } else if (this.variableFilterControllerProperty.get() != null) {
                this.cropControlsContainer.getChildren().remove((Object)((SessionVariableFilterPaneController)this.variableFilterControllerProperty.get()).getMainPane());
            }
            this.stage.sizeToScene();
        });
        this.stage.setScene(new Scene((Parent)this.mainPane));
        this.stage.setTitle("Log session controls");
        this.stage.getIcons().add((Object)SessionVisualizerIOTools.LOG_SESSION_IMAGE);
        toolkit.getMainWindow().addEventHandler(WindowEvent.WINDOW_CLOSE_REQUEST, e -> {
            if (!e.isConsumed()) {
                this.shutdown();
            }
        });
    }

    private void initializeControls(LogSession newValue) {
        File logDirectory = newValue.getLogDirectory();
        LogDataReader logDataReader = newValue.getLogDataReader();
        LogPropertiesReader logProperties = newValue.getLogProperties();
        this.sessionNameLabel.setText(newValue.getSessionName());
        this.dateLabel.setText(LogSessionManagerController.getDate(logDirectory, (LogProperties)logProperties));
        this.logPathLabel.setText(logDirectory.getAbsolutePath());
        this.endSessionButton.setDisable(false);
        this.logPositionSlider.setDisable(false);
        this.logPositionSlider.setValue(0.0);
        this.logPositionSlider.setMin(0.0);
        this.logPositionSlider.setMax((double)(logDataReader.getNumberOfEntries() - 1));
        this.cropControlsContainer.setDisable(false);
        MultiVideoDataReader multiReader = new MultiVideoDataReader(logDirectory, (LogProperties)logProperties, this.backgroundExecutorManager);
        multiReader.readVideoFrameNow(logDataReader.getTimestamp().getLongValue());
        logDataReader.getTimestamp().addListener(v -> multiReader.readVideoFrameInBackground(v.getValueAsLongBits()));
        this.multiVideoViewerProperty.set((Object)new MultiVideoViewer((Window)this.stage, (Pane)this.videoThumbnailPane, multiReader, 200.0));
        this.logCropperProperty.set((Object)new YoVariableLogCropper(multiReader, logDirectory, (LogProperties)logProperties));
        boolean logHasVideos = multiReader.getNumberOfVideos() > 0;
        this.thumbnailsTitledPane.setText(logHasVideos ? "Logged videos" : "No video");
        this.thumbnailsTitledPane.setExpanded(logHasVideos);
        this.thumbnailsTitledPane.setDisable(!logHasVideos);
        JavaFXMissingTools.runNFramesLater(5, () -> this.stage.sizeToScene());
        JavaFXMissingTools.runNFramesLater(6, () -> this.stage.toFront());
    }

    private void clearControls() {
        this.sessionNameLabel.setText("N/D");
        this.dateLabel.setText("N/D");
        this.logPathLabel.setText("N/D");
        this.endSessionButton.setDisable(true);
        this.logPositionSlider.setDisable(true);
        this.showTrimsButton.setSelected(false);
        this.cropControlsContainer.setDisable(true);
        this.multiVideoViewerProperty.set(null);
        this.logCropperProperty.set(null);
    }

    public void openLogFile() {
        FileChooser fileChooser = new FileChooser();
        fileChooser.setInitialDirectory(SessionVisualizerIOTools.getDefaultFilePath(LOG_FILE_KEY));
        fileChooser.getExtensionFilters().add((Object)new FileChooser.ExtensionFilter("Log property file", new String[]{"*.log"}));
        fileChooser.setTitle("Choose log directory");
        File result = fileChooser.showOpenDialog((Window)this.stage);
        if (result == null) {
            return;
        }
        this.unloadSession();
        this.setIsLoading(true);
        this.backgroundExecutorManager.executeInBackground(() -> {
            try {
                LogTools.info((String)"Creating log session.");
                LogSession newSession = new LogSession(result.getParentFile(), null);
                LogTools.info((String)"Created log session.");
                JavaFXMissingTools.runLater(this.getClass(), () -> this.activeSessionProperty.set((Object)newSession));
                SessionVisualizerIOTools.setDefaultFilePath(LOG_FILE_KEY, result);
            }
            catch (IOException ex) {
                ex.printStackTrace();
                this.setIsLoading(false);
            }
        });
    }

    public void setIsLoading(boolean isLoading) {
        this.loadingSpinner.setVisible(isLoading);
    }

    @FXML
    public void resetTrims() {
        this.logPositionSlider.setTrimStartValue(0.0);
        this.logPositionSlider.setTrimEndValue(this.logPositionSlider.getMax());
    }

    @FXML
    public void snapStartTrimToCurrent() {
        this.logPositionSlider.setTrimStartValue(this.logPositionSlider.getValue());
    }

    @FXML
    public void snapEndTrimToCurrent() {
        this.logPositionSlider.setTrimEndValue(this.logPositionSlider.getValue());
    }

    @FXML
    public void cropAndExport() throws IOException {
        Predicate<YoRegistry> registryFilter;
        Predicate<YoVariable> variableFilter;
        YoVariableLogCropper logCropper = (YoVariableLogCropper)((Object)this.logCropperProperty.get());
        if (logCropper == null) {
            return;
        }
        OutputFormat outputFormat = (OutputFormat)((Object)this.outputFormatComboBox.getSelectionModel().getSelectedItem());
        File destination = switch (outputFormat) {
            case OutputFormat.MATLAB -> SessionVisualizerIOTools.showSaveDialog((Window)this.stage, "Export MATLAB data", new FileChooser.ExtensionFilter("MATLAB File format", new String[]{"*.mat"}), LOG_FILE_KEY);
            case OutputFormat.CSV -> SessionVisualizerIOTools.showSaveDialog((Window)this.stage, "Export CSV data", new FileChooser.ExtensionFilter("Comma-Separated Value format", new String[]{"*.csv"}), LOG_FILE_KEY);
            default -> {
                DirectoryChooser directoryChooser = new DirectoryChooser();
                directoryChooser.setInitialDirectory(SessionVisualizerIOTools.getDefaultFilePath(LOG_FILE_KEY));
                yield directoryChooser.showDialog((Window)this.stage);
            }
        };
        if (destination == null) {
            return;
        }
        FXMLLoader loader = new FXMLLoader(SessionVisualizerIOTools.LOG_CROP_PROGRESS_PANE_FXML_URL);
        loader.load();
        LogCropProgressController controller = (LogCropProgressController)loader.getController();
        controller.initialize(this.cropProgressMonitorPane);
        if (this.enableVariableFilterToggleButton.isSelected()) {
            SessionVariableFilterPaneController filterController = (SessionVariableFilterPaneController)this.variableFilterControllerProperty.get();
            variableFilter = filterController.buildVariableFilter();
            registryFilter = filterController.buildRegistryFilter();
        } else {
            variableFilter = null;
            registryFilter = null;
        }
        int from = (int)this.logPositionSlider.getTrimStartValue();
        int to = (int)this.logPositionSlider.getTrimEndValue();
        List logVariables = ((LogSession)this.activeSessionProperty.get()).getLogDataReader().getParser().getYoVariablesList();
        this.backgroundExecutorManager.executeInBackground(() -> {
            this.setIsLoading(true);
            this.messager.submitMessage(this.topics.getDisableUserControls(), (Object)true);
            try {
                if (outputFormat == OutputFormat.MATLAB) {
                    logCropper.cropMATLAB(destination, logVariables, variableFilter, registryFilter, from, to, controller);
                } else if (outputFormat == OutputFormat.CSV) {
                    logCropper.cropCSV(destination, logVariables, variableFilter, registryFilter, from, to, controller);
                } else {
                    logCropper.crop(destination, from, to, controller);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                controller.error("Terminated with exception: " + e.getMessage());
                controller.done();
            }
            finally {
                this.messager.submitMessage(this.topics.getDisableUserControls(), (Object)false);
                this.setIsLoading(false);
            }
        });
    }

    @Override
    public void shutdown() {
        if (this.variableFilterControllerProperty.get() != null) {
            ((SessionVariableFilterPaneController)this.variableFilterControllerProperty.get()).dispose();
            this.variableFilterControllerProperty.set(null);
        }
        this.stage.close();
    }

    @Override
    public Stage getStage() {
        return this.stage;
    }

    @Override
    public void unloadSession() {
        this.enableVariableFilterToggleButton.setSelected(false);
        this.variableFilterControllerProperty.set(null);
    }

    @Override
    public void notifySessionLoaded() {
        this.setIsLoading(false);
    }

    private static String getDate(File logDirectory, LogProperties logProperties) {
        String timestampAsString = LogSessionManagerController.parseTimestamp(logProperties.getTimestampAsString());
        if (timestampAsString != null) {
            return timestampAsString;
        }
        timestampAsString = LogSessionManagerController.parseTimestamp(logDirectory.getName());
        if (timestampAsString != null) {
            return timestampAsString;
        }
        return "N/D";
    }

    public static String parseTimestamp(String string) {
        if (string == null || string.length() < 15) {
            return null;
        }
        String year = string.substring(0, 4);
        String month = string.substring(4, 6);
        String day = string.substring(6, 8);
        String hour = string.substring(9, 11);
        String minute = string.substring(11, 13);
        String second = string.substring(13, 15);
        return year + "-" + month + "-" + day + " " + hour + ":" + minute + ":" + second;
    }

    private static enum OutputFormat {
        Default,
        MATLAB,
        CSV;

    }

    public static class TimeStringBinding
    extends StringBinding {
        private ObservableLongValue observableNanoTime;

        public <N extends Number> TimeStringBinding(ObservableValue<N> time, ToLongFunction<N> conversionToNano) {
            SimpleLongProperty nanoTimeProperty = new SimpleLongProperty((Object)this, "nanoTime", 0L);
            time.addListener((arg_0, arg_1, arg_2) -> TimeStringBinding.lambda$new$0((LongProperty)nanoTimeProperty, conversionToNano, arg_0, arg_1, arg_2));
            this.observableNanoTime = nanoTimeProperty;
            this.observableNanoTime.addListener((o, oldValue, newValue) -> this.invalidate());
        }

        protected String computeValue() {
            long nanoTime = this.observableNanoTime.get();
            long hours = TimeUnit.NANOSECONDS.toHours(nanoTime);
            long minutes = TimeUnit.NANOSECONDS.toMinutes(nanoTime);
            long seconds = TimeUnit.NANOSECONDS.toSeconds(nanoTime);
            long millis = TimeUnit.NANOSECONDS.toMillis(nanoTime);
            millis -= 1000L * seconds;
            seconds -= 60L * minutes;
            Object time = String.format("%02ds%03d", seconds, millis);
            if ((minutes -= 60L * hours) > 0L || hours > 0L) {
                time = String.format("%02d", minutes) + "m\n" + (String)time;
            }
            if (hours > 0L) {
                time = hours + "h" + (String)time;
            }
            return time;
        }

        private static /* synthetic */ void lambda$new$0(LongProperty nanoTimeProperty, ToLongFunction conversionToNano, ObservableValue o, Number oldValue, Number newValue) {
            nanoTimeProperty.set(conversionToNano.applyAsLong(newValue));
        }
    }
}

