/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.scs2.sessionVisualizer.jfx.controllers.menu;

import java.io.File;
import javafx.fxml.FXML;
import javafx.stage.Window;
import javafx.util.Pair;
import us.ihmc.messager.javafx.JavaFXMessager;
import us.ihmc.scs2.sessionVisualizer.jfx.SessionVisualizerIOTools;
import us.ihmc.scs2.sessionVisualizer.jfx.SessionVisualizerTopics;
import us.ihmc.scs2.sessionVisualizer.jfx.controllers.VisualizerController;
import us.ihmc.scs2.sessionVisualizer.jfx.managers.SecondaryWindowManager;
import us.ihmc.scs2.sessionVisualizer.jfx.managers.SessionVisualizerWindowToolkit;

public class YoChartMenuController
implements VisualizerController {
    private SessionVisualizerTopics topics;
    private JavaFXMessager messager;
    private Window owner;

    @Override
    public void initialize(SessionVisualizerWindowToolkit toolkit) {
        this.topics = toolkit.getTopics();
        this.messager = toolkit.getMessager();
        this.owner = toolkit.getWindow();
    }

    @FXML
    public void showChartYAxis() {
        this.messager.submitMessage(this.topics.getYoChartShowYAxis(), (Object)new Pair((Object)this.owner, (Object)true));
    }

    @FXML
    public void hideChartYAxis() {
        this.messager.submitMessage(this.topics.getYoChartShowYAxis(), (Object)new Pair((Object)this.owner, (Object)false));
    }

    @FXML
    public void loadChartGroup() {
        File result = SessionVisualizerIOTools.yoChartConfigurationOpenFileDialog(this.owner);
        if (result != null) {
            this.messager.submitMessage(this.topics.getYoChartGroupLoadConfiguration(), (Object)new Pair((Object)this.owner, (Object)result));
        }
    }

    @FXML
    public void saveChartGroup() {
        File result = SessionVisualizerIOTools.yoChartConfigurationSaveFileDialog(this.owner);
        if (result != null) {
            this.messager.submitMessage(this.topics.getYoChartGroupSaveConfiguration(), (Object)new Pair((Object)this.owner, (Object)result));
        }
    }

    @FXML
    public void newChartWindow() {
        this.messager.submitMessage(this.topics.getOpenWindowRequest(), (Object)SecondaryWindowManager.NewWindowRequest.chartWindow(this.owner));
    }
}

