/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.scs2.sessionVisualizer.jfx.controllers.yoComposite.creator;

import com.jfoenix.controls.JFXListView;
import java.util.Map;
import javafx.beans.property.IntegerProperty;
import javafx.beans.property.SimpleIntegerProperty;
import javafx.beans.value.ObservableValue;
import javafx.fxml.FXML;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.control.Label;
import javafx.scene.control.ListCell;
import javafx.scene.layout.HBox;
import javafx.scene.layout.VBox;
import javafx.scene.text.Font;
import javafx.scene.text.FontPosture;
import javafx.scene.text.Text;
import javafx.stage.Stage;
import javafx.stage.StageStyle;
import javafx.stage.Window;
import javafx.util.Pair;
import us.ihmc.scs2.sessionVisualizer.jfx.SessionVisualizerIOTools;
import us.ihmc.scs2.symbolic.parser.EquationAliasManager;
import us.ihmc.scs2.symbolic.parser.EquationOperationLibrary;
import us.ihmc.scs2.symbolic.parser.EquationSymbol;

public class YoEquationEditorHelpPaneController {
    @FXML
    public VBox mainPane;
    @FXML
    public JFXListView<Pair<String, String>> constantsListView;
    @FXML
    public JFXListView<Pair<String, String>> symbolsListView;
    @FXML
    public JFXListView<Pair<String, String>> functionsListView;
    private final IntegerProperty nameLabelPrefWidthProperty = new SimpleIntegerProperty((Object)this, "nameLabelPrefWidth", -1);

    public void show(Window owner) {
        this.constantsListView.setCellFactory(param -> new NameDescriptionListCell());
        this.symbolsListView.setCellFactory(param -> new NameDescriptionListCell());
        this.functionsListView.setCellFactory(param -> new NameDescriptionListCell());
        for (Map.Entry aliasEntry : EquationAliasManager.defaultAliases.entrySet()) {
            this.constantsListView.getItems().add((Object)new Pair((Object)((String)aliasEntry.getKey()), (Object)((EquationAliasManager.EquationAlias)aliasEntry.getValue()).input().valueAsString()));
        }
        for (EquationSymbol symbol : EquationSymbol.getSupportedSymbols()) {
            this.symbolsListView.getItems().add((Object)new Pair((Object)symbol.getSymbolString(), (Object)symbol.getDescription()));
        }
        for (String name : EquationOperationLibrary.getOperationNames()) {
            this.functionsListView.getItems().add((Object)new Pair((Object)name, (Object)EquationOperationLibrary.getOperationDescription((String)name)));
        }
        Stage stage = new Stage();
        stage.initStyle(StageStyle.UTILITY);
        stage.initOwner(owner);
        stage.setTitle("Equation Editor Help");
        SessionVisualizerIOTools.addSCSIconToWindow((Window)stage);
        Scene scene = new Scene((Parent)this.mainPane);
        stage.setScene(scene);
        stage.show();
    }

    private class NameDescriptionListCell
    extends ListCell<Pair<String, String>> {
        private NameDescriptionListCell() {
        }

        protected void updateItem(Pair<String, String> item, boolean empty) {
            super.updateItem(item, empty);
            if (empty || item == null) {
                this.setText(null);
                this.setGraphic(null);
            } else {
                this.setText(null);
                HBox graphic = new HBox(5.0);
                Label nameLabel = new Label((String)item.getKey());
                nameLabel.prefWidthProperty().bind((ObservableValue)YoEquationEditorHelpPaneController.this.nameLabelPrefWidthProperty);
                Font nameFont = Font.font((String)Font.getDefault().getFamily(), (FontPosture)FontPosture.ITALIC, (double)12.0);
                Text sample = new Text((String)item.getKey());
                sample.setFont(nameFont);
                YoEquationEditorHelpPaneController.this.nameLabelPrefWidthProperty.set((int)Math.max((double)YoEquationEditorHelpPaneController.this.nameLabelPrefWidthProperty.get(), sample.getLayoutBounds().getWidth() + 10.0));
                nameLabel.setFont(nameFont);
                graphic.getChildren().add((Object)nameLabel);
                Label descriptionLabel = new Label((String)item.getValue());
                descriptionLabel.setFont(Font.font((String)Font.getDefault().getFamily(), (double)12.0));
                graphic.getChildren().add((Object)descriptionLabel);
                this.setGraphic((Node)graphic);
            }
        }
    }
}

