/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.scs2.sessionVisualizer.jfx.controllers.menu;

import java.util.concurrent.atomic.AtomicReference;
import javafx.beans.property.Property;
import javafx.fxml.FXML;
import javafx.scene.control.CheckMenuItem;
import javafx.scene.control.CustomMenuItem;
import javafx.scene.control.Menu;
import javafx.scene.control.TextField;
import javafx.scene.control.TextFormatter;
import javafx.util.StringConverter;
import javafx.util.converter.DoubleStringConverter;
import us.ihmc.messager.javafx.JavaFXMessager;
import us.ihmc.messager.javafx.MessageBidirectionalBinding;
import us.ihmc.scs2.session.SessionMode;
import us.ihmc.scs2.sessionVisualizer.jfx.SessionVisualizerTopics;
import us.ihmc.scs2.sessionVisualizer.jfx.controllers.VisualizerController;
import us.ihmc.scs2.sessionVisualizer.jfx.managers.SessionVisualizerWindowToolkit;
import us.ihmc.scs2.sessionVisualizer.jfx.tools.MenuTools;
import us.ihmc.scs2.sharedMemory.interfaces.YoBufferPropertiesReadOnly;

public class RunMenuController
implements VisualizerController {
    @FXML
    private Menu menu;
    @FXML
    private CustomMenuItem playbackRealTimeRateMenuItem;
    @FXML
    private CustomMenuItem runMaxDurationMenuItem;
    @FXML
    private CheckMenuItem simulateAtRealTimeCheckMenuItem;
    @FXML
    private TextField playbackRealTimeRateTextField;
    @FXML
    private TextField runMaxDurationTextField;
    private JavaFXMessager messager;
    private SessionVisualizerTopics topics;
    private AtomicReference<YoBufferPropertiesReadOnly> bufferProperties;

    @Override
    public void initialize(SessionVisualizerWindowToolkit toolkit) {
        this.messager = toolkit.getMessager();
        this.topics = toolkit.getTopics();
        this.bufferProperties = this.messager.createInput(this.topics.getYoBufferCurrentProperties(), null);
        this.messager.bindBidirectional(this.topics.getRunAtRealTimeRate(), (Property)this.simulateAtRealTimeCheckMenuItem.selectedProperty(), false);
        this.messager.addFXTopicListener(this.topics.getDisableUserControls(), disable -> this.menu.setDisable(disable.booleanValue()));
        TextFormatter formatter = new TextFormatter((StringConverter)new DoubleStringConverter());
        formatter.setValue((Object)1.0);
        this.playbackRealTimeRateTextField.setTextFormatter(formatter);
        this.messager.bindBidirectional(this.topics.getPlaybackRealTimeRate(), (Property)formatter.valueProperty(), false);
        formatter = new TextFormatter((StringConverter)new DoubleStringConverter());
        formatter.setValue((Object)-1.0);
        this.runMaxDurationTextField.setTextFormatter(formatter);
        this.messager.bindBidirectional(this.topics.getRunMaxDuration(), (Property)formatter.valueProperty(), (MessageBidirectionalBinding.PropertyToMessageTypeConverter)new MessageBidirectionalBinding.PropertyToMessageTypeConverter<Long, Double>(){

            public Long convert(Double propertyValue) {
                if (propertyValue != null) {
                    return (long)(propertyValue * 1.0E9);
                }
                return -1L;
            }

            public Double interpret(Long messageContent) {
                if (messageContent != null) {
                    return messageContent.doubleValue() / 1.0E9;
                }
                return -1.0;
            }
        }, false);
        MenuTools.configureTextFieldForCustomMenuItem(this.playbackRealTimeRateMenuItem, this.playbackRealTimeRateTextField);
        MenuTools.configureTextFieldForCustomMenuItem(this.runMaxDurationMenuItem, this.runMaxDurationTextField);
    }

    @FXML
    private void startSimulating() {
        this.messager.submitMessage(this.topics.getSessionCurrentMode(), (Object)SessionMode.RUNNING);
    }

    @FXML
    private void startPlayback() {
        this.messager.submitMessage(this.topics.getSessionCurrentMode(), (Object)SessionMode.PLAYBACK);
    }

    @FXML
    private void pause() {
        this.messager.submitMessage(this.topics.getSessionCurrentMode(), (Object)SessionMode.PAUSE);
    }

    @FXML
    private void setInPoint() {
        if (this.bufferProperties.get() != null) {
            this.messager.submitMessage(this.topics.getYoBufferInPointIndexRequest(), (Object)this.bufferProperties.get().getCurrentIndex());
        }
    }

    @FXML
    private void gotoInPoint() {
        if (this.bufferProperties.get() != null) {
            this.messager.submitMessage(this.topics.getYoBufferCurrentIndexRequest(), (Object)this.bufferProperties.get().getInPoint());
        }
    }

    @FXML
    private void stepBack() {
        this.messager.submitMessage(this.topics.getYoBufferDecrementCurrentIndexRequest(), (Object)1);
    }

    @FXML
    private void stepForward() {
        this.messager.submitMessage(this.topics.getYoBufferIncrementCurrentIndexRequest(), (Object)1);
    }

    @FXML
    private void gotoOutPoint() {
        if (this.bufferProperties.get() != null) {
            this.messager.submitMessage(this.topics.getYoBufferCurrentIndexRequest(), (Object)this.bufferProperties.get().getOutPoint());
        }
    }

    @FXML
    private void setOutPoint() {
        if (this.bufferProperties.get() != null) {
            this.messager.submitMessage(this.topics.getYoBufferOutPointIndexRequest(), (Object)this.bufferProperties.get().getCurrentIndex());
        }
    }
}

