/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.scs2.sessionVisualizer.jfx.controllers.yoGraphic.graphic3D;

import javafx.beans.value.ObservableValue;
import javafx.fxml.FXML;
import javafx.scene.control.CheckBox;
import javafx.scene.control.TextField;
import javafx.scene.image.ImageView;
import us.ihmc.scs2.definition.yoComposite.YoCompositeDefinition;
import us.ihmc.scs2.definition.yoGraphic.YoGraphic3DDefinition;
import us.ihmc.scs2.definition.yoGraphic.YoGraphicArrow3DDefinition;
import us.ihmc.scs2.sessionVisualizer.jfx.controllers.editor.YoCompositeEditorPaneController;
import us.ihmc.scs2.sessionVisualizer.jfx.controllers.yoGraphic.graphic3D.YoGraphicFX3DEditorController;
import us.ihmc.scs2.sessionVisualizer.jfx.managers.SessionVisualizerToolkit;
import us.ihmc.scs2.sessionVisualizer.jfx.yoGraphic.YoArrowFX3D;
import us.ihmc.scs2.sessionVisualizer.jfx.yoGraphic.YoGraphicTools;

public class YoArrowFX3DEditorController
extends YoGraphicFX3DEditorController<YoArrowFX3D> {
    @FXML
    private YoCompositeEditorPaneController originEditorController;
    @FXML
    private YoCompositeEditorPaneController directionEditorController;
    @FXML
    private TextField bodyLengthTextField;
    @FXML
    private TextField headLengthTextField;
    @FXML
    private TextField bodyRadiusTextField;
    @FXML
    private TextField headRadiusTextField;
    @FXML
    private CheckBox scaleLengthCheckBox;
    @FXML
    private CheckBox scaleRadiusCheckBox;
    @FXML
    private ImageView bodyLengthValidImageView;
    @FXML
    private ImageView headLengthValidImageView;
    @FXML
    private ImageView bodyRadiusValidImageView;
    @FXML
    private ImageView headRadiusValidImageView;
    private YoGraphicArrow3DDefinition definitionBeforeEdits;

    @Override
    public void initialize(SessionVisualizerToolkit toolkit, YoArrowFX3D yoGraphicToEdit) {
        super.initialize(toolkit, yoGraphicToEdit);
        this.definitionBeforeEdits = YoGraphicTools.toYoGraphicArrow3DDefinition(yoGraphicToEdit);
        yoGraphicToEdit.visibleProperty().addListener((observable, oldValue, newValue) -> this.definitionBeforeEdits.setVisible(newValue.booleanValue()));
        this.setupTuple3DPropertyEditor(this.originEditorController, "Origin", true, yoGraphicToEdit.getOrigin());
        this.setupTuple3DPropertyEditor(this.directionEditorController, "Direction", true, yoGraphicToEdit.getDirection());
        this.setupDoublePropertyEditor(this.bodyLengthTextField, this.bodyLengthValidImageView, YoArrowFX3D::setBodyLength);
        this.setupDoublePropertyEditor(this.headLengthTextField, this.headLengthValidImageView, YoArrowFX3D::setHeadLength);
        this.setupDoublePropertyEditor(this.bodyRadiusTextField, this.bodyRadiusValidImageView, YoArrowFX3D::setBodyRadius);
        this.setupDoublePropertyEditor(this.headRadiusTextField, this.headRadiusValidImageView, YoArrowFX3D::setHeadRadius);
        this.scaleLengthCheckBox.selectedProperty().addListener((observable, oldValue, newValue) -> yoGraphicToEdit.setScaleLength((boolean)newValue));
        this.scaleRadiusCheckBox.selectedProperty().addListener((observable, oldValue, newValue) -> yoGraphicToEdit.setScaleRadius((boolean)newValue));
        this.scaleLengthCheckBox.selectedProperty().addListener(this::updateHasChangesPendingProperty);
        this.scaleRadiusCheckBox.selectedProperty().addListener(this::updateHasChangesPendingProperty);
        this.resetFields();
    }

    @Override
    protected <T> void updateHasChangesPendingProperty(ObservableValue<? extends T> observable, T oldValue, T newValue) {
        this.hasChangesPendingProperty.set(!this.definitionBeforeEdits.equals((Object)YoGraphicTools.toYoGraphicArrow3DDefinition((YoArrowFX3D)this.yoGraphicToEdit)));
    }

    @Override
    public void resetFields() {
        this.originEditorController.setInput((YoCompositeDefinition)this.definitionBeforeEdits.getOrigin());
        this.directionEditorController.setInput((YoCompositeDefinition)this.definitionBeforeEdits.getDirection());
        this.bodyLengthTextField.setText(this.definitionBeforeEdits.getBodyLength());
        this.headLengthTextField.setText(this.definitionBeforeEdits.getHeadLength());
        this.scaleLengthCheckBox.setSelected(this.definitionBeforeEdits.isScaleLength());
        this.bodyRadiusTextField.setText(this.definitionBeforeEdits.getBodyRadius());
        this.headRadiusTextField.setText(this.definitionBeforeEdits.getHeadRadius());
        this.scaleRadiusCheckBox.setSelected(this.definitionBeforeEdits.isScaleRadius());
        this.styleEditorController.setInput((YoGraphic3DDefinition)this.definitionBeforeEdits);
        this.nameEditorController.setInput(this.definitionBeforeEdits.getName(), ((YoArrowFX3D)this.yoGraphicToEdit).getNamespace());
    }

    @Override
    public void saveChanges() {
        this.definitionBeforeEdits = YoGraphicTools.toYoGraphicArrow3DDefinition((YoArrowFX3D)this.yoGraphicToEdit);
        this.hasChangesPendingProperty.set(false);
    }
}

