/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.scs2.sessionVisualizer.jfx.controllers.editor;

import com.jfoenix.controls.JFXTextField;
import java.util.Arrays;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import javafx.beans.binding.BooleanExpression;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.Property;
import javafx.beans.property.ReadOnlyObjectProperty;
import javafx.beans.property.ReadOnlyProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;
import javafx.beans.value.ObservableBooleanValue;
import javafx.fxml.FXML;
import javafx.geometry.HPos;
import javafx.geometry.VPos;
import javafx.scene.Node;
import javafx.scene.control.Label;
import javafx.scene.control.TextField;
import javafx.scene.image.ImageView;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.RowConstraints;
import us.ihmc.scs2.definition.yoComposite.YoCompositeDefinition;
import us.ihmc.scs2.sessionVisualizer.jfx.SessionVisualizerIOTools;
import us.ihmc.scs2.sessionVisualizer.jfx.controllers.editor.searchTextField.DoubleSearchField;
import us.ihmc.scs2.sessionVisualizer.jfx.controllers.editor.searchTextField.ReferenceFrameSearchField;
import us.ihmc.scs2.sessionVisualizer.jfx.controllers.editor.searchTextField.YoCompositeSearchField;
import us.ihmc.scs2.sessionVisualizer.jfx.controllers.yoGraphic.YoGraphicFXControllerTools;
import us.ihmc.scs2.sessionVisualizer.jfx.managers.ReferenceFrameManager;
import us.ihmc.scs2.sessionVisualizer.jfx.managers.ReferenceFrameWrapper;
import us.ihmc.scs2.sessionVisualizer.jfx.managers.SessionVisualizerToolkit;
import us.ihmc.scs2.sessionVisualizer.jfx.managers.YoCompositeSearchManager;
import us.ihmc.scs2.sessionVisualizer.jfx.tools.CompositePropertyTools;
import us.ihmc.scs2.sessionVisualizer.jfx.yoComposite.CompositeProperty;
import us.ihmc.scs2.sessionVisualizer.jfx.yoComposite.YoComposite;
import us.ihmc.scs2.sessionVisualizer.jfx.yoComposite.YoCompositeCollection;
import us.ihmc.scs2.sessionVisualizer.jfx.yoComposite.YoCompositePattern;
import us.ihmc.scs2.sharedMemory.LinkedYoRegistry;

public class YoCompositeEditorPaneController {
    private static final double VALID_IMAGE_HEIGHT = 25.0;
    @FXML
    private GridPane mainPane;
    @FXML
    private Label searchYoCompositeLabel;
    @FXML
    private TextField searchYoCompositeTextField;
    private Label[] componentLabels;
    private TextField[] componentSearchTextFields;
    private ImageView[] componentValidImageViews;
    private YoCompositeSearchField yoCompositeTextField;
    private DoubleSearchField[] yoComponentTextFields;
    private int numberOfComponents;
    private YoCompositePattern yoCompositePattern;
    private final StringProperty compositeNameProperty = new SimpleStringProperty((Object)this, "compositeName", "YoComposite");
    private BooleanExpression inputsValidityProperty;
    private ObjectProperty<DoubleProperty[]> compositeSupplierProperty = new SimpleObjectProperty((Object)this, "compositeSupplier", null);
    private Label referenceFrameLabel;
    private TextField referenceFrameSearchTextField;
    private ImageView referenceFrameValidImageView;
    private ReferenceFrameManager referenceFrameManager;
    private ReferenceFrameSearchField yoReferenceFrameTextField;

    public void initialize(SessionVisualizerToolkit toolkit, YoCompositeCollection yoCompositeCollection, boolean setupReferenceFrameFields) {
        this.initialize(toolkit.getYoCompositeSearchManager(), toolkit.getReferenceFrameManager(), toolkit.getYoManager().getLinkedRootRegistry(), yoCompositeCollection, setupReferenceFrameFields);
    }

    public void initialize(YoCompositeSearchManager searchManager, ReferenceFrameManager referenceFrameManager, LinkedYoRegistry linkedRootRegistry, YoCompositeCollection yoCompositeCollection, boolean setupReferenceFrameFields) {
        int i;
        this.yoCompositePattern = yoCompositeCollection.getPattern();
        this.referenceFrameManager = referenceFrameManager;
        this.numberOfComponents = this.yoCompositePattern.getComponentIdentifiers() != null ? this.yoCompositePattern.getComponentIdentifiers().length : 1;
        this.createLayout();
        if (setupReferenceFrameFields) {
            this.setupReferenceFrameFields();
        }
        this.yoComponentTextFields = new DoubleSearchField[this.numberOfComponents];
        this.compositeSupplierProperty.set((Object)new DoubleProperty[this.numberOfComponents]);
        for (i = 0; i < this.numberOfComponents; ++i) {
            DoubleSearchField yoComponentTextField = new DoubleSearchField(this.componentSearchTextFields[i], searchManager, linkedRootRegistry, this.componentValidImageViews[i]);
            yoComponentTextField.setupAutoCompletion();
            this.inputsValidityProperty = this.inputsValidityProperty == null ? BooleanExpression.booleanExpression((ObservableBooleanValue)yoComponentTextField.getValidityProperty()) : this.inputsValidityProperty.and((ObservableBooleanValue)yoComponentTextField.getValidityProperty());
            int supplierIndex = i;
            yoComponentTextField.supplierProperty().addListener((o, oldValue, newValue) -> {
                DoubleProperty[] newSuppliers = Arrays.copyOf((DoubleProperty[])this.compositeSupplierProperty.get(), this.numberOfComponents);
                newSuppliers[supplierIndex] = newValue;
                this.compositeSupplierProperty.set((Object)newSuppliers);
            });
            this.yoComponentTextFields[i] = yoComponentTextField;
        }
        if (setupReferenceFrameFields) {
            this.inputsValidityProperty = this.inputsValidityProperty.and((ObservableBooleanValue)this.yoReferenceFrameTextField.getValidityProperty());
        }
        if (this.numberOfComponents > 1) {
            this.yoCompositeTextField = new YoCompositeSearchField(searchManager, yoCompositeCollection, this.searchYoCompositeTextField);
            this.yoCompositeTextField.setupAutoCompletion();
            this.yoCompositeTextField.attachIndividualComponentFields(this.componentSearchTextFields);
        }
        for (i = 0; i < this.numberOfComponents; ++i) {
            this.componentSearchTextFields[i].setText(Double.toString(0.0));
        }
        this.compositeNameProperty.addListener((observable, oldValue, newValue) -> {
            if (newValue == null || newValue.isEmpty()) {
                this.compositeNameProperty.set(oldValue);
                return;
            }
            this.searchYoCompositeLabel.setText(YoGraphicFXControllerTools.replaceAndMatchCase(this.searchYoCompositeLabel.getText(), oldValue, newValue));
        });
    }

    private void createLayout() {
        this.componentLabels = new Label[this.numberOfComponents];
        this.componentSearchTextFields = new JFXTextField[this.numberOfComponents];
        this.componentValidImageViews = new ImageView[this.numberOfComponents];
        if (this.numberOfComponents == 1) {
            this.mainPane.getChildren().clear();
            this.mainPane.getRowConstraints().remove(0);
            Label componentLabel = new Label((String)this.compositeNameProperty.get());
            this.mainPane.getChildren().add((Object)componentLabel);
            GridPane.setConstraints((Node)componentLabel, (int)0, (int)0, (int)1, (int)1, (HPos)HPos.LEFT, (VPos)VPos.CENTER);
            JFXTextField componentSearchTextField = new JFXTextField();
            this.mainPane.getChildren().add((Object)componentSearchTextField);
            GridPane.setConstraints((Node)componentSearchTextField, (int)1, (int)0, (int)1, (int)1, (HPos)HPos.CENTER, (VPos)VPos.CENTER);
            ImageView componentValidImageView = new ImageView(SessionVisualizerIOTools.INVALID_ICON_IMAGE);
            componentValidImageView.setPreserveRatio(true);
            componentValidImageView.setFitHeight(25.0);
            this.mainPane.getChildren().add((Object)componentValidImageView);
            GridPane.setConstraints((Node)componentValidImageView, (int)2, (int)0, (int)1, (int)1, (HPos)HPos.LEFT, (VPos)VPos.CENTER);
            this.componentLabels[0] = componentLabel;
            this.componentSearchTextFields[0] = componentSearchTextField;
            this.componentValidImageViews[0] = componentValidImageView;
            this.searchYoCompositeLabel = componentLabel;
            this.searchYoCompositeTextField = componentSearchTextField;
        } else {
            String[] componentIdentifiers = this.yoCompositePattern.getComponentIdentifiers();
            while (this.mainPane.getRowConstraints().size() < this.numberOfComponents + 1) {
                this.mainPane.getRowConstraints().add((Object)((RowConstraints)this.mainPane.getRowConstraints().get(1)));
            }
            for (int i = 0; i < this.numberOfComponents; ++i) {
                String id = componentIdentifiers[i];
                Label componentLabel = new Label(id);
                this.mainPane.getChildren().add((Object)componentLabel);
                GridPane.setConstraints((Node)componentLabel, (int)0, (int)(i + 1), (int)1, (int)1, (HPos)HPos.RIGHT, (VPos)VPos.CENTER);
                JFXTextField componentSearchTextField = new JFXTextField();
                this.mainPane.getChildren().add((Object)componentSearchTextField);
                GridPane.setConstraints((Node)componentSearchTextField, (int)1, (int)(i + 1), (int)1, (int)1, (HPos)HPos.CENTER, (VPos)VPos.CENTER);
                ImageView componentValidImageView = new ImageView(SessionVisualizerIOTools.INVALID_ICON_IMAGE);
                componentValidImageView.setPreserveRatio(true);
                componentValidImageView.setFitHeight(25.0);
                this.mainPane.getChildren().add((Object)componentValidImageView);
                GridPane.setConstraints((Node)componentValidImageView, (int)2, (int)(i + 1), (int)1, (int)1, (HPos)HPos.LEFT, (VPos)VPos.CENTER);
                this.componentLabels[i] = componentLabel;
                this.componentSearchTextFields[i] = componentSearchTextField;
                this.componentValidImageViews[i] = componentValidImageView;
            }
        }
    }

    private void setupReferenceFrameFields() {
        this.referenceFrameLabel = new Label("Reference frame");
        this.referenceFrameSearchTextField = new JFXTextField();
        this.referenceFrameValidImageView = new ImageView(SessionVisualizerIOTools.VALID_ICON_IMAGE);
        this.referenceFrameValidImageView.setPreserveRatio(true);
        this.referenceFrameValidImageView.setFitHeight(25.0);
        this.mainPane.getRowConstraints().add((Object)((RowConstraints)this.mainPane.getRowConstraints().get(1)));
        this.mainPane.getChildren().addAll((Object[])new Node[]{this.referenceFrameLabel, this.referenceFrameSearchTextField, this.referenceFrameValidImageView});
        GridPane.setConstraints((Node)this.referenceFrameLabel, (int)0, (int)(this.numberOfComponents + 1), (int)1, (int)1, (HPos)HPos.LEFT, (VPos)VPos.CENTER);
        GridPane.setConstraints((Node)this.referenceFrameSearchTextField, (int)1, (int)(this.numberOfComponents + 1), (int)1, (int)1, (HPos)HPos.CENTER, (VPos)VPos.CENTER);
        GridPane.setConstraints((Node)this.referenceFrameValidImageView, (int)2, (int)(this.numberOfComponents + 1), (int)1, (int)1, (HPos)HPos.LEFT, (VPos)VPos.CENTER);
        this.yoReferenceFrameTextField = new ReferenceFrameSearchField(this.referenceFrameSearchTextField, this.referenceFrameManager, this.referenceFrameValidImageView);
        this.yoReferenceFrameTextField.setupAutoCompletion();
        this.referenceFrameSearchTextField.setText(this.referenceFrameManager.getWorldFrame().getName());
    }

    public void setCompositeName(String compositeName) {
        this.compositeNameProperty.set((Object)compositeName);
    }

    public void setInput(YoComposite input) {
        if (this.yoCompositeTextField != null) {
            this.yoCompositeTextField.setInput(input);
        } else {
            this.componentSearchTextFields[0].setText(input.getUniqueName());
        }
    }

    public void setInput(CompositeProperty input) {
        this.setInput(CompositePropertyTools.toYoCompositeDefinition(input));
    }

    public void setInput(YoCompositeDefinition input) {
        for (int i = 0; i < this.numberOfComponents; ++i) {
            this.componentSearchTextFields[i].setText(input.getComponentValues()[i]);
        }
        if (this.yoCompositeTextField != null) {
            this.yoCompositeTextField.initializeFieldFromComponents();
        }
        if (this.referenceFrameSearchTextField != null) {
            if (input.getReferenceFrame() == null) {
                this.referenceFrameSearchTextField.setText(this.referenceFrameManager.getWorldFrame().getName());
            } else {
                this.referenceFrameSearchTextField.setText(input.getReferenceFrame());
            }
        }
    }

    public void setInput(String ... input) {
        for (int i = 0; i < this.numberOfComponents; ++i) {
            this.componentSearchTextFields[i].setText(input[i]);
        }
        if (this.yoCompositeTextField != null) {
            this.yoCompositeTextField.initializeFieldFromComponents();
        }
    }

    public void setReferenceFrame(ReferenceFrameWrapper referenceFrame) {
        if (this.yoReferenceFrameTextField == null) {
            return;
        }
        this.referenceFrameSearchTextField.setText(referenceFrame.getFullName());
    }

    public ObservableBooleanValue inputsValidityProperty() {
        return this.inputsValidityProperty;
    }

    public ReadOnlyObjectProperty<DoubleProperty[]> compositeSupplierProperty() {
        return this.compositeSupplierProperty;
    }

    public ReadOnlyProperty<Property<ReferenceFrameWrapper>> frameSupplierProperty() {
        return this.yoReferenceFrameTextField.supplierProperty();
    }

    public void addInputNotification(Runnable callback) {
        this.compositeSupplierProperty.addListener((o, oldValue, newValue) -> callback.run());
        if (this.yoReferenceFrameTextField != null) {
            this.frameSupplierProperty().addListener((o, oldValue, newValue) -> callback.run());
        }
    }

    public void addInputListener(Consumer<DoubleProperty[]> componentsConsumer) {
        this.compositeSupplierProperty.addListener((o, oldValue, newValue) -> componentsConsumer.accept((DoubleProperty[])newValue));
    }

    public void addInputListener(BiConsumer<DoubleProperty[], Property<ReferenceFrameWrapper>> frameComponentsConsumer) {
        this.compositeSupplierProperty.addListener((o, oldValue, newValue) -> frameComponentsConsumer.accept((DoubleProperty[])newValue, (Property<ReferenceFrameWrapper>)this.yoReferenceFrameTextField.getSupplier()));
        this.frameSupplierProperty().addListener((o, oldValue, newValue) -> frameComponentsConsumer.accept((DoubleProperty[])this.compositeSupplierProperty.get(), (Property<ReferenceFrameWrapper>)newValue));
    }

    public void bindYoCompositeDoubleProperty(CompositeProperty propertyToBind) {
        if (this.yoReferenceFrameTextField == null) {
            this.addInputListener((DoubleProperty[] components) -> propertyToBind.setComponentValueProperties((DoubleProperty)components));
        } else {
            this.addInputListener((DoubleProperty[] components, Property<ReferenceFrameWrapper> frame) -> propertyToBind.set((Property<ReferenceFrameWrapper>)frame, (DoubleProperty)components));
        }
    }

    public GridPane getMainPane() {
        return this.mainPane;
    }

    public TextField getSearchYoCompositeTextField() {
        return this.searchYoCompositeTextField;
    }
}

