/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.scs2.sessionVisualizer.jfx.yoGraphic;

import javafx.beans.value.ObservableValue;
import javafx.scene.Node;
import javafx.scene.paint.Material;
import javafx.scene.paint.PhongMaterial;
import javafx.scene.shape.Mesh;
import javafx.scene.shape.MeshView;
import javafx.scene.transform.Affine;
import javafx.scene.transform.Scale;
import javafx.scene.transform.Transform;
import us.ihmc.euclid.orientation.interfaces.Orientation3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DReadOnly;
import us.ihmc.scs2.definition.geometry.GeometryDefinition;
import us.ihmc.scs2.definition.geometry.Ramp3DDefinition;
import us.ihmc.scs2.sessionVisualizer.jfx.definition.JavaFXTriangleMesh3DDefinitionInterpreter;
import us.ihmc.scs2.sessionVisualizer.jfx.managers.ReferenceFrameWrapper;
import us.ihmc.scs2.sessionVisualizer.jfx.tools.JavaFXMissingTools;
import us.ihmc.scs2.sessionVisualizer.jfx.yoComposite.Orientation3DProperty;
import us.ihmc.scs2.sessionVisualizer.jfx.yoComposite.QuaternionProperty;
import us.ihmc.scs2.sessionVisualizer.jfx.yoComposite.Tuple3DProperty;
import us.ihmc.scs2.sessionVisualizer.jfx.yoGraphic.YoGraphicFX3D;
import us.ihmc.scs2.sessionVisualizer.jfx.yoGraphic.color.SimpleColorFX;

public class YoRampFX3D
extends YoGraphicFX3D {
    private final MeshView rampNode = new MeshView((Mesh)JavaFXTriangleMesh3DDefinitionInterpreter.interpretDefinition((GeometryDefinition)new Ramp3DDefinition(1.0, 1.0, 1.0)));
    private Tuple3DProperty position = new Tuple3DProperty(null, 0.0, 0.0, 0.0);
    private Orientation3DProperty orientation = new QuaternionProperty(null, 0.0, 0.0, 0.0, 1.0);
    private Tuple3DProperty size = new Tuple3DProperty(null, 0.0, 0.0, 0.0);
    private final Affine affine = new Affine();
    private final Scale scale = new Scale();
    private final PhongMaterial material = new PhongMaterial();

    public YoRampFX3D() {
        this.rampNode.setMaterial((Material)this.material);
        this.rampNode.getTransforms().addAll((Object[])new Transform[]{this.affine, this.scale});
        this.rampNode.idProperty().bind((ObservableValue)this.nameProperty());
        this.rampNode.getProperties().put((Object)YO_GRAPHICFX_ITEM_KEY, (Object)this);
    }

    public YoRampFX3D(ReferenceFrameWrapper worldFrame) {
        this();
        this.position.setReferenceFrame(worldFrame);
        this.orientation.setReferenceFrame(worldFrame);
    }

    @Override
    public void render() {
        if (this.position.containsNaN() || this.orientation.containsNaN() || this.size.containsNaN()) {
            this.affine.setToIdentity();
            this.scale.setX(0.0);
            this.scale.setY(0.0);
            this.scale.setZ(0.0);
        }
        this.affine.setToTransform((Transform)JavaFXMissingTools.createAffineFromOrientation3DAndTuple((Orientation3DReadOnly)this.orientation.toQuaternionInWorld(), (Tuple3DReadOnly)this.position.toPoint3DInWorld()));
        if (this.color == null) {
            this.color = new SimpleColorFX();
        }
        this.material.setDiffuseColor(this.color.get());
        this.scale.setX(this.size.getX());
        this.scale.setY(this.size.getY());
        this.scale.setZ(this.size.getZ());
    }

    @Override
    public void clear() {
        this.position = null;
        this.orientation = null;
        this.size = null;
        this.color = null;
    }

    @Override
    public YoRampFX3D clone() {
        YoRampFX3D clone = new YoRampFX3D();
        clone.setName(this.getName());
        clone.setPosition(new Tuple3DProperty(this.position));
        clone.setOrientation(this.orientation.clone());
        clone.setSize(new Tuple3DProperty(this.size));
        clone.setColor(this.color);
        return clone;
    }

    public void setPosition(Tuple3DProperty position) {
        this.position = position;
    }

    public void setOrientation(Orientation3DProperty orientation) {
        this.orientation = orientation;
    }

    public void setSize(Tuple3DProperty size) {
        this.size = size;
    }

    public Tuple3DProperty getPosition() {
        return this.position;
    }

    public Orientation3DProperty getOrientation() {
        return this.orientation;
    }

    public Tuple3DProperty getSize() {
        return this.size;
    }

    @Override
    public Node getNode() {
        return this.rampNode;
    }
}

