/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.scs2.sessionVisualizer.jfx.yoGraphic;

import javafx.beans.property.DoubleProperty;
import javafx.beans.property.SimpleDoubleProperty;
import javafx.beans.value.ObservableValue;
import javafx.scene.Node;
import javafx.scene.paint.Material;
import javafx.scene.paint.PhongMaterial;
import javafx.scene.shape.Mesh;
import javafx.scene.shape.MeshView;
import javafx.scene.transform.Rotate;
import javafx.scene.transform.Transform;
import javafx.scene.transform.Translate;
import us.ihmc.euclid.axisAngle.AxisAngle;
import us.ihmc.euclid.axisAngle.interfaces.AxisAngleReadOnly;
import us.ihmc.euclid.geometry.tools.EuclidGeometryTools;
import us.ihmc.euclid.tools.EuclidCoreTools;
import us.ihmc.euclid.tuple3D.Point3D;
import us.ihmc.euclid.tuple3D.interfaces.Vector3DReadOnly;
import us.ihmc.scs2.definition.visual.TriangleMesh3DFactories;
import us.ihmc.scs2.sessionVisualizer.jfx.definition.JavaFXTriangleMesh3DDefinitionInterpreter;
import us.ihmc.scs2.sessionVisualizer.jfx.managers.ReferenceFrameWrapper;
import us.ihmc.scs2.sessionVisualizer.jfx.tools.JavaFXMissingTools;
import us.ihmc.scs2.sessionVisualizer.jfx.yoComposite.Tuple3DProperty;
import us.ihmc.scs2.sessionVisualizer.jfx.yoGraphic.YoGraphicFX3D;
import us.ihmc.scs2.sessionVisualizer.jfx.yoGraphic.YoGraphicTools;
import us.ihmc.scs2.sessionVisualizer.jfx.yoGraphic.color.SimpleColorFX;

public class YoConeFX3D
extends YoGraphicFX3D {
    private Tuple3DProperty position = new Tuple3DProperty(null, 0.0, 0.0, 0.0);
    private Tuple3DProperty axis = new Tuple3DProperty(null, 0.0, 0.0, 1.0);
    private DoubleProperty height = new SimpleDoubleProperty(0.3);
    private DoubleProperty radius = new SimpleDoubleProperty(0.05);
    private final PhongMaterial material = new PhongMaterial();
    private final MeshView coneNode = new MeshView();
    private final Translate translate = new Translate();
    private final Rotate rotate = new Rotate();
    private ConeData newData = null;
    private ConeData oldData = null;
    private Mesh newMesh = null;
    private boolean clearMesh = false;

    public YoConeFX3D() {
        this.coneNode.setMaterial((Material)this.material);
        this.coneNode.getTransforms().addAll((Object[])new Transform[]{this.translate, this.rotate});
        this.coneNode.idProperty().bind((ObservableValue)this.nameProperty());
        this.coneNode.getProperties().put((Object)YO_GRAPHICFX_ITEM_KEY, (Object)this);
    }

    public YoConeFX3D(ReferenceFrameWrapper worldFrame) {
        this();
        this.position.setReferenceFrame(worldFrame);
        this.axis.setReferenceFrame(worldFrame);
    }

    @Override
    public void render() {
        if (this.position.containsNaN() || this.axis.containsNaN()) {
            this.oldData = null;
            this.coneNode.setMesh(null);
            return;
        }
        this.newData = YoConeFX3D.newConeData(this.height, this.radius);
        if (this.color == null) {
            this.color = new SimpleColorFX();
        }
        this.material.setDiffuseColor(this.color.get());
        if (this.translate != null) {
            Point3D positionInWorld = this.position.toPoint3DInWorld();
            this.translate.setX(positionInWorld.getX());
            this.translate.setY(positionInWorld.getY());
            this.translate.setZ(positionInWorld.getZ());
        }
        if (this.axis != null) {
            AxisAngle axisAngle = EuclidGeometryTools.axisAngleFromZUpToVector3D((Vector3DReadOnly)this.axis.toVector3DInWorld());
            axisAngle.setAngle(Math.toDegrees(axisAngle.getAngle()));
            JavaFXMissingTools.convertAxisAngleToRotate((AxisAngleReadOnly)axisAngle, this.rotate);
        }
        if (this.clearMesh) {
            this.clearMesh = false;
            this.coneNode.setMesh(null);
        }
        if (this.newMesh != null) {
            this.coneNode.setMesh(this.newMesh);
            this.newMesh = null;
        }
    }

    @Override
    public void computeBackground() {
        ConeData newDataLocal = this.newData;
        this.newData = null;
        if (newDataLocal == null) {
            return;
        }
        if (newDataLocal.containsNaN() || EuclidCoreTools.isZero((double)newDataLocal.height, (double)1.0E-5) || EuclidCoreTools.isZero((double)newDataLocal.radius, (double)1.0E-5)) {
            this.clearMesh = true;
            this.oldData = null;
            return;
        }
        if (newDataLocal.equals(this.oldData)) {
            return;
        }
        this.newMesh = JavaFXTriangleMesh3DDefinitionInterpreter.interpretDefinition(TriangleMesh3DFactories.Cone((double)newDataLocal.height, (double)newDataLocal.radius, (int)32));
        this.oldData = newDataLocal;
    }

    private static ConeData newConeData(DoubleProperty height, DoubleProperty radius) {
        ConeData data = new ConeData();
        if (YoGraphicTools.isAnyNull(height, radius)) {
            return data;
        }
        data.height = height.get();
        data.radius = radius.get();
        return data;
    }

    public void setPosition(Tuple3DProperty position) {
        this.position = position;
    }

    public void setAxis(Tuple3DProperty axis) {
        this.axis = axis;
    }

    public void setHeight(DoubleProperty height) {
        this.height = height;
    }

    public void setHeight(double height) {
        this.height = new SimpleDoubleProperty(height);
    }

    public void setRadius(DoubleProperty radius) {
        this.radius = radius;
    }

    public void setRadius(double radius) {
        this.radius = new SimpleDoubleProperty(radius);
    }

    @Override
    public void clear() {
        this.position = null;
        this.axis = null;
        this.height = null;
        this.radius = null;
        this.color = null;
    }

    @Override
    public YoConeFX3D clone() {
        YoConeFX3D clone = new YoConeFX3D();
        clone.setName(this.getName());
        clone.setPosition(new Tuple3DProperty(this.position));
        clone.setAxis(new Tuple3DProperty(this.axis));
        clone.setHeight(this.height);
        clone.setRadius(this.radius);
        clone.setColor(this.color);
        return clone;
    }

    public Tuple3DProperty getPosition() {
        return this.position;
    }

    public Tuple3DProperty getAxis() {
        return this.axis;
    }

    public DoubleProperty getHeight() {
        return this.height;
    }

    public DoubleProperty getRadius() {
        return this.radius;
    }

    @Override
    public Node getNode() {
        return this.coneNode;
    }

    private static class ConeData {
        private double height;
        private double radius;

        private ConeData() {
        }

        public boolean equals(Object object) {
            if (object == this) {
                return true;
            }
            if (object instanceof ConeData) {
                ConeData other = (ConeData)object;
                if (this.height != other.height) {
                    return false;
                }
                return this.radius == other.radius;
            }
            return false;
        }

        public boolean containsNaN() {
            return Double.isNaN(this.height) || Double.isNaN(this.radius);
        }
    }
}

