/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.scs2.sessionVisualizer.jfx.session.mcap;

import java.io.File;
import java.util.concurrent.atomic.AtomicLong;
import org.bytedeco.javacv.FFmpegFrameGrabber;
import org.bytedeco.javacv.Frame;
import org.bytedeco.javacv.FrameGrabber;

public class FFMPEGVideoDataReader {
    private final File videoFile;
    private final FFmpegFrameGrabber frameGrabber;
    private Frame currentFrame = null;
    private final long maxVideoTimestamp;
    private final AtomicLong currentTimestamp = new AtomicLong(-1L);

    public FFMPEGVideoDataReader(File file) {
        this.videoFile = file;
        this.frameGrabber = new FFmpegFrameGrabber(file);
        try {
            this.frameGrabber.start();
        }
        catch (FFmpegFrameGrabber.Exception e) {
            throw new RuntimeException(e);
        }
        this.maxVideoTimestamp = this.frameGrabber.getLengthInTime();
    }

    public Frame getCurrentFrame() {
        return this.currentFrame;
    }

    public long readFrameAtTimestamp(long timestamp) {
        if (timestamp != this.currentTimestamp.get()) {
            long clampedTime = Math.min(this.maxVideoTimestamp, Math.max(0L, timestamp / 1000L));
            this.currentTimestamp.set(clampedTime);
            try {
                this.frameGrabber.setVideoTimestamp(clampedTime);
                this.currentFrame = this.frameGrabber.grabFrame();
            }
            catch (FrameGrabber.Exception e) {
                throw new RuntimeException(e);
            }
        }
        return this.currentTimestamp.get();
    }

    public long getVideoLengthInSeconds() {
        return this.maxVideoTimestamp / 1000000L;
    }

    public void shutdown() {
        try {
            this.frameGrabber.stop();
            this.frameGrabber.release();
        }
        catch (FFmpegFrameGrabber.Exception e) {
            throw new RuntimeException(e);
        }
    }
}

