/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.scs2.sessionVisualizer.jfx.managers;

import gnu.trove.list.array.TIntArrayList;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.Property;
import javafx.beans.property.ReadOnlyObjectProperty;
import javafx.beans.property.SimpleObjectProperty;
import us.ihmc.messager.javafx.JavaFXMessager;
import us.ihmc.scs2.session.Session;
import us.ihmc.scs2.sessionVisualizer.jfx.SessionVisualizerTopics;
import us.ihmc.scs2.sessionVisualizer.jfx.managers.Manager;
import us.ihmc.scs2.sharedMemory.interfaces.YoBufferPropertiesReadOnly;

public class KeyFrameManager
implements Manager {
    private final ObjectProperty<int[]> keyFrameIndicesProperty = new SimpleObjectProperty((Object)this, "keyFrameIndices", null);
    private final TIntArrayList keyFrameIndices = new TIntArrayList();
    private final Property<YoBufferPropertiesReadOnly> bufferProperties;
    private final JavaFXMessager messager;
    private final SessionVisualizerTopics topics;

    public KeyFrameManager(JavaFXMessager messager, SessionVisualizerTopics topics) {
        this.messager = messager;
        this.topics = topics;
        this.bufferProperties = messager.createPropertyInput(topics.getYoBufferCurrentProperties(), null);
        messager.addFXTopicListener(topics.getToggleKeyFrame(), messageContent -> this.toggleKeyFrame());
        messager.addFXTopicListener(topics.getGoToNextKeyFrame(), messageContent -> this.gotToNextKeyFrame());
        messager.addFXTopicListener(topics.getGoToPreviousKeyFrame(), messageContent -> this.gotToPreviousKeyFrame());
        messager.addFXTopicListener(topics.getRequestCurrentKeyFrames(), messageContent -> messager.submitMessage(topics.getCurrentKeyFrames(), (Object)((int[])this.keyFrameIndicesProperty.get())));
        this.bufferProperties.addListener((o, oldValue, newValue) -> {
            if (oldValue == null || oldValue.getSize() != newValue.getSize()) {
                this.clearAllKeyFrames();
            }
        });
        this.keyFrameIndicesProperty.addListener((o, oldValue, newValue) -> messager.submitMessage(topics.getCurrentKeyFrames(), newValue));
    }

    @Override
    public void startSession(Session session) {
    }

    @Override
    public void stopSession() {
        this.clearAllKeyFrames();
    }

    @Override
    public boolean isSessionLoaded() {
        return true;
    }

    private void clearAllKeyFrames() {
        this.keyFrameIndices.clear();
        this.keyFrameIndicesProperty.set(null);
    }

    private void toggleKeyFrame() {
        if (this.bufferProperties.getValue() == null) {
            return;
        }
        int currentIndex = ((YoBufferPropertiesReadOnly)this.bufferProperties.getValue()).getCurrentIndex();
        if (this.keyFrameIndices.isEmpty()) {
            this.keyFrameIndices.add(currentIndex);
        } else {
            int result = this.keyFrameIndices.binarySearch(currentIndex);
            if (result < 0) {
                int insertionIndex = -result - 1;
                this.keyFrameIndices.insert(insertionIndex, currentIndex);
            } else {
                this.keyFrameIndices.removeAt(result);
            }
        }
        this.keyFrameIndicesProperty.set((Object)this.keyFrameIndices.toArray());
    }

    private void gotToNextKeyFrame() {
        if (this.bufferProperties.getValue() == null) {
            return;
        }
        if (this.keyFrameIndices.isEmpty()) {
            return;
        }
        int currentIndex = ((YoBufferPropertiesReadOnly)this.bufferProperties.getValue()).getCurrentIndex();
        int result = this.keyFrameIndices.binarySearch(currentIndex);
        int nextKeyframeIndex = result < 0 ? -result - 1 : result + 1;
        if (nextKeyframeIndex >= this.keyFrameIndices.size()) {
            nextKeyframeIndex = 0;
        }
        this.messager.submitMessage(this.topics.getYoBufferCurrentIndexRequest(), (Object)this.keyFrameIndices.get(nextKeyframeIndex));
    }

    private void gotToPreviousKeyFrame() {
        if (this.bufferProperties.getValue() == null) {
            return;
        }
        if (this.keyFrameIndices.isEmpty()) {
            return;
        }
        int currentIndex = ((YoBufferPropertiesReadOnly)this.bufferProperties.getValue()).getCurrentIndex();
        int result = this.keyFrameIndices.binarySearch(currentIndex);
        int previousKeyframeIndex = result < 0 ? -result - 2 : result - 1;
        if (previousKeyframeIndex < 0) {
            previousKeyframeIndex = this.keyFrameIndices.size() - 1;
        }
        this.messager.submitMessage(this.topics.getYoBufferCurrentIndexRequest(), (Object)this.keyFrameIndices.get(previousKeyframeIndex));
    }

    public ReadOnlyObjectProperty<int[]> keyFrameIndicesProperty() {
        return this.keyFrameIndicesProperty;
    }
}

